// Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
// the License. You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
// an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
// specific language governing permissions and limitations under the License.

//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by google-apis-code-generator 1.6.0
//     C# generator version: 1.10.0
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

/**
 * \mainpage
 *   Google Wallet API Version v1
 *
 * \section ApiInfo API Version Information
 *    <table>
 *      <tr><th>API
 *          <td><a href='https://developers.google.com/pay/passes'>Google Wallet API</a>
 *      <tr><th>API Version<td>v1
 *      <tr><th>API Rev<td>0
 *      <tr><th>API Docs
 *          <td><a href='https://developers.google.com/pay/passes'>
 *              https://developers.google.com/pay/passes</a>
 *      <tr><th>Discovery Name<td>walletobjects
 *    </table>
 *
 * \section ForMoreInfo For More Information
 *
 * The complete API documentation for using Google Wallet API can be found at
 * <a href='https://developers.google.com/pay/passes'>https://developers.google.com/pay/passes</a>.
 *
 * For more information about the Google APIs Client Library for .NET, see
 * <a href='https://developers.google.com/api-client-library/dotnet/get_started'>
 * https://developers.google.com/api-client-library/dotnet/get_started</a>
 */

namespace Google.Apis.Walletobjects.v1.Data
{    

    /// <summary>ActivationOptions for the class</summary>
    public class ActivationOptions : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>HTTPS URL that supports REST semantics. Would be used for requesting activation from partners for
        /// given valuable, triggered by the users.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("activationUrl")]
        public virtual string ActivationUrl { get; set; } 

        /// <summary>Flag to allow users to make activation call from different device. This allows client to render the
        /// activation button enabled even if the activationStatus is ACTIVATED but the requested device is different
        /// than the current device.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("allowReactivation")]
        public virtual System.Nullable<bool> AllowReactivation { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>The activation status of the object. This field includes activation status if valuable supports
    /// activation.</summary>
    public class ActivationStatus : Google.Apis.Requests.IDirectResponseSchema
    {
        [Newtonsoft.Json.JsonPropertyAttribute("state")]
        public virtual string State { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Resource used when the AddMessage endpoints are called.</summary>
    public class AddMessageRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        [Newtonsoft.Json.JsonPropertyAttribute("message")]
        public virtual Message Message { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class AirportInfo : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Three character IATA airport code. This is a required field for `origin` and `destination`. Eg:
        /// "SFO"</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("airportIataCode")]
        public virtual string AirportIataCode { get; set; } 

        /// <summary>Optional field that overrides the airport city name defined by IATA. By default, Google takes the
        /// `airportIataCode` provided and maps it to the official airport city name defined by IATA. Official IATA
        /// airport city names can be found at IATA airport city names website. For example, for the airport IATA code
        /// "LTN", IATA website tells us that the corresponding airport city is "London". If this field is not
        /// populated, Google would display "London". However, populating this field with a custom name (eg: "London
        /// Luton") would override it.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("airportNameOverride")]
        public virtual LocalizedString AirportNameOverride { get; set; } 

        /// <summary>A name of the gate. Eg: "B59" or "59"</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("gate")]
        public virtual string Gate { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#airportInfo"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>Terminal name. Eg: "INTL" or "I"</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("terminal")]
        public virtual string Terminal { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>An identifier for an Android application.</summary>
    public class AndroidAppId : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A description an issuer may use to note what the signing key refers to (for example, whether it's a
        /// prod or debug key).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("description")]
        public virtual string Description { get; set; } 

        /// <summary>Package name of the Android application.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("packageName")]
        public virtual string PackageName { get; set; } 

        /// <summary>Encoded android application signing certificate using the
        /// signing_key_fingerprint_hash_algorithm.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("signingKeyFingerprint")]
        public virtual string SigningKeyFingerprint { get; set; } 

        /// <summary>Hash algorithm used when encoding signing_key_fingerprint.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("signingKeyFingerprintHashAlgorithm")]
        public virtual string SigningKeyFingerprintHashAlgorithm { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class AppLinkData : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Optional information about the partner app link.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("androidAppLinkInfo")]
        public virtual AppLinkDataAppLinkInfo AndroidAppLinkInfo { get; set; } 

        /// <summary>Deprecated. Links to open iOS apps are not supported.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("iosAppLinkInfo")]
        public virtual AppLinkDataAppLinkInfo IosAppLinkInfo { get; set; } 

        /// <summary>Optional information about the partner web link.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("webAppLinkInfo")]
        public virtual AppLinkDataAppLinkInfo WebAppLinkInfo { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class AppLinkDataAppLinkInfo : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Deprecated. Image isn't supported in the app link module.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("appLogoImage")]
        public virtual Image AppLogoImage { get; set; } 

        /// <summary>Target to follow when opening the app link on clients. It will be used by partners to open their
        /// app or webpage.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("appTarget")]
        public virtual AppLinkDataAppLinkInfoAppTarget AppTarget { get; set; } 

        /// <summary>Deprecated. Description isn't supported in the app link module.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("description")]
        public virtual LocalizedString Description { get; set; } 

        /// <summary>Deprecated. Title isn't supported in the app link module.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("title")]
        public virtual LocalizedString Title { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class AppLinkDataAppLinkInfoAppTarget : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Package name for AppTarget. For example: com.google.android.gm</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("packageName")]
        public virtual string PackageName { get; set; } 

        /// <summary>URI for AppTarget. The description on the URI must be set. Prefer setting package field instead, if
        /// this target is defined for your application.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("targetUri")]
        public virtual Uri TargetUri { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class AuthenticationKey : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A 33-byte compressed EC public key.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("compressedPublicKey")]
        public virtual string CompressedPublicKey { get; set; } 

        /// <summary>Available only to Smart Tap enabled partners. Contact support for additional guidance.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("id")]
        public virtual System.Nullable<int> Id { get; set; } 

        /// <summary>Available only to Smart Tap enabled partners. Contact support for additional guidance.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("publicKeyPem")]
        public virtual string PublicKeyPem { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class Barcode : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>An optional text that will override the default text that shows under the barcode. This field is
        /// intended for a human readable equivalent of the barcode value, used when the barcode cannot be
        /// scanned.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("alternateText")]
        public virtual string AlternateText { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#barcode"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>The render encoding for the barcode. When specified, barcode is rendered in the given encoding.
        /// Otherwise best known encoding is chosen by Google.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("renderEncoding")]
        public virtual string RenderEncoding { get; set; } 

        /// <summary>Optional text that will be shown when the barcode is hidden behind a click action. This happens in
        /// cases where a pass has Smart Tap enabled. If not specified, a default is chosen by Google.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("showCodeText")]
        public virtual LocalizedString ShowCodeText { get; set; } 

        /// <summary>The type of barcode.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("type")]
        public virtual string Type { get; set; } 

        /// <summary>The value encoded in the barcode.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("value")]
        public virtual string Value { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class BarcodeSectionDetail : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A reference to an existing text-based or image field to display.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("fieldSelector")]
        public virtual FieldSelector FieldSelector { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Details of the BHN gift card balance sync configuration for a class.</summary>
    public class BhnIntegrationDetails : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The types of BHN integrations supported by this merchant.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("balanceInquiryTypes")]
        public virtual System.Collections.Generic.IList<string> BalanceInquiryTypes { get; set; } 

        /// <summary>Product line id - passed to BHN to perform merchant balance lookup. This field is only used if the
        /// merchant has consented to balance inquiry and capability is supported.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("productLineId")]
        public virtual string ProductLineId { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Information to read/write to blobstore2.</summary>
    public class Blobstore2Info : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The blob generation id.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("blobGeneration")]
        public virtual System.Nullable<long> BlobGeneration { get; set; } 

        /// <summary>The blob id, e.g., /blobstore/prod/playground/scotty</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("blobId")]
        public virtual string BlobId { get; set; } 

        /// <summary>Read handle passed from Bigstore -> Scotty for a GCS download. This is a signed, serialized
        /// blobstore2.ReadHandle proto which must never be set outside of Bigstore, and is not applicable to non-GCS
        /// media downloads.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("downloadReadHandle")]
        public virtual string DownloadReadHandle { get; set; } 

        /// <summary>The blob read token. Needed to read blobs that have not been replicated. Might not be available
        /// until the final call.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("readToken")]
        public virtual string ReadToken { get; set; } 

        /// <summary>Metadata passed from Blobstore -> Scotty for a new GCS upload. This is a signed, serialized
        /// blobstore2.BlobMetadataContainer proto which must never be consumed outside of Bigstore, and is not
        /// applicable to non-GCS media uploads.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("uploadMetadataContainer")]
        public virtual string UploadMetadataContainer { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class BoardingAndSeatingInfo : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Set this field only if this flight boards through more than one door or bridge and you want to
        /// explicitly print the door location on the boarding pass. Most airlines route their passengers to the right
        /// door or bridge by refering to doors/bridges by the `seatClass`. In those cases `boardingDoor` should not be
        /// set.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("boardingDoor")]
        public virtual string BoardingDoor { get; set; } 

        /// <summary>The value of boarding group (or zone) this passenger shall board with. eg: "B" The label for this
        /// value will be determined by the `boardingPolicy` field in the `flightClass` referenced by this
        /// object.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("boardingGroup")]
        public virtual string BoardingGroup { get; set; } 

        /// <summary>The value of boarding position. eg: "76"</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("boardingPosition")]
        public virtual string BoardingPosition { get; set; } 

        /// <summary>A small image shown above the boarding barcode. Airlines can use it to communicate any special
        /// boarding privileges. In the event the security program logo is also set, this image might be rendered
        /// alongside the logo for that security program.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("boardingPrivilegeImage")]
        public virtual Image BoardingPrivilegeImage { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#boardingAndSeatingInfo"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>The passenger's seat assignment. To be used when there is no specific identifier to use in
        /// `seatNumber`. eg: "assigned at gate"</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("seatAssignment")]
        public virtual LocalizedString SeatAssignment { get; set; } 

        /// <summary>The value of the seat class. eg: "Economy" or "Economy Plus"</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("seatClass")]
        public virtual string SeatClass { get; set; } 

        /// <summary>The value of passenger seat. If there is no specific identifier, use `seatAssignment` instead. eg:
        /// "25A"</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("seatNumber")]
        public virtual string SeatNumber { get; set; } 

        /// <summary>The sequence number on the boarding pass. This usually matches the sequence in which the passengers
        /// checked in. Airline might use the number for manual boarding and bag tags. eg: "49"</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("sequenceNumber")]
        public virtual string SequenceNumber { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class BoardingAndSeatingPolicy : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Indicates the policy the airline uses for boarding. If unset, Google will default to
        /// `zoneBased`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("boardingPolicy")]
        public virtual string BoardingPolicy { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#boardingAndSeatingPolicy"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>Seating policy which dictates how we display the seat class. If unset, Google will default to
        /// `cabinBased`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("seatClassPolicy")]
        public virtual string SeatClassPolicy { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class Brand : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The app associated with this merchant.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("androidApp")]
        public virtual BrandApp AndroidApp { get; set; } 

        /// <summary>The country code of this brand configuration.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("countryCode")]
        public virtual string CountryCode { get; set; } 

        /// <summary>Customer service numbr in RFC3966 format.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customerServiceNumber")]
        public virtual string CustomerServiceNumber { get; set; } 

        /// <summary>Gift card program associated with this merchant.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("giftCardProgram")]
        public virtual BrandGiftCardProgram GiftCardProgram { get; set; } 

        /// <summary>GMB accounts associated with the merchant.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("gmbEmailAddress")]
        public virtual System.Collections.Generic.IList<string> GmbEmailAddress { get; set; } 

        /// <summary>The unique identifier for a merchant.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("issuerId")]
        public virtual System.Nullable<long> IssuerId { get; set; } 

        /// <summary>Standard merchant logo, to be used in entity views & transactions as merchant icon.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("logo")]
        public virtual Image Logo { get; set; } 

        /// <summary>Loyalty programs associated with this merchant.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("loyaltyProgram")]
        public virtual System.Collections.Generic.IList<BrandLoyaltyProgram> LoyaltyProgram { get; set; } 

        /// <summary>The name of the merchant.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("name")]
        public virtual LocalizedString Name { get; set; } 

        /// <summary>Notes about the merchant.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("notes")]
        public virtual string Notes { get; set; } 

        /// <summary>The website of the merchant.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("websiteUrl")]
        public virtual string WebsiteUrl { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class BrandApp : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The package name of the Android App.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("appPackage")]
        public virtual string AppPackage { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class BrandDeleteResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class BrandGiftCardProgram : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Whether the additional data field is hidden or if input is optional/required.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("additionalDataInputState")]
        public virtual string AdditionalDataInputState { get; set; } 

        /// <summary>Any additional field that may be needed on "add gift card".</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("additionalDataLabel")]
        public virtual LocalizedString AdditionalDataLabel { get; set; } 

        /// <summary>Whether barcode redemption is allowed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("allowBarcodeRedemption")]
        public virtual System.Nullable<bool> AllowBarcodeRedemption { get; set; } 

        /// <summary>Barcode type of this gift card.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("barcodeType")]
        public virtual string BarcodeType { get; set; } 

        /// <summary>BHN Product Line ID used to sync balances and the balance inquiry types supported.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("bhnIntegrationDetails")]
        public virtual BhnIntegrationDetails BhnIntegrationDetails { get; set; } 

        /// <summary>Label to show for the card number.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cardNumberLabel")]
        public virtual LocalizedString CardNumberLabel { get; set; } 

        /// <summary>Whether balance inquiry is supported for this gift card.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("consentToBalanceInquiry")]
        public virtual System.Nullable<bool> ConsentToBalanceInquiry { get; set; } 

        /// <summary>The configuration used to generate a barcode if it isn't set.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("generateBarcodePart")]
        public virtual System.Collections.Generic.IList<GeneratedBarcodePart> GenerateBarcodePart { get; set; } 

        /// <summary>If set, barcode will never be shown in client.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hideBarcode")]
        public virtual System.Nullable<bool> HideBarcode { get; set; } 

        /// <summary>Whether the PIN field is hidden or if input is optional/required.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("inputState")]
        public virtual string InputState { get; set; } 

        /// <summary>Label to show for the PIN.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("pinLabel")]
        public virtual LocalizedString PinLabel { get; set; } 

        /// <summary>Visibility state of this gift card.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("state")]
        public virtual string State { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class BrandListResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Resources corresponding to the list request.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resources")]
        public virtual System.Collections.Generic.IList<Brand> Resources { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class BrandLoyaltyProgram : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Barcode type of this loyalty program.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("barcodeType")]
        public virtual string BarcodeType { get; set; } 

        /// <summary>The hero image of the loyalty program.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("heroImage")]
        public virtual Image HeroImage { get; set; } 

        /// <summary>If set, barcode will never be shown in client.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hideBarcode")]
        public virtual System.Nullable<bool> HideBarcode { get; set; } 

        /// <summary>Controls how the user can create a valuable for the program.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("inputMode")]
        public virtual string InputMode { get; set; } 

        /// <summary>Knowledge Graph Machine Identifier for this loyalty program.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kgMid")]
        public virtual string KgMid { get; set; } 

        /// <summary>The logo of the loyalty program.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("logo")]
        public virtual Image Logo { get; set; } 

        /// <summary>The name of the loyalty program.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("name")]
        public virtual LocalizedString Name { get; set; } 

        /// <summary>Visibility state of this loyalty program.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("state")]
        public virtual string State { get; set; } 

        /// <summary>The loyalty program's website URL.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("websiteUrl")]
        public virtual string WebsiteUrl { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Represents a textual call-out.</summary>
    public class BubbleText : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Background color for the bubble. The format is #rrggbb where rrggbb is a hex RGB triplet, such as
        /// #ffcc00. You can also use the shorthand version of the RGB triplet which is #rgb, such as #fc0. If unset,
        /// will be treated as # 000.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("backgroundColor")]
        public virtual string BackgroundColor { get; set; } 

        /// <summary>Translated strings for the content. Recommended maximum length is 20 characters to ensure that the
        /// full string can be displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedContent")]
        public virtual LocalizedString LocalizedContent { get; set; } 

        /// <summary>Color of the text inside the bubble. The format is #rrggbb where rrggbb is a hex RGB triplet, such
        /// as #ffcc00. You can also use the shorthand version of the RGB triplet which is #rgb, such as #fc0. If unset,
        /// will be treated as #fff.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("textColor")]
        public virtual string TextColor { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class CallbackOptions : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>URL for the merchant endpoint that would be called to request updates. The URL should be hosted on
        /// HTTPS and robots.txt should allow the URL path to be accessible by UserAgent:Googlebot.
        /// Deprecated.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("updateRequestUrl")]
        public virtual string UpdateRequestUrl { get; set; } 

        /// <summary>The HTTPS url configured by the merchant. The URL should be hosted on HTTPS and robots.txt should
        /// allow the URL path to be accessible by UserAgent:Googlebot.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("url")]
        public virtual string Url { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class CardBarcodeSectionDetails : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Optional information to display below the barcode.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("firstBottomDetail")]
        public virtual BarcodeSectionDetail FirstBottomDetail { get; set; } 

        /// <summary>Optional information to display above the barcode. If `secondTopDetail` is defined, this will be
        /// displayed to the start side of this detail section.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("firstTopDetail")]
        public virtual BarcodeSectionDetail FirstTopDetail { get; set; } 

        /// <summary>Optional second piece of information to display above the barcode. If `firstTopDetail` is defined,
        /// this will be displayed to the end side of this detail section.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("secondTopDetail")]
        public virtual BarcodeSectionDetail SecondTopDetail { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class CardRowOneItem : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The item to be displayed in the row. This item will be automatically centered.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("item")]
        public virtual TemplateItem Item { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class CardRowTemplateInfo : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Template for a row containing one item. Exactly one of "one_item", "two_items", "three_items" must
        /// be set.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("oneItem")]
        public virtual CardRowOneItem OneItem { get; set; } 

        /// <summary>A predefined row. For internal use only. Exactly one of "one_item", "two_items", "three_items",
        /// "predefined_row" must be set.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("predefinedRow")]
        public virtual PredefinedTemplateRow PredefinedRow { get; set; } 

        /// <summary>Template for a row containing three items. Exactly one of "one_item", "two_items", "three_items"
        /// must be set.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("threeItems")]
        public virtual CardRowThreeItems ThreeItems { get; set; } 

        /// <summary>Template for a row containing two items. Exactly one of "one_item", "two_items", "three_items" must
        /// be set.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("twoItems")]
        public virtual CardRowTwoItems TwoItems { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class CardRowThreeItems : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The item to be displayed at the end of the row. This item will be aligned to the right.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("endItem")]
        public virtual TemplateItem EndItem { get; set; } 

        /// <summary>The item to be displayed in the middle of the row. This item will be centered between the start and
        /// end items.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("middleItem")]
        public virtual TemplateItem MiddleItem { get; set; } 

        /// <summary>The item to be displayed at the start of the row. This item will be aligned to the left.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("startItem")]
        public virtual TemplateItem StartItem { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class CardRowTwoItems : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The item to be displayed at the end of the row. This item will be aligned to the right.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("endItem")]
        public virtual TemplateItem EndItem { get; set; } 

        /// <summary>The item to be displayed at the start of the row. This item will be aligned to the left.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("startItem")]
        public virtual TemplateItem StartItem { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class CardTemplateOverride : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Template information for rows in the card view. At most three rows are allowed to be
        /// specified.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cardRowTemplateInfos")]
        public virtual System.Collections.Generic.IList<CardRowTemplateInfo> CardRowTemplateInfos { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class ClassTemplateInfo : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Specifies extra information to be displayed above and below the barcode.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cardBarcodeSectionDetails")]
        public virtual CardBarcodeSectionDetails CardBarcodeSectionDetails { get; set; } 

        /// <summary>Override for the card view.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cardTemplateOverride")]
        public virtual CardTemplateOverride CardTemplateOverride { get; set; } 

        /// <summary>Override for the details view (beneath the card view).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("detailsTemplateOverride")]
        public virtual DetailsTemplateOverride DetailsTemplateOverride { get; set; } 

        /// <summary>Override for the passes list view.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("listTemplateOverride")]
        public virtual ListTemplateOverride ListTemplateOverride { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>A sequence of media data references representing composite data. Introduced to support Bigstore
    /// composite objects. For details, visit http://go/bigstore-composites.</summary>
    public class CompositeMedia : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Blobstore v1 reference, set if reference_type is BLOBSTORE_REF This should be the byte
        /// representation of a blobstore.BlobRef. Since Blobstore is deprecating v1, use blobstore2_info instead. For
        /// now, any v2 blob will also be represented in this field as v1 BlobRef.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("blobRef")]
        public virtual string BlobRef { get; set; } 

        /// <summary>Blobstore v2 info, set if reference_type is BLOBSTORE_REF and it refers to a v2 blob.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("blobstore2Info")]
        public virtual Blobstore2Info Blobstore2Info { get; set; } 

        /// <summary>A binary data reference for a media download. Serves as a technology-agnostic binary reference in
        /// some Google infrastructure. This value is a serialized storage_cosmo.BinaryReference proto. Storing it as
        /// bytes is a hack to get around the fact that the cosmo proto (as well as others it includes) doesn't support
        /// JavaScript. This prevents us from including the actual type of this field.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cosmoBinaryReference")]
        public virtual string CosmoBinaryReference { get; set; } 

        /// <summary>crc32.c hash for the payload.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("crc32cHash")]
        public virtual System.Nullable<long> Crc32cHash { get; set; } 

        /// <summary>Media data, set if reference_type is INLINE</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("inline")]
        public virtual string Inline { get; set; } 

        /// <summary>Size of the data, in bytes</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("length")]
        public virtual System.Nullable<long> Length { get; set; } 

        /// <summary>MD5 hash for the payload.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("md5Hash")]
        public virtual string Md5Hash { get; set; } 

        /// <summary>Reference to a TI Blob, set if reference_type is BIGSTORE_REF.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("objectId")]
        public virtual ObjectId ObjectId { get; set; } 

        /// <summary>Path to the data, set if reference_type is PATH</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("path")]
        public virtual string Path { get; set; } 

        /// <summary>Describes what the field reference contains.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("referenceType")]
        public virtual string ReferenceType { get; set; } 

        /// <summary>SHA-1 hash for the payload.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("sha1Hash")]
        public virtual string Sha1Hash { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Detailed Content-Type information from Scotty. The Content-Type of the media will typically be filled
    /// in by the header or Scotty's best_guess, but this extended information provides the backend with more
    /// information so that it can make a better decision if needed. This is only used on media upload requests from
    /// Scotty.</summary>
    public class ContentTypeInfo : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Scotty's best guess of what the content type of the file is.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("bestGuess")]
        public virtual string BestGuess { get; set; } 

        /// <summary>The content type of the file derived by looking at specific bytes (i.e. "magic bytes") of the
        /// actual file.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("fromBytes")]
        public virtual string FromBytes { get; set; } 

        /// <summary>The content type of the file derived from the file extension of the original file name used by the
        /// client.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("fromFileName")]
        public virtual string FromFileName { get; set; } 

        /// <summary>The content type of the file as specified in the request headers, multipart headers, or RUPIO start
        /// request.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("fromHeader")]
        public virtual string FromHeader { get; set; } 

        /// <summary>The content type of the file derived from the file extension of the URL path. The URL path is
        /// assumed to represent a file name (which is typically only true for agents that are providing a REST
        /// API).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("fromUrlPath")]
        public virtual string FromUrlPath { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Covid card object</summary>
    public class CovidCardObject : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Optional app or website link that will be displayed as a button on the front of the pass.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("appLinkData")]
        public virtual AppLinkData AppLinkData { get; set; } 

        /// <summary>Optional. The barcode type and value.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("barcode")]
        public virtual Barcode Barcode { get; set; } 

        /// <summary>Required. The background color for the card. The format is `#rrggbb` where `rrggbb` is a hex RGB
        /// triplet, such as `#ffcc00`. You can also use the shorthand version of the RGB triplet which is `#rgb`, such
        /// as `#fc0`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cardColorHex")]
        public virtual string CardColorHex { get; set; } 

        /// <summary>Optional. Generic description for the card, may not be necessary if descriptions supplied
        /// individually in `VaccinationDetails` or `TestingDetails`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cardDescription")]
        public virtual string CardDescription { get; set; } 

        /// <summary>Optional. A custom label to use for the card description field.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cardDescriptionLabel")]
        public virtual string CardDescriptionLabel { get; set; } 

        /// <summary>Optional. Check icon for the card, shouldn't include any PII and should follow logo image
        /// guidelines. Will be displayed next to Title on card detail when provided with hero_image. This will be
        /// ignored if hero_image is not set. https://developers.google.com/pay/passes/guides/api-guidelines/brand-
        /// guidelines#logo-image-guidelines</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("checkIcon")]
        public virtual Image CheckIcon { get; set; } 

        /// <summary>Optional. Formatting option for valid ISO 8601 Date Fields, this applies to all date fields across
        /// the card, including the detail fields. If a date field is not provided in valid ISO 8601 format (eg.
        /// `2018-12-14T13:00:00`) it will ignore the formatting option and render the field as-is. For language
        /// specific date/time formatting, uses the device locale with the fallback of `en_US`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("dateFormat")]
        public virtual string DateFormat { get; set; } 

        /// <summary>Optional. Entry eligibility or expiration date and time for the card. Cards using this field are
        /// subject to additional eligibility requirements, as detailed in the [Acceptable Use
        /// Policy](https://payments.developers.google.com/terms/aup#covid-cards). This is an ISO 8601 extended format
        /// date and time without an offset. For example: `2027-03-25T06:30:00`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("expiration")]
        public virtual string Expiration { get; set; } 

        /// <summary>Optional. A custom label to use for the expiration field.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("expirationLabel")]
        public virtual string ExpirationLabel { get; set; } 

        /// <summary>Optional. The hero image of the card, shouldn't include any PII and should follow hero image
        /// guidelines. Will be displayed on top row in the card details.
        /// https://developers.google.com/pay/passes/guides/api-guidelines/brand-guidelines#hero-image-
        /// guidelines</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("heroImage")]
        public virtual Image HeroImage { get; set; } 

        /// <summary>Required. The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is issued by Google and
        /// `identifier` is chosen by you. The unique identifier can only include alphanumeric characters, `.`, `_`, or
        /// `-`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("id")]
        public virtual string Id { get; set; } 

        /// <summary>Required. The ID of the issuer authorized to validate the `CovidCardObject`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("issuerId")]
        public virtual string IssuerId { get; set; } 

        /// <summary>Optional. Links module data. Can contain up to a maximum of 3 uris.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("linksModuleData")]
        public virtual LinksModuleData LinksModuleData { get; set; } 

        /// <summary>Required. The logo image of the card. We recommend that this be the logo of the Covid Card
        /// Provider. This image is displayed in the card detail and is used as the icon for the shortcut on the Android
        /// home screen. Should follow logo guidelines and shouldn't include any PII.
        /// https://developers.google.com/pay/passes/guides/api-guidelines/brand-guidelines#logo-image-
        /// guidelines</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("logo")]
        public virtual Image Logo { get; set; } 

        /// <summary>Required. Patient details.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("patientDetails")]
        public virtual PatientDetails PatientDetails { get; set; } 

        /// <summary>Optional. Security animation options for the barcode. If this is set a security animation will be
        /// provided around the barcode if present.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("securityAnimation")]
        public virtual SecurityAnimation SecurityAnimation { get; set; } 

        /// <summary>Optional. Summary for the pass. If `Summary` is provided, then this field is displayed right-
        /// aligned in the top the card. Cards using this field are subject to additional eligibility requirements, as
        /// detailed in the [Acceptable Use Policy](https://payments.developers.google.com/terms/aup#covid-cards). For
        /// example: `Vaccinated`</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("summary")]
        public virtual string Summary { get; set; } 

        /// <summary>Optional. Details for the test. If `TestingDetails` is provided, then don't set
        /// `VaccinationDetails`, as a COVID Card can only include one of these details.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("testingDetails")]
        public virtual TestingDetails TestingDetails { get; set; } 

        /// <summary>Optional. Text module data. Can specify up to a maximum of 10 items.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("textModulesData")]
        public virtual System.Collections.Generic.IList<TextModuleData> TextModulesData { get; set; } 

        /// <summary>Required. Title for the pass. This is displayed on the home screen and on the card. For example:
        /// `COVID-19 Pass` or `Vaccine Certificate`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("title")]
        public virtual string Title { get; set; } 

        /// <summary>Optional. Details for the vaccination. If `VaccinationDetails` is provided, then don't set
        /// `TestingDetails`, as a Covid Card can only include one of these details.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("vaccinationDetails")]
        public virtual VaccinationDetails VaccinationDetails { get; set; } 

        /// <summary>Optional. Valid start date and time for the card This is an ISO 8601 extended format date and time
        /// without an offset. For example: `2027-03-25T06:30:00`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("validFrom")]
        public virtual string ValidFrom { get; set; } 

        /// <summary>Optional. A custom label to use for the valid from field.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("validFromLabel")]
        public virtual string ValidFromLabel { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class DateTime : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>An ISO 8601 extended format date/time. Offset may or may not be required (refer to the parent
        /// field's documentation). Time may be specified up to nanosecond precision. Offsets may be specified with
        /// seconds precision (even though offset seconds is not part of ISO 8601). For example:
        /// `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the 23rd hour of April 12th, 1985 in
        /// UTC. `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds after the 19th hour of April 12th,
        /// 1985, 4 hours before UTC (same instant in time as the above example). If the date/time is intended for a
        /// physical location in New York, this would be the equivalent of Eastern Daylight Time (EDT). Remember that
        /// offset varies in regions that observe Daylight Saving Time (or Summer Time), depending on the time of the
        /// year. `1985-04-12T19:20:50.52` would be 20 minutes and 50.52 seconds after the 19th hour of April 12th, 1985
        /// with no offset information. Providing an offset makes this an absolute instant in time around the world. The
        /// date/time will be adjusted based on the user's time zone. For example, a time of `2018-06-19T18:30:00-04:00`
        /// will be 18:30:00 for a user in New York and 15:30:00 for a user in Los Angeles. Omitting the offset makes
        /// this a local date/time, representing several instants in time around the world. The date/time will always be
        /// in the user's current time zone. For example, a time of `2018-06-19T18:30:00` will be 18:30:00 for a user in
        /// New York and also 18:30:00 for a user in Los Angeles. This is useful when the same local date/time should
        /// apply to many physical locations across several time zones.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("date")]
        public virtual string Date { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class DetailsItemInfo : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The item to be displayed in the details list.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("item")]
        public virtual TemplateItem Item { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class DetailsTemplateOverride : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Information for the "nth" item displayed in the details list.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("detailsItemInfos")]
        public virtual System.Collections.Generic.IList<DetailsItemInfo> DetailsItemInfos { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>DeviceCertificationSupport for the class</summary>
    public class DeviceCertificationSupport : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>VDV certification details</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("vdvCertDetails")]
        public virtual DeviceCertificationSupportVdvCertificationDetails VdvCertDetails { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Intended for use by select partners in limited circumstances. Contact support for additional
    /// information.</summary>
    public class DeviceCertificationSupportVdvCertificationDetails : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Specifies which certification environment should be called.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("certEnvironment")]
        public virtual string CertEnvironment { get; set; } 

        /// <summary>Intended for use by select partners in limited circumstances. Contact support for additional
        /// information.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("ownerId")]
        public virtual string OwnerId { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Device context associated with the object.</summary>
    public class DeviceContext : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>If set, redemption information will only be returned to the given device upon activation of the
        /// object. This should not be used as a stable identifier to trace a user's device. It can change across
        /// different passes for the same device or even across different activations for the same device. When setting
        /// this, callers must also set has_linked_device on the object being activated.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("deviceToken")]
        public virtual string DeviceToken { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Backend response for a Diff get checksums response. For details on the Scotty Diff protocol, visit
    /// http://go/scotty-diff-protocol.</summary>
    public class DiffChecksumsResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Exactly one of these fields must be populated. If checksums_location is filled, the server will
        /// return the corresponding contents to the user. If object_location is filled, the server will calculate the
        /// checksums based on the content there and return that to the user. For details on the format of the
        /// checksums, see http://go/scotty-diff-protocol.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("checksumsLocation")]
        public virtual CompositeMedia ChecksumsLocation { get; set; } 

        /// <summary>The chunk size of checksums. Must be a multiple of 256KB.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("chunkSizeBytes")]
        public virtual System.Nullable<long> ChunkSizeBytes { get; set; } 

        /// <summary>If set, calculate the checksums based on the contents and return them to the caller.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("objectLocation")]
        public virtual CompositeMedia ObjectLocation { get; set; } 

        /// <summary>The total size of the server object.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("objectSizeBytes")]
        public virtual System.Nullable<long> ObjectSizeBytes { get; set; } 

        /// <summary>The object version of the object the checksums are being returned for.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("objectVersion")]
        public virtual string ObjectVersion { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Backend response for a Diff download response. For details on the Scotty Diff protocol, visit
    /// http://go/scotty-diff-protocol.</summary>
    public class DiffDownloadResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The original object location.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("objectLocation")]
        public virtual CompositeMedia ObjectLocation { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>A Diff upload request. For details on the Scotty Diff protocol, visit http://go/scotty-diff-
    /// protocol.</summary>
    public class DiffUploadRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The location of the checksums for the new object. Agents must clone the object located here, as the
        /// upload server will delete the contents once a response is received. For details on the format of the
        /// checksums, see http://go/scotty-diff-protocol.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("checksumsInfo")]
        public virtual CompositeMedia ChecksumsInfo { get; set; } 

        /// <summary>The location of the new object. Agents must clone the object located here, as the upload server
        /// will delete the contents once a response is received.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("objectInfo")]
        public virtual CompositeMedia ObjectInfo { get; set; } 

        /// <summary>The object version of the object that is the base version the incoming diff script will be applied
        /// to. This field will always be filled in.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("objectVersion")]
        public virtual string ObjectVersion { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Backend response for a Diff upload request. For details on the Scotty Diff protocol, visit
    /// http://go/scotty-diff-protocol.</summary>
    public class DiffUploadResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The object version of the object at the server. Must be included in the end notification response.
        /// The version in the end notification response must correspond to the new version of the object that is now
        /// stored at the server, after the upload.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("objectVersion")]
        public virtual string ObjectVersion { get; set; } 

        /// <summary>The location of the original file for a diff upload request. Must be filled in if responding to an
        /// upload start notification.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("originalObject")]
        public virtual CompositeMedia OriginalObject { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Backend response for a Diff get version response. For details on the Scotty Diff protocol, visit
    /// http://go/scotty-diff-protocol.</summary>
    public class DiffVersionResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The total size of the server object.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("objectSizeBytes")]
        public virtual System.Nullable<long> ObjectSizeBytes { get; set; } 

        /// <summary>The version of the object stored at the server.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("objectVersion")]
        public virtual string ObjectVersion { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Information about how a class may be discovered and instantiated from within the Android Pay app. This
    /// is done by searching for a loyalty or gift card program and scanning or manually entering.</summary>
    public class DiscoverableProgram : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Data specific to gift card discoverables.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("giftCard")]
        public virtual DiscoverableProgramGiftCard GiftCard { get; set; } 

        /// <summary>Supported mode when adding a valuable directly in Google Pay. The object that is created will keep
        /// the input mode of the program at the time it was created. Used when ADD_IN_ANDROID_PAY feature is enabled.
        /// This needs to be kept in sync with go/valuables-merchant-matrix.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("inputMode")]
        public virtual string InputMode { get; set; } 

        /// <summary>Information about the ability to signin and add a valuable for this program through a merchant
        /// site. Used when MERCHANT_HOSTED_SIGNIN is enabled.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("merchantSigninInfo")]
        public virtual DiscoverableProgramMerchantSigninInfo MerchantSigninInfo { get; set; } 

        /// <summary>Information about the ability to signup and add a valuable for this program through a merchant
        /// site. Used when MERCHANT_HOSTED_SIGNUP is enabled.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("merchantSignupInfo")]
        public virtual DiscoverableProgramMerchantSignupInfo MerchantSignupInfo { get; set; } 

        /// <summary>Id currently used by the Google Pay client to identify the program.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("programId")]
        public virtual string ProgramId { get; set; } 

        /// <summary>Class Ids for objects that will be created through the S2AP API as part of merchant signin or
        /// signup flow. Used, for example, to stop prompting the user to add a valuable for this program when they have
        /// an object of this class.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("s2apClassIds")]
        public virtual System.Collections.Generic.IList<string> S2apClassIds { get; set; } 

        /// <summary>Visibility state of the discoverable program.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("state")]
        public virtual string State { get; set; } 

        /// <summary>Features that this program supports.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("supportedFeatures")]
        public virtual System.Collections.Generic.IList<string> SupportedFeatures { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Gift card specific discoverable information. This information needs to be kept in sync with
    /// go/valuables-merchant-matrix.</summary>
    public class DiscoverableProgramGiftCard : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Input fields displayed to the user when adding or editing a gift card directly in Google
        /// Pay.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("inputFields")]
        public virtual System.Collections.Generic.IList<DiscoverableProgramGiftCardGiftCardInput> InputFields { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class DiscoverableProgramGiftCardGiftCardInput : Google.Apis.Requests.IDirectResponseSchema
    {
        [Newtonsoft.Json.JsonPropertyAttribute("field")]
        public virtual string Field { get; set; } 

        [Newtonsoft.Json.JsonPropertyAttribute("required")]
        public virtual System.Nullable<bool> Required { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Information about the merchant hosted signin flow for a program.</summary>
    public class DiscoverableProgramMerchantSigninInfo : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The URL to direct the user to for the merchant's signin site.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("signinWebsite")]
        public virtual Uri SigninWebsite { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Information about the merchant hosted signup flow for a program.</summary>
    public class DiscoverableProgramMerchantSignupInfo : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The banner to display in the signup section of a transaction rich receipt.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("bannerImage")]
        public virtual Image BannerImage { get; set; } 

        /// <summary>The description of this program shown underneath the title on a transaction rich receipt.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("description")]
        public virtual LocalizedString Description { get; set; } 

        /// <summary> User data that is sent in a POST request to the signup website URL. This information is encoded
        /// and then shared so that the merchant's website can prefill fields used to enroll the user for the
        /// discoverable program.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("signupSharedDatas")]
        public virtual System.Collections.Generic.IList<string> SignupSharedDatas { get; set; } 

        /// <summary>The URL to direct the user to for the merchant's signup site.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("signupWebsite")]
        public virtual Uri SignupWebsite { get; set; } 

        /// <summary>The title or main text for the program, displayed on a transaction rich receipt.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("title")]
        public virtual LocalizedString Title { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Parameters specific to media downloads.</summary>
    public class DownloadParameters : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A boolean to be returned in the response to Scotty. Allows/disallows gzip encoding of the payload
        /// content when the server thinks it's advantageous (hence, does not guarantee compression) which allows Scotty
        /// to GZip the response to the client.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("allowGzipCompression")]
        public virtual System.Nullable<bool> AllowGzipCompression { get; set; } 

        /// <summary>Determining whether or not Apiary should skip the inclusion of any Content-Range header on its
        /// response to Scotty.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("ignoreRange")]
        public virtual System.Nullable<bool> IgnoreRange { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class EventDateTime : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A custom label to use for the doors open value (`doorsOpen`) on the card detail view. This should
        /// only be used if the default "Doors Open" label or one of the `doorsOpenLabel` options is not sufficient.
        /// Both `doorsOpenLabel` and `customDoorsOpenLabel` may not be set. If neither is set, the label will default
        /// to "Doors Open", localized. If the doors open field is unset, this label will not be used.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customDoorsOpenLabel")]
        public virtual LocalizedString CustomDoorsOpenLabel { get; set; } 

        /// <summary>The date/time when the doors open at the venue. This is an ISO 8601 extended format date/time, with
        /// or without an offset. Time may be specified up to nanosecond precision. Offsets may be specified with
        /// seconds precision (even though offset seconds is not part of ISO 8601). For example:
        /// `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the 23rd hour of April 12th, 1985 in
        /// UTC. `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds after the 19th hour of April 12th,
        /// 1985, 4 hours before UTC (same instant in time as the above example). If the event were in New York, this
        /// would be the equivalent of Eastern Daylight Time (EDT). Remember that offset varies in regions that observe
        /// Daylight Saving Time (or Summer Time), depending on the time of the year. `1985-04-12T19:20:50.52` would be
        /// 20 minutes and 50.52 seconds after the 19th hour of April 12th, 1985 with no offset information. The portion
        /// of the date/time without the offset is considered the "local date/time". This should be the local date/time
        /// at the venue. For example, if the event occurs at the 20th hour of June 5th, 2018 at the venue, the local
        /// date/time portion should be `2018-06-05T20:00:00`. If the local date/time at the venue is 4 hours before
        /// UTC, an offset of `-04:00` may be appended. Without offset information, some rich features may not be
        /// available.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("doorsOpen")]
        public virtual string DoorsOpen { get; set; } 

        /// <summary>The label to use for the doors open value (`doorsOpen`) on the card detail view. Each available
        /// option maps to a set of localized strings, so that translations are shown to the user based on their locale.
        /// Both `doorsOpenLabel` and `customDoorsOpenLabel` may not be set. If neither is set, the label will default
        /// to "Doors Open", localized. If the doors open field is unset, this label will not be used.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("doorsOpenLabel")]
        public virtual string DoorsOpenLabel { get; set; } 

        /// <summary>The date/time when the event ends. If the event spans multiple days, it should be the end date/time
        /// on the last day. This is an ISO 8601 extended format date/time, with or without an offset. Time may be
        /// specified up to nanosecond precision. Offsets may be specified with seconds precision (even though offset
        /// seconds is not part of ISO 8601). For example: `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52
        /// seconds after the 23rd hour of April 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would be 20 minutes
        /// and 50.52 seconds after the 19th hour of April 12th, 1985, 4 hours before UTC (same instant in time as the
        /// above example). If the event were in New York, this would be the equivalent of Eastern Daylight Time (EDT).
        /// Remember that offset varies in regions that observe Daylight Saving Time (or Summer Time), depending on the
        /// time of the year. `1985-04-12T19:20:50.52` would be 20 minutes and 50.52 seconds after the 19th hour of
        /// April 12th, 1985 with no offset information. The portion of the date/time without the offset is considered
        /// the "local date/time". This should be the local date/time at the venue. For example, if the event occurs at
        /// the 20th hour of June 5th, 2018 at the venue, the local date/time portion should be `2018-06-05T20:00:00`.
        /// If the local date/time at the venue is 4 hours before UTC, an offset of `-04:00` may be appended. Without
        /// offset information, some rich features may not be available.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("end")]
        public virtual string End { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#eventDateTime"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>The date/time when the event starts. If the event spans multiple days, it should be the start
        /// date/time on the first day. This is an ISO 8601 extended format date/time, with or without an offset. Time
        /// may be specified up to nanosecond precision. Offsets may be specified with seconds precision (even though
        /// offset seconds is not part of ISO 8601). For example: `1985-04-12T23:20:50.52Z` would be 20 minutes and
        /// 50.52 seconds after the 23rd hour of April 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would be 20
        /// minutes and 50.52 seconds after the 19th hour of April 12th, 1985, 4 hours before UTC (same instant in time
        /// as the above example). If the event were in New York, this would be the equivalent of Eastern Daylight Time
        /// (EDT). Remember that offset varies in regions that observe Daylight Saving Time (or Summer Time), depending
        /// on the time of the year. `1985-04-12T19:20:50.52` would be 20 minutes and 50.52 seconds after the 19th hour
        /// of April 12th, 1985 with no offset information. The portion of the date/time without the offset is
        /// considered the "local date/time". This should be the local date/time at the venue. For example, if the event
        /// occurs at the 20th hour of June 5th, 2018 at the venue, the local date/time portion should be
        /// `2018-06-05T20:00:00`. If the local date/time at the venue is 4 hours before UTC, an offset of `-04:00` may
        /// be appended. Without offset information, some rich features may not be available.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("start")]
        public virtual string Start { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class EventReservationInfo : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The confirmation code of the event reservation. This may also take the form of an "order number",
        /// "confirmation number", "reservation number", or other equivalent.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("confirmationCode")]
        public virtual string ConfirmationCode { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#eventReservationInfo"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class EventSeat : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The gate the ticket holder should enter to get to their seat, such as "A" or "West". This field is
        /// localizable so you may translate words or use different alphabets for the characters in an
        /// identifier.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("gate")]
        public virtual LocalizedString Gate { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#eventSeat"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>The row of the seat, such as "1", E", "BB", or "A5". This field is localizable so you may translate
        /// words or use different alphabets for the characters in an identifier.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("row")]
        public virtual LocalizedString Row { get; set; } 

        /// <summary>The seat number, such as "1", "2", "3", or any other seat identifier. This field is localizable so
        /// you may translate words or use different alphabets for the characters in an identifier.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("seat")]
        public virtual LocalizedString Seat { get; set; } 

        /// <summary>The section of the seat, such as "121". This field is localizable so you may translate words or use
        /// different alphabets for the characters in an identifier.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("section")]
        public virtual LocalizedString Section { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class EventTicketClass : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Activation options for an activatable ticket.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("activationOptions")]
        public virtual ActivationOptions ActivationOptions { get; set; } 

        /// <summary>Deprecated. Use `multipleDevicesAndHoldersAllowedStatus` instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("allowMultipleUsersPerObject")]
        public virtual System.Nullable<bool> AllowMultipleUsersPerObject { get; set; } 

        /// <summary>Optional app or website link that will be displayed as a button on the front of the pass. If
        /// AppLinkData is provided for the corresponding object that will be used instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("appLinkData")]
        public virtual AppLinkData AppLinkData { get; set; } 

        /// <summary>Callback options to be used to call the issuer back for every save/delete of an object for this
        /// class by the end-user. All objects of this class are eligible for the callback.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("callbackOptions")]
        public virtual CallbackOptions CallbackOptions { get; set; } 

        /// <summary>Template information about how the class should be displayed. If unset, Google will fallback to a
        /// default set of fields to display.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("classTemplateInfo")]
        public virtual ClassTemplateInfo ClassTemplateInfo { get; set; } 

        /// <summary>The label to use for the confirmation code value
        /// (`eventTicketObject.reservationInfo.confirmationCode`) on the card detail view. Each available option maps
        /// to a set of localized strings, so that translations are shown to the user based on their locale. Both
        /// `confirmationCodeLabel` and `customConfirmationCodeLabel` may not be set. If neither is set, the label will
        /// default to "Confirmation Code", localized. If the confirmation code field is unset, this label will not be
        /// used.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("confirmationCodeLabel")]
        public virtual string ConfirmationCodeLabel { get; set; } 

        /// <summary>Country code used to display the card's country (when the user is not in that country), as well as
        /// to display localized content when content is not available in the user's locale.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("countryCode")]
        public virtual string CountryCode { get; set; } 

        /// <summary>A custom label to use for the confirmation code value
        /// (`eventTicketObject.reservationInfo.confirmationCode`) on the card detail view. This should only be used if
        /// the default "Confirmation Code" label or one of the `confirmationCodeLabel` options is not sufficient. Both
        /// `confirmationCodeLabel` and `customConfirmationCodeLabel` may not be set. If neither is set, the label will
        /// default to "Confirmation Code", localized. If the confirmation code field is unset, this label will not be
        /// used.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customConfirmationCodeLabel")]
        public virtual LocalizedString CustomConfirmationCodeLabel { get; set; } 

        /// <summary>A custom label to use for the gate value (`eventTicketObject.seatInfo.gate`) on the card detail
        /// view. This should only be used if the default "Gate" label or one of the `gateLabel` options is not
        /// sufficient. Both `gateLabel` and `customGateLabel` may not be set. If neither is set, the label will default
        /// to "Gate", localized. If the gate field is unset, this label will not be used.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customGateLabel")]
        public virtual LocalizedString CustomGateLabel { get; set; } 

        /// <summary>A custom label to use for the row value (`eventTicketObject.seatInfo.row`) on the card detail view.
        /// This should only be used if the default "Row" label or one of the `rowLabel` options is not sufficient. Both
        /// `rowLabel` and `customRowLabel` may not be set. If neither is set, the label will default to "Row",
        /// localized. If the row field is unset, this label will not be used.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customRowLabel")]
        public virtual LocalizedString CustomRowLabel { get; set; } 

        /// <summary>A custom label to use for the seat value (`eventTicketObject.seatInfo.seat`) on the card detail
        /// view. This should only be used if the default "Seat" label or one of the `seatLabel` options is not
        /// sufficient. Both `seatLabel` and `customSeatLabel` may not be set. If neither is set, the label will default
        /// to "Seat", localized. If the seat field is unset, this label will not be used.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customSeatLabel")]
        public virtual LocalizedString CustomSeatLabel { get; set; } 

        /// <summary>A custom label to use for the section value (`eventTicketObject.seatInfo.section`) on the card
        /// detail view. This should only be used if the default "Section" label or one of the `sectionLabel` options is
        /// not sufficient. Both `sectionLabel` and `customSectionLabel` may not be set. If neither is set, the label
        /// will default to "Section", localized. If the section field is unset, this label will not be used.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customSectionLabel")]
        public virtual LocalizedString CustomSectionLabel { get; set; } 

        /// <summary>The date & time information of the event.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("dateTime")]
        public virtual EventDateTime DateTime { get; set; } 

        /// <summary>Identifies whether this class supports Smart Tap. The `redemptionIssuers` and object level
        /// `smartTapRedemptionLevel` fields must also be set up correctly in order for a pass to support Smart
        /// Tap.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("enableSmartTap")]
        public virtual System.Nullable<bool> EnableSmartTap { get; set; } 

        /// <summary>The ID of the event. This ID should be unique for every event in an account. It is used to group
        /// tickets together if the user has saved multiple tickets for the same event. It can be at most 64 characters.
        /// If provided, the grouping will be stable. Be wary of unintentional collision to avoid grouping tickets that
        /// should not be grouped. If you use only one class per event, you can simply set this to the `classId` (with
        /// or without the issuer ID portion). If not provided, the platform will attempt to use other data to group
        /// tickets (potentially unstable).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("eventId")]
        public virtual string EventId { get; set; } 

        /// <summary>Required. The name of the event, such as "LA Dodgers at SF Giants".</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("eventName")]
        public virtual LocalizedString EventName { get; set; } 

        /// <summary>The fine print, terms, or conditions of the ticket.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("finePrint")]
        public virtual LocalizedString FinePrint { get; set; } 

        /// <summary>The label to use for the gate value (`eventTicketObject.seatInfo.gate`) on the card detail view.
        /// Each available option maps to a set of localized strings, so that translations are shown to the user based
        /// on their locale. Both `gateLabel` and `customGateLabel` may not be set. If neither is set, the label will
        /// default to "Gate", localized. If the gate field is unset, this label will not be used.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("gateLabel")]
        public virtual string GateLabel { get; set; } 

        /// <summary>When a barcode is not set for an instance, the configuration used to generate one. It may consist
        /// of multiple parts concatenated together such as the account id, card number, pin, event number, or other
        /// hard coded values. The data is normally stored in the mag stripe and printed on the card.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("generatedBarcodeParts")]
        public virtual System.Collections.Generic.IList<GeneratedBarcodePart> GeneratedBarcodeParts { get; set; } 

        /// <summary>The type of barcode to be used when generating a barcode. If not specified for loyalty TEXT_ONLY
        /// will be used, and for gift cards CODE_128 will be used.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("generatedBarcodeType")]
        public virtual string GeneratedBarcodeType { get; set; } 

        /// <summary>Optional banner image displayed on the front of the card. If none is present, nothing will be
        /// displayed. The image will display at 100% width.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("heroImage")]
        public virtual Image HeroImage { get; set; } 

        /// <summary>The background color for the card. If not set the dominant color of the hero image is used, and if
        /// no hero image is set, the dominant color of the logo is used. The format is #rrggbb where rrggbb is a hex
        /// RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the RGB triplet which is #rgb,
        /// such as `#fc0`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hexBackgroundColor")]
        public virtual string HexBackgroundColor { get; set; } 

        /// <summary>Identifies whether or not this class should display a barcode for the user. This can be set if the
        /// class will not be scannable for some reason (eg: if the merchant uses scanners that cannot read phone
        /// screens).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hideBarcode")]
        public virtual System.Nullable<bool> HideBarcode { get; set; } 

        /// <summary>The URI of your application's home page. Populating the URI in this field results in the exact same
        /// behavior as populating an URI in linksModuleData (when an object is rendered, a link to the homepage is
        /// shown in what would usually be thought of as the linksModuleData section of the object).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("homepageUri")]
        public virtual Uri HomepageUri { get; set; } 

        /// <summary>Required. The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and
        /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or
        /// '-'.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("id")]
        public virtual string Id { get; set; } 

        /// <summary>Image module data. The maximum number of these fields displayed is 1 from object level and 1 for
        /// class object level.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("imageModulesData")]
        public virtual System.Collections.Generic.IList<ImageModuleData> ImageModulesData { get; set; } 

        /// <summary>Deprecated. Use textModulesData instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("infoModuleData")]
        public virtual InfoModuleData InfoModuleData { get; set; } 

        /// <summary>Required. The issuer name. Recommended maximum length is 20 characters to ensure full string is
        /// displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("issuerName")]
        public virtual string IssuerName { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#eventTicketClass"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>Links module data. If links module data is also defined on the object, both will be
        /// displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("linksModuleData")]
        public virtual LinksModuleData LinksModuleData { get; set; } 

        /// <summary>Translated strings for the issuer_name. Recommended maximum length is 20 characters to ensure full
        /// string is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedIssuerName")]
        public virtual LocalizedString LocalizedIssuerName { get; set; } 

        /// <summary>Translated strings for the message displayed on the preview of a card before it is saved by a user
        /// to their account.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedSaveToAndroidPayPreviewMessage")]
        public virtual LocalizedString LocalizedSaveToAndroidPayPreviewMessage { get; set; } 

        /// <summary>Note: This field is currently not supported to trigger geo notifications.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locations")]
        public virtual System.Collections.Generic.IList<LatLongPoint> Locations { get; set; } 

        /// <summary>The logo image of the ticket. This image is displayed in the card detail view of the app.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("logo")]
        public virtual Image Logo { get; set; } 

        /// <summary>An array of messages displayed in the app. All users of this object will receive its associated
        /// messages. The maximum number of these fields is 10.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("messages")]
        public virtual System.Collections.Generic.IList<Message> Messages { get; set; } 

        /// <summary>Identifies whether multiple users and devices will save the same object referencing this
        /// class.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("multipleDevicesAndHoldersAllowedStatus")]
        public virtual string MultipleDevicesAndHoldersAllowedStatus { get; set; } 

        /// <summary>Whether or not field updates to this class should trigger notifications. When set to NOTIFY, we
        /// will attempt to trigger a field update notification to users. These notifications will only be sent to users
        /// if the field is part of an allowlist. If not specified, no notification will be triggered. This setting is
        /// ephemeral and needs to be set with each PATCH or UPDATE request, otherwise a notification will not be
        /// triggered.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("notifyPreference")]
        public virtual string NotifyPreference { get; set; } 

        /// <summary>Identifies which redemption issuers can redeem the pass over Smart Tap. Redemption issuers are
        /// identified by their issuer ID. Redemption issuers must have at least one Smart Tap key configured. The
        /// `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also be set up correctly in order
        /// for a pass to support Smart Tap.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("redemptionIssuers")]
        public virtual System.Collections.Generic.IList<System.Nullable<long>> RedemptionIssuers { get; set; } 

        /// <summary>The review comments set by the platform when a class is marked `approved` or `rejected`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("review")]
        public virtual Review Review { get; set; } 

        /// <summary>Required. The status of the class. This field can be set to `draft` or `underReview` using the
        /// insert, patch, or update API calls. Once the review state is changed from `draft` it may not be changed back
        /// to `draft`. You should keep this field to `draft` when the class is under development. A `draft` class
        /// cannot be used to create any object. You should set this field to `underReview` when you believe the class
        /// is ready for use. The platform will automatically set this field to `approved` and it can be immediately
        /// used to create or migrate objects. When updating an already `approved` class you should keep setting this
        /// field to `underReview`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("reviewStatus")]
        public virtual string ReviewStatus { get; set; } 

        /// <summary>The label to use for the row value (`eventTicketObject.seatInfo.row`) on the card detail view. Each
        /// available option maps to a set of localized strings, so that translations are shown to the user based on
        /// their locale. Both `rowLabel` and `customRowLabel` may not be set. If neither is set, the label will default
        /// to "Row", localized. If the row field is unset, this label will not be used.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("rowLabel")]
        public virtual string RowLabel { get; set; } 

        /// <summary>Message displayed on the preview of a card before it is saved by a user to their account.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("saveToAndroidPayPreviewMessage")]
        public virtual string SaveToAndroidPayPreviewMessage { get; set; } 

        /// <summary>The label to use for the seat value (`eventTicketObject.seatInfo.seat`) on the card detail view.
        /// Each available option maps to a set of localized strings, so that translations are shown to the user based
        /// on their locale. Both `seatLabel` and `customSeatLabel` may not be set. If neither is set, the label will
        /// default to "Seat", localized. If the seat field is unset, this label will not be used.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("seatLabel")]
        public virtual string SeatLabel { get; set; } 

        /// <summary>The label to use for the section value (`eventTicketObject.seatInfo.section`) on the card detail
        /// view. Each available option maps to a set of localized strings, so that translations are shown to the user
        /// based on their locale. Both `sectionLabel` and `customSectionLabel` may not be set. If neither is set, the
        /// label will default to "Section", localized. If the section field is unset, this label will not be
        /// used.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("sectionLabel")]
        public virtual string SectionLabel { get; set; } 

        /// <summary>Optional information about the security animation. If this is set a security animation will be
        /// rendered on pass details.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("securityAnimation")]
        public virtual SecurityAnimation SecurityAnimation { get; set; } 

        /// <summary>Indicates if authentication should be required when transmitting the valuable. If this is true, and
        /// the terminal does not support authentication then objects of this class will not be transmitted. May only by
        /// true when smart_tap_encryption_required is true.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapAuthenticationRequired")]
        public virtual System.Nullable<bool> SmartTapAuthenticationRequired { get; set; } 

        /// <summary>Indicates if encryption should be required when transmitting the valuable. If this is true, and the
        /// terminal does not support encryption, then objects of this class will not be transmitted. May only be true
        /// when enable_smart_tap is true.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapEncryptionRequired")]
        public virtual System.Nullable<bool> SmartTapEncryptionRequired { get; set; } 

        /// <summary>Determines how to generate the smart tap redemption value from the redemption identifier. If this
        /// field is populated, the user's smart tap redemption value will change whenever the redemption identifier
        /// changes.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapRedemptionValueGenerationParams")]
        public virtual SmartTapRedemptionValueGenerationParams SmartTapRedemptionValueGenerationParams { get; set; } 

        /// <summary>Text module data. If text module data is also defined on the class, both will be displayed. The
        /// maximum number of these fields displayed is 10 from the object and 10 from the class.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("textModulesData")]
        public virtual System.Collections.Generic.IList<TextModuleData> TextModulesData { get; set; } 

        /// <summary>A regex that describes what a valid redemption identifier for this class looks like.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("validRedemptionIdentifierRegex")]
        public virtual string ValidRedemptionIdentifierRegex { get; set; } 

        /// <summary>Event venue details.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("venue")]
        public virtual EventVenue Venue { get; set; } 

        /// <summary>Deprecated</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("version")]
        public virtual System.Nullable<long> Version { get; set; } 

        /// <summary>View Unlock Requirement options for the event ticket.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("viewUnlockRequirement")]
        public virtual string ViewUnlockRequirement { get; set; } 

        /// <summary>The wide logo of the ticket. When provided, this will be used in place of the logo in the top left
        /// of the card view.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("wideLogo")]
        public virtual Image WideLogo { get; set; } 

        /// <summary>Deprecated.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("wordMark")]
        public virtual Image WordMark { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class EventTicketClassAddMessageResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The updated EventTicketClass resource.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resource")]
        public virtual EventTicketClass Resource { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class EventTicketClassListResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Pagination of the response.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("pagination")]
        public virtual Pagination Pagination { get; set; } 

        /// <summary>Resources corresponding to the list request.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resources")]
        public virtual System.Collections.Generic.IList<EventTicketClass> Resources { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class EventTicketObject : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The activation status for the object. Required if the class has `activationOptions` set.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("activationStatus")]
        public virtual ActivationStatus ActivationStatus { get; set; } 

        /// <summary>Optional app or website link that will be displayed as a button on the front of the pass. If
        /// AppLinkData is provided for the corresponding class only object AppLinkData will be displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("appLinkData")]
        public virtual AppLinkData AppLinkData { get; set; } 

        /// <summary>The barcode type and value.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("barcode")]
        public virtual Barcode Barcode { get; set; } 

        /// <summary>Required. The class associated with this object. The class must be of the same type as this object,
        /// must already exist, and must be approved. Class IDs should follow the format issuer ID.identifier where the
        /// former is issued by Google and latter is chosen by you.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("classId")]
        public virtual string ClassId { get; set; } 

        /// <summary>A copy of the inherited fields of the parent class. These fields are retrieved during a
        /// GET.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("classReference")]
        public virtual EventTicketClass ClassReference { get; set; } 

        /// <summary>Device context associated with the object.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("deviceContext")]
        public virtual DeviceContext DeviceContext { get; set; } 

        /// <summary>Indicates if notifications should explicitly be suppressed. If this field is set to true,
        /// regardless of the `messages` field, expiration notifications to the user will be suppressed. By default,
        /// this field is set to false. Currently, this can only be set for offers.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("disableExpirationNotification")]
        public virtual System.Nullable<bool> DisableExpirationNotification { get; set; } 

        /// <summary>The face value of the ticket, matching what would be printed on a physical version of the
        /// ticket.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("faceValue")]
        public virtual Money FaceValue { get; set; } 

        /// <summary>Information that controls how passes are grouped together.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("groupingInfo")]
        public virtual GroupingInfo GroupingInfo { get; set; } 

        /// <summary>Whether this object is currently linked to a single device. This field is set by the platform when
        /// a user saves the object, linking it to their device. Intended for use by select partners. Contact support
        /// for additional information.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hasLinkedDevice")]
        public virtual System.Nullable<bool> HasLinkedDevice { get; set; } 

        /// <summary>Indicates if the object has users. This field is set by the platform.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hasUsers")]
        public virtual System.Nullable<bool> HasUsers { get; set; } 

        /// <summary>Optional banner image displayed on the front of the card. If none is present, hero image of the
        /// class, if present, will be displayed. If hero image of the class is also not present, nothing will be
        /// displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("heroImage")]
        public virtual Image HeroImage { get; set; } 

        /// <summary>The background color for the card. If not set the dominant color of the hero image is used, and if
        /// no hero image is set, the dominant color of the logo is used. The format is #rrggbb where rrggbb is a hex
        /// RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the RGB triplet which is #rgb,
        /// such as `#fc0`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hexBackgroundColor")]
        public virtual string HexBackgroundColor { get; set; } 

        /// <summary>Required. The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID.identifier where the former is issued by Google and
        /// latter is chosen by you. The unique identifier should only include alphanumeric characters, '.', '_', or
        /// '-'.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("id")]
        public virtual string Id { get; set; } 

        /// <summary>Image module data. The maximum number of these fields displayed is 1 from object level and 1 for
        /// class object level.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("imageModulesData")]
        public virtual System.Collections.Generic.IList<ImageModuleData> ImageModulesData { get; set; } 

        /// <summary>Deprecated. Use textModulesData instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("infoModuleData")]
        public virtual InfoModuleData InfoModuleData { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#eventTicketObject"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>linked_object_ids are a list of other objects such as event ticket, loyalty, offer, generic,
        /// giftcard, transit and boarding pass that should be automatically attached to this event ticket object. If a
        /// user had saved this event ticket, then these linked_object_ids would be automatically pushed to the user's
        /// wallet (unless they turned off the setting to receive such linked passes). Object IDs should follow the
        /// format issuer ID. identifier where the former is issued by Google and the latter is chosen by you.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("linkedObjectIds")]
        public virtual System.Collections.Generic.IList<string> LinkedObjectIds { get; set; } 

        /// <summary>A list of offer objects linked to this event ticket. The offer objects must already exist. Offer
        /// object IDs should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("linkedOfferIds")]
        public virtual System.Collections.Generic.IList<string> LinkedOfferIds { get; set; } 

        /// <summary>Links module data. If links module data is also defined on the class, both will be
        /// displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("linksModuleData")]
        public virtual LinksModuleData LinksModuleData { get; set; } 

        /// <summary>Note: This field is currently not supported to trigger geo notifications.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locations")]
        public virtual System.Collections.Generic.IList<LatLongPoint> Locations { get; set; } 

        /// <summary>An array of messages displayed in the app. All users of this object will receive its associated
        /// messages. The maximum number of these fields is 10.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("messages")]
        public virtual System.Collections.Generic.IList<Message> Messages { get; set; } 

        /// <summary>Whether or not field updates to this object should trigger notifications. When set to NOTIFY, we
        /// will attempt to trigger a field update notification to users. These notifications will only be sent to users
        /// if the field is part of an allowlist. If set to DO_NOT_NOTIFY or NOTIFICATION_SETTINGS_UNSPECIFIED, no
        /// notification will be triggered. This setting is ephemeral and needs to be set with each PATCH or UPDATE
        /// request, otherwise a notification will not be triggered.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("notifyPreference")]
        public virtual string NotifyPreference { get; set; } 

        /// <summary>Pass constraints for the object. Includes limiting NFC and screenshot behaviors.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("passConstraints")]
        public virtual PassConstraints PassConstraints { get; set; } 

        /// <summary>Reservation details for this ticket. This is expected to be shared amongst all tickets that were
        /// purchased in the same order.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("reservationInfo")]
        public virtual EventReservationInfo ReservationInfo { get; set; } 

        /// <summary>The rotating barcode type and value.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("rotatingBarcode")]
        public virtual RotatingBarcode RotatingBarcode { get; set; } 

        /// <summary>Restrictions on the object that needs to be verified before the user tries to save the pass. Note
        /// that this restrictions will only be applied during save time. If the restrictions changed after a user saves
        /// the pass, the new restrictions will not be applied to an already saved pass.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("saveRestrictions")]
        public virtual SaveRestrictions SaveRestrictions { get; set; } 

        /// <summary>Seating details for this ticket.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("seatInfo")]
        public virtual EventSeat SeatInfo { get; set; } 

        /// <summary>The value that will be transmitted to a Smart Tap certified terminal over NFC for this object. The
        /// class level fields `enableSmartTap` and `redemptionIssuers` must also be set up correctly in order for the
        /// pass to support Smart Tap. Only ASCII characters are supported.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapRedemptionValue")]
        public virtual string SmartTapRedemptionValue { get; set; } 

        /// <summary>Required. The state of the object. This field is used to determine how an object is displayed in
        /// the app. For example, an `inactive` object is moved to the "Expired passes" section.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("state")]
        public virtual string State { get; set; } 

        /// <summary>Text module data. If text module data is also defined on the class, both will be displayed. The
        /// maximum number of these fields displayed is 10 from the object and 10 from the class.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("textModulesData")]
        public virtual System.Collections.Generic.IList<TextModuleData> TextModulesData { get; set; } 

        /// <summary>Name of the ticket holder, if the ticket is assigned to a person. E.g. "John Doe" or "Jane
        /// Doe".</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("ticketHolderName")]
        public virtual string TicketHolderName { get; set; } 

        /// <summary>The number of the ticket. This can be a unique identifier across all tickets in an issuer's system,
        /// all tickets for the event (e.g. XYZ1234512345), or all tickets in the order (1, 2, 3, etc.).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("ticketNumber")]
        public virtual string TicketNumber { get; set; } 

        /// <summary>The type of the ticket, such as "Adult" or "Child", or "VIP" or "Standard".</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("ticketType")]
        public virtual LocalizedString TicketType { get; set; } 

        /// <summary>The time period this object will be `active` and object can be used. An object's state will be
        /// changed to `expired` when this time period has passed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("validTimeInterval")]
        public virtual TimeInterval ValidTimeInterval { get; set; } 

        /// <summary>Deprecated</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("version")]
        public virtual System.Nullable<long> Version { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class EventTicketObjectAddMessageResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The updated EventTicketObject resource.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resource")]
        public virtual EventTicketObject Resource { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class EventTicketObjectListResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Pagination of the response.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("pagination")]
        public virtual Pagination Pagination { get; set; } 

        /// <summary>Resources corresponding to the list request.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resources")]
        public virtual System.Collections.Generic.IList<EventTicketObject> Resources { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Request to upload rotating barcode values.</summary>
    public class EventTicketObjectUploadRotatingBarcodeValuesRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A reference to the rotating barcode values payload that was uploaded.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("blob")]
        public virtual Media Blob { get; set; } 

        /// <summary>Extra information about the uploaded media.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mediaRequestInfo")]
        public virtual MediaRequestInfo MediaRequestInfo { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Response for uploading rotating barcode values.</summary>
    public class EventTicketObjectUploadRotatingBarcodeValuesResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class EventVenue : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The address of the venue, such as "24 Willie Mays Plaza\nSan Francisco, CA 94107". Address lines
        /// are separated by line feed (`\n`) characters. This is required.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("address")]
        public virtual LocalizedString Address { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#eventVenue"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>The name of the venue, such as "AT&T Park". This is required.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("name")]
        public virtual LocalizedString Name { get; set; } 

        /// <summary>Place ID of the venue (preferred). If provided, it will be used to look up the venue name and
        /// address in Maps. If the Place ID is not valid, behavior will fall back to the values provided in the name
        /// and address fields. Place IDs can be obtained using the Place ID Finder. These are Base64-encoded
        /// maps_api.PlaceId protobufs. See http://go/place-id-encoding for more details.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("placeId")]
        public virtual string PlaceId { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Indicates that the issuer would like Google Wallet to send expiry notifications 2 days prior to the
    /// card expiration.</summary>
    public class ExpiryNotification : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Indicates if the object needs to have expiry notification enabled.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("enableNotification")]
        public virtual System.Nullable<bool> EnableNotification { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>A globally unique identifier associated with each feature. We use 128-bit identifiers so that we have
    /// lots of bits available to distinguish between features. The feature id currently consists of a 64-bit "cell id"
    /// that **sometimes** corresponds to the approximate centroid of the feature, plus a 64-bit fingerprint of other
    /// identifying information. See more on each respective field in its comments. Feature ids are first assigned when
    /// the data is created in MapFacts. After initial creation of the feature, they are immutable. This means that the
    /// only properties that you should rely on are that they are unique, and that cell_ids often - but not always -
    /// preserve spatial locality. The degree of locality varies as the feature undergoes geometry changes, and should
    /// not in general be considered a firm guarantee of the location of any particular feature. In fact, some
    /// locationless features have randomized cell IDs! Consumers of FeatureProtos from Mapfacts are guaranteed that
    /// fprints in the id field of features will be globally unique. Using the fprint allows consumers who don't need
    /// the spatial benefit of cell ids to uniquely identify features in a 64-bit address space. This property is not
    /// guaranteed for other sources of FeatureProtos.</summary>
    public class FeatureIdProto : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The S2CellId corresponding to the approximate location of this feature as of when it was first
        /// created. This can be of variable accuracy, ranging from the exact centroid of the feature at creation, a
        /// very large S2 Cell, or even being completely randomized for locationless features. Cell ids have the nice
        /// property that they follow a space-filling curve over the surface of the earth. (See s2cellid.h for details.)
        /// WARNING: Clients should only use cell IDs to perform spatial locality optimizations. There is no strict
        /// guarantee that the cell ID of a feature is related to the current geometry of the feature in any
        /// way.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cellId")]
        public virtual System.Nullable<ulong> CellId { get; set; } 

        /// <summary>A 64-bit fingerprint used to identify features. Most clients should rely on MapFacts or OneRing to
        /// choose fingerprints. If creating new fprints, the strategy should be chosen so that the chance of collision
        /// is remote or non-existent, and the distribution should be reasonably uniform. For example, if the source
        /// data assigns unique ids to features, then a fingerprint of the provider name, version, and source id is
        /// sufficient.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("fprint")]
        public virtual System.Nullable<ulong> Fprint { get; set; } 

        /// <summary>A place for clients to attach arbitrary data to a feature ID. Never set in MapFacts.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("temporaryData")]
        public virtual MessageSet TemporaryData { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Reference definition to use with field overrides.</summary>
    public class FieldReference : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Only valid if the `fieldPath` references a date field. Chooses how the date field will be formatted
        /// and displayed in the UI.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("dateFormat")]
        public virtual string DateFormat { get; set; } 

        /// <summary>Path to the field being referenced, prefixed with "object" or "class" and separated with dots. For
        /// example, it may be the string "object.purchaseDetails.purchasePrice".</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("fieldPath")]
        public virtual string FieldPath { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Custom field selector to use with field overrides.</summary>
    public class FieldSelector : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>If more than one reference is supplied, then the first one that references a non-empty field will
        /// be displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("fields")]
        public virtual System.Collections.Generic.IList<FieldReference> Fields { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class FirstRowOption : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A reference to the field to be displayed in the first row.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("fieldOption")]
        public virtual FieldSelector FieldOption { get; set; } 

        [Newtonsoft.Json.JsonPropertyAttribute("transitOption")]
        public virtual string TransitOption { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class FlightCarrier : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A logo for the airline alliance, displayed below the QR code that the passenger scans to
        /// board.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("airlineAllianceLogo")]
        public virtual Image AirlineAllianceLogo { get; set; } 

        /// <summary>A logo for the airline described by carrierIataCode and localizedAirlineName. This logo will be
        /// rendered at the top of the detailed card view.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("airlineLogo")]
        public virtual Image AirlineLogo { get; set; } 

        /// <summary>A localized name of the airline specified by carrierIataCode. If unset, `issuer_name` or
        /// `localized_issuer_name` from `FlightClass` will be used for display purposes. eg: "Swiss Air" for
        /// "LX"</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("airlineName")]
        public virtual LocalizedString AirlineName { get; set; } 

        /// <summary>Two character IATA airline code of the marketing carrier (as opposed to operating carrier). Exactly
        /// one of this or `carrierIcaoCode` needs to be provided for `carrier` and `operatingCarrier`. eg: "LX" for
        /// Swiss Air</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("carrierIataCode")]
        public virtual string CarrierIataCode { get; set; } 

        /// <summary>Three character ICAO airline code of the marketing carrier (as opposed to operating carrier).
        /// Exactly one of this or `carrierIataCode` needs to be provided for `carrier` and `operatingCarrier`. eg:
        /// "EZY" for Easy Jet</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("carrierIcaoCode")]
        public virtual string CarrierIcaoCode { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#flightCarrier"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>The wide logo of the airline. When provided, this will be used in place of the airline logo in the
        /// top left of the card view.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("wideAirlineLogo")]
        public virtual Image WideAirlineLogo { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class FlightClass : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Activation options for an activatable ticket.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("activationOptions")]
        public virtual ActivationOptions ActivationOptions { get; set; } 

        /// <summary>Deprecated. Use `multipleDevicesAndHoldersAllowedStatus` instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("allowMultipleUsersPerObject")]
        public virtual System.Nullable<bool> AllowMultipleUsersPerObject { get; set; } 

        /// <summary>Optional app or website link that will be displayed as a button on the front of the pass. If
        /// AppLinkData is provided for the corresponding object that will be used instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("appLinkData")]
        public virtual AppLinkData AppLinkData { get; set; } 

        /// <summary>Policies for boarding and seating. These will inform which labels will be shown to users.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("boardingAndSeatingPolicy")]
        public virtual BoardingAndSeatingPolicy BoardingAndSeatingPolicy { get; set; } 

        /// <summary>Callback options to be used to call the issuer back for every save/delete of an object for this
        /// class by the end-user. All objects of this class are eligible for the callback.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("callbackOptions")]
        public virtual CallbackOptions CallbackOptions { get; set; } 

        /// <summary>Template information about how the class should be displayed. If unset, Google will fallback to a
        /// default set of fields to display.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("classTemplateInfo")]
        public virtual ClassTemplateInfo ClassTemplateInfo { get; set; } 

        /// <summary>Country code used to display the card's country (when the user is not in that country), as well as
        /// to display localized content when content is not available in the user's locale.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("countryCode")]
        public virtual string CountryCode { get; set; } 

        /// <summary>Required. Destination airport.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("destination")]
        public virtual AirportInfo Destination { get; set; } 

        /// <summary>Identifies whether this class supports Smart Tap. The `redemptionIssuers` and object level
        /// `smartTapRedemptionLevel` fields must also be set up correctly in order for a pass to support Smart
        /// Tap.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("enableSmartTap")]
        public virtual System.Nullable<bool> EnableSmartTap { get; set; } 

        /// <summary>Required. Information about the flight carrier and number.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("flightHeader")]
        public virtual FlightHeader FlightHeader { get; set; } 

        /// <summary>Status of this flight. If unset, Google will compute status based on data from other sources, such
        /// as FlightStats, etc. Note: Google-computed status will not be returned in API responses.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("flightStatus")]
        public virtual string FlightStatus { get; set; } 

        /// <summary>When a barcode is not set for an instance, the configuration used to generate one. It may consist
        /// of multiple parts concatenated together such as the account id, card number, pin, event number, or other
        /// hard coded values. The data is normally stored in the mag stripe and printed on the card.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("generatedBarcodeParts")]
        public virtual System.Collections.Generic.IList<GeneratedBarcodePart> GeneratedBarcodeParts { get; set; } 

        /// <summary>The type of barcode to be used when generating a barcode. If not specified for Flight TEXT_ONLY
        /// will be used, and for gift cards CODE_128 will be used.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("generatedBarcodeType")]
        public virtual string GeneratedBarcodeType { get; set; } 

        /// <summary>Optional banner image displayed on the front of the card. If none is present, nothing will be
        /// displayed. The image will display at 100% width.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("heroImage")]
        public virtual Image HeroImage { get; set; } 

        /// <summary>The background color for the card. If not set the dominant color of the hero image is used, and if
        /// no hero image is set, the dominant color of the logo is used. The format is #rrggbb where rrggbb is a hex
        /// RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the RGB triplet which is #rgb,
        /// such as `#fc0`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hexBackgroundColor")]
        public virtual string HexBackgroundColor { get; set; } 

        /// <summary>Identifies whether or not this class should display a barcode for the user. This can be set if the
        /// class will not be scannable for some reason (eg: if the merchant uses scanners that cannot read phone
        /// screens).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hideBarcode")]
        public virtual System.Nullable<bool> HideBarcode { get; set; } 

        /// <summary>The URI of your application's home page. Populating the URI in this field results in the exact same
        /// behavior as populating an URI in linksModuleData (when an object is rendered, a link to the homepage is
        /// shown in what would usually be thought of as the linksModuleData section of the object).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("homepageUri")]
        public virtual Uri HomepageUri { get; set; } 

        /// <summary>Required. The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and
        /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or
        /// '-'.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("id")]
        public virtual string Id { get; set; } 

        /// <summary>Image module data. The maximum number of these fields displayed is 1 from object level and 1 for
        /// class object level.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("imageModulesData")]
        public virtual System.Collections.Generic.IList<ImageModuleData> ImageModulesData { get; set; } 

        /// <summary>Deprecated. Use textModulesData instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("infoModuleData")]
        public virtual InfoModuleData InfoModuleData { get; set; } 

        /// <summary>Required. The issuer name. Recommended maximum length is 20 characters to ensure full string is
        /// displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("issuerName")]
        public virtual string IssuerName { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#flightClass"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>If this field is present, boarding passes served to a user's device will always be in this
        /// language. Represents the BCP 47 language tag. Example values are "en-US", "en-GB", "de", or "de-
        /// AT".</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("languageOverride")]
        public virtual string LanguageOverride { get; set; } 

        /// <summary>Links module data. If links module data is also defined on the object, both will be
        /// displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("linksModuleData")]
        public virtual LinksModuleData LinksModuleData { get; set; } 

        /// <summary>The boarding time as it would be printed on the boarding pass. This is an ISO 8601 extended format
        /// date/time without an offset. Time may be specified up to millisecond precision. eg: `2027-03-05T06:30:00`
        /// This should be the local date/time at the airport (not a UTC time). Google will reject the request if UTC
        /// offset is provided. Time zones will be calculated by Google based on departure airport. If this is not set,
        /// Google will set it based on data from other sources.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localBoardingDateTime")]
        public virtual string LocalBoardingDateTime { get; set; } 

        /// <summary>The estimated time the aircraft plans to reach the destination gate (not the runway) or the actual
        /// time it reached the gate. This field should be set if at least one of the below is true: - It differs from
        /// the scheduled time. Google will use it to calculate the delay. - The aircraft already arrived at the gate.
        /// Google will use it to inform the user that the flight has arrived at the gate. This is an ISO 8601 extended
        /// format date/time without an offset. Time may be specified up to millisecond precision. eg:
        /// `2027-03-05T06:30:00` This should be the local date/time at the airport (not a UTC time). Google will reject
        /// the request if UTC offset is provided. Time zones will be calculated by Google based on arrival airport. If
        /// this is not set, Google will set it based on data from other sources.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localEstimatedOrActualArrivalDateTime")]
        public virtual string LocalEstimatedOrActualArrivalDateTime { get; set; } 

        /// <summary>The estimated time the aircraft plans to pull from the gate or the actual time the aircraft already
        /// pulled from the gate. Note: This is not the runway time. This field should be set if at least one of the
        /// below is true: - It differs from the scheduled time. Google will use it to calculate the delay. - The
        /// aircraft already pulled from the gate. Google will use it to inform the user when the flight actually
        /// departed. This is an ISO 8601 extended format date/time without an offset. Time may be specified up to
        /// millisecond precision. eg: `2027-03-05T06:30:00` This should be the local date/time at the airport (not a
        /// UTC time). Google will reject the request if UTC offset is provided. Time zones will be calculated by Google
        /// based on departure airport. If this is not set, Google will set it based on data from other
        /// sources.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localEstimatedOrActualDepartureDateTime")]
        public virtual string LocalEstimatedOrActualDepartureDateTime { get; set; } 

        /// <summary>The gate closing time as it would be printed on the boarding pass. Do not set this field if you do
        /// not want to print it in the boarding pass. This is an ISO 8601 extended format date/time without an offset.
        /// Time may be specified up to millisecond precision. eg: `2027-03-05T06:30:00` This should be the local
        /// date/time at the airport (not a UTC time). Google will reject the request if UTC offset is provided. Time
        /// zones will be calculated by Google based on departure airport.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localGateClosingDateTime")]
        public virtual string LocalGateClosingDateTime { get; set; } 

        /// <summary>The scheduled time the aircraft plans to reach the destination gate (not the runway). Note: This
        /// field should not change too close to the flight time. For updates to departure times (delays, etc), please
        /// set `localEstimatedOrActualArrivalDateTime`. This is an ISO 8601 extended format date/time without an
        /// offset. Time may be specified up to millisecond precision. eg: `2027-03-05T06:30:00` This should be the
        /// local date/time at the airport (not a UTC time). Google will reject the request if UTC offset is provided.
        /// Time zones will be calculated by Google based on arrival airport. If this is not set, Google will set it
        /// based on data from other sources.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localScheduledArrivalDateTime")]
        public virtual string LocalScheduledArrivalDateTime { get; set; } 

        /// <summary>Required. The scheduled date and time when the aircraft is expected to depart the gate (not the
        /// runway) Note: This field should not change too close to the departure time. For updates to departure times
        /// (delays, etc), please set `localEstimatedOrActualDepartureDateTime`. This is an ISO 8601 extended format
        /// date/time without an offset. Time may be specified up to millisecond precision. eg: `2027-03-05T06:30:00`
        /// This should be the local date/time at the airport (not a UTC time). Google will reject the request if UTC
        /// offset is provided. Time zones will be calculated by Google based on departure airport.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localScheduledDepartureDateTime")]
        public virtual string LocalScheduledDepartureDateTime { get; set; } 

        /// <summary>Translated strings for the issuer_name. Recommended maximum length is 20 characters to ensure full
        /// string is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedIssuerName")]
        public virtual LocalizedString LocalizedIssuerName { get; set; } 

        /// <summary>Translated strings for the message displayed on the preview of a card before it is saved by a user
        /// to their account.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedSaveToAndroidPayPreviewMessage")]
        public virtual LocalizedString LocalizedSaveToAndroidPayPreviewMessage { get; set; } 

        /// <summary>Note: This field is currently not supported to trigger geo notifications.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locations")]
        public virtual System.Collections.Generic.IList<LatLongPoint> Locations { get; set; } 

        /// <summary>An array of messages displayed in the app. All users of this object will receive its associated
        /// messages. The maximum number of these fields is 10.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("messages")]
        public virtual System.Collections.Generic.IList<Message> Messages { get; set; } 

        /// <summary>Identifies whether multiple users and devices will save the same object referencing this
        /// class.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("multipleDevicesAndHoldersAllowedStatus")]
        public virtual string MultipleDevicesAndHoldersAllowedStatus { get; set; } 

        /// <summary>Whether or not field updates to this class should trigger notifications. When set to NOTIFY, we
        /// will attempt to trigger a field update notification to users. These notifications will only be sent to users
        /// if the field is part of an allowlist. If not specified, no notification will be triggered. This setting is
        /// ephemeral and needs to be set with each PATCH or UPDATE request, otherwise a notification will not be
        /// triggered.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("notifyPreference")]
        public virtual string NotifyPreference { get; set; } 

        /// <summary>Required. Origin airport.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("origin")]
        public virtual AirportInfo Origin { get; set; } 

        /// <summary>Identifies which redemption issuers can redeem the pass over Smart Tap. Redemption issuers are
        /// identified by their issuer ID. Redemption issuers must have at least one Smart Tap key configured. The
        /// `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also be set up correctly in order
        /// for a pass to support Smart Tap.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("redemptionIssuers")]
        public virtual System.Collections.Generic.IList<System.Nullable<long>> RedemptionIssuers { get; set; } 

        /// <summary>The review comments set by the platform when a class is marked `approved` or `rejected`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("review")]
        public virtual Review Review { get; set; } 

        /// <summary>Required. The status of the class. This field can be set to `draft` or `underReview` using the
        /// insert, patch, or update API calls. Once the review state is changed from `draft` it may not be changed back
        /// to `draft`. You should keep this field to `draft` when the class is under development. A `draft` class
        /// cannot be used to create any object. You should set this field to `underReview` when you believe the class
        /// is ready for use. The platform will automatically set this field to `approved` and it can be immediately
        /// used to create or migrate objects. When updating an already `approved` class you should keep setting this
        /// field to `underReview`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("reviewStatus")]
        public virtual string ReviewStatus { get; set; } 

        /// <summary>Message displayed on the preview of a card before it is saved by a user to their account.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("saveToAndroidPayPreviewMessage")]
        public virtual string SaveToAndroidPayPreviewMessage { get; set; } 

        /// <summary>Optional information about the security animation. If this is set a security animation will be
        /// rendered on pass details.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("securityAnimation")]
        public virtual SecurityAnimation SecurityAnimation { get; set; } 

        /// <summary>Indicates if authentication should be required when transmitting the valuable. If this is true, and
        /// the terminal does not support authentication then objects of this class will not be transmitted. May only by
        /// true when smart_tap_encryption_required is true.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapAuthenticationRequired")]
        public virtual System.Nullable<bool> SmartTapAuthenticationRequired { get; set; } 

        /// <summary>Indicates if encryption should be required when transmitting the valuable. If this is true, and the
        /// terminal does not support encryption, then objects of this class will not be transmitted. May only be true
        /// when enable_smart_tap is true.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapEncryptionRequired")]
        public virtual System.Nullable<bool> SmartTapEncryptionRequired { get; set; } 

        /// <summary>Determines how to generate the smart tap redemption value from the redemption identifier. If this
        /// field is populated, the user's smart tap redemption value will change whenever the redemption identifier
        /// changes.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapRedemptionValueGenerationParams")]
        public virtual SmartTapRedemptionValueGenerationParams SmartTapRedemptionValueGenerationParams { get; set; } 

        /// <summary>Text module data. If text module data is also defined on the class, both will be displayed. The
        /// maximum number of these fields displayed is 10 from the object and 10 from the class.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("textModulesData")]
        public virtual System.Collections.Generic.IList<TextModuleData> TextModulesData { get; set; } 

        /// <summary>A regex that describes what a valid redemption identifier for this class looks like.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("validRedemptionIdentifierRegex")]
        public virtual string ValidRedemptionIdentifierRegex { get; set; } 

        /// <summary>Deprecated</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("version")]
        public virtual System.Nullable<long> Version { get; set; } 

        /// <summary>View Unlock Requirement options for the boarding pass.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("viewUnlockRequirement")]
        public virtual string ViewUnlockRequirement { get; set; } 

        /// <summary>Deprecated.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("wordMark")]
        public virtual Image WordMark { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class FlightClassAddMessageResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The updated FlightClass resource.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resource")]
        public virtual FlightClass Resource { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class FlightClassListResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Pagination of the response.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("pagination")]
        public virtual Pagination Pagination { get; set; } 

        /// <summary>Resources corresponding to the list request.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resources")]
        public virtual System.Collections.Generic.IList<FlightClass> Resources { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class FlightHeader : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Information about airline carrier. This is a required property of `flightHeader`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("carrier")]
        public virtual FlightCarrier Carrier { get; set; } 

        /// <summary>The flight number without IATA carrier code. This field should contain only digits. This is a
        /// required property of `flightHeader`. eg: "123"</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("flightNumber")]
        public virtual string FlightNumber { get; set; } 

        /// <summary>Override value to use for flight number. The default value used for display purposes is carrier +
        /// flight_number. If a different value needs to be shown to passengers, use this field to override the default
        /// behavior. eg: "XX1234 / YY576"</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("flightNumberDisplayOverride")]
        public virtual string FlightNumberDisplayOverride { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#flightHeader"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>Information about operating airline carrier.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("operatingCarrier")]
        public virtual FlightCarrier OperatingCarrier { get; set; } 

        /// <summary>The flight number used by the operating carrier without IATA carrier code. This field should
        /// contain only digits. eg: "234"</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("operatingFlightNumber")]
        public virtual string OperatingFlightNumber { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class FlightObject : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The activation status for the object. Required if the class has `activationOptions` set.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("activationStatus")]
        public virtual ActivationStatus ActivationStatus { get; set; } 

        /// <summary>Optional app or website link that will be displayed as a button on the front of the pass. If
        /// AppLinkData is provided for the corresponding class only object AppLinkData will be displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("appLinkData")]
        public virtual AppLinkData AppLinkData { get; set; } 

        /// <summary>The barcode type and value.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("barcode")]
        public virtual Barcode Barcode { get; set; } 

        /// <summary>Passenger specific information about boarding and seating.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("boardingAndSeatingInfo")]
        public virtual BoardingAndSeatingInfo BoardingAndSeatingInfo { get; set; } 

        /// <summary>Required. The class associated with this object. The class must be of the same type as this object,
        /// must already exist, and must be approved. Class IDs should follow the format issuer ID.identifier where the
        /// former is issued by Google and latter is chosen by you.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("classId")]
        public virtual string ClassId { get; set; } 

        /// <summary>A copy of the inherited fields of the parent class. These fields are retrieved during a
        /// GET.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("classReference")]
        public virtual FlightClass ClassReference { get; set; } 

        /// <summary>Device context associated with the object.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("deviceContext")]
        public virtual DeviceContext DeviceContext { get; set; } 

        /// <summary>Indicates if notifications should explicitly be suppressed. If this field is set to true,
        /// regardless of the `messages` field, expiration notifications to the user will be suppressed. By default,
        /// this field is set to false. Currently, this can only be set for Flights.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("disableExpirationNotification")]
        public virtual System.Nullable<bool> DisableExpirationNotification { get; set; } 

        /// <summary>Information that controls how passes are grouped together.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("groupingInfo")]
        public virtual GroupingInfo GroupingInfo { get; set; } 

        /// <summary>Whether this object is currently linked to a single device. This field is set by the platform when
        /// a user saves the object, linking it to their device. Intended for use by select partners. Contact support
        /// for additional information.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hasLinkedDevice")]
        public virtual System.Nullable<bool> HasLinkedDevice { get; set; } 

        /// <summary>Indicates if the object has users. This field is set by the platform.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hasUsers")]
        public virtual System.Nullable<bool> HasUsers { get; set; } 

        /// <summary>Optional banner image displayed on the front of the card. If none is present, hero image of the
        /// class, if present, will be displayed. If hero image of the class is also not present, nothing will be
        /// displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("heroImage")]
        public virtual Image HeroImage { get; set; } 

        /// <summary>The background color for the card. If not set the dominant color of the hero image is used, and if
        /// no hero image is set, the dominant color of the logo is used. The format is #rrggbb where rrggbb is a hex
        /// RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the RGB triplet which is #rgb,
        /// such as `#fc0`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hexBackgroundColor")]
        public virtual string HexBackgroundColor { get; set; } 

        /// <summary>Required. The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID.identifier where the former is issued by Google and
        /// latter is chosen by you. The unique identifier should only include alphanumeric characters, '.', '_', or
        /// '-'.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("id")]
        public virtual string Id { get; set; } 

        /// <summary>Image module data. The maximum number of these fields displayed is 1 from object level and 1 for
        /// class object level.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("imageModulesData")]
        public virtual System.Collections.Generic.IList<ImageModuleData> ImageModulesData { get; set; } 

        /// <summary>Deprecated. Use textModulesData instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("infoModuleData")]
        public virtual InfoModuleData InfoModuleData { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#flightObject"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>linked_object_ids are a list of other objects such as event ticket, loyalty, offer, generic,
        /// giftcard, transit and boarding pass that should be automatically attached to this flight object. If a user
        /// had saved this boarding pass, then these linked_object_ids would be automatically pushed to the user's
        /// wallet (unless they turned off the setting to receive such linked passes). Object IDs should follow the
        /// format issuer ID.identifier where the former is issued by Google and the latter is chosen by you.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("linkedObjectIds")]
        public virtual System.Collections.Generic.IList<string> LinkedObjectIds { get; set; } 

        /// <summary>Links module data. If links module data is also defined on the class, both will be
        /// displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("linksModuleData")]
        public virtual LinksModuleData LinksModuleData { get; set; } 

        /// <summary>Note: This field is currently not supported to trigger geo notifications.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locations")]
        public virtual System.Collections.Generic.IList<LatLongPoint> Locations { get; set; } 

        /// <summary>An array of messages displayed in the app. All users of this object will receive its associated
        /// messages. The maximum number of these fields is 10.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("messages")]
        public virtual System.Collections.Generic.IList<Message> Messages { get; set; } 

        /// <summary>Whether or not field updates to this object should trigger notifications. When set to NOTIFY, we
        /// will attempt to trigger a field update notification to users. These notifications will only be sent to users
        /// if the field is part of an allowlist. If set to DO_NOT_NOTIFY or NOTIFICATION_SETTINGS_UNSPECIFIED, no
        /// notification will be triggered. This setting is ephemeral and needs to be set with each PATCH or UPDATE
        /// request, otherwise a notification will not be triggered.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("notifyPreference")]
        public virtual string NotifyPreference { get; set; } 

        /// <summary>Pass constraints for the object. Includes limiting NFC and screenshot behaviors.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("passConstraints")]
        public virtual PassConstraints PassConstraints { get; set; } 

        /// <summary>Required. Passenger name as it would appear on the boarding pass. eg: "Dave M Gahan" or
        /// "Gahan/Dave" or "GAHAN/DAVEM"</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("passengerName")]
        public virtual string PassengerName { get; set; } 

        /// <summary>Required. Information about flight reservation.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("reservationInfo")]
        public virtual ReservationInfo ReservationInfo { get; set; } 

        /// <summary>The rotating barcode type and value.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("rotatingBarcode")]
        public virtual RotatingBarcode RotatingBarcode { get; set; } 

        /// <summary>Restrictions on the object that needs to be verified before the user tries to save the pass. Note
        /// that this restrictions will only be applied during save time. If the restrictions changed after a user saves
        /// the pass, the new restrictions will not be applied to an already saved pass.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("saveRestrictions")]
        public virtual SaveRestrictions SaveRestrictions { get; set; } 

        /// <summary>An image for the security program that applies to the passenger.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("securityProgramLogo")]
        public virtual Image SecurityProgramLogo { get; set; } 

        /// <summary>The value that will be transmitted to a Smart Tap certified terminal over NFC for this object. The
        /// class level fields `enableSmartTap` and `redemptionIssuers` must also be set up correctly in order for the
        /// pass to support Smart Tap. Only ASCII characters are supported.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapRedemptionValue")]
        public virtual string SmartTapRedemptionValue { get; set; } 

        /// <summary>Required. The state of the object. This field is used to determine how an object is displayed in
        /// the app. For example, an `inactive` object is moved to the "Expired passes" section.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("state")]
        public virtual string State { get; set; } 

        /// <summary>Text module data. If text module data is also defined on the class, both will be displayed. The
        /// maximum number of these fields displayed is 10 from the object and 10 from the class.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("textModulesData")]
        public virtual System.Collections.Generic.IList<TextModuleData> TextModulesData { get; set; } 

        /// <summary>The time period this object will be `active` and object can be used. An object's state will be
        /// changed to `expired` when this time period has passed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("validTimeInterval")]
        public virtual TimeInterval ValidTimeInterval { get; set; } 

        /// <summary>Deprecated</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("version")]
        public virtual System.Nullable<long> Version { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class FlightObjectAddMessageResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The updated FlightObject resource.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resource")]
        public virtual FlightObject Resource { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class FlightObjectListResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Pagination of the response.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("pagination")]
        public virtual Pagination Pagination { get; set; } 

        /// <summary>Resources corresponding to the list request.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resources")]
        public virtual System.Collections.Generic.IList<FlightObject> Resources { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Request to upload rotating barcode values.</summary>
    public class FlightObjectUploadRotatingBarcodeValuesRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A reference to the rotating barcode values payload that was uploaded.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("blob")]
        public virtual Media Blob { get; set; } 

        /// <summary>Extra information about the uploaded media.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mediaRequestInfo")]
        public virtual MediaRequestInfo MediaRequestInfo { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Response for uploading rotating barcode values.</summary>
    public class FlightObjectUploadRotatingBarcodeValuesResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class FrequentFlyerInfo : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Frequent flyer number. Required for each nested object of kind
        /// `walletobjects#frequentFlyerInfo`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("frequentFlyerNumber")]
        public virtual string FrequentFlyerNumber { get; set; } 

        /// <summary>Frequent flyer program name. eg: "Lufthansa Miles & More"</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("frequentFlyerProgramName")]
        public virtual LocalizedString FrequentFlyerProgramName { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#frequentFlyerInfo"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>When a barcode is not set for an object, this is the configuration used to generate one. It may consist
    /// of multiple parts concatenated together such as the account id, card number, pin, event number, or other hard
    /// coded values. The data is normally stored in the mag stripe and printed on the card.</summary>
    public class GeneratedBarcodePart : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>For barcode part with field CARD_NUMBER, the optional substring range.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cardNumberParams")]
        public virtual GeneratedBarcodePartCardNumberParams CardNumberParams { get; set; } 

        /// <summary>The field from the gift card object to be used for this barcode part. If an implicit value, the
        /// value field of this barcode part is used instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("field")]
        public virtual string Field { get; set; } 

        /// <summary>For a barcode part with field IMPLICIT_VALUE, the value to use.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("implicitValue")]
        public virtual string ImplicitValue { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Inclusive start index and exclusive end index when using a substring of the field's value. Only used
    /// with CARD_NUMBER field type. Ignored for other types.</summary>
    public class GeneratedBarcodePartCardNumberParams : Google.Apis.Requests.IDirectResponseSchema
    {
        [Newtonsoft.Json.JsonPropertyAttribute("endIndex")]
        public virtual System.Nullable<int> EndIndex { get; set; } 

        [Newtonsoft.Json.JsonPropertyAttribute("startIndex")]
        public virtual System.Nullable<int> StartIndex { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Generic Class</summary>
    public class GenericClass : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Optional app or website link that will be displayed as a button on the front of the pass. If
        /// AppLinkData is provided for the corresponding object that will be used instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("appLinkData")]
        public virtual AppLinkData AppLinkData { get; set; } 

        /// <summary>Callback options to be used to call the issuer back for every save/delete of an object for this
        /// class by the end-user. All objects of this class are eligible for the callback.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("callbackOptions")]
        public virtual CallbackOptions CallbackOptions { get; set; } 

        /// <summary>Template information about how the class should be displayed. If unset, Google will fallback to a
        /// default set of fields to display.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("classTemplateInfo")]
        public virtual ClassTemplateInfo ClassTemplateInfo { get; set; } 

        /// <summary>Available only to Smart Tap enabled partners. Contact support for additional guidance.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("enableSmartTap")]
        public virtual System.Nullable<bool> EnableSmartTap { get; set; } 

        /// <summary>Required. The unique identifier for the class. This ID must be unique across all from an issuer.
        /// This value needs to follow the format `issuerID.identifier` where `issuerID` is issued by Google and
        /// `identifier` is chosen by you. The unique identifier can only include alphanumeric characters, `.`, `_`, or
        /// `-`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("id")]
        public virtual string Id { get; set; } 

        /// <summary>Image module data. If `imageModulesData` is also defined on the object, both will be displayed.
        /// Only one of the image from class and one from object level will be rendered when both set.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("imageModulesData")]
        public virtual System.Collections.Generic.IList<ImageModuleData> ImageModulesData { get; set; } 

        /// <summary>Links module data. If `linksModuleData` is also defined on the object, both will be displayed. The
        /// maximum number of these fields displayed is 10 from class and 10 from object.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("linksModuleData")]
        public virtual LinksModuleData LinksModuleData { get; set; } 

        /// <summary>An array of messages displayed in the app. All users of this object will receive its associated
        /// messages. The maximum number of these fields is 10.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("messages")]
        public virtual System.Collections.Generic.IList<Message> Messages { get; set; } 

        /// <summary>Identifies whether multiple users and devices will save the same object referencing this
        /// class.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("multipleDevicesAndHoldersAllowedStatus")]
        public virtual string MultipleDevicesAndHoldersAllowedStatus { get; set; } 

        /// <summary>Identifies which redemption issuers can redeem the pass over Smart Tap. Redemption issuers are
        /// identified by their issuer ID. Redemption issuers must have at least one Smart Tap key configured. The
        /// `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also be set up correctly in order
        /// for a pass to support Smart Tap.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("redemptionIssuers")]
        public virtual System.Collections.Generic.IList<System.Nullable<long>> RedemptionIssuers { get; set; } 

        /// <summary>Optional information about the security animation. If this is set a security animation will be
        /// rendered on pass details.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("securityAnimation")]
        public virtual SecurityAnimation SecurityAnimation { get; set; } 

        /// <summary>Indicates if authentication should be required when transmitting the pass. If this is true, and the
        /// terminal does not support authentication then objects of this class will not be transmitted. May only by
        /// true when smart_tap_encryption_required is true.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapAuthenticationRequired")]
        public virtual System.Nullable<bool> SmartTapAuthenticationRequired { get; set; } 

        /// <summary>Indicates if encryption should be required when transmitting the pass. If this is true, and the
        /// terminal does not support encryption, then objects of this class will not be transmitted. May only be true
        /// when enable_smart_tap is true.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapEncryptionRequired")]
        public virtual System.Nullable<bool> SmartTapEncryptionRequired { get; set; } 

        /// <summary>Determines how to generate the smart tap redemption value from the redemption identifier. If this
        /// field is populated, the user's smart tap redemption value will change whenever the redemption identifier
        /// changes.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapRedemptionValueGenerationParams")]
        public virtual SmartTapRedemptionValueGenerationParams SmartTapRedemptionValueGenerationParams { get; set; } 

        /// <summary>Text module data. If `textModulesData` is also defined on the object, both will be displayed. The
        /// maximum number of these fields displayed is 10 from class and 10 from object.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("textModulesData")]
        public virtual System.Collections.Generic.IList<TextModuleData> TextModulesData { get; set; } 

        /// <summary>View Unlock Requirement options for the generic pass.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("viewUnlockRequirement")]
        public virtual string ViewUnlockRequirement { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Response to adding a new issuer message to the class. This contains the entire updated
    /// GenericClass.</summary>
    public class GenericClassAddMessageResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The updated EventTicketClass resource.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resource")]
        public virtual GenericClass Resource { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>List response which contains the list of all generic classes for a given issuer ID.</summary>
    public class GenericClassListResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Pagination of the response.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("pagination")]
        public virtual Pagination Pagination { get; set; } 

        /// <summary>Resources corresponding to the list request.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resources")]
        public virtual System.Collections.Generic.IList<GenericClass> Resources { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Generic Object</summary>
    public class GenericObject : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Optional app or website link that will be displayed as a button on the front of the pass. If
        /// AppLinkData is provided for the corresponding class only object AppLinkData will be displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("appLinkData")]
        public virtual AppLinkData AppLinkData { get; set; } 

        /// <summary>The barcode type and value. If pass does not have a barcode, we can allow the issuer to set
        /// Barcode.alternate_text and display just that.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("barcode")]
        public virtual Barcode Barcode { get; set; } 

        /// <summary>Required. The header of the pass. This is usually the Business name such as "XXX Gym", "AAA
        /// Insurance". This field is required and appears in the header row at the very top of the pass.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cardTitle")]
        public virtual LocalizedString CardTitle { get; set; } 

        /// <summary>Required. The class associated with this object. The class must be of the same type as this object,
        /// must already exist, and must be approved. Class IDs should follow the format `issuerID.identifier` where
        /// `issuerID` is issued by Google and `identifier` is chosen by you.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("classId")]
        public virtual string ClassId { get; set; } 

        /// <summary>Specify which `GenericType` the card belongs to.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("genericType")]
        public virtual string GenericType { get; set; } 

        /// <summary>Information that controls how passes are grouped together.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("groupingInfo")]
        public virtual GroupingInfo GroupingInfo { get; set; } 

        /// <summary>Whether this object is currently linked to a single device. This field is set by the platform when
        /// a user saves the object, linking it to their device.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hasLinkedDevice")]
        public virtual System.Nullable<bool> HasLinkedDevice { get; set; } 

        /// <summary>Indicates if the object has users. This field is set by the platform.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hasUsers")]
        public virtual System.Nullable<bool> HasUsers { get; set; } 

        /// <summary>Required. The title of the pass, such as "50% off coupon" or "Library card" or "Voucher". This
        /// field is required and appears in the title row of the pass detail view.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("header")]
        public virtual LocalizedString Header { get; set; } 

        /// <summary>Banner image displayed on the front of the card if present. The image will be displayed at 100%
        /// width.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("heroImage")]
        public virtual Image HeroImage { get; set; } 

        /// <summary>The background color for the card. If not set, the dominant color of the hero image is used, and if
        /// no hero image is set, the dominant color of the logo is used and if logo is not set, a color would be chosen
        /// by Google.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hexBackgroundColor")]
        public virtual string HexBackgroundColor { get; set; } 

        /// <summary>Required. The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is issued by Google and
        /// `identifier` is chosen by you. The unique identifier can only include alphanumeric characters, `.`, `_`, or
        /// `-`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("id")]
        public virtual string Id { get; set; } 

        /// <summary>Image module data. Only one of the image from class and one from object level will be rendered when
        /// both set.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("imageModulesData")]
        public virtual System.Collections.Generic.IList<ImageModuleData> ImageModulesData { get; set; } 

        /// <summary>linked_object_ids are a list of other objects such as event ticket, loyalty, offer, generic,
        /// giftcard, transit and boarding pass that should be automatically attached to this generic object. If a user
        /// had saved this generic card, then these linked_object_ids would be automatically pushed to the user's wallet
        /// (unless they turned off the setting to receive such linked passes). Object IDs should follow the format
        /// issuer ID.identifier where the former is issued by Google and the latter is chosen by you.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("linkedObjectIds")]
        public virtual System.Collections.Generic.IList<string> LinkedObjectIds { get; set; } 

        /// <summary>Links module data. If `linksModuleData` is also defined on the class, both will be displayed. The
        /// maximum number of these fields displayed is 10 from class and 10 from object.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("linksModuleData")]
        public virtual LinksModuleData LinksModuleData { get; set; } 

        /// <summary>The logo image of the pass. This image is displayed in the card detail view in upper left, and also
        /// on the list/thumbnail view. If the logo is not present, the first letter of `cardTitle` would be shown as
        /// logo.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("logo")]
        public virtual Image Logo { get; set; } 

        /// <summary>An array of messages displayed in the app. All users of this object will receive its associated
        /// messages. The maximum number of these fields is 10.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("messages")]
        public virtual System.Collections.Generic.IList<Message> Messages { get; set; } 

        /// <summary>The notification settings that are enabled for this object.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("notifications")]
        public virtual Notifications Notifications { get; set; } 

        /// <summary>Pass constraints for the object. Includes limiting NFC and screenshot behaviors.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("passConstraints")]
        public virtual PassConstraints PassConstraints { get; set; } 

        /// <summary>Private module data used to receive private textModulesData, imageModulesData or
        /// linksModuleData.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("privateModulesData")]
        public virtual System.Collections.Generic.IList<PrivateModuleData> PrivateModulesData { get; set; } 

        /// <summary>The rotating barcode settings/details.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("rotatingBarcode")]
        public virtual RotatingBarcode RotatingBarcode { get; set; } 

        /// <summary>Restrictions on the object that needs to be verified before the user tries to save the pass. Note
        /// that this restrictions will only be applied during save time. If the restrictions changed after a user saves
        /// the pass, the new restrictions will not be applied to an already saved pass.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("saveRestrictions")]
        public virtual SaveRestrictions SaveRestrictions { get; set; } 

        /// <summary>The value that will be transmitted to a Smart Tap certified terminal over NFC for this object. The
        /// class level fields `enableSmartTap` and `redemptionIssuers` must also be set up correctly in order for the
        /// pass to support Smart Tap. Only ASCII characters are supported.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapRedemptionValue")]
        public virtual string SmartTapRedemptionValue { get; set; } 

        /// <summary>The state of the object. This field is used to determine how an object is displayed in the app. For
        /// example, an `inactive` object is moved to the "Expired passes" section. If this is not provided, the object
        /// would be considered `ACTIVE`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("state")]
        public virtual string State { get; set; } 

        /// <summary>The title label of the pass, such as location where this pass can be used. Appears right above the
        /// title in the title row in the pass detail view.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("subheader")]
        public virtual LocalizedString Subheader { get; set; } 

        /// <summary>Text module data. If `textModulesData` is also defined on the class, both will be displayed. The
        /// maximum number of these fields displayed is 10 from class and 10 from object.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("textModulesData")]
        public virtual System.Collections.Generic.IList<TextModuleData> TextModulesData { get; set; } 

        /// <summary>The time period this object will be considered valid or usable. When the time period is passed, the
        /// object will be considered expired, which will affect the rendering on user's devices.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("validTimeInterval")]
        public virtual TimeInterval ValidTimeInterval { get; set; } 

        /// <summary>The wide logo of the pass. When provided, this will be used in place of the logo in the top left of
        /// the card view.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("wideLogo")]
        public virtual Image WideLogo { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Response to adding a new issuer message to the object. This contains the entire updated
    /// GenericObject.</summary>
    public class GenericObjectAddMessageResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The updated GenericObject resource.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resource")]
        public virtual GenericObject Resource { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>List response which contains the list of all generic objects for a given issuer ID.</summary>
    public class GenericObjectListResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Pagination of the response.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("pagination")]
        public virtual Pagination Pagination { get; set; } 

        /// <summary>Resources corresponding to the list request.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resources")]
        public virtual System.Collections.Generic.IList<GenericObject> Resources { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Request to upload rotating barcode values.</summary>
    public class GenericObjectUploadRotatingBarcodeValuesRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A reference to the rotating barcode values payload that was uploaded.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("blob")]
        public virtual Media Blob { get; set; } 

        /// <summary>Extra information about the uploaded media.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mediaRequestInfo")]
        public virtual MediaRequestInfo MediaRequestInfo { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Response for uploading rotating barcode values.</summary>
    public class GenericObjectUploadRotatingBarcodeValuesResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>A pass that contains generic private information.</summary>
    public class GenericPrivatePass : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Optional. Optional app or website link that will be displayed as a button on the front of the
        /// pass.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("appLinkData")]
        public virtual AppLinkData AppLinkData { get; set; } 

        /// <summary>Optional. The barcode type and value.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("barcode")]
        public virtual Barcode Barcode { get; set; } 

        /// <summary>Optional. Information that controls how passes are grouped together.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("groupingInfo")]
        public virtual GroupingInfo GroupingInfo { get; set; } 

        /// <summary>Required. A header to display in the header row. Required. This can be a name of the pass issuer or
        /// some other name you would like to be displayed in the header row.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("header")]
        public virtual LocalizedString Header { get; set; } 

        /// <summary>Required. The header logo image of the card. We recommend that this be the logo of the pass
        /// provider. This image is displayed in the header row of the card detail and is also used as the icon for the
        /// shortcut on the Android home screen. Should follow logo guidelines and shouldn't include any PII.
        /// https://developers.google.com/pay/passes/guides/api-guidelines/brand-guidelines#logo-image-
        /// guidelines</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("headerLogo")]
        public virtual Image HeaderLogo { get; set; } 

        /// <summary>Optional. The hero image of the card, shouldn't include any PII and should follow hero image
        /// guidelines. Will be displayed on top row in the card details.
        /// https://developers.google.com/pay/passes/guides/api-guidelines/brand-guidelines#hero-image-
        /// guidelines</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("heroImage")]
        public virtual Image HeroImage { get; set; } 

        /// <summary>Optional. The background color for the card. If not set the dominant color of the hero image is
        /// used, and if no hero image is set, the dominant color of the logo is used. The format is #rrggbb where
        /// rrggbb is a hex RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the RGB triplet
        /// which is #rgb, such as `#fc0`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hexBackgroundColor")]
        public virtual string HexBackgroundColor { get; set; } 

        /// <summary>Required. The unique identifier for a pass. This ID must be unique across all passes from an
        /// issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is issued by Google and
        /// `identifier` is chosen by you. The unique identifier can only include alphanumeric characters, `.` (dot),
        /// `_` (underscore), or `-` (dash).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("id")]
        public virtual string Id { get; set; } 

        /// <summary>Optional. Image module data. The maximum number of these fields displayed is 1.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("imageModulesData")]
        public virtual System.Collections.Generic.IList<ImageModuleData> ImageModulesData { get; set; } 

        /// <summary>Optional. Links module data. Can contain up to a maximum of 3 uris.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("linksModuleData")]
        public virtual LinksModuleData LinksModuleData { get; set; } 

        /// <summary>Optional. A short meta text to be displayed in the header row. This will be displayed to the right
        /// of the header. Please limit to 10 characters including whitespaces.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("metaText")]
        public virtual LocalizedString MetaText { get; set; } 

        /// <summary>Optional. Information to make the pass smart tappable.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapInfo")]
        public virtual SmartTapInfo SmartTapInfo { get; set; } 

        /// <summary>Optional. Text module data. Can specify up to a maximum of 20 items.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("textModulesData")]
        public virtual System.Collections.Generic.IList<TextModuleData> TextModulesData { get; set; } 

        /// <summary>Required. A title of this pass. Required. Appears in the title row which is below the header
        /// row.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("title")]
        public virtual LocalizedString Title { get; set; } 

        /// <summary>Optional. A label above the pass title. Appears in the title row which is below the header
        /// row.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("titleLabel")]
        public virtual LocalizedString TitleLabel { get; set; } 

        /// <summary>Required. Specify which `GenericPrivateType` the card belongs to.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("type")]
        public virtual string Type { get; set; } 

        /// <summary>Optional. The time period this pass will be `active` and pass can be used. A pass's state will be
        /// changed to `expired` when this time period has passed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("validTimeInterval")]
        public virtual TimeInterval ValidTimeInterval { get; set; } 

        /// <summary>The wide header logo image of the card. We recommend that this be the logo of the pass provider.
        /// When provided, this will be used in place of the logo and header in the header row of the card view. Should
        /// follow logo guidelines and shouldn't include any PII.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("wideHeaderLogo")]
        public virtual Image WideHeaderLogo { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class GiftCardClass : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Activation options for an activatable ticket.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("activationOptions")]
        public virtual ActivationOptions ActivationOptions { get; set; } 

        /// <summary>Determines whether the merchant supports gift card redemption using barcode. If true, app displays
        /// a barcode for the gift card on the Gift card details screen. If false, a barcode is not displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("allowBarcodeRedemption")]
        public virtual System.Nullable<bool> AllowBarcodeRedemption { get; set; } 

        /// <summary>Deprecated. Use `multipleDevicesAndHoldersAllowedStatus` instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("allowMultipleUsersPerObject")]
        public virtual System.Nullable<bool> AllowMultipleUsersPerObject { get; set; } 

        /// <summary>Optional app or website link that will be displayed as a button on the front of the pass. If
        /// AppLinkData is provided for the corresponding object that will be used instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("appLinkData")]
        public virtual AppLinkData AppLinkData { get; set; } 

        /// <summary>Details of BHN Integration for gift card balance sync.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("bhnIntegrationDetails")]
        public virtual BhnIntegrationDetails BhnIntegrationDetails { get; set; } 

        /// <summary>Callback options to be used to call the issuer back for every save/delete of an object for this
        /// class by the end-user. All objects of this class are eligible for the callback.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("callbackOptions")]
        public virtual CallbackOptions CallbackOptions { get; set; } 

        /// <summary>The label to display for the card number, such as "Card Number".</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cardNumberLabel")]
        public virtual string CardNumberLabel { get; set; } 

        /// <summary>Template information about how the class should be displayed. If unset, Google will fallback to a
        /// default set of fields to display.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("classTemplateInfo")]
        public virtual ClassTemplateInfo ClassTemplateInfo { get; set; } 

        /// <summary>Whether the merchant has consented for us to send them requests for balance inquiries. We should
        /// only allow balance inquiry if supported_features contains universal/partial balance inquiry AND merchant has
        /// consented to balance inquiry.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("consentToBalanceInquiry")]
        public virtual System.Nullable<bool> ConsentToBalanceInquiry { get; set; } 

        /// <summary>Country code used to display the card's country (when the user is not in that country), as well as
        /// to display localized content when content is not available in the user's locale.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("countryCode")]
        public virtual string CountryCode { get; set; } 

        /// <summary>Information about how the class may be discovered and instantiated from within the Google Pay
        /// app.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("discoverableProgram")]
        public virtual DiscoverableProgram DiscoverableProgram { get; set; } 

        /// <summary>Identifies whether this class supports Smart Tap. The `redemptionIssuers` and object level
        /// `smartTapRedemptionLevel` fields must also be set up correctly in order for a pass to support Smart
        /// Tap.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("enableSmartTap")]
        public virtual System.Nullable<bool> EnableSmartTap { get; set; } 

        /// <summary>The label to display for event number, such as "Target Event #".</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("eventNumberLabel")]
        public virtual string EventNumberLabel { get; set; } 

        /// <summary>When a barcode is not set for an instance, the configuration used to generate one. It may consist
        /// of multiple parts concatenated together such as the account id, card number, pin, event number, or other
        /// hard coded values. The data is normally stored in the mag stripe and printed on the card.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("generatedBarcodeParts")]
        public virtual System.Collections.Generic.IList<GeneratedBarcodePart> GeneratedBarcodeParts { get; set; } 

        /// <summary>The type of barcode to be used when generating a barcode. If not specified for loyalty TEXT_ONLY
        /// will be used, and for gift cards CODE_128 will be used.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("generatedBarcodeType")]
        public virtual string GeneratedBarcodeType { get; set; } 

        /// <summary>Optional banner image displayed on the front of the card. If none is present, nothing will be
        /// displayed. The image will display at 100% width.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("heroImage")]
        public virtual Image HeroImage { get; set; } 

        /// <summary>The background color for the card. If not set the dominant color of the hero image is used, and if
        /// no hero image is set, the dominant color of the logo is used. The format is #rrggbb where rrggbb is a hex
        /// RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the RGB triplet which is #rgb,
        /// such as `#fc0`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hexBackgroundColor")]
        public virtual string HexBackgroundColor { get; set; } 

        /// <summary>Identifies whether or not this class should display a barcode for the user. This can be set if the
        /// class will not be scannable for some reason (eg: if the merchant uses scanners that cannot read phone
        /// screens).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hideBarcode")]
        public virtual System.Nullable<bool> HideBarcode { get; set; } 

        /// <summary>The URI of your application's home page. Populating the URI in this field results in the exact same
        /// behavior as populating an URI in linksModuleData (when an object is rendered, a link to the homepage is
        /// shown in what would usually be thought of as the linksModuleData section of the object).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("homepageUri")]
        public virtual Uri HomepageUri { get; set; } 

        /// <summary>Required. The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and
        /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or
        /// '-'.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("id")]
        public virtual string Id { get; set; } 

        /// <summary>Image module data. The maximum number of these fields displayed is 1 from object level and 1 for
        /// class object level.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("imageModulesData")]
        public virtual System.Collections.Generic.IList<ImageModuleData> ImageModulesData { get; set; } 

        /// <summary>Deprecated. Use textModulesData instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("infoModuleData")]
        public virtual InfoModuleData InfoModuleData { get; set; } 

        /// <summary>Required. The issuer name. Recommended maximum length is 20 characters to ensure full string is
        /// displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("issuerName")]
        public virtual string IssuerName { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#giftCardClass"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>Links module data. If links module data is also defined on the object, both will be
        /// displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("linksModuleData")]
        public virtual LinksModuleData LinksModuleData { get; set; } 

        /// <summary>Translated strings for the card_number_label.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedCardNumberLabel")]
        public virtual LocalizedString LocalizedCardNumberLabel { get; set; } 

        /// <summary>Translated strings for the event_number_label.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedEventNumberLabel")]
        public virtual LocalizedString LocalizedEventNumberLabel { get; set; } 

        /// <summary>Translated strings for the issuer_name. Recommended maximum length is 20 characters to ensure full
        /// string is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedIssuerName")]
        public virtual LocalizedString LocalizedIssuerName { get; set; } 

        /// <summary>Translated strings for the merchant_name. The app may display an ellipsis after the first 20
        /// characters to ensure full string is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedMerchantName")]
        public virtual LocalizedString LocalizedMerchantName { get; set; } 

        /// <summary>Translated strings for the pin_label.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedPinLabel")]
        public virtual LocalizedString LocalizedPinLabel { get; set; } 

        /// <summary>Translated strings for the message displayed on the preview of a card before it is saved by a user
        /// to their account.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedSaveToAndroidPayPreviewMessage")]
        public virtual LocalizedString LocalizedSaveToAndroidPayPreviewMessage { get; set; } 

        /// <summary>Note: This field is currently not supported to trigger geo notifications.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locations")]
        public virtual System.Collections.Generic.IList<LatLongPoint> Locations { get; set; } 

        /// <summary>Merchant name, such as "Adam's Apparel". The app may display an ellipsis after the first 20
        /// characters to ensure full string is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("merchantName")]
        public virtual string MerchantName { get; set; } 

        /// <summary>An array of messages displayed in the app. All users of this object will receive its associated
        /// messages. The maximum number of these fields is 10.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("messages")]
        public virtual System.Collections.Generic.IList<Message> Messages { get; set; } 

        /// <summary>Identifies whether multiple users and devices will save the same object referencing this
        /// class.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("multipleDevicesAndHoldersAllowedStatus")]
        public virtual string MultipleDevicesAndHoldersAllowedStatus { get; set; } 

        /// <summary>Whether or not field updates to this class should trigger notifications. When set to NOTIFY, we
        /// will attempt to trigger a field update notification to users. These notifications will only be sent to users
        /// if the field is part of an allowlist. If not specified, no notification will be triggered. This setting is
        /// ephemeral and needs to be set with each PATCH or UPDATE request, otherwise a notification will not be
        /// triggered.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("notifyPreference")]
        public virtual string NotifyPreference { get; set; } 

        /// <summary>The label to display for the PIN, such as "4-digit PIN".</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("pinLabel")]
        public virtual string PinLabel { get; set; } 

        /// <summary>The logo of the gift card program or company. This logo is displayed in both the details and list
        /// views of the app.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("programLogo")]
        public virtual Image ProgramLogo { get; set; } 

        /// <summary>Identifies which redemption issuers can redeem the pass over Smart Tap. Redemption issuers are
        /// identified by their issuer ID. Redemption issuers must have at least one Smart Tap key configured. The
        /// `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also be set up correctly in order
        /// for a pass to support Smart Tap.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("redemptionIssuers")]
        public virtual System.Collections.Generic.IList<System.Nullable<long>> RedemptionIssuers { get; set; } 

        /// <summary>The review comments set by the platform when a class is marked `approved` or `rejected`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("review")]
        public virtual Review Review { get; set; } 

        /// <summary>Required. The status of the class. This field can be set to `draft` or `underReview` using the
        /// insert, patch, or update API calls. Once the review state is changed from `draft` it may not be changed back
        /// to `draft`. You should keep this field to `draft` when the class is under development. A `draft` class
        /// cannot be used to create any object. You should set this field to `underReview` when you believe the class
        /// is ready for use. The platform will automatically set this field to `approved` and it can be immediately
        /// used to create or migrate objects. When updating an already `approved` class you should keep setting this
        /// field to `underReview`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("reviewStatus")]
        public virtual string ReviewStatus { get; set; } 

        /// <summary>Message displayed on the preview of a card before it is saved by a user to their account.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("saveToAndroidPayPreviewMessage")]
        public virtual string SaveToAndroidPayPreviewMessage { get; set; } 

        /// <summary>Optional information about the security animation. If this is set a security animation will be
        /// rendered on pass details.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("securityAnimation")]
        public virtual SecurityAnimation SecurityAnimation { get; set; } 

        /// <summary>Indicates if authentication should be required when transmitting the valuable. If this is true, and
        /// the terminal does not support authentication then objects of this class will not be transmitted. May only by
        /// true when smart_tap_encryption_required is true.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapAuthenticationRequired")]
        public virtual System.Nullable<bool> SmartTapAuthenticationRequired { get; set; } 

        /// <summary>Indicates if encryption should be required when transmitting the valuable. If this is true, and the
        /// terminal does not support encryption, then objects of this class will not be transmitted. May only be true
        /// when enable_smart_tap is true.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapEncryptionRequired")]
        public virtual System.Nullable<bool> SmartTapEncryptionRequired { get; set; } 

        /// <summary>Determines how to generate the smart tap redemption value from the redemption identifier. If this
        /// field is populated, the user's smart tap redemption value will change whenever the redemption identifier
        /// changes.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapRedemptionValueGenerationParams")]
        public virtual SmartTapRedemptionValueGenerationParams SmartTapRedemptionValueGenerationParams { get; set; } 

        /// <summary>Text module data. If text module data is also defined on the class, both will be displayed. The
        /// maximum number of these fields displayed is 10 from the object and 10 from the class.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("textModulesData")]
        public virtual System.Collections.Generic.IList<TextModuleData> TextModulesData { get; set; } 

        /// <summary>A regex that describes what a valid redemption identifier for this class looks like.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("validRedemptionIdentifierRegex")]
        public virtual string ValidRedemptionIdentifierRegex { get; set; } 

        /// <summary>Deprecated</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("version")]
        public virtual System.Nullable<long> Version { get; set; } 

        /// <summary>View Unlock Requirement options for the gift card.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("viewUnlockRequirement")]
        public virtual string ViewUnlockRequirement { get; set; } 

        /// <summary>The wide logo of the gift card program or company. When provided, this will be used in place of the
        /// program logo in the top left of the card view.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("wideProgramLogo")]
        public virtual Image WideProgramLogo { get; set; } 

        /// <summary>Deprecated.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("wordMark")]
        public virtual Image WordMark { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class GiftCardClassAddMessageResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The updated GiftCardClass resource.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resource")]
        public virtual GiftCardClass Resource { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class GiftCardClassListResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Pagination of the response.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("pagination")]
        public virtual Pagination Pagination { get; set; } 

        /// <summary>Resources corresponding to the list request.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resources")]
        public virtual System.Collections.Generic.IList<GiftCardClass> Resources { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class GiftCardObject : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The activation status for the object. Required if the class has `activationOptions` set.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("activationStatus")]
        public virtual ActivationStatus ActivationStatus { get; set; } 

        /// <summary>Optional app or website link that will be displayed as a button on the front of the pass. If
        /// AppLinkData is provided for the corresponding class only object AppLinkData will be displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("appLinkData")]
        public virtual AppLinkData AppLinkData { get; set; } 

        /// <summary>The card's monetary balance.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("balance")]
        public virtual Money Balance { get; set; } 

        /// <summary>The date and time when the balance was last updated. Offset is required. If balance is updated and
        /// this property is not provided, system will default to the current time.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("balanceUpdateTime")]
        public virtual DateTime BalanceUpdateTime { get; set; } 

        /// <summary>The barcode type and value.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("barcode")]
        public virtual Barcode Barcode { get; set; } 

        /// <summary>Required. The card's number.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cardNumber")]
        public virtual string CardNumber { get; set; } 

        /// <summary>Required. The class associated with this object. The class must be of the same type as this object,
        /// must already exist, and must be approved. Class IDs should follow the format issuer ID.identifier where the
        /// former is issued by Google and latter is chosen by you.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("classId")]
        public virtual string ClassId { get; set; } 

        /// <summary>A copy of the inherited fields of the parent class. These fields are retrieved during a
        /// GET.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("classReference")]
        public virtual GiftCardClass ClassReference { get; set; } 

        /// <summary>Device context associated with the object.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("deviceContext")]
        public virtual DeviceContext DeviceContext { get; set; } 

        /// <summary>Indicates if notifications should explicitly be suppressed. If this field is set to true,
        /// regardless of the `messages` field, expiration notifications to the user will be suppressed. By default,
        /// this field is set to false. Currently, this can only be set for offers.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("disableExpirationNotification")]
        public virtual System.Nullable<bool> DisableExpirationNotification { get; set; } 

        /// <summary>The card's event number, an optional field used by some gift cards.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("eventNumber")]
        public virtual string EventNumber { get; set; } 

        /// <summary>Information that controls how passes are grouped together.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("groupingInfo")]
        public virtual GroupingInfo GroupingInfo { get; set; } 

        /// <summary>Whether this object is currently linked to a single device. This field is set by the platform when
        /// a user saves the object, linking it to their device. Intended for use by select partners. Contact support
        /// for additional information.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hasLinkedDevice")]
        public virtual System.Nullable<bool> HasLinkedDevice { get; set; } 

        /// <summary>Indicates if the object has users. This field is set by the platform.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hasUsers")]
        public virtual System.Nullable<bool> HasUsers { get; set; } 

        /// <summary>Optional banner image displayed on the front of the card. If none is present, hero image of the
        /// class, if present, will be displayed. If hero image of the class is also not present, nothing will be
        /// displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("heroImage")]
        public virtual Image HeroImage { get; set; } 

        /// <summary>Required. The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID.identifier where the former is issued by Google and
        /// latter is chosen by you. The unique identifier should only include alphanumeric characters, '.', '_', or
        /// '-'.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("id")]
        public virtual string Id { get; set; } 

        /// <summary>Image module data. The maximum number of these fields displayed is 1 from object level and 1 for
        /// class object level.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("imageModulesData")]
        public virtual System.Collections.Generic.IList<ImageModuleData> ImageModulesData { get; set; } 

        /// <summary>Deprecated. Use textModulesData instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("infoModuleData")]
        public virtual InfoModuleData InfoModuleData { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#giftCardObject"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>linked_object_ids are a list of other objects such as event ticket, loyalty, offer, generic,
        /// giftcard, transit and boarding pass that should be automatically attached to this giftcard object. If a user
        /// had saved this gift card, then these linked_object_ids would be automatically pushed to the user's wallet
        /// (unless they turned off the setting to receive such linked passes). Object IDs should follow the format
        /// issuer ID.identifier where the former is issued by Google and the latter is chosen by you.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("linkedObjectIds")]
        public virtual System.Collections.Generic.IList<string> LinkedObjectIds { get; set; } 

        [Newtonsoft.Json.JsonPropertyAttribute("linkedOfferIds")]
        public virtual System.Collections.Generic.IList<string> LinkedOfferIds { get; set; } 

        /// <summary>Links module data. If links module data is also defined on the class, both will be
        /// displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("linksModuleData")]
        public virtual LinksModuleData LinksModuleData { get; set; } 

        /// <summary>Note: This field is currently not supported to trigger geo notifications.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locations")]
        public virtual System.Collections.Generic.IList<LatLongPoint> Locations { get; set; } 

        /// <summary>An array of messages displayed in the app. All users of this object will receive its associated
        /// messages. The maximum number of these fields is 10.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("messages")]
        public virtual System.Collections.Generic.IList<Message> Messages { get; set; } 

        /// <summary>Whether or not field updates to this object should trigger notifications. When set to NOTIFY, we
        /// will attempt to trigger a field update notification to users. These notifications will only be sent to users
        /// if the field is part of an allowlist. If set to DO_NOT_NOTIFY or NOTIFICATION_SETTINGS_UNSPECIFIED, no
        /// notification will be triggered. This setting is ephemeral and needs to be set with each PATCH or UPDATE
        /// request, otherwise a notification will not be triggered.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("notifyPreference")]
        public virtual string NotifyPreference { get; set; } 

        /// <summary>Pass constraints for the object. Includes limiting NFC and screenshot behaviors.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("passConstraints")]
        public virtual PassConstraints PassConstraints { get; set; } 

        /// <summary>The card's PIN.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("pin")]
        public virtual string Pin { get; set; } 

        /// <summary>The rotating barcode type and value.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("rotatingBarcode")]
        public virtual RotatingBarcode RotatingBarcode { get; set; } 

        /// <summary>Restrictions on the object that needs to be verified before the user tries to save the pass. Note
        /// that this restrictions will only be applied during save time. If the restrictions changed after a user saves
        /// the pass, the new restrictions will not be applied to an already saved pass.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("saveRestrictions")]
        public virtual SaveRestrictions SaveRestrictions { get; set; } 

        /// <summary>The value that will be transmitted to a Smart Tap certified terminal over NFC for this object. The
        /// class level fields `enableSmartTap` and `redemptionIssuers` must also be set up correctly in order for the
        /// pass to support Smart Tap. Only ASCII characters are supported.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapRedemptionValue")]
        public virtual string SmartTapRedemptionValue { get; set; } 

        /// <summary>Required. The state of the object. This field is used to determine how an object is displayed in
        /// the app. For example, an `inactive` object is moved to the "Expired passes" section.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("state")]
        public virtual string State { get; set; } 

        /// <summary>Text module data. If text module data is also defined on the class, both will be displayed. The
        /// maximum number of these fields displayed is 10 from the object and 10 from the class.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("textModulesData")]
        public virtual System.Collections.Generic.IList<TextModuleData> TextModulesData { get; set; } 

        /// <summary>The time period this object will be `active` and object can be used. An object's state will be
        /// changed to `expired` when this time period has passed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("validTimeInterval")]
        public virtual TimeInterval ValidTimeInterval { get; set; } 

        /// <summary>Deprecated</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("version")]
        public virtual System.Nullable<long> Version { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class GiftCardObjectAddMessageResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The updated GiftCardObject resource.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resource")]
        public virtual GiftCardObject Resource { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class GiftCardObjectListResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Pagination of the response.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("pagination")]
        public virtual Pagination Pagination { get; set; } 

        /// <summary>Resources corresponding to the list request.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resources")]
        public virtual System.Collections.Generic.IList<GiftCardObject> Resources { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Request to upload rotating barcode values.</summary>
    public class GiftCardObjectUploadRotatingBarcodeValuesRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A reference to the rotating barcode values payload that was uploaded.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("blob")]
        public virtual Media Blob { get; set; } 

        /// <summary>Extra information about the uploaded media.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mediaRequestInfo")]
        public virtual MediaRequestInfo MediaRequestInfo { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Response for uploading rotating barcode values.</summary>
    public class GiftCardObjectUploadRotatingBarcodeValuesResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class GroupingInfo : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Optional grouping ID for grouping the passes with the same ID visually together. Grouping with
        /// different types of passes is allowed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("groupingId")]
        public virtual string GroupingId { get; set; } 

        /// <summary>Optional index for sorting the passes when they are grouped with other passes. Passes with lower
        /// sort index are shown before passes with higher sort index. If unspecified, the value is assumed to be
        /// INT_MAX. For two passes with the same sort index, the sorting behavior is undefined.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("sortIndex")]
        public virtual System.Nullable<int> SortIndex { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Wrapping type for Google hosted images. Next ID: 7</summary>
    public class Image : Google.Apis.Requests.IDirectResponseSchema
    {
        [Newtonsoft.Json.JsonPropertyAttribute("aspectRatio")]
        public virtual System.Nullable<float> AspectRatio { get; set; } 

        /// <summary>Description of the image used for accessibility.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("contentDescription")]
        public virtual LocalizedString ContentDescription { get; set; } 

        /// <summary>Static URI for the image, not tied to a user.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("googleUri")]
        public virtual ImageUri GoogleUri { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#image"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>Secure Fife URI for the image, tied to user's Gaia.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("secureFifeUri")]
        public virtual ImageUri SecureFifeUri { get; set; } 

        /// <summary>The URI for the image.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("sourceUri")]
        public virtual ImageUri SourceUri { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class ImageModuleData : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The ID associated with an image module. This field is here to enable ease of management of image
        /// modules.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("id")]
        public virtual string Id { get; set; } 

        /// <summary>A 100% width image.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mainImage")]
        public virtual Image MainImage { get; set; } 

        /// <summary>URI to follow when tapping on the image. This field is only used when an image is referenced in the
        /// details template override.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("tapTargetUri")]
        public virtual Uri TapTargetUri { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class ImageUri : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Additional information about the image, which is unused and retained only for backward
        /// compatibility.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("description")]
        public virtual string Description { get; set; } 

        /// <summary>Translated strings for the description, which are unused and retained only for backward
        /// compatibility.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedDescription")]
        public virtual LocalizedString LocalizedDescription { get; set; } 

        /// <summary>The location of the image. URIs must have a scheme.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("uri")]
        public virtual string Uri { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class InfoModuleData : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A list of collections of labels and values. These will be displayed one after the other in a
        /// singular column.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("labelValueRows")]
        public virtual System.Collections.Generic.IList<LabelValueRow> LabelValueRows { get; set; } 

        [Newtonsoft.Json.JsonPropertyAttribute("showLastUpdateTime")]
        public virtual System.Nullable<bool> ShowLastUpdateTime { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class Issuer : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Allows the issuer to provide their callback settings.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("callbackOptions")]
        public virtual CallbackOptions CallbackOptions { get; set; } 

        /// <summary>Issuer contact information.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("contactInfo")]
        public virtual IssuerContactInfo ContactInfo { get; set; } 

        /// <summary>URL for the issuer's home page.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("homepageUrl")]
        public virtual string HomepageUrl { get; set; } 

        /// <summary>The capabilities of the issuer.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("issuerCapabilities")]
        public virtual System.Collections.Generic.IList<string> IssuerCapabilities { get; set; } 

        /// <summary>The unique identifier for an issuer account. This is automatically generated when the issuer is
        /// inserted.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("issuerId")]
        public virtual System.Nullable<long> IssuerId { get; set; } 

        /// <summary>Holds information necessary to match a Knowledge Graph MID to an Issuer.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("knowledgeGraphMapping")]
        public virtual KnowledgeGraphMapping KnowledgeGraphMapping { get; set; } 

        /// <summary>The issuer's launch state.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("launchState")]
        public virtual string LaunchState { get; set; } 

        /// <summary>Describes the locations where valuables for this merchant can be used.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locationIdentifiers")]
        public virtual LocationIdentifiers LocationIdentifiers { get; set; } 

        /// <summary>Holds information about which apps can save valuables using the 3P SDK for this issuer. Note: This
        /// field is expected to be updated only from the merchant console, so requests updating this field need
        /// CallSource set to MERCHANT_CONSOLE.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("merchantAppConfig")]
        public virtual MerchantAppConfig MerchantAppConfig { get; set; } 

        /// <summary>Unique Merchant ID assosiated with this issuer. It will be automatically generated when the issuer
        /// is inserted.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("merchantId")]
        public virtual string MerchantId { get; set; } 

        /// <summary>The account name of the issuer.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("name")]
        public virtual string Name { get; set; } 

        /// <summary>The issuer's review state.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("reviewState")]
        public virtual string ReviewState { get; set; } 

        /// <summary>Available only to Smart Tap enabled partners. Contact support for additional guidance.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapMerchantData")]
        public virtual SmartTapMerchantData SmartTapMerchantData { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class IssuerContactInfo : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Email addresses which will receive alerts.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("alertsEmails")]
        public virtual System.Collections.Generic.IList<string> AlertsEmails { get; set; } 

        /// <summary>The primary contact email address.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("email")]
        public virtual string Email { get; set; } 

        /// <summary>The primary contact name.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("name")]
        public virtual string Name { get; set; } 

        /// <summary>The primary contact phone number.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("phone")]
        public virtual string Phone { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class IssuerListResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Resources corresponding to the list request.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resources")]
        public virtual System.Collections.Generic.IList<Issuer> Resources { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class IssuerToUserInfo : Google.Apis.Requests.IDirectResponseSchema
    {
        [Newtonsoft.Json.JsonPropertyAttribute("action")]
        public virtual string Action { get; set; } 

        [Newtonsoft.Json.JsonPropertyAttribute("signUpInfo")]
        public virtual SignUpInfo SignUpInfo { get; set; } 

        /// <summary>Currently not used, consider deprecating.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("url")]
        public virtual string Url { get; set; } 

        /// <summary>JSON web token for action S2AP.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("value")]
        public virtual string Value { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class JwtInsertResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Data that corresponds to the ids of the provided classes and objects in the JWT. resources will
        /// only include the non-empty arrays (i.e. if the JWT only includes eventTicketObjects, then that is the only
        /// field that will be present in resources).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resources")]
        public virtual Resources Resources { get; set; } 

        /// <summary>A URI that, when opened, will allow the end user to save the object(s) identified in the JWT to
        /// their Google account.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("saveUri")]
        public virtual string SaveUri { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class JwtResource : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A string representing a JWT of the format described at
        /// https://developers.google.com/wallet/reference/rest/v1/Jwt</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("jwt")]
        public virtual string Jwt { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class KnowledgeGraphMapping : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The Knowledge Graph machine ID of the issuer.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mid")]
        public virtual string Mid { get; set; } 

        /// <summary>The Status of this Knowledge Graph Mapping.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("status")]
        public virtual string Status { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>A pair of text strings to be displayed in the details view. Note we no longer display
    /// LabelValue/LabelValueRow as a table, instead a list of items.</summary>
    public class LabelValue : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The label for a specific row and column. Recommended maximum is 15 characters for a two-column
        /// layout and 30 characters for a one-column layout.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("label")]
        public virtual string Label { get; set; } 

        /// <summary>Translated strings for the label. Recommended maximum is 15 characters for a two-column layout and
        /// 30 characters for a one-column layout.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedLabel")]
        public virtual LocalizedString LocalizedLabel { get; set; } 

        /// <summary>Translated strings for the value. Recommended maximum is 15 characters for a two-column layout and
        /// 30 characters for a one-column layout.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedValue")]
        public virtual LocalizedString LocalizedValue { get; set; } 

        /// <summary>The value for a specific row and column. Recommended maximum is 15 characters for a two-column
        /// layout and 30 characters for a one-column layout.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("value")]
        public virtual string Value { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class LabelValueRow : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A list of labels and values. These will be displayed in a singular column, one after the other, not
        /// in multiple columns, despite the field name.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("columns")]
        public virtual System.Collections.Generic.IList<LabelValue> Columns { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class LatLongPoint : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#latLongPoint"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>The latitude specified as any value in the range of -90.0 through +90.0, both inclusive. Values
        /// outside these bounds will be rejected.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("latitude")]
        public virtual System.Nullable<double> Latitude { get; set; } 

        /// <summary>The longitude specified in the range -180.0 through +180.0, both inclusive. Values outside these
        /// bounds will be rejected.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("longitude")]
        public virtual System.Nullable<double> Longitude { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class LinksModuleData : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The list of URIs.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("uris")]
        public virtual System.Collections.Generic.IList<Uri> Uris { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class ListTemplateOverride : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Specifies from a predefined set of options or from a reference to the field what will be displayed
        /// in the first row. To set this override, set the FirstRowOption.fieldOption to the FieldSelector of your
        /// choice.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("firstRowOption")]
        public virtual FirstRowOption FirstRowOption { get; set; } 

        /// <summary>A reference to the field to be displayed in the second row. This option is only displayed if there
        /// are not multiple user objects in a group. If there is a group, the second row will always display a field
        /// shared by all objects. To set this override, please set secondRowOption to the FieldSelector of you
        /// choice.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("secondRowOption")]
        public virtual FieldSelector SecondRowOption { get; set; } 

        /// <summary>An unused/deprecated field. Setting it will have no effect on what the user sees.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("thirdRowOption")]
        public virtual FieldSelector ThirdRowOption { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Response containing the list of all valuable classes for an issuer (optionally for given
    /// type(s)).</summary>
    public class ListValuablesClassesResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Pagination of the response.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("pagination")]
        public virtual Pagination Pagination { get; set; } 

        /// <summary>Resources corresponding to the list request.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("valuablesClasses")]
        public virtual System.Collections.Generic.IList<ValuablesClass> ValuablesClasses { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class LocalizedString : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Contains the string to be displayed if no appropriate translation is available.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("defaultValue")]
        public virtual TranslatedString DefaultValue { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#localizedString"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>Contains the translations for the string.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("translatedValues")]
        public virtual System.Collections.Generic.IList<TranslatedString> TranslatedValues { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Contains merchant and chain identifiers that describe locations where valuables for a merchant can be
    /// used. Can contain any number of any type of the identifiers. To produce a comprehensive list of locations, this
    /// must be evaluated from all identifiers combined.</summary>
    public class LocationIdentifiers : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>go/chive clusters businesses into 'chains' and represents that data in MapFacts. Per Chive team,
        /// using the entity id, if available, is this most recommended way to identify chain locations in MapFacts.
        /// Prefer this over chain_feature_id, but chain_feature_id (if present) should still be used when computing
        /// locations.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("chainEntityIds")]
        public virtual System.Collections.Generic.IList<string> ChainEntityIds { get; set; } 

        /// <summary>In MapFacts chain data, member stores all point to a 'root feature' using RELATION_MEMBER_OF_CHAIN
        /// and that root feature has TypeCategory TYPE_BUSINESS_CHAIN. This feature id corresponds to the root feature
        /// which represents the abstract notion of a chain store. There can be multiple such roots, but that is encoded
        /// as repeated fingerprints.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("chainFeatureIds")]
        public virtual System.Collections.Generic.IList<FeatureIdProto> ChainFeatureIds { get; set; } 

        /// <summary>Gaia IDs to look up in Google My Business Backend (aka CBDB) for locations.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("merchantGaiaIds")]
        public virtual System.Collections.Generic.IList<System.Nullable<long>> MerchantGaiaIds { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class LoyaltyClass : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The account ID label, such as "Member ID." Recommended maximum length is 15 characters to ensure
        /// full string is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("accountIdLabel")]
        public virtual string AccountIdLabel { get; set; } 

        /// <summary>The account name label, such as "Member Name." Recommended maximum length is 15 characters to
        /// ensure full string is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("accountNameLabel")]
        public virtual string AccountNameLabel { get; set; } 

        /// <summary>Activation options for an activatable ticket.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("activationOptions")]
        public virtual ActivationOptions ActivationOptions { get; set; } 

        /// <summary>Deprecated. Use `multipleDevicesAndHoldersAllowedStatus` instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("allowMultipleUsersPerObject")]
        public virtual System.Nullable<bool> AllowMultipleUsersPerObject { get; set; } 

        /// <summary>Optional app or website link that will be displayed as a button on the front of the pass. If
        /// AppLinkData is provided for the corresponding object that will be used instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("appLinkData")]
        public virtual AppLinkData AppLinkData { get; set; } 

        /// <summary>Callback options to be used to call the issuer back for every save/delete of an object for this
        /// class by the end-user. All objects of this class are eligible for the callback.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("callbackOptions")]
        public virtual CallbackOptions CallbackOptions { get; set; } 

        /// <summary>Template information about how the class should be displayed. If unset, Google will fallback to a
        /// default set of fields to display.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("classTemplateInfo")]
        public virtual ClassTemplateInfo ClassTemplateInfo { get; set; } 

        /// <summary>Country code used to display the card's country (when the user is not in that country), as well as
        /// to display localized content when content is not available in the user's locale.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("countryCode")]
        public virtual string CountryCode { get; set; } 

        /// <summary>Information about how the class may be discovered and instantiated from within the Google Pay
        /// app.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("discoverableProgram")]
        public virtual DiscoverableProgram DiscoverableProgram { get; set; } 

        /// <summary>Identifies whether this class supports Smart Tap. The `redemptionIssuers` and one of object level
        /// `smartTapRedemptionLevel`, barcode.value`, or `accountId` fields must also be set up correctly in order for
        /// a pass to support Smart Tap.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("enableSmartTap")]
        public virtual System.Nullable<bool> EnableSmartTap { get; set; } 

        /// <summary>When a barcode is not set for an instance, the configuration used to generate one. It may consist
        /// of multiple parts concatenated together such as the account id, card number, pin, event number, or other
        /// hard coded values. The data is normally stored in the mag stripe and printed on the card.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("generatedBarcodeParts")]
        public virtual System.Collections.Generic.IList<GeneratedBarcodePart> GeneratedBarcodeParts { get; set; } 

        /// <summary>The type of barcode to be used when generating a barcode. If not specified for loyalty TEXT_ONLY
        /// will be used, and for gift cards CODE_128 will be used.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("generatedBarcodeType")]
        public virtual string GeneratedBarcodeType { get; set; } 

        /// <summary>Optional banner image displayed on the front of the card. If none is present, nothing will be
        /// displayed. The image will display at 100% width.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("heroImage")]
        public virtual Image HeroImage { get; set; } 

        /// <summary>The background color for the card. If not set the dominant color of the hero image is used, and if
        /// no hero image is set, the dominant color of the logo is used. The format is #rrggbb where rrggbb is a hex
        /// RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the RGB triplet which is #rgb,
        /// such as `#fc0`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hexBackgroundColor")]
        public virtual string HexBackgroundColor { get; set; } 

        /// <summary>Identifies whether or not this class should display a barcode for the user. This can be set if the
        /// class will not be scannable for some reason (eg: if the merchant uses scanners that cannot read phone
        /// screens).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hideBarcode")]
        public virtual System.Nullable<bool> HideBarcode { get; set; } 

        /// <summary>The URI of your application's home page. Populating the URI in this field results in the exact same
        /// behavior as populating an URI in linksModuleData (when an object is rendered, a link to the homepage is
        /// shown in what would usually be thought of as the linksModuleData section of the object).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("homepageUri")]
        public virtual Uri HomepageUri { get; set; } 

        /// <summary>Required. The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and
        /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or
        /// '-'.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("id")]
        public virtual string Id { get; set; } 

        /// <summary>Image module data. The maximum number of these fields displayed is 1 from object level and 1 for
        /// class object level.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("imageModulesData")]
        public virtual System.Collections.Generic.IList<ImageModuleData> ImageModulesData { get; set; } 

        /// <summary>Deprecated. Use textModulesData instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("infoModuleData")]
        public virtual InfoModuleData InfoModuleData { get; set; } 

        /// <summary>Required. The issuer name. Recommended maximum length is 20 characters to ensure full string is
        /// displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("issuerName")]
        public virtual string IssuerName { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#loyaltyClass"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>Links module data. If links module data is also defined on the object, both will be
        /// displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("linksModuleData")]
        public virtual LinksModuleData LinksModuleData { get; set; } 

        /// <summary>Translated strings for the account_id_label. Recommended maximum length is 15 characters to ensure
        /// full string is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedAccountIdLabel")]
        public virtual LocalizedString LocalizedAccountIdLabel { get; set; } 

        /// <summary>Translated strings for the account_name_label. Recommended maximum length is 15 characters to
        /// ensure full string is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedAccountNameLabel")]
        public virtual LocalizedString LocalizedAccountNameLabel { get; set; } 

        /// <summary>Translated strings for the issuer_name. Recommended maximum length is 20 characters to ensure full
        /// string is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedIssuerName")]
        public virtual LocalizedString LocalizedIssuerName { get; set; } 

        /// <summary>Translated strings for the program_name. The app may display an ellipsis after the first 20
        /// characters to ensure full string is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedProgramName")]
        public virtual LocalizedString LocalizedProgramName { get; set; } 

        /// <summary>Translated strings for the rewards_tier. Recommended maximum length is 7 characters to ensure full
        /// string is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedRewardsTier")]
        public virtual LocalizedString LocalizedRewardsTier { get; set; } 

        /// <summary>Translated strings for the rewards_tier_label. Recommended maximum length is 9 characters to ensure
        /// full string is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedRewardsTierLabel")]
        public virtual LocalizedString LocalizedRewardsTierLabel { get; set; } 

        /// <summary>Translated strings for the message displayed on the preview of a card before it is saved by a user
        /// to their account.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedSaveToAndroidPayPreviewMessage")]
        public virtual LocalizedString LocalizedSaveToAndroidPayPreviewMessage { get; set; } 

        /// <summary>Translated strings for the secondary_rewards_tier.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedSecondaryRewardsTier")]
        public virtual LocalizedString LocalizedSecondaryRewardsTier { get; set; } 

        /// <summary>Translated strings for the secondary_rewards_tier_label.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedSecondaryRewardsTierLabel")]
        public virtual LocalizedString LocalizedSecondaryRewardsTierLabel { get; set; } 

        /// <summary>Note: This field is currently not supported to trigger geo notifications.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locations")]
        public virtual System.Collections.Generic.IList<LatLongPoint> Locations { get; set; } 

        /// <summary>An array of messages displayed in the app. All users of this object will receive its associated
        /// messages. The maximum number of these fields is 10.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("messages")]
        public virtual System.Collections.Generic.IList<Message> Messages { get; set; } 

        /// <summary>Identifies whether multiple users and devices will save the same object referencing this
        /// class.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("multipleDevicesAndHoldersAllowedStatus")]
        public virtual string MultipleDevicesAndHoldersAllowedStatus { get; set; } 

        /// <summary>Whether or not field updates to this class should trigger notifications. When set to NOTIFY, we
        /// will attempt to trigger a field update notification to users. These notifications will only be sent to users
        /// if the field is part of an allowlist. If not specified, no notification will be triggered. This setting is
        /// ephemeral and needs to be set with each PATCH or UPDATE request, otherwise a notification will not be
        /// triggered.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("notifyPreference")]
        public virtual string NotifyPreference { get; set; } 

        /// <summary>Required. The logo of the loyalty program or company. This logo is displayed in both the details
        /// and list views of the app.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("programLogo")]
        public virtual Image ProgramLogo { get; set; } 

        /// <summary>Required. The program name, such as "Adam's Apparel". The app may display an ellipsis after the
        /// first 20 characters to ensure full string is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("programName")]
        public virtual string ProgramName { get; set; } 

        /// <summary>Identifies which redemption issuers can redeem the pass over Smart Tap. Redemption issuers are
        /// identified by their issuer ID. Redemption issuers must have at least one Smart Tap key configured. The
        /// `enableSmartTap` and one of object level `smartTapRedemptionValue`, barcode.value`, or `accountId` fields
        /// must also be set up correctly in order for a pass to support Smart Tap.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("redemptionIssuers")]
        public virtual System.Collections.Generic.IList<System.Nullable<long>> RedemptionIssuers { get; set; } 

        /// <summary>The review comments set by the platform when a class is marked `approved` or `rejected`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("review")]
        public virtual Review Review { get; set; } 

        /// <summary>Required. The status of the class. This field can be set to `draft` or `underReview` using the
        /// insert, patch, or update API calls. Once the review state is changed from `draft` it may not be changed back
        /// to `draft`. You should keep this field to `draft` when the class is under development. A `draft` class
        /// cannot be used to create any object. You should set this field to `underReview` when you believe the class
        /// is ready for use. The platform will automatically set this field to `approved` and it can be immediately
        /// used to create or migrate objects. When updating an already `approved` class you should keep setting this
        /// field to `underReview`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("reviewStatus")]
        public virtual string ReviewStatus { get; set; } 

        /// <summary>The rewards tier, such as "Gold" or "Platinum." Recommended maximum length is 7 characters to
        /// ensure full string is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("rewardsTier")]
        public virtual string RewardsTier { get; set; } 

        /// <summary>The rewards tier label, such as "Rewards Tier." Recommended maximum length is 9 characters to
        /// ensure full string is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("rewardsTierLabel")]
        public virtual string RewardsTierLabel { get; set; } 

        /// <summary>Message displayed on the preview of a card before it is saved by a user to their account.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("saveToAndroidPayPreviewMessage")]
        public virtual string SaveToAndroidPayPreviewMessage { get; set; } 

        /// <summary>The secondary rewards tier, such as "Gold" or "Platinum."</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("secondaryRewardsTier")]
        public virtual string SecondaryRewardsTier { get; set; } 

        /// <summary>The secondary rewards tier label, such as "Rewards Tier."</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("secondaryRewardsTierLabel")]
        public virtual string SecondaryRewardsTierLabel { get; set; } 

        /// <summary>Optional information about the security animation. If this is set a security animation will be
        /// rendered on pass details.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("securityAnimation")]
        public virtual SecurityAnimation SecurityAnimation { get; set; } 

        /// <summary>Indicates if authentication should be required when transmitting the valuable. If this is true, and
        /// the terminal does not support authentication then objects of this class will not be transmitted. May only by
        /// true when smart_tap_encryption_required is true.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapAuthenticationRequired")]
        public virtual System.Nullable<bool> SmartTapAuthenticationRequired { get; set; } 

        /// <summary>Indicates if encryption should be required when transmitting the valuable. If this is true, and the
        /// terminal does not support encryption, then objects of this class will not be transmitted. May only be true
        /// when enable_smart_tap is true.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapEncryptionRequired")]
        public virtual System.Nullable<bool> SmartTapEncryptionRequired { get; set; } 

        /// <summary>Determines how to generate the smart tap redemption value from the redemption identifier. If this
        /// field is populated, the user's smart tap redemption value will change whenever the redemption identifier
        /// changes.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapRedemptionValueGenerationParams")]
        public virtual SmartTapRedemptionValueGenerationParams SmartTapRedemptionValueGenerationParams { get; set; } 

        /// <summary>Text module data. If text module data is also defined on the class, both will be displayed. The
        /// maximum number of these fields displayed is 10 from the object and 10 from the class.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("textModulesData")]
        public virtual System.Collections.Generic.IList<TextModuleData> TextModulesData { get; set; } 

        /// <summary>A regex that describes what a valid redemption identifier for this class looks like.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("validRedemptionIdentifierRegex")]
        public virtual string ValidRedemptionIdentifierRegex { get; set; } 

        /// <summary>Deprecated</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("version")]
        public virtual System.Nullable<long> Version { get; set; } 

        /// <summary>View Unlock Requirement options for the loyalty card.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("viewUnlockRequirement")]
        public virtual string ViewUnlockRequirement { get; set; } 

        /// <summary>The wide logo of the loyalty program or company. When provided, this will be used in place of the
        /// program logo in the top left of the card view.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("wideProgramLogo")]
        public virtual Image WideProgramLogo { get; set; } 

        /// <summary>Deprecated.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("wordMark")]
        public virtual Image WordMark { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class LoyaltyClassAddMessageResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The updated LoyaltyClass resource.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resource")]
        public virtual LoyaltyClass Resource { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class LoyaltyClassListResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Pagination of the response.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("pagination")]
        public virtual Pagination Pagination { get; set; } 

        /// <summary>Resources corresponding to the list request.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resources")]
        public virtual System.Collections.Generic.IList<LoyaltyClass> Resources { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class LoyaltyObject : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The loyalty account identifier. Recommended maximum length is 20 characters.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("accountId")]
        public virtual string AccountId { get; set; } 

        /// <summary>The loyalty account holder name, such as "John Smith." Recommended maximum length is 20 characters
        /// to ensure full string is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("accountName")]
        public virtual string AccountName { get; set; } 

        /// <summary>The activation status for the object. Required if the class has `activationOptions` set.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("activationStatus")]
        public virtual ActivationStatus ActivationStatus { get; set; } 

        /// <summary>Optional app or website link that will be displayed as a button on the front of the pass. If
        /// AppLinkData is provided for the corresponding class only object AppLinkData will be displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("appLinkData")]
        public virtual AppLinkData AppLinkData { get; set; } 

        /// <summary>The barcode type and value.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("barcode")]
        public virtual Barcode Barcode { get; set; } 

        /// <summary>Required. The class associated with this object. The class must be of the same type as this object,
        /// must already exist, and must be approved. Class IDs should follow the format issuer ID.identifier where the
        /// former is issued by Google and latter is chosen by you.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("classId")]
        public virtual string ClassId { get; set; } 

        /// <summary>A copy of the inherited fields of the parent class. These fields are retrieved during a
        /// GET.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("classReference")]
        public virtual LoyaltyClass ClassReference { get; set; } 

        /// <summary>Device context associated with the object.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("deviceContext")]
        public virtual DeviceContext DeviceContext { get; set; } 

        /// <summary>Indicates if notifications should explicitly be suppressed. If this field is set to true,
        /// regardless of the `messages` field, expiration notifications to the user will be suppressed. By default,
        /// this field is set to false. Currently, this can only be set for offers.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("disableExpirationNotification")]
        public virtual System.Nullable<bool> DisableExpirationNotification { get; set; } 

        /// <summary>Information that controls how passes are grouped together.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("groupingInfo")]
        public virtual GroupingInfo GroupingInfo { get; set; } 

        /// <summary>Whether this object is currently linked to a single device. This field is set by the platform when
        /// a user saves the object, linking it to their device. Intended for use by select partners. Contact support
        /// for additional information.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hasLinkedDevice")]
        public virtual System.Nullable<bool> HasLinkedDevice { get; set; } 

        /// <summary>Indicates if the object has users. This field is set by the platform.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hasUsers")]
        public virtual System.Nullable<bool> HasUsers { get; set; } 

        /// <summary>Optional banner image displayed on the front of the card. If none is present, hero image of the
        /// class, if present, will be displayed. If hero image of the class is also not present, nothing will be
        /// displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("heroImage")]
        public virtual Image HeroImage { get; set; } 

        /// <summary>Required. The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID.identifier where the former is issued by Google and
        /// latter is chosen by you. The unique identifier should only include alphanumeric characters, '.', '_', or
        /// '-'.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("id")]
        public virtual string Id { get; set; } 

        /// <summary>Image module data. The maximum number of these fields displayed is 1 from object level and 1 for
        /// class object level.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("imageModulesData")]
        public virtual System.Collections.Generic.IList<ImageModuleData> ImageModulesData { get; set; } 

        /// <summary>Deprecated. Use textModulesData instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("infoModuleData")]
        public virtual InfoModuleData InfoModuleData { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#loyaltyObject"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>linked_object_ids are a list of other objects such as event ticket, loyalty, offer, generic,
        /// giftcard, transit and boarding pass that should be automatically attached to this loyalty object. If a user
        /// had saved this loyalty card, then these linked_object_ids would be automatically pushed to the user's wallet
        /// (unless they turned off the setting to receive such linked passes). Object IDs should follow the format
        /// issuer ID.identifier where the former is issued by Google and the latter is chosen by you.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("linkedObjectIds")]
        public virtual System.Collections.Generic.IList<string> LinkedObjectIds { get; set; } 

        /// <summary>A list of offer objects linked to this loyalty card. The offer objects must already exist. Offer
        /// object IDs should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("linkedOfferIds")]
        public virtual System.Collections.Generic.IList<string> LinkedOfferIds { get; set; } 

        /// <summary>Links module data. If links module data is also defined on the class, both will be
        /// displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("linksModuleData")]
        public virtual LinksModuleData LinksModuleData { get; set; } 

        /// <summary>Note: This field is currently not supported to trigger geo notifications.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locations")]
        public virtual System.Collections.Generic.IList<LatLongPoint> Locations { get; set; } 

        /// <summary>The loyalty reward points label, balance, and type.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("loyaltyPoints")]
        public virtual LoyaltyPoints LoyaltyPoints { get; set; } 

        /// <summary>The loyalty profile. Internal only.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("loyaltyProfile")]
        public virtual LoyaltyProfile LoyaltyProfile { get; set; } 

        /// <summary>An array of messages displayed in the app. All users of this object will receive its associated
        /// messages. The maximum number of these fields is 10.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("messages")]
        public virtual System.Collections.Generic.IList<Message> Messages { get; set; } 

        /// <summary>Whether or not field updates to this object should trigger notifications. When set to NOTIFY, we
        /// will attempt to trigger a field update notification to users. These notifications will only be sent to users
        /// if the field is part of an allowlist. If set to DO_NOT_NOTIFY or NOTIFICATION_SETTINGS_UNSPECIFIED, no
        /// notification will be triggered. This setting is ephemeral and needs to be set with each PATCH or UPDATE
        /// request, otherwise a notification will not be triggered.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("notifyPreference")]
        public virtual string NotifyPreference { get; set; } 

        /// <summary>Pass constraints for the object. Includes limiting NFC and screenshot behaviors.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("passConstraints")]
        public virtual PassConstraints PassConstraints { get; set; } 

        /// <summary>The rotating barcode type and value.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("rotatingBarcode")]
        public virtual RotatingBarcode RotatingBarcode { get; set; } 

        /// <summary>Restrictions on the object that needs to be verified before the user tries to save the pass. Note
        /// that this restrictions will only be applied during save time. If the restrictions changed after a user saves
        /// the pass, the new restrictions will not be applied to an already saved pass.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("saveRestrictions")]
        public virtual SaveRestrictions SaveRestrictions { get; set; } 

        /// <summary>The secondary loyalty reward points label, balance, and type. Shown in addition to the primary
        /// loyalty points.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("secondaryLoyaltyPoints")]
        public virtual LoyaltyPoints SecondaryLoyaltyPoints { get; set; } 

        /// <summary>The value that will be transmitted to a Smart Tap certified terminal over NFC for this object. The
        /// class level fields `enableSmartTap` and `redemptionIssuers` must also be set up correctly in order for the
        /// pass to support Smart Tap. Only ASCII characters are supported. If this value is not set but the class level
        /// fields `enableSmartTap` and `redemptionIssuers` are set up correctly, the `barcode.value` or the `accountId`
        /// fields are used as fallback if present.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapRedemptionValue")]
        public virtual string SmartTapRedemptionValue { get; set; } 

        /// <summary>Required. The state of the object. This field is used to determine how an object is displayed in
        /// the app. For example, an `inactive` object is moved to the "Expired passes" section.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("state")]
        public virtual string State { get; set; } 

        /// <summary>Text module data. If text module data is also defined on the class, both will be displayed. The
        /// maximum number of these fields displayed is 10 from the object and 10 from the class.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("textModulesData")]
        public virtual System.Collections.Generic.IList<TextModuleData> TextModulesData { get; set; } 

        /// <summary>The time period this object will be `active` and object can be used. An object's state will be
        /// changed to `expired` when this time period has passed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("validTimeInterval")]
        public virtual TimeInterval ValidTimeInterval { get; set; } 

        /// <summary>Deprecated</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("version")]
        public virtual System.Nullable<long> Version { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class LoyaltyObjectAddMessageResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The updated LoyaltyObject resource.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resource")]
        public virtual LoyaltyObject Resource { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class LoyaltyObjectListResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Pagination of the response.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("pagination")]
        public virtual Pagination Pagination { get; set; } 

        /// <summary>Resources corresponding to the list request.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resources")]
        public virtual System.Collections.Generic.IList<LoyaltyObject> Resources { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Request to upload rotating barcode values.</summary>
    public class LoyaltyObjectUploadRotatingBarcodeValuesRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A reference to the rotating barcode values payload that was uploaded.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("blob")]
        public virtual Media Blob { get; set; } 

        /// <summary>Extra information about the uploaded media.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mediaRequestInfo")]
        public virtual MediaRequestInfo MediaRequestInfo { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Response for uploading rotating barcode values.</summary>
    public class LoyaltyObjectUploadRotatingBarcodeValuesResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class LoyaltyPoints : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The account holder's loyalty point balance, such as "500" or "$10.00". Recommended maximum length
        /// is 7 characters. This is a required field of `loyaltyPoints` and `secondaryLoyaltyPoints`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("balance")]
        public virtual LoyaltyPointsBalance Balance { get; set; } 

        /// <summary>The loyalty points label, such as "Points". Recommended maximum length is 9 characters.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("label")]
        public virtual string Label { get; set; } 

        /// <summary>Translated strings for the label. Recommended maximum length is 9 characters.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedLabel")]
        public virtual LocalizedString LocalizedLabel { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class LoyaltyPointsBalance : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The double form of a balance. Only one of these subtypes (string, int, double, money) should be
        /// populated.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("double")]
        public virtual System.Nullable<double> Double__ { get; set; } 

        /// <summary>The integer form of a balance. Only one of these subtypes (string, int, double, money) should be
        /// populated.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("int")]
        public virtual System.Nullable<int> Int__ { get; set; } 

        /// <summary>The money form of a balance. Only one of these subtypes (string, int, double, money) should be
        /// populated.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("money")]
        public virtual Money Money { get; set; } 

        /// <summary>The string form of a balance. Only one of these subtypes (string, int, double, money) should be
        /// populated.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("string")]
        public virtual string String__ { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>The loyalty profile information retrieved from issuer's user profile api.</summary>
    public class LoyaltyProfile : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The user level of the loyalty profile.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("userLevel")]
        public virtual UserLevel UserLevel { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>A reference to data stored on the filesystem, on GFS or in blobstore.</summary>
    public class Media : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Deprecated, use one of explicit hash type fields instead. Algorithm used for calculating the hash.
        /// As of 2011/01/21, "MD5" is the only possible value for this field. New values may be added at any
        /// time.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("algorithm")]
        public virtual string Algorithm { get; set; } 

        /// <summary>Use object_id instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("bigstoreObjectRef")]
        public virtual string BigstoreObjectRef { get; set; } 

        /// <summary>Blobstore v1 reference, set if reference_type is BLOBSTORE_REF This should be the byte
        /// representation of a blobstore.BlobRef. Since Blobstore is deprecating v1, use blobstore2_info instead. For
        /// now, any v2 blob will also be represented in this field as v1 BlobRef.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("blobRef")]
        public virtual string BlobRef { get; set; } 

        /// <summary>Blobstore v2 info, set if reference_type is BLOBSTORE_REF and it refers to a v2 blob.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("blobstore2Info")]
        public virtual Blobstore2Info Blobstore2Info { get; set; } 

        /// <summary>A composite media composed of one or more media objects, set if reference_type is COMPOSITE_MEDIA.
        /// The media length field must be set to the sum of the lengths of all composite media objects. Note: All
        /// composite media must have length specified.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("compositeMedia")]
        public virtual System.Collections.Generic.IList<CompositeMedia> CompositeMedia { get; set; } 

        /// <summary>MIME type of the data</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("contentType")]
        public virtual string ContentType { get; set; } 

        /// <summary>Extended content type information provided for Scotty uploads.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("contentTypeInfo")]
        public virtual ContentTypeInfo ContentTypeInfo { get; set; } 

        /// <summary>A binary data reference for a media download. Serves as a technology-agnostic binary reference in
        /// some Google infrastructure. This value is a serialized storage_cosmo.BinaryReference proto. Storing it as
        /// bytes is a hack to get around the fact that the cosmo proto (as well as others it includes) doesn't support
        /// JavaScript. This prevents us from including the actual type of this field.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cosmoBinaryReference")]
        public virtual string CosmoBinaryReference { get; set; } 

        /// <summary>For Scotty Uploads: Scotty-provided hashes for uploads For Scotty Downloads: (WARNING: DO NOT USE
        /// WITHOUT PERMISSION FROM THE SCOTTY TEAM.) A Hash provided by the agent to be used to verify the data being
        /// downloaded. Currently only supported for inline payloads. Further, only crc32c_hash is currently
        /// supported.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("crc32cHash")]
        public virtual System.Nullable<long> Crc32cHash { get; set; } 

        /// <summary>Set if reference_type is DIFF_CHECKSUMS_RESPONSE.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("diffChecksumsResponse")]
        public virtual DiffChecksumsResponse DiffChecksumsResponse { get; set; } 

        /// <summary>Set if reference_type is DIFF_DOWNLOAD_RESPONSE.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("diffDownloadResponse")]
        public virtual DiffDownloadResponse DiffDownloadResponse { get; set; } 

        /// <summary>Set if reference_type is DIFF_UPLOAD_REQUEST.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("diffUploadRequest")]
        public virtual DiffUploadRequest DiffUploadRequest { get; set; } 

        /// <summary>Set if reference_type is DIFF_UPLOAD_RESPONSE.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("diffUploadResponse")]
        public virtual DiffUploadResponse DiffUploadResponse { get; set; } 

        /// <summary>Set if reference_type is DIFF_VERSION_RESPONSE.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("diffVersionResponse")]
        public virtual DiffVersionResponse DiffVersionResponse { get; set; } 

        /// <summary>Parameters for a media download.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("downloadParameters")]
        public virtual DownloadParameters DownloadParameters { get; set; } 

        /// <summary>Original file name</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("filename")]
        public virtual string Filename { get; set; } 

        /// <summary>Deprecated, use one of explicit hash type fields instead. These two hash related fields will only
        /// be populated on Scotty based media uploads and will contain the content of the hash group in the
        /// NotificationRequest:
        /// http://cs/#google3/blobstore2/api/scotty/service/proto/upload_listener.proto&q=class:Hash Hex encoded hash
        /// value of the uploaded media.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hash")]
        public virtual string Hash { get; set; } 

        /// <summary>For Scotty uploads only. If a user sends a hash code and the backend has requested that Scotty
        /// verify the upload against the client hash, Scotty will perform the check on behalf of the backend and will
        /// reject it if the hashes don't match. This is set to true if Scotty performed this verification.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hashVerified")]
        public virtual System.Nullable<bool> HashVerified { get; set; } 

        /// <summary>Media data, set if reference_type is INLINE</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("inline")]
        public virtual string Inline { get; set; } 

        /// <summary>|is_potential_retry| is set false only when Scotty is certain that it has not sent the request
        /// before. When a client resumes an upload, this field must be set true in agent calls, because Scotty cannot
        /// be certain that it has never sent the request before due to potential failure in the session state
        /// persistence.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("isPotentialRetry")]
        public virtual System.Nullable<bool> IsPotentialRetry { get; set; } 

        /// <summary>Size of the data, in bytes</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("length")]
        public virtual System.Nullable<long> Length { get; set; } 

        /// <summary>Scotty-provided MD5 hash for an upload.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("md5Hash")]
        public virtual string Md5Hash { get; set; } 

        /// <summary>Media id to forward to the operation GetMedia. Can be set if reference_type is GET_MEDIA.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mediaId")]
        public virtual string MediaId { get; set; } 

        /// <summary>Reference to a TI Blob, set if reference_type is BIGSTORE_REF.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("objectId")]
        public virtual ObjectId ObjectId { get; set; } 

        /// <summary>Path to the data, set if reference_type is PATH</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("path")]
        public virtual string Path { get; set; } 

        /// <summary>Describes what the field reference contains.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("referenceType")]
        public virtual string ReferenceType { get; set; } 

        /// <summary>Scotty-provided SHA1 hash for an upload.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("sha1Hash")]
        public virtual string Sha1Hash { get; set; } 

        /// <summary>Scotty-provided SHA256 hash for an upload.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("sha256Hash")]
        public virtual string Sha256Hash { get; set; } 

        /// <summary>Time at which the media data was last updated, in milliseconds since UNIX epoch</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("timestamp")]
        public virtual System.Nullable<ulong> Timestamp { get; set; } 

        /// <summary>A unique fingerprint/version id for the media data</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("token")]
        public virtual string Token { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Extra information added to operations that support Scotty media requests.</summary>
    public class MediaRequestInfo : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The number of current bytes uploaded or downloaded.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("currentBytes")]
        public virtual System.Nullable<long> CurrentBytes { get; set; } 

        /// <summary>Data to be copied to backend requests. Custom data is returned to Scotty in the agent_state field,
        /// which Scotty will then provide in subsequent upload notifications.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customData")]
        public virtual string CustomData { get; set; } 

        /// <summary>Set if the http request info is diff encoded. The value of this field is the version number of the
        /// base revision. This is corresponding to Apiary's mediaDiffObjectVersion
        /// (//depot/google3/java/com/google/api/server/media/variable/DiffObjectVersionVariable.java). See go/esf-
        /// scotty-diff-upload for more information.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("diffObjectVersion")]
        public virtual string DiffObjectVersion { get; set; } 

        [Newtonsoft.Json.JsonPropertyAttribute("finalStatus")]
        public virtual System.Nullable<int> FinalStatus { get; set; } 

        /// <summary>The type of notification received from Scotty.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("notificationType")]
        public virtual string NotificationType { get; set; } 

        /// <summary>The Scotty request ID.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("requestId")]
        public virtual string RequestId { get; set; } 

        /// <summary>The partition of the Scotty server handling this request. type is
        /// uploader_service.RequestReceivedParamsServingInfo
        /// LINT.IfChange(request_received_params_serving_info_annotations) LINT.ThenChange()</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("requestReceivedParamsServingInfo")]
        public virtual string RequestReceivedParamsServingInfo { get; set; } 

        /// <summary>The total size of the file.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("totalBytes")]
        public virtual System.Nullable<long> TotalBytes { get; set; } 

        /// <summary>Whether the total bytes field contains an estimated data.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("totalBytesIsEstimated")]
        public virtual System.Nullable<bool> TotalBytesIsEstimated { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Holds information about which apps can save valuables using the 3P SDK for a given issuer.</summary>
    public class MerchantAppConfig : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>List of Android app identifiers to accept for this issuer. This usually consists of a prod key
        /// and/or debug key (referring to prod and debug versions of the issuer's apps).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("androidAppId")]
        public virtual System.Collections.Generic.IList<AndroidAppId> AndroidAppId { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>A message that will be displayed with a Valuable</summary>
    public class Message : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The message body.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("body")]
        public virtual string Body { get; set; } 

        /// <summary>The period of time that the message will be displayed to users. You can define both a `startTime`
        /// and `endTime` for each message. A message is displayed immediately after a Wallet Object is inserted unless
        /// a `startTime` is set. The message will appear in a list of messages indefinitely if `endTime` is not
        /// provided.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("displayInterval")]
        public virtual TimeInterval DisplayInterval { get; set; } 

        /// <summary>The message header.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("header")]
        public virtual string Header { get; set; } 

        /// <summary>The ID associated with a message. This field is here to enable ease of management of messages.
        /// Notice ID values could possibly duplicate across multiple messages in the same class/instance, and care must
        /// be taken to select a reasonable ID for each message.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("id")]
        public virtual string Id { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#walletObjectMessage"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>Translated strings for the message body.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedBody")]
        public virtual LocalizedString LocalizedBody { get; set; } 

        /// <summary>Translated strings for the message header.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedHeader")]
        public virtual LocalizedString LocalizedHeader { get; set; } 

        /// <summary>The message type.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("messageType")]
        public virtual string MessageType { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>This is proto2's version of MessageSet.</summary>
    public class MessageSet : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class ModifyLinkedOfferObjects : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The linked offer object ids to add to the object.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("addLinkedOfferObjectIds")]
        public virtual System.Collections.Generic.IList<string> AddLinkedOfferObjectIds { get; set; } 

        /// <summary>The linked offer object ids to remove from the object.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("removeLinkedOfferObjectIds")]
        public virtual System.Collections.Generic.IList<string> RemoveLinkedOfferObjectIds { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class ModifyLinkedOfferObjectsRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The linked offer object ids to add or remove from the object.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("linkedOfferObjectIds")]
        public virtual ModifyLinkedOfferObjects LinkedOfferObjectIds { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class Money : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The currency code, such as "USD" or "EUR."</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("currencyCode")]
        public virtual string CurrencyCode { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#money"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>The unit of money amount in micros. For example, $1 USD would be represented as 1000000
        /// micros.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("micros")]
        public virtual System.Nullable<long> Micros { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Indicates if the object needs to have notification enabled. We support only one of
    /// ExpiryNotification/UpcomingNotification. `expiryNotification` takes precedence over `upcomingNotification`. In
    /// other words if `expiryNotification` is set, we ignore the `upcomingNotification` field.</summary>
    public class Notifications : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A notification would be triggered at a specific time before the card expires.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("expiryNotification")]
        public virtual ExpiryNotification ExpiryNotification { get; set; } 

        /// <summary>A notification would be triggered at a specific time before the card becomes usable.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("upcomingNotification")]
        public virtual UpcomingNotification UpcomingNotification { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>This is a copy of the tech.blob.ObjectId proto, which could not be used directly here due to transitive
    /// closure issues with JavaScript support; see http://b/8801763.</summary>
    public class ObjectId : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The name of the bucket to which this object belongs.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("bucketName")]
        public virtual string BucketName { get; set; } 

        /// <summary>Generation of the object. Generations are monotonically increasing across writes, allowing them to
        /// be be compared to determine which generation is newer. If this is omitted in a request, then you are
        /// requesting the live object. See http://go/bigstore-versions</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("generation")]
        public virtual System.Nullable<long> Generation { get; set; } 

        /// <summary>The name of the object.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("objectName")]
        public virtual string ObjectName { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class OfferClass : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Activation options for an activatable ticket.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("activationOptions")]
        public virtual ActivationOptions ActivationOptions { get; set; } 

        /// <summary>Deprecated. Use `multipleDevicesAndHoldersAllowedStatus` instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("allowMultipleUsersPerObject")]
        public virtual System.Nullable<bool> AllowMultipleUsersPerObject { get; set; } 

        /// <summary>Optional app or website link that will be displayed as a button on the front of the pass. If
        /// AppLinkData is provided for the corresponding object that will be used instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("appLinkData")]
        public virtual AppLinkData AppLinkData { get; set; } 

        /// <summary>Callback options to be used to call the issuer back for every save/delete of an object for this
        /// class by the end-user. All objects of this class are eligible for the callback.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("callbackOptions")]
        public virtual CallbackOptions CallbackOptions { get; set; } 

        /// <summary>Template information about how the class should be displayed. If unset, Google will fallback to a
        /// default set of fields to display.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("classTemplateInfo")]
        public virtual ClassTemplateInfo ClassTemplateInfo { get; set; } 

        /// <summary>Country code used to display the card's country (when the user is not in that country), as well as
        /// to display localized content when content is not available in the user's locale.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("countryCode")]
        public virtual string CountryCode { get; set; } 

        /// <summary>The details of the offer.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("details")]
        public virtual string Details { get; set; } 

        /// <summary>Identifies whether this class supports Smart Tap. The `redemptionIssuers` and object level
        /// `smartTapRedemptionLevel` fields must also be set up correctly in order for a pass to support Smart
        /// Tap.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("enableSmartTap")]
        public virtual System.Nullable<bool> EnableSmartTap { get; set; } 

        /// <summary>The fine print or terms of the offer, such as "20% off any t-shirt at Adam's Apparel."</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("finePrint")]
        public virtual string FinePrint { get; set; } 

        /// <summary>When a barcode is not set for an instance, the configuration used to generate one. It may consist
        /// of multiple parts concatenated together such as the account id, card number, pin, event number, or other
        /// hard coded values. The data is normally stored in the mag stripe and printed on the card.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("generatedBarcodeParts")]
        public virtual System.Collections.Generic.IList<GeneratedBarcodePart> GeneratedBarcodeParts { get; set; } 

        /// <summary>The type of barcode to be used when generating a barcode. If not specified for loyalty TEXT_ONLY
        /// will be used, and for gift cards CODE_128 will be used.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("generatedBarcodeType")]
        public virtual string GeneratedBarcodeType { get; set; } 

        /// <summary>The help link for the offer, such as `http://myownpersonaldomain.com/help`</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("helpUri")]
        public virtual Uri HelpUri { get; set; } 

        /// <summary>Optional banner image displayed on the front of the card. If none is present, nothing will be
        /// displayed. The image will display at 100% width.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("heroImage")]
        public virtual Image HeroImage { get; set; } 

        /// <summary>The background color for the card. If not set the dominant color of the hero image is used, and if
        /// no hero image is set, the dominant color of the logo is used. The format is #rrggbb where rrggbb is a hex
        /// RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the RGB triplet which is #rgb,
        /// such as `#fc0`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hexBackgroundColor")]
        public virtual string HexBackgroundColor { get; set; } 

        /// <summary>Identifies whether or not this class should display a barcode for the user. This can be set if the
        /// class will not be scannable for some reason (eg: if the merchant uses scanners that cannot read phone
        /// screens).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hideBarcode")]
        public virtual System.Nullable<bool> HideBarcode { get; set; } 

        /// <summary>The URI of your application's home page. Populating the URI in this field results in the exact same
        /// behavior as populating an URI in linksModuleData (when an object is rendered, a link to the homepage is
        /// shown in what would usually be thought of as the linksModuleData section of the object).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("homepageUri")]
        public virtual Uri HomepageUri { get; set; } 

        /// <summary>Required. The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and
        /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or
        /// '-'.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("id")]
        public virtual string Id { get; set; } 

        /// <summary>Image module data. The maximum number of these fields displayed is 1 from object level and 1 for
        /// class object level.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("imageModulesData")]
        public virtual System.Collections.Generic.IList<ImageModuleData> ImageModulesData { get; set; } 

        /// <summary>Deprecated. Use textModulesData instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("infoModuleData")]
        public virtual InfoModuleData InfoModuleData { get; set; } 

        /// <summary>Required. The issuer name. Recommended maximum length is 20 characters to ensure full string is
        /// displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("issuerName")]
        public virtual string IssuerName { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#offerClass"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>Links module data. If links module data is also defined on the object, both will be
        /// displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("linksModuleData")]
        public virtual LinksModuleData LinksModuleData { get; set; } 

        /// <summary>Translated strings for the details.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedDetails")]
        public virtual LocalizedString LocalizedDetails { get; set; } 

        /// <summary>Translated strings for the fine_print.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedFinePrint")]
        public virtual LocalizedString LocalizedFinePrint { get; set; } 

        /// <summary>Translated strings for the issuer_name. Recommended maximum length is 20 characters to ensure full
        /// string is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedIssuerName")]
        public virtual LocalizedString LocalizedIssuerName { get; set; } 

        /// <summary>Translated strings for the provider. Recommended maximum length is 12 characters to ensure full
        /// string is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedProvider")]
        public virtual LocalizedString LocalizedProvider { get; set; } 

        /// <summary>Translated strings for the message displayed on the preview of a card before it is saved by a user
        /// to their account.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedSaveToAndroidPayPreviewMessage")]
        public virtual LocalizedString LocalizedSaveToAndroidPayPreviewMessage { get; set; } 

        /// <summary>Translated strings for the short title. Recommended maximum length is 20 characters.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedShortTitle")]
        public virtual LocalizedString LocalizedShortTitle { get; set; } 

        /// <summary>Translated strings for the title. Recommended maximum length is 60 characters to ensure full string
        /// is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedTitle")]
        public virtual LocalizedString LocalizedTitle { get; set; } 

        /// <summary>Note: This field is currently not supported to trigger geo notifications.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locations")]
        public virtual System.Collections.Generic.IList<LatLongPoint> Locations { get; set; } 

        /// <summary>An array of messages displayed in the app. All users of this object will receive its associated
        /// messages. The maximum number of these fields is 10.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("messages")]
        public virtual System.Collections.Generic.IList<Message> Messages { get; set; } 

        /// <summary>Identifies whether multiple users and devices will save the same object referencing this
        /// class.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("multipleDevicesAndHoldersAllowedStatus")]
        public virtual string MultipleDevicesAndHoldersAllowedStatus { get; set; } 

        /// <summary>Whether or not field updates to this class should trigger notifications. When set to NOTIFY, we
        /// will attempt to trigger a field update notification to users. These notifications will only be sent to users
        /// if the field is part of an allowlist. If not specified, no notification will be triggered. This setting is
        /// ephemeral and needs to be set with each PATCH or UPDATE request, otherwise a notification will not be
        /// triggered.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("notifyPreference")]
        public virtual string NotifyPreference { get; set; } 

        /// <summary>Required. The offer provider (either the aggregator name or merchant name). Recommended maximum
        /// length is 12 characters to ensure full string is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("provider")]
        public virtual string Provider { get; set; } 

        /// <summary>Required. The redemption channels applicable to this offer.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("redemptionChannel")]
        public virtual string RedemptionChannel { get; set; } 

        /// <summary>Identifies which redemption issuers can redeem the pass over Smart Tap. Redemption issuers are
        /// identified by their issuer ID. Redemption issuers must have at least one Smart Tap key configured. The
        /// `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also be set up correctly in order
        /// for a pass to support Smart Tap.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("redemptionIssuers")]
        public virtual System.Collections.Generic.IList<System.Nullable<long>> RedemptionIssuers { get; set; } 

        /// <summary>The review comments set by the platform when a class is marked `approved` or `rejected`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("review")]
        public virtual Review Review { get; set; } 

        /// <summary>Required. The status of the class. This field can be set to `draft` or The status of the class.
        /// This field can be set to `draft` or `underReview` using the insert, patch, or update API calls. Once the
        /// review state is changed from `draft` it may not be changed back to `draft`. You should keep this field to
        /// `draft` when the class is under development. A `draft` class cannot be used to create any object. You should
        /// set this field to `underReview` when you believe the class is ready for use. The platform will automatically
        /// set this field to `approved` and it can be immediately used to create or migrate objects. When updating an
        /// already `approved` class you should keep setting this field to `underReview`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("reviewStatus")]
        public virtual string ReviewStatus { get; set; } 

        /// <summary>Message displayed on the preview of a card before it is saved by a user to their account.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("saveToAndroidPayPreviewMessage")]
        public virtual string SaveToAndroidPayPreviewMessage { get; set; } 

        /// <summary>Optional information about the security animation. If this is set a security animation will be
        /// rendered on pass details.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("securityAnimation")]
        public virtual SecurityAnimation SecurityAnimation { get; set; } 

        /// <summary>A shortened version of the title of the offer, such as "20% off," shown to users as a quick
        /// reference to the offer contents. Recommended maximum length is 20 characters.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("shortTitle")]
        public virtual string ShortTitle { get; set; } 

        /// <summary>Indicates if authentication should be required when transmitting the valuable. If this is true, and
        /// the terminal does not support authentication then objects of this class will not be transmitted. May only by
        /// true when smart_tap_encryption_required is true.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapAuthenticationRequired")]
        public virtual System.Nullable<bool> SmartTapAuthenticationRequired { get; set; } 

        /// <summary>Indicates if encryption should be required when transmitting the valuable. If this is true, and the
        /// terminal does not support encryption, then objects of this class will not be transmitted. May only be true
        /// when enable_smart_tap is true.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapEncryptionRequired")]
        public virtual System.Nullable<bool> SmartTapEncryptionRequired { get; set; } 

        /// <summary>Determines how to generate the smart tap redemption value from the redemption identifier. If this
        /// field is populated, the user's smart tap redemption value will change whenever the redemption identifier
        /// changes.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapRedemptionValueGenerationParams")]
        public virtual SmartTapRedemptionValueGenerationParams SmartTapRedemptionValueGenerationParams { get; set; } 

        /// <summary>Text module data. If text module data is also defined on the class, both will be displayed. The
        /// maximum number of these fields displayed is 10 from the object and 10 from the class.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("textModulesData")]
        public virtual System.Collections.Generic.IList<TextModuleData> TextModulesData { get; set; } 

        /// <summary>Required. The title of the offer, such as "20% off any t-shirt." Recommended maximum length is 60
        /// characters to ensure full string is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("title")]
        public virtual string Title { get; set; } 

        /// <summary>The title image of the offer. This image is displayed in both the details and list views of the
        /// app.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("titleImage")]
        public virtual Image TitleImage { get; set; } 

        /// <summary>A regex that describes what a valid redemption identifier for this class looks like.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("validRedemptionIdentifierRegex")]
        public virtual string ValidRedemptionIdentifierRegex { get; set; } 

        /// <summary>Deprecated</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("version")]
        public virtual System.Nullable<long> Version { get; set; } 

        /// <summary>View Unlock Requirement options for the offer.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("viewUnlockRequirement")]
        public virtual string ViewUnlockRequirement { get; set; } 

        /// <summary>The wide title image of the offer. When provided, this will be used in place of the title image in
        /// the top left of the card view.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("wideTitleImage")]
        public virtual Image WideTitleImage { get; set; } 

        /// <summary>Deprecated.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("wordMark")]
        public virtual Image WordMark { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class OfferClassAddMessageResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The updated OfferClass resource.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resource")]
        public virtual OfferClass Resource { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class OfferClassListResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Pagination of the response.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("pagination")]
        public virtual Pagination Pagination { get; set; } 

        /// <summary>Resources corresponding to the list request.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resources")]
        public virtual System.Collections.Generic.IList<OfferClass> Resources { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class OfferObject : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The activation status for the object. Required if the class has `activationOptions` set.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("activationStatus")]
        public virtual ActivationStatus ActivationStatus { get; set; } 

        /// <summary>Optional app or website link that will be displayed as a button on the front of the pass. If
        /// AppLinkData is provided for the corresponding class only object AppLinkData will be displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("appLinkData")]
        public virtual AppLinkData AppLinkData { get; set; } 

        /// <summary>The barcode type and value.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("barcode")]
        public virtual Barcode Barcode { get; set; } 

        /// <summary>Required. The class associated with this object. The class must be of the same type as this object,
        /// must already exist, and must be approved. Class IDs should follow the format issuer ID.identifier where the
        /// former is issued by Google and latter is chosen by you.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("classId")]
        public virtual string ClassId { get; set; } 

        /// <summary>A copy of the inherited fields of the parent class. These fields are retrieved during a
        /// GET.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("classReference")]
        public virtual OfferClass ClassReference { get; set; } 

        /// <summary>Device context associated with the object.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("deviceContext")]
        public virtual DeviceContext DeviceContext { get; set; } 

        /// <summary>Indicates if notifications should explicitly be suppressed. If this field is set to true,
        /// regardless of the `messages` field, expiration notifications to the user will be suppressed. By default,
        /// this field is set to false. Currently, this can only be set for offers.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("disableExpirationNotification")]
        public virtual System.Nullable<bool> DisableExpirationNotification { get; set; } 

        /// <summary>Information that controls how passes are grouped together.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("groupingInfo")]
        public virtual GroupingInfo GroupingInfo { get; set; } 

        /// <summary>Whether this object is currently linked to a single device. This field is set by the platform when
        /// a user saves the object, linking it to their device. Intended for use by select partners. Contact support
        /// for additional information.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hasLinkedDevice")]
        public virtual System.Nullable<bool> HasLinkedDevice { get; set; } 

        /// <summary>Indicates if the object has users. This field is set by the platform.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hasUsers")]
        public virtual System.Nullable<bool> HasUsers { get; set; } 

        /// <summary>Optional banner image displayed on the front of the card. If none is present, hero image of the
        /// class, if present, will be displayed. If hero image of the class is also not present, nothing will be
        /// displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("heroImage")]
        public virtual Image HeroImage { get; set; } 

        /// <summary>Required. The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID.identifier where the former is issued by Google and
        /// latter is chosen by you. The unique identifier should only include alphanumeric characters, '.', '_', or
        /// '-'.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("id")]
        public virtual string Id { get; set; } 

        /// <summary>Image module data. The maximum number of these fields displayed is 1 from object level and 1 for
        /// class object level.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("imageModulesData")]
        public virtual System.Collections.Generic.IList<ImageModuleData> ImageModulesData { get; set; } 

        /// <summary>Deprecated. Use textModulesData instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("infoModuleData")]
        public virtual InfoModuleData InfoModuleData { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#offerObject"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>linked_object_ids are a list of other objects such as event ticket, loyalty, offer, generic,
        /// giftcard, transit and boarding pass that should be automatically attached to this offer object. If a user
        /// had saved this offer, then these linked_object_ids would be automatically pushed to the user's wallet
        /// (unless they turned off the setting to receive such linked passes). Object IDs should follow the format
        /// issuer ID.identifier where the former is issued by Google and the latter is chosen by you.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("linkedObjectIds")]
        public virtual System.Collections.Generic.IList<string> LinkedObjectIds { get; set; } 

        /// <summary>Links module data. If links module data is also defined on the class, both will be
        /// displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("linksModuleData")]
        public virtual LinksModuleData LinksModuleData { get; set; } 

        /// <summary>Note: This field is currently not supported to trigger geo notifications.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locations")]
        public virtual System.Collections.Generic.IList<LatLongPoint> Locations { get; set; } 

        /// <summary>An array of messages displayed in the app. All users of this object will receive its associated
        /// messages. The maximum number of these fields is 10.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("messages")]
        public virtual System.Collections.Generic.IList<Message> Messages { get; set; } 

        /// <summary>Whether or not field updates to this object should trigger notifications. When set to NOTIFY, we
        /// will attempt to trigger a field update notification to users. These notifications will only be sent to users
        /// if the field is part of an allowlist. If set to DO_NOT_NOTIFY or NOTIFICATION_SETTINGS_UNSPECIFIED, no
        /// notification will be triggered. This setting is ephemeral and needs to be set with each PATCH or UPDATE
        /// request, otherwise a notification will not be triggered.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("notifyPreference")]
        public virtual string NotifyPreference { get; set; } 

        /// <summary>Pass constraints for the object. Includes limiting NFC and screenshot behaviors.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("passConstraints")]
        public virtual PassConstraints PassConstraints { get; set; } 

        /// <summary>The rotating barcode type and value.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("rotatingBarcode")]
        public virtual RotatingBarcode RotatingBarcode { get; set; } 

        /// <summary>Restrictions on the object that needs to be verified before the user tries to save the pass. Note
        /// that this restrictions will only be applied during save time. If the restrictions changed after a user saves
        /// the pass, the new restrictions will not be applied to an already saved pass.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("saveRestrictions")]
        public virtual SaveRestrictions SaveRestrictions { get; set; } 

        /// <summary>The value that will be transmitted to a Smart Tap certified terminal over NFC for this object. The
        /// class level fields `enableSmartTap` and `redemptionIssuers` must also be set up correctly in order for the
        /// pass to support Smart Tap. Only ASCII characters are supported.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapRedemptionValue")]
        public virtual string SmartTapRedemptionValue { get; set; } 

        /// <summary>Required. The state of the object. This field is used to determine how an object is displayed in
        /// the app. For example, an `inactive` object is moved to the "Expired passes" section.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("state")]
        public virtual string State { get; set; } 

        /// <summary>Text module data. If text module data is also defined on the class, both will be displayed. The
        /// maximum number of these fields displayed is 10 from the object and 10 from the class.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("textModulesData")]
        public virtual System.Collections.Generic.IList<TextModuleData> TextModulesData { get; set; } 

        /// <summary>The time period this object will be `active` and object can be used. An object's state will be
        /// changed to `expired` when this time period has passed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("validTimeInterval")]
        public virtual TimeInterval ValidTimeInterval { get; set; } 

        /// <summary>Deprecated</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("version")]
        public virtual System.Nullable<long> Version { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class OfferObjectAddMessageResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The updated OfferObject resource.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resource")]
        public virtual OfferObject Resource { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class OfferObjectListResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Pagination of the response.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("pagination")]
        public virtual Pagination Pagination { get; set; } 

        /// <summary>Resources corresponding to the list request.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resources")]
        public virtual System.Collections.Generic.IList<OfferObject> Resources { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Request to upload rotating barcode values.</summary>
    public class OfferObjectUploadRotatingBarcodeValuesRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A reference to the rotating barcode values payload that was uploaded.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("blob")]
        public virtual Media Blob { get; set; } 

        /// <summary>Extra information about the uploaded media.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mediaRequestInfo")]
        public virtual MediaRequestInfo MediaRequestInfo { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Response for uploading rotating barcode values.</summary>
    public class OfferObjectUploadRotatingBarcodeValuesResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class Pagination : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#pagination"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>Page token to send to fetch the next page.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("nextPageToken")]
        public virtual string NextPageToken { get; set; } 

        /// <summary>Number of results returned in this page.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resultsPerPage")]
        public virtual System.Nullable<int> ResultsPerPage { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Container for any constraints that may be placed on passes.</summary>
    public class PassConstraints : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The NFC constraints for the pass.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("nfcConstraint")]
        public virtual System.Collections.Generic.IList<string> NfcConstraint { get; set; } 

        /// <summary>The screenshot eligibility for the pass.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("screenshotEligibility")]
        public virtual string ScreenshotEligibility { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Details for the Patient.</summary>
    public class PatientDetails : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Optional. Patient date of birth. This is an ISO 8601 extended format date without an offset. For
        /// example: `2027-03-25`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("dateOfBirth")]
        public virtual string DateOfBirth { get; set; } 

        /// <summary>Optional. A custom label to use for the date of birth field.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("dateOfBirthLabel")]
        public virtual string DateOfBirthLabel { get; set; } 

        /// <summary>Optional. [Identity Assurance Level](http://build.fhir.org/ig/dvci/vaccine-credential-
        /// ig/branches/main/#identity-assurance). For example: `IAL1.4`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("identityAssuranceLevel")]
        public virtual string IdentityAssuranceLevel { get; set; } 

        /// <summary>Optional. A custom label to use for the identity assurance level field.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("identityAssuranceLevelLabel")]
        public virtual string IdentityAssuranceLevelLabel { get; set; } 

        /// <summary>Optional. Patient ID. Could be government ID or other.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("patientId")]
        public virtual string PatientId { get; set; } 

        /// <summary>Optional. A custom label to use for the patient id field.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("patientIdLabel")]
        public virtual string PatientIdLabel { get; set; } 

        /// <summary>Required. Patient name. This can be a full name, last name, preferred name, or nickname.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("patientName")]
        public virtual string PatientName { get; set; } 

        /// <summary>Optional. A custom label to use for the patient name field.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("patientNameLabel")]
        public virtual string PatientNameLabel { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class Permission : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The email address of the user, group, or service account to which this permission refers
        /// to.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("emailAddress")]
        public virtual string EmailAddress { get; set; } 

        /// <summary>The role granted by this permission.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("role")]
        public virtual string Role { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class Permissions : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>ID of the issuer the list of permissions refer to.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("issuerId")]
        public virtual System.Nullable<long> IssuerId { get; set; } 

        /// <summary>The complete list of permissions for the issuer account.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("permissions")]
        public virtual System.Collections.Generic.IList<Permission> PermissionsValue { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>A predefined covid card template row.</summary>
    public class PredefinedCovidCardTemplateRow : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The covid card template row corresponding to testing details. A PredefinedCovidCardTemplateRow of
        /// type TestingDetailsTemplateRow might result in more than a row if more than a single testing records are
        /// available. Exactly one of "testing_details_row" or "vaccination_details_row" must be set.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("testingDetailsRow")]
        public virtual PredefinedCovidCardTemplateRowTestingDetailsTemplateRow TestingDetailsRow { get; set; } 

        /// <summary>The covid card template row corresponding to vaccination details. A PredefinedCovidCardTemplateRow
        /// of type VaccinationDetailsTemplateRow might result in more than a row if more than a single vaccination
        /// records are available. Exactly one of "testing_details_row" or "vaccination_details_row" must be
        /// set.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("vaccinationDetailsRow")]
        public virtual PredefinedCovidCardTemplateRowVaccinationDetailsTemplateRow VaccinationDetailsRow { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>A predefined template row for covid card testing details. Intentionally left blank.</summary>
    public class PredefinedCovidCardTemplateRowTestingDetailsTemplateRow : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>A predefined template row for covid card vaccination details. Intentionally left blank.</summary>
    public class PredefinedCovidCardTemplateRowVaccinationDetailsTemplateRow : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>A predefined template row. For internal use only. Do not expose to the public API.</summary>
    public class PredefinedTemplateRow : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Predefined template row to render covid card template row.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("covidCardRow")]
        public virtual PredefinedCovidCardTemplateRow CovidCardRow { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Data for Private module. Signifies either of TextModuleData, ImageModuleData or LinksModuleData (using
    /// the private content id) sent in advance by the issuer.</summary>
    public class PrivateModuleData : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The ID associated with the module. This field is here to enable ease of management of modules as
        /// they may be used as references in templates.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("id")]
        public virtual string Id { get; set; } 

        /// <summary>Private content id received from Google for the content after the private content was successfully
        /// pre-inserted.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("privateContentId")]
        public virtual System.Nullable<long> PrivateContentId { get; set; } 

        /// <summary>Type of private data sent by the user corresponding to the private content id passed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("privateDataType")]
        public virtual string PrivateDataType { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Private data for TextModule. This data will be rendered as a TextModule for a pass.</summary>
    public class PrivateText : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Translated strings for the body.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("body")]
        public virtual LocalizedString Body { get; set; } 

        /// <summary>Translated strings for the header.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("header")]
        public virtual LocalizedString Header { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Private data for LinkModule. This data will be rendered as the LinkModule for a pass.</summary>
    public class PrivateUri : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The URI's title appearing in the app as text and its translated strings. Recommended maximum is 20
        /// characters to ensure the full string is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("description")]
        public virtual LocalizedString Description { get; set; } 

        /// <summary>The location of a web page, image, or other resource. URIs in the `LinksModuleData` can have
        /// different prefixes indicating the type of URI (a link to a web page, a link to a map, a telephone number, or
        /// an email address).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("uri")]
        public virtual string Uri { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class PurchaseDetails : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>ID of the account used to purchase the ticket.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("accountId")]
        public virtual string AccountId { get; set; } 

        /// <summary>The confirmation code for the purchase. This may be the same for multiple different tickets and is
        /// used to group tickets together.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("confirmationCode")]
        public virtual string ConfirmationCode { get; set; } 

        /// <summary>The purchase date/time of the ticket. This is an ISO 8601 extended format date/time, with or
        /// without an offset. Time may be specified up to nanosecond precision. Offsets may be specified with seconds
        /// precision (even though offset seconds is not part of ISO 8601). For example: `1985-04-12T23:20:50.52Z` would
        /// be 20 minutes and 50.52 seconds after the 23rd hour of April 12th, 1985 in UTC.
        /// `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds after the 19th hour of April 12th,
        /// 1985, 4 hours before UTC (same instant in time as the above example). If the event were in New York, this
        /// would be the equivalent of Eastern Daylight Time (EDT). Remember that offset varies in regions that observe
        /// Daylight Saving Time (or Summer Time), depending on the time of the year. `1985-04-12T19:20:50.52` would be
        /// 20 minutes and 50.52 seconds after the 19th hour of April 12th, 1985 with no offset information. Without
        /// offset information, some rich features may not be available.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("purchaseDateTime")]
        public virtual string PurchaseDateTime { get; set; } 

        /// <summary>Receipt number/identifier for tracking the ticket purchase via the body that sold the
        /// ticket.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("purchaseReceiptNumber")]
        public virtual string PurchaseReceiptNumber { get; set; } 

        /// <summary>The cost of the ticket.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("ticketCost")]
        public virtual TicketCost TicketCost { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class ReservationInfo : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Confirmation code needed to check into this flight. This is the number that the passenger would
        /// enter into a kiosk at the airport to look up the flight and print a boarding pass.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("confirmationCode")]
        public virtual string ConfirmationCode { get; set; } 

        /// <summary>E-ticket number.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("eticketNumber")]
        public virtual string EticketNumber { get; set; } 

        /// <summary>Frequent flyer membership information.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("frequentFlyerInfo")]
        public virtual FrequentFlyerInfo FrequentFlyerInfo { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#reservationInfo"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class Resources : Google.Apis.Requests.IDirectResponseSchema
    {
        [Newtonsoft.Json.JsonPropertyAttribute("eventTicketClasses")]
        public virtual System.Collections.Generic.IList<EventTicketClass> EventTicketClasses { get; set; } 

        [Newtonsoft.Json.JsonPropertyAttribute("eventTicketObjects")]
        public virtual System.Collections.Generic.IList<EventTicketObject> EventTicketObjects { get; set; } 

        [Newtonsoft.Json.JsonPropertyAttribute("flightClasses")]
        public virtual System.Collections.Generic.IList<FlightClass> FlightClasses { get; set; } 

        [Newtonsoft.Json.JsonPropertyAttribute("flightObjects")]
        public virtual System.Collections.Generic.IList<FlightObject> FlightObjects { get; set; } 

        [Newtonsoft.Json.JsonPropertyAttribute("giftCardClasses")]
        public virtual System.Collections.Generic.IList<GiftCardClass> GiftCardClasses { get; set; } 

        [Newtonsoft.Json.JsonPropertyAttribute("giftCardObjects")]
        public virtual System.Collections.Generic.IList<GiftCardObject> GiftCardObjects { get; set; } 

        [Newtonsoft.Json.JsonPropertyAttribute("loyaltyClasses")]
        public virtual System.Collections.Generic.IList<LoyaltyClass> LoyaltyClasses { get; set; } 

        [Newtonsoft.Json.JsonPropertyAttribute("loyaltyObjects")]
        public virtual System.Collections.Generic.IList<LoyaltyObject> LoyaltyObjects { get; set; } 

        [Newtonsoft.Json.JsonPropertyAttribute("offerClasses")]
        public virtual System.Collections.Generic.IList<OfferClass> OfferClasses { get; set; } 

        [Newtonsoft.Json.JsonPropertyAttribute("offerObjects")]
        public virtual System.Collections.Generic.IList<OfferObject> OfferObjects { get; set; } 

        [Newtonsoft.Json.JsonPropertyAttribute("transitClasses")]
        public virtual System.Collections.Generic.IList<TransitClass> TransitClasses { get; set; } 

        [Newtonsoft.Json.JsonPropertyAttribute("transitObjects")]
        public virtual System.Collections.Generic.IList<TransitObject> TransitObjects { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class Review : Google.Apis.Requests.IDirectResponseSchema
    {
        [Newtonsoft.Json.JsonPropertyAttribute("comments")]
        public virtual string Comments { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class RotatingBarcode : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>An optional text that will override the default text that shows under the barcode. This field is
        /// intended for a human readable equivalent of the barcode value, used when the barcode cannot be
        /// scanned.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("alternateText")]
        public virtual string AlternateText { get; set; } 

        /// <summary>Details used to evaluate barcode substitutions where the issuer is required to provide data proving
        /// the device is entitled to use the ticket.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("deviceEntitlementSupport")]
        public virtual RotatingBarcodeDeviceEntitlementSupport DeviceEntitlementSupport { get; set; } 

        /// <summary>Input only. NOTE: This feature is only available for the transit vertical. Optional set of initial
        /// rotating barcode values. This allows a small subset of barcodes to be included with the object. Further
        /// rotating barcode values must be uploaded with the UploadRotatingBarcodeValues endpoint.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("initialRotatingBarcodeValues")]
        public virtual RotatingBarcodeValues InitialRotatingBarcodeValues { get; set; } 

        /// <summary>The render encoding for the barcode. When specified, barcode is rendered in the given encoding.
        /// Otherwise best known encoding is chosen by Google.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("renderEncoding")]
        public virtual string RenderEncoding { get; set; } 

        /// <summary>Optional text that will be shown when the barcode is hidden behind a click action. This happens in
        /// cases where a pass has Smart Tap enabled. If not specified, a default is chosen by Google.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("showCodeText")]
        public virtual LocalizedString ShowCodeText { get; set; } 

        /// <summary>Details used to evaluate the {totp_value_n} substitutions.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("totpDetails")]
        public virtual RotatingBarcodeTotpDetails TotpDetails { get; set; } 

        /// <summary>The type of this barcode.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("type")]
        public virtual string Type { get; set; } 

        /// <summary>String encoded barcode value. This string supports the following substitutions: * {totp_value_n}:
        /// Replaced with the TOTP value (see TotpDetails.parameters). * {totp_timestamp_millis}: Replaced with the
        /// timestamp (millis since epoch) at which the barcode was generated. * {totp_timestamp_seconds}: Replaced with
        /// the timestamp (seconds since epoch) at which the barcode was generated.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("valuePattern")]
        public virtual string ValuePattern { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>DeviceEntitlementSupport for the barcode NextId: 2</summary>
    public class RotatingBarcodeDeviceEntitlementSupport : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Details used to evaluate the {vdv_barcode} substitutions.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("vdvEntitlementDetails")]
        public virtual RotatingBarcodeDeviceEntitlementSupportVdvEntitlementDetails VdvEntitlementDetails { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Details related to entitlement of device to use a ticket issued by transit agencies in Germany that use
    /// VDV as their certfication authority.</summary>
    public class RotatingBarcodeDeviceEntitlementSupportVdvEntitlementDetails : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>TLV formatted string supplied by the issuer and encoded directly in the barcode. This field will
        /// contain sigSTB, Cert(puk_SAM), and CAR. See go/vdv-mvp for details.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("applicationData")]
        public virtual string ApplicationData { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Configuration for the time-based OTP substitutions. See https://tools.ietf.org/html/rfc6238</summary>
    public class RotatingBarcodeTotpDetails : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The TOTP algorithm used to generate the OTP.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("algorithm")]
        public virtual string Algorithm { get; set; } 

        /// <summary>The TOTP parameters for each of the {totp_value_*} substitutions. The TotpParameters at index n is
        /// used for the {totp_value_n} substitution.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("parameters")]
        public virtual System.Collections.Generic.IList<RotatingBarcodeTotpDetailsTotpParameters> Parameters { get; set; } 

        /// <summary>The time interval used for the TOTP value generation, in milliseconds.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("periodMillis")]
        public virtual System.Nullable<long> PeriodMillis { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Configuration for the key and value length. See https://www.rfc-
    /// editor.org/rfc/rfc4226#section-5.3</summary>
    public class RotatingBarcodeTotpDetailsTotpParameters : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The secret key used for the TOTP value generation, encoded as a Base16 string.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("key")]
        public virtual string Key { get; set; } 

        /// <summary>The length of the TOTP value in decimal digits.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("valueLength")]
        public virtual System.Nullable<int> ValueLength { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>A payload containing many barcode values and start date/time.</summary>
    public class RotatingBarcodeValues : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Required. The amount of time each barcode is valid for.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("periodMillis")]
        public virtual System.Nullable<long> PeriodMillis { get; set; } 

        /// <summary>Required. The date/time the first barcode is valid from. Barcodes will be rotated through using
        /// period_millis defined on the object's RotatingBarcodeValueInfo. This is an ISO 8601 extended format
        /// date/time, with an offset. Time may be specified up to nanosecond precision. Offsets may be specified with
        /// seconds precision (even though offset seconds is not part of ISO 8601). For example:
        /// `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the 23rd hour of April 12th, 1985 in
        /// UTC. `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds after the 19th hour of April 12th,
        /// 1985, 4 hours before UTC (same instant in time as the above example). If the event were in New York, this
        /// would be the equivalent of Eastern Daylight Time (EDT). Remember that offset varies in regions that observe
        /// Daylight Saving Time (or Summer Time), depending on the time of the year.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("startDateTime")]
        public virtual string StartDateTime { get; set; } 

        /// <summary>Required. The values to encode in the barcode. At least one value is required.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("values")]
        public virtual System.Collections.Generic.IList<string> Values { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Defines restrictions on the object that will be verified during save.</summary>
    public class SaveRestrictions : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Restrict the save of the referencing object to the given email address only. This is the hex output
        /// of SHA256 sum of the email address, all lowercase and without any notations like "." or "+", except "@". For
        /// example, for example@example.com, this value will be
        /// 31c5543c1734d25c7206f5fd591525d0295bec6fe84ff82f946a34fe970a1e66 and for Example@example.com, this value
        /// will be bc34f262c93ad7122763684ccea6f07fb7f5d8a2d11e60ce15a6f43fe70ce632 If email address of the logged-in
        /// user who tries to save this pass does not match with the defined value here, users won't be allowed to save
        /// this pass. They will instead be prompted with an error to contact the issuer. This information should be
        /// gathered from the user with an explicit consent via Sign in with Google integration
        /// https://developers.google.com/identity/authentication. Please contact with support before using Save
        /// Restrictions.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("restrictToEmailSha256")]
        public virtual string RestrictToEmailSha256 { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class SecurityAnimation : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Type of animation.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("animationType")]
        public virtual string AnimationType { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Request to send a private pass update notice information to Google, so that devices can then fetch the
    /// notice prompting the user to update a pass.</summary>
    public class SetPassUpdateNoticeRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Required. A fully qualified identifier of the pass that the issuer wants to notify the pass
        /// holder(s) about. Formatted as .</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("externalPassId")]
        public virtual string ExternalPassId { get; set; } 

        /// <summary>Not exposed to partners who should use update_uri for now. Eventually we might either revive it or
        /// mark it as deprecated.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("issuerMessage")]
        public virtual LocalizedString IssuerMessage { get; set; } 

        /// <summary>Required. The issuer endpoint URI the pass holder needs to follow in order to receive an updated
        /// pass JWT. It can not contain any sensitive information. The endpoint needs to authenticate the user before
        /// giving the user the updated JWT. Example update URI
        /// https://someissuer.com/update/passId=someExternalPassId</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("updateUri")]
        public virtual string UpdateUri { get; set; } 

        /// <summary>Required. The JWT signature of the updated pass that the issuer wants to notify Google about. Only
        /// devices that report a different JWT signature than this JWT signature will receive the update
        /// notification.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("updatedPassJwtSignature")]
        public virtual string UpdatedPassJwtSignature { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>A response to a request to notify Google of an awaiting update to a private pass.</summary>
    public class SetPassUpdateNoticeResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class SignUpInfo : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>ID of the class the user can sign up for.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("classId")]
        public virtual string ClassId { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class SmartTap : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The unique identifier for a smart tap. This value should follow the format issuer ID.identifier
        /// where the former is issued by Google and latter is the Smart Tap id. The Smart Tap id is a Base64 encoded
        /// string which represents the id which was generated by the Google Pay app.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("id")]
        public virtual string Id { get; set; } 

        /// <summary>Communication from merchant to user.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("infos")]
        public virtual System.Collections.Generic.IList<IssuerToUserInfo> Infos { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#smartTap"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>Smart Tap merchant ID of who engaged in the Smart Tap interaction.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("merchantId")]
        public virtual System.Nullable<long> MerchantId { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>SmartTapInfo contains fields to enable smart tap for a pass.</summary>
    public class SmartTapInfo : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Optional. Available only to Smart Tap enabled partners. Contact support for additional
        /// guidance.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("enableSmartTap")]
        public virtual System.Nullable<bool> EnableSmartTap { get; set; } 

        /// <summary>Optional. Identifies which redemption issuers can redeem the pass over Smart Tap. Redemption
        /// issuers are identified by their issuer ID. Redemption issuers must have at least one Smart Tap key
        /// configured. The `enableSmartTap` and `smartTapRedemptionValue` fields must also be set up correctly in order
        /// for a pass to support Smart Tap.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("redemptionIssuers")]
        public virtual System.Collections.Generic.IList<System.Nullable<long>> RedemptionIssuers { get; set; } 

        /// <summary>Indicates if authentication should be required when transmitting the pass. If this is true, and the
        /// terminal does not support authentication then objects of this class will not be transmitted. May only by
        /// true when smart_tap_encryption_required is true.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapAuthenticationRequired")]
        public virtual System.Nullable<bool> SmartTapAuthenticationRequired { get; set; } 

        /// <summary>Indicates if encryption should be required when transmitting the pass. If this is true, and the
        /// terminal does not support encryption, then objects of this class will not be transmitted. May only be true
        /// when enable_smart_tap is true.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapEncryptionRequired")]
        public virtual System.Nullable<bool> SmartTapEncryptionRequired { get; set; } 

        /// <summary>Optional. The value that will be transmitted to a Smart Tap certified terminal over NFC for this
        /// object. The fields `enableSmartTap` and `redemptionIssuers` must also be set up correctly in order for the
        /// pass to support Smart Tap. Only ASCII characters are supported.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapRedemptionValue")]
        public virtual string SmartTapRedemptionValue { get; set; } 

        /// <summary>Determines how to generate the smart tap redemption value from the redemption identifier. If this
        /// field is populated, the user's smart tap redemption value will change whenever the redemption identifier
        /// changes.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapRedemptionValueGenerationParams")]
        public virtual SmartTapRedemptionValueGenerationParams SmartTapRedemptionValueGenerationParams { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class SmartTapMerchantData : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Available only to Smart Tap enabled partners. Contact support for additional guidance.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("authenticationKeys")]
        public virtual System.Collections.Generic.IList<AuthenticationKey> AuthenticationKeys { get; set; } 

        /// <summary>Available only to Smart Tap enabled partners. Contact support for additional guidance.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapMerchantId")]
        public virtual System.Nullable<long> SmartTapMerchantId { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class SmartTapRedemptionValueGenerationParams : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The replacement to use with the above regex. For example, to insert a 'B' after the 5th character
        /// this would be the string $1B.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("replacement")]
        public virtual string Replacement { get; set; } 

        /// <summary>A regular expression search to use on the redemption identifier. To use the replacement regex
        /// below, it should contain a capturing group. An example usage is the regex ^(.{5}) which captures everything
        /// up to the 5th token.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("searchRegex")]
        public virtual string SearchRegex { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class TemplateItem : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A reference to a field to display. If both `firstValue` and `secondValue` are populated, they will
        /// both appear as one item with a slash between them. For example, values A and B would be shown as "A /
        /// B".</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("firstValue")]
        public virtual FieldSelector FirstValue { get; set; } 

        /// <summary>Defines the position of the template item inside of its assigned horizontal space.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("gravity")]
        public virtual string Gravity { get; set; } 

        /// <summary>Defines how to position the label of values which have labels. Defaults to TOP.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("labelPosition")]
        public virtual string LabelPosition { get; set; } 

        /// <summary>Defines the whole TemplateItem to be a decoration item.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("layoutDecorator")]
        public virtual string LayoutDecorator { get; set; } 

        /// <summary>A predefined item to display. Only one of `firstValue` or `predefinedItem` may be set.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("predefinedItem")]
        public virtual string PredefinedItem { get; set; } 

        /// <summary>A reference to a field to display. This may only be populated if the `firstValue` field is
        /// populated.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("secondValue")]
        public virtual FieldSelector SecondValue { get; set; } 

        /// <summary>Indicates which type of separator should be used to separate `firstValue`, `secondValue` and
        /// `thirdValue`. If no `separatorType` is specified, forward slash will be used to separate the
        /// values.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("separatorType")]
        public virtual string SeparatorType { get; set; } 

        /// <summary>A reference to a field to display. This may only be populated if the `firstValue` and `secondValue`
        /// fields are populated.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("thirdValue")]
        public virtual FieldSelector ThirdValue { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Details for the Testing Records.</summary>
    public class TestingDetails : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Required. The first item in the `TestingRecord` is used as the default value.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("testingRecord")]
        public virtual System.Collections.Generic.IList<TestingRecord> TestingRecord { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Details for the individual Testing Record.</summary>
    public class TestingRecord : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Required. The date and time when the test was administered. This is an ISO 8601 extended format
        /// date and time without an offset. For example: `2027-03-25T06:30:00`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("administrationDateTime")]
        public virtual string AdministrationDateTime { get; set; } 

        /// <summary>Optional. A custom label to use for the administration date time field.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("administrationDateTimeLabel")]
        public virtual string AdministrationDateTimeLabel { get; set; } 

        /// <summary>Optional. Contact information for the provider where the test happened; it can be the address and
        /// phone number for the hospital, lab, or pharmacy.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("contactInfo")]
        public virtual string ContactInfo { get; set; } 

        /// <summary>Optional. A custom label to use for the contact info field.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("contactInfoLabel")]
        public virtual string ContactInfoLabel { get; set; } 

        /// <summary>Optional. Information for the test provider; it can be the name of the hospital, lab, or pharmacy
        /// name where the test happened.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("provider")]
        public virtual string Provider { get; set; } 

        /// <summary>Optional. A custom label to use for the provider field.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("providerLabel")]
        public virtual string ProviderLabel { get; set; } 

        /// <summary>Optional. The date and time when the result for the test was declared. This is an ISO 8601 extended
        /// format date and time without an offset. For example: `2027-03-25T06:30:00`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("reportDateTime")]
        public virtual string ReportDateTime { get; set; } 

        /// <summary>Optional. A custom label to use for the report date time field.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("reportDateTimeLabel")]
        public virtual string ReportDateTimeLabel { get; set; } 

        /// <summary>Optional. Information about the biological sample taken from the patient against which tests are
        /// performed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("specimen")]
        public virtual string Specimen { get; set; } 

        /// <summary>Optional. A custom label to use for the specimen field.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("specimenLabel")]
        public virtual string SpecimenLabel { get; set; } 

        /// <summary>Optional. Test Code of the observation.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("testCode")]
        public virtual string TestCode { get; set; } 

        /// <summary>Optional. A custom label to use for the test code field.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("testCodeLabel")]
        public virtual string TestCodeLabel { get; set; } 

        /// <summary>Optional. For example: `Viral, nucleic acid amplification test`</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("testDescription")]
        public virtual string TestDescription { get; set; } 

        /// <summary>Optional. A custom label to use for the test description field.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("testDescriptionLabel")]
        public virtual string TestDescriptionLabel { get; set; } 

        /// <summary>Optional. The testing platform of the COVID 19 test such as RT-PCR / RT-LAMP. Laboratory methods
        /// used in the COVID-19 testing.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("testPlatform")]
        public virtual string TestPlatform { get; set; } 

        /// <summary>Optional. A custom label to use for the test platform field.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("testPlatformLabel")]
        public virtual string TestPlatformLabel { get; set; } 

        /// <summary>Optional. Code to identify the test result.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("testResultCode")]
        public virtual string TestResultCode { get; set; } 

        /// <summary>Optional. A custom label to use for the test result code field.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("testResultCodeLabel")]
        public virtual string TestResultCodeLabel { get; set; } 

        /// <summary>Optional. Result of the test, such as `Negative`, `Positive`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("testResultDescription")]
        public virtual string TestResultDescription { get; set; } 

        /// <summary>Optional. A custom label to use for the test result description field.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("testResultDescriptionLabel")]
        public virtual string TestResultDescriptionLabel { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Data for Text module. All fields are optional. Header will be displayed if available, different types
    /// of bodies will be concatenated if they are defined.</summary>
    public class TextModuleData : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The body of the Text Module, which is defined as an uninterrupted string. Recommended maximum
        /// length is 500 characters to ensure full string is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("body")]
        public virtual string Body { get; set; } 

        /// <summary>The header of the Text Module. Recommended maximum length is 35 characters to ensure full string is
        /// displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("header")]
        public virtual string Header { get; set; } 

        /// <summary>The ID associated with a text module. This field is here to enable ease of management of text
        /// modules.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("id")]
        public virtual string Id { get; set; } 

        /// <summary>Translated strings for the body. Recommended maximum length is 500 characters to ensure full string
        /// is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedBody")]
        public virtual LocalizedString LocalizedBody { get; set; } 

        /// <summary>Translated strings for the header. Recommended maximum length is 35 characters to ensure full
        /// string is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedHeader")]
        public virtual LocalizedString LocalizedHeader { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class TicketCost : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A message describing any kind of discount that was applied.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("discountMessage")]
        public virtual LocalizedString DiscountMessage { get; set; } 

        /// <summary>The face value of the ticket.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("faceValue")]
        public virtual Money FaceValue { get; set; } 

        /// <summary>The actual purchase price of the ticket, after tax and/or discounts.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("purchasePrice")]
        public virtual Money PurchasePrice { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class TicketLeg : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The date/time of arrival. This is an ISO 8601 extended format date/time, with or without an offset.
        /// Time may be specified up to nanosecond precision. Offsets may be specified with seconds precision (even
        /// though offset seconds is not part of ISO 8601). For example: `1985-04-12T23:20:50.52Z` would be 20 minutes
        /// and 50.52 seconds after the 23rd hour of April 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would be 20
        /// minutes and 50.52 seconds after the 19th hour of April 12th, 1985, 4 hours before UTC (same instant in time
        /// as the above example). If the event were in New York, this would be the equivalent of Eastern Daylight Time
        /// (EDT). Remember that offset varies in regions that observe Daylight Saving Time (or Summer Time), depending
        /// on the time of the year. `1985-04-12T19:20:50.52` would be 20 minutes and 50.52 seconds after the 19th hour
        /// of April 12th, 1985 with no offset information. The portion of the date/time without the offset is
        /// considered the "local date/time". This should be the local date/time at the destination station. For
        /// example, if the event occurs at the 20th hour of June 5th, 2018 at the destination station, the local
        /// date/time portion should be `2018-06-05T20:00:00`. If the local date/time at the destination station is 4
        /// hours before UTC, an offset of `-04:00` may be appended. Without offset information, some rich features may
        /// not be available.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("arrivalDateTime")]
        public virtual string ArrivalDateTime { get; set; } 

        /// <summary>The train or ship name/number that the passsenger needs to board.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("carriage")]
        public virtual string Carriage { get; set; } 

        /// <summary>The date/time of departure. This is required if there is no validity time interval set on the
        /// transit object. This is an ISO 8601 extended format date/time, with or without an offset. Time may be
        /// specified up to nanosecond precision. Offsets may be specified with seconds precision (even though offset
        /// seconds is not part of ISO 8601). For example: `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52
        /// seconds after the 23rd hour of April 12th, 1985 in UTC. `1985-04-12T19:20:50.52-04:00` would be 20 minutes
        /// and 50.52 seconds after the 19th hour of April 12th, 1985, 4 hours before UTC (same instant in time as the
        /// above example). If the event were in New York, this would be the equivalent of Eastern Daylight Time (EDT).
        /// Remember that offset varies in regions that observe Daylight Saving Time (or Summer Time), depending on the
        /// time of the year. `1985-04-12T19:20:50.52` would be 20 minutes and 50.52 seconds after the 19th hour of
        /// April 12th, 1985 with no offset information. The portion of the date/time without the offset is considered
        /// the "local date/time". This should be the local date/time at the origin station. For example, if the
        /// departure occurs at the 20th hour of June 5th, 2018 at the origin station, the local date/time portion
        /// should be `2018-06-05T20:00:00`. If the local date/time at the origin station is 4 hours before UTC, an
        /// offset of `-04:00` may be appended. Without offset information, some rich features may not be
        /// available.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("departureDateTime")]
        public virtual string DepartureDateTime { get; set; } 

        /// <summary>The destination name.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("destinationName")]
        public virtual LocalizedString DestinationName { get; set; } 

        /// <summary>The destination station code.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("destinationStationCode")]
        public virtual string DestinationStationCode { get; set; } 

        /// <summary>Short description/name of the fare for this leg of travel. Eg "Anytime Single Use".</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("fareName")]
        public virtual LocalizedString FareName { get; set; } 

        /// <summary>The name of the origin station. This is required if `desinationName` is present or if
        /// `originStationCode` is not present.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("originName")]
        public virtual LocalizedString OriginName { get; set; } 

        /// <summary>The origin station code. This is required if `destinationStationCode` is present or if `originName`
        /// is not present.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("originStationCode")]
        public virtual string OriginStationCode { get; set; } 

        /// <summary>The platform or gate where the passenger can board the carriage.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("platform")]
        public virtual string Platform { get; set; } 

        /// <summary>The reserved seat for the passenger(s). If more than one seat is to be specified then use the
        /// `ticketSeats` field instead. Both `ticketSeat` and `ticketSeats` may not be set.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("ticketSeat")]
        public virtual TicketSeat TicketSeat { get; set; } 

        /// <summary>The reserved seat for the passenger(s). If only one seat is to be specified then use the
        /// `ticketSeat` field instead. Both `ticketSeat` and `ticketSeats` may not be set.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("ticketSeats")]
        public virtual System.Collections.Generic.IList<TicketSeat> TicketSeats { get; set; } 

        /// <summary>The name of the transit operator that is operating this leg of a trip.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("transitOperatorName")]
        public virtual LocalizedString TransitOperatorName { get; set; } 

        /// <summary>Terminus station or destination of the train/bus/etc.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("transitTerminusName")]
        public virtual LocalizedString TransitTerminusName { get; set; } 

        /// <summary>The zone of boarding within the platform.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("zone")]
        public virtual string Zone { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class TicketRestrictions : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Extra restrictions that don't fall under the "route" or "time" categories.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("otherRestrictions")]
        public virtual LocalizedString OtherRestrictions { get; set; } 

        /// <summary>Restrictions about routes that may be taken. For example, this may be the string "Reserved
        /// CrossCountry trains only".</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("routeRestrictions")]
        public virtual LocalizedString RouteRestrictions { get; set; } 

        /// <summary>More details about the above `routeRestrictions`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("routeRestrictionsDetails")]
        public virtual LocalizedString RouteRestrictionsDetails { get; set; } 

        /// <summary>Restrictions about times this ticket may be used.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("timeRestrictions")]
        public virtual LocalizedString TimeRestrictions { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class TicketSeat : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The identifier of the train car or coach in which the ticketed seat is located. Eg. "10"</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("coach")]
        public virtual string Coach { get; set; } 

        /// <summary>A custome fare class to be used if no `fareClass` applies. Both `fareClass` and `customFareClass`
        /// may not be set.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customFareClass")]
        public virtual LocalizedString CustomFareClass { get; set; } 

        /// <summary>The fare class of the ticketed seat.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("fareClass")]
        public virtual string FareClass { get; set; } 

        /// <summary>The identifier of where the ticketed seat is located. Eg. "42". If there is no specific identifier,
        /// use `seatAssigment` instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("seat")]
        public virtual string Seat { get; set; } 

        /// <summary>The passenger's seat assignment. Eg. "no specific seat". To be used when there is no specific
        /// identifier to use in `seat`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("seatAssignment")]
        public virtual LocalizedString SeatAssignment { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class TimeInterval : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>End time of the interval. Offset is not required. If an offset is provided and `start` time is set,
        /// `start` must also include an offset.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("end")]
        public virtual DateTime End { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#timeInterval"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>Start time of the interval. Offset is not required. If an offset is provided and `end` time is set,
        /// `end` must also include an offset.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("start")]
        public virtual DateTime Start { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Displays a ticker showing the current time in the specified format.</summary>
    public class TimeTicker : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>ISO 8601 DateTime format string for which to display the time. The format can be with or without
        /// offset. If unspecified, time will be displayed as local client time. For example, hh:mm:ssZ can be used to
        /// display time in UTC or hh:mm:ss-07:00 to display time in PST.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("format")]
        public virtual string Format { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class TransitClass : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Activation options for an activatable ticket.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("activationOptions")]
        public virtual ActivationOptions ActivationOptions { get; set; } 

        /// <summary>Deprecated. Use `multipleDevicesAndHoldersAllowedStatus` instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("allowMultipleUsersPerObject")]
        public virtual System.Nullable<bool> AllowMultipleUsersPerObject { get; set; } 

        /// <summary>Optional app or website link that will be displayed as a button on the front of the pass. If
        /// AppLinkData is provided for the corresponding object that will be used instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("appLinkData")]
        public virtual AppLinkData AppLinkData { get; set; } 

        /// <summary>Callback options to be used to call the issuer back for every save/delete of an object for this
        /// class by the end-user. All objects of this class are eligible for the callback.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("callbackOptions")]
        public virtual CallbackOptions CallbackOptions { get; set; } 

        /// <summary>Template information about how the class should be displayed. If unset, Google will fallback to a
        /// default set of fields to display.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("classTemplateInfo")]
        public virtual ClassTemplateInfo ClassTemplateInfo { get; set; } 

        /// <summary>Country code used to display the card's country (when the user is not in that country), as well as
        /// to display localized content when content is not available in the user's locale.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("countryCode")]
        public virtual string CountryCode { get; set; } 

        /// <summary>A custom label to use for the transit object activation date.
        /// (`transitObject.activationDateTime`).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customActivationDateTimeLabel")]
        public virtual LocalizedString CustomActivationDateTimeLabel { get; set; } 

        /// <summary>A custom label to use for the arrival date/time value
        /// (`transitObject.ticketLeg.arrivalDateTime`).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customArrivalDateLabel")]
        public virtual LocalizedString CustomArrivalDateLabel { get; set; } 

        /// <summary>A custom label to use for the carriage value (`transitObject.ticketLeg.carriage`).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customCarriageLabel")]
        public virtual LocalizedString CustomCarriageLabel { get; set; } 

        /// <summary>A custom label to use for the coach value (`transitObject.ticketLeg.ticketSeat.coach`).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customCoachLabel")]
        public virtual LocalizedString CustomCoachLabel { get; set; } 

        /// <summary>A custom label to use for the transit concession category value
        /// (`transitObject.concessionCategory`).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customConcessionCategoryLabel")]
        public virtual LocalizedString CustomConcessionCategoryLabel { get; set; } 

        /// <summary>A custom label to use for the confirmation code value
        /// (`transitObject.purchaseDetails.confirmationCode`).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customConfirmationCodeLabel")]
        public virtual LocalizedString CustomConfirmationCodeLabel { get; set; } 

        /// <summary>A custom label to use for the departure date/time value
        /// (`transitObject.ticketLeg.departureDateTime`).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customDepartureDateLabel")]
        public virtual LocalizedString CustomDepartureDateLabel { get; set; } 

        /// <summary>A custom label to use for the transit discount message value
        /// (`transitObject.purchaseDetails.ticketCost.discountMessage`).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customDiscountMessageLabel")]
        public virtual LocalizedString CustomDiscountMessageLabel { get; set; } 

        /// <summary>A custom label to use for the fare class value
        /// (`transitObject.ticketLeg.ticketSeat.fareClass`).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customFareClassLabel")]
        public virtual LocalizedString CustomFareClassLabel { get; set; } 

        /// <summary>A custom label to use for the transit fare name value
        /// (`transitObject.ticketLeg.fareName`).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customFareNameLabel")]
        public virtual LocalizedString CustomFareNameLabel { get; set; } 

        /// <summary>A custom label to use for the other restrictions value
        /// (`transitObject.ticketRestrictions.otherRestrictions`).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customOtherRestrictionsLabel")]
        public virtual LocalizedString CustomOtherRestrictionsLabel { get; set; } 

        /// <summary>A custom label to use for the boarding platform value
        /// (`transitObject.ticketLeg.platform`).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customPlatformLabel")]
        public virtual LocalizedString CustomPlatformLabel { get; set; } 

        /// <summary>A custom label to use for the purchase date/time value
        /// (`transitObject.purchaseDetails.purchaseDateTime`).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customPurchaseDateTimeLabel")]
        public virtual LocalizedString CustomPurchaseDateTimeLabel { get; set; } 

        /// <summary>A custom label to use for the purchase face value
        /// (`transitObject.purchaseDetails.ticketCost.faceValue`).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customPurchaseFaceValueLabel")]
        public virtual LocalizedString CustomPurchaseFaceValueLabel { get; set; } 

        /// <summary>A custom label to use for the purchase price value
        /// (`transitObject.purchaseDetails.ticketCost.purchasePrice`).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customPurchasePriceLabel")]
        public virtual LocalizedString CustomPurchasePriceLabel { get; set; } 

        /// <summary>A custom label to use for the purchase receipt number value
        /// (`transitObject.purchaseDetails.purchaseReceiptNumber`).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customPurchaseReceiptNumberLabel")]
        public virtual LocalizedString CustomPurchaseReceiptNumberLabel { get; set; } 

        /// <summary>A custom label to use for the route restrictions details value
        /// (`transitObject.ticketRestrictions.routeRestrictionsDetails`).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customRouteRestrictionsDetailsLabel")]
        public virtual LocalizedString CustomRouteRestrictionsDetailsLabel { get; set; } 

        /// <summary>A custom label to use for the route restrictions value
        /// (`transitObject.ticketRestrictions.routeRestrictions`).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customRouteRestrictionsLabel")]
        public virtual LocalizedString CustomRouteRestrictionsLabel { get; set; } 

        /// <summary>A custom label to use for the seat location value
        /// (`transitObject.ticketLeg.ticketSeat.seat`).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customSeatLabel")]
        public virtual LocalizedString CustomSeatLabel { get; set; } 

        /// <summary>A custom label to use for the ticket number value (`transitObject.ticketNumber`).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customTicketNumberLabel")]
        public virtual LocalizedString CustomTicketNumberLabel { get; set; } 

        /// <summary>A custom label to use for the time restrictions details value
        /// (`transitObject.ticketRestrictions.timeRestrictions`).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customTimeRestrictionsLabel")]
        public virtual LocalizedString CustomTimeRestrictionsLabel { get; set; } 

        /// <summary>A custom label to use for the transit terminus name value
        /// (`transitObject.ticketLeg.transitTerminusName`).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customTransitTerminusNameLabel")]
        public virtual LocalizedString CustomTransitTerminusNameLabel { get; set; } 

        /// <summary>A custom label to use for the validity end date/time value
        /// (`transitObject.validTimeInterval.end`).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customValidityEndDateLabel")]
        public virtual LocalizedString CustomValidityEndDateLabel { get; set; } 

        /// <summary>A custom label to use for the validity start date/time value
        /// (`transitObject.validTimeInterval.start`).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customValidityStartDateLabel")]
        public virtual LocalizedString CustomValidityStartDateLabel { get; set; } 

        /// <summary>A custom label to use for the boarding zone value (`transitObject.ticketLeg.zone`).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customZoneLabel")]
        public virtual LocalizedString CustomZoneLabel { get; set; } 

        /// <summary>Whether the device that holds the pass needs the pass to be certified and how.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("deviceCertificationSupport")]
        public virtual DeviceCertificationSupport DeviceCertificationSupport { get; set; } 

        /// <summary>Controls the display of the single-leg itinerary for this class. By default, an itinerary will only
        /// display for multi-leg trips.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("enableSingleLegItinerary")]
        public virtual System.Nullable<bool> EnableSingleLegItinerary { get; set; } 

        /// <summary>Identifies whether this class supports Smart Tap. The `redemptionIssuers` and object level
        /// `smartTapRedemptionLevel` fields must also be set up correctly in order for a pass to support Smart
        /// Tap.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("enableSmartTap")]
        public virtual System.Nullable<bool> EnableSmartTap { get; set; } 

        /// <summary>When a barcode is not set for an instance, the configuration used to generate one. It may consist
        /// of multiple parts concatenated together such as the account id, card number, pin, event number, or other
        /// hard coded values. The data is normally stored in the mag stripe and printed on the card.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("generatedBarcodeParts")]
        public virtual System.Collections.Generic.IList<GeneratedBarcodePart> GeneratedBarcodeParts { get; set; } 

        /// <summary>The type of barcode to be used when generating a barcode. If not specified for loyalty TEXT_ONLY
        /// will be used, and for gift cards CODE_128 will be used.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("generatedBarcodeType")]
        public virtual string GeneratedBarcodeType { get; set; } 

        /// <summary>Optional banner image displayed on the front of the card. If none is present, nothing will be
        /// displayed. The image will display at 100% width.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("heroImage")]
        public virtual Image HeroImage { get; set; } 

        /// <summary>The background color for the card. If not set the dominant color of the hero image is used, and if
        /// no hero image is set, the dominant color of the logo is used. The format is #rrggbb where rrggbb is a hex
        /// RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the RGB triplet which is #rgb,
        /// such as `#fc0`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hexBackgroundColor")]
        public virtual string HexBackgroundColor { get; set; } 

        /// <summary>Identifies whether or not this class should display a barcode for the user. This can be set if the
        /// class will not be scannable for some reason (eg: if the merchant uses scanners that cannot read phone
        /// screens).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hideBarcode")]
        public virtual System.Nullable<bool> HideBarcode { get; set; } 

        /// <summary>The URI of your application's home page. Populating the URI in this field results in the exact same
        /// behavior as populating an URI in linksModuleData (when an object is rendered, a link to the homepage is
        /// shown in what would usually be thought of as the linksModuleData section of the object).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("homepageUri")]
        public virtual Uri HomepageUri { get; set; } 

        /// <summary>Required. The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and
        /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or
        /// '-'.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("id")]
        public virtual string Id { get; set; } 

        /// <summary>Image module data. The maximum number of these fields displayed is 1 from object level and 1 for
        /// class object level.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("imageModulesData")]
        public virtual System.Collections.Generic.IList<ImageModuleData> ImageModulesData { get; set; } 

        /// <summary>Deprecated. Use textModulesData instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("infoModuleData")]
        public virtual InfoModuleData InfoModuleData { get; set; } 

        /// <summary>Required. The issuer name. Recommended maximum length is 20 characters to ensure full string is
        /// displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("issuerName")]
        public virtual string IssuerName { get; set; } 

        /// <summary>If this field is present, transit tickets served to a user's device will always be in this
        /// language. Represents the BCP 47 language tag. Example values are "en-US", "en-GB", "de", or "de-
        /// AT".</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("languageOverride")]
        public virtual string LanguageOverride { get; set; } 

        /// <summary>Links module data. If links module data is also defined on the object, both will be
        /// displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("linksModuleData")]
        public virtual LinksModuleData LinksModuleData { get; set; } 

        /// <summary>Translated strings for the issuer_name. Recommended maximum length is 20 characters to ensure full
        /// string is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedIssuerName")]
        public virtual LocalizedString LocalizedIssuerName { get; set; } 

        /// <summary>Translated strings for the message displayed on the preview of a card before it is saved by a user
        /// to their account.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedSaveToAndroidPayPreviewMessage")]
        public virtual LocalizedString LocalizedSaveToAndroidPayPreviewMessage { get; set; } 

        /// <summary>Note: This field is currently not supported to trigger geo notifications.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locations")]
        public virtual System.Collections.Generic.IList<LatLongPoint> Locations { get; set; } 

        /// <summary>Required. The logo image of the ticket. This image is displayed in the card detail view of the
        /// app.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("logo")]
        public virtual Image Logo { get; set; } 

        /// <summary>An array of messages displayed in the app. All users of this object will receive its associated
        /// messages. The maximum number of these fields is 10.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("messages")]
        public virtual System.Collections.Generic.IList<Message> Messages { get; set; } 

        /// <summary>Identifies whether multiple users and devices will save the same object referencing this
        /// class.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("multipleDevicesAndHoldersAllowedStatus")]
        public virtual string MultipleDevicesAndHoldersAllowedStatus { get; set; } 

        /// <summary>Whether or not field updates to this class should trigger notifications. When set to NOTIFY, we
        /// will attempt to trigger a field update notification to users. These notifications will only be sent to users
        /// if the field is part of an allowlist. If set to DO_NOT_NOTIFY or NOTIFICATION_SETTINGS_UNSPECIFIED, no
        /// notification will be triggered. This setting is ephemeral and needs to be set with each PATCH or UPDATE
        /// request, otherwise a notification will not be triggered.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("notifyPreference")]
        public virtual string NotifyPreference { get; set; } 

        /// <summary>Identifies which redemption issuers can redeem the pass over Smart Tap. Redemption issuers are
        /// identified by their issuer ID. Redemption issuers must have at least one Smart Tap key configured. The
        /// `enableSmartTap` and object level `smartTapRedemptionLevel` fields must also be set up correctly in order
        /// for a pass to support Smart Tap.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("redemptionIssuers")]
        public virtual System.Collections.Generic.IList<System.Nullable<long>> RedemptionIssuers { get; set; } 

        /// <summary>The review comments set by the platform when a class is marked `approved` or `rejected`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("review")]
        public virtual Review Review { get; set; } 

        /// <summary>Required. The status of the class. This field can be set to `draft` or `underReview` using the
        /// insert, patch, or update API calls. Once the review state is changed from `draft` it may not be changed back
        /// to `draft`. You should keep this field to `draft` when the class is under development. A `draft` class
        /// cannot be used to create any object. You should set this field to `underReview` when you believe the class
        /// is ready for use. The platform will automatically set this field to `approved` and it can be immediately
        /// used to create or migrate objects. When updating an already `approved` class you should keep setting this
        /// field to `underReview`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("reviewStatus")]
        public virtual string ReviewStatus { get; set; } 

        /// <summary>Message displayed on the preview of a card before it is saved by a user to their account.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("saveToAndroidPayPreviewMessage")]
        public virtual string SaveToAndroidPayPreviewMessage { get; set; } 

        /// <summary>Optional information about the security animation. If this is set a security animation will be
        /// rendered on pass details.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("securityAnimation")]
        public virtual SecurityAnimation SecurityAnimation { get; set; } 

        /// <summary>Indicates if authentication should be required when transmitting the valuable. If this is true, and
        /// the terminal does not support authentication then objects of this class will not be transmitted. May only by
        /// true when smart_tap_encryption_required is true.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapAuthenticationRequired")]
        public virtual System.Nullable<bool> SmartTapAuthenticationRequired { get; set; } 

        /// <summary>Indicates if encryption should be required when transmitting the valuable. If this is true, and the
        /// terminal does not support encryption, then objects of this class will not be transmitted. May only be true
        /// when enable_smart_tap is true.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapEncryptionRequired")]
        public virtual System.Nullable<bool> SmartTapEncryptionRequired { get; set; } 

        /// <summary>Determines how to generate the smart tap redemption value from the redemption identifier. If this
        /// field is populated, the user's smart tap redemption value will change whenever the redemption identifier
        /// changes.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapRedemptionValueGenerationParams")]
        public virtual SmartTapRedemptionValueGenerationParams SmartTapRedemptionValueGenerationParams { get; set; } 

        /// <summary>Text module data. If text module data is also defined on the class, both will be displayed. The
        /// maximum number of these fields displayed is 10 from the object and 10 from the class.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("textModulesData")]
        public virtual System.Collections.Generic.IList<TextModuleData> TextModulesData { get; set; } 

        /// <summary>ISO 8601 DateTime format string for which to display the time. The format can be with or without
        /// offset. If unspecified, time will be displayed as local client time. For example, hh:mm:ssZ can be used to
        /// display time in UTC hh:mm:ss-07:00 to display time in PST.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("timeTicker")]
        public virtual TimeTicker TimeTicker { get; set; } 

        /// <summary>The name of the transit operator.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("transitOperatorName")]
        public virtual LocalizedString TransitOperatorName { get; set; } 

        /// <summary>Required. The type of transit this class represents, such as "bus".</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("transitType")]
        public virtual string TransitType { get; set; } 

        /// <summary>A regex that describes what a valid redemption identifier for this class looks like.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("validRedemptionIdentifierRegex")]
        public virtual string ValidRedemptionIdentifierRegex { get; set; } 

        /// <summary>Deprecated</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("version")]
        public virtual System.Nullable<long> Version { get; set; } 

        /// <summary>View Unlock Requirement options for the transit ticket.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("viewUnlockRequirement")]
        public virtual string ViewUnlockRequirement { get; set; } 

        /// <summary>When set, causes the primary view of the valuable to be visual inspection based. Communicates key
        /// fields like type and color.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("visualInspections")]
        public virtual System.Collections.Generic.IList<VisualInspection> VisualInspections { get; set; } 

        /// <summary>Watermark image to display on the user's device.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("watermark")]
        public virtual Image Watermark { get; set; } 

        /// <summary>The wide logo of the ticket. When provided, this will be used in place of the logo in the top left
        /// of the card view.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("wideLogo")]
        public virtual Image WideLogo { get; set; } 

        /// <summary>Deprecated.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("wordMark")]
        public virtual Image WordMark { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class TransitClassAddMessageResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The updated TransitClass resource.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resource")]
        public virtual TransitClass Resource { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class TransitClassListResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Pagination of the response.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("pagination")]
        public virtual Pagination Pagination { get; set; } 

        /// <summary>Resources corresponding to the list request.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resources")]
        public virtual System.Collections.Generic.IList<TransitClass> Resources { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class TransitObject : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The date/time the transit object was activated. If this field is selected to be displayed and it is
        /// not present, a pass will display the text "Use to activate". This is an ISO 8601 extended format date/time,
        /// with or without an offset. Time may be specified up to nanosecond precision. Offsets may be specified with
        /// seconds precision (even though offset seconds is not part of ISO 8601). For example:
        /// `1985-04-12T23:20:50.52Z` would be 20 minutes and 50.52 seconds after the 23rd hour of April 12th, 1985 in
        /// UTC. `1985-04-12T19:20:50.52-04:00` would be 20 minutes and 50.52 seconds after the 19th hour of April 12th,
        /// 1985, 4 hours before UTC (same instant in time as the above example). If the event were in New York, this
        /// would be the equivalent of Eastern Daylight Time (EDT). Remember that offset varies in regions that observe
        /// Daylight Saving Time (or Summer Time), depending on the time of the year. `1985-04-12T19:20:50.52` would be
        /// 20 minutes and 50.52 seconds after the 19th hour of April 12th, 1985 with no offset information. Without
        /// offset information, some rich features may not be available.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("activationDateTime")]
        public virtual string ActivationDateTime { get; set; } 

        /// <summary>The activation status for the object. Required if the class has `activationOptions` set.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("activationStatus")]
        public virtual ActivationStatus ActivationStatus { get; set; } 

        /// <summary>Optional app or website link that will be displayed as a button on the front of the pass. If
        /// AppLinkData is provided for the corresponding class only object AppLinkData will be displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("appLinkData")]
        public virtual AppLinkData AppLinkData { get; set; } 

        /// <summary>The barcode type and value.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("barcode")]
        public virtual Barcode Barcode { get; set; } 

        /// <summary>Represents textual call-outs within a bubble.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("bubbleTexts")]
        public virtual System.Collections.Generic.IList<BubbleText> BubbleTexts { get; set; } 

        /// <summary>Required. The class associated with this object. The class must be of the same type as this object,
        /// must already exist, and must be approved. Class IDs should follow the format issuer ID.identifier where the
        /// former is issued by Google and latter is chosen by you.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("classId")]
        public virtual string ClassId { get; set; } 

        /// <summary>A copy of the inherited fields of the parent class. These fields are retrieved during a
        /// GET.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("classReference")]
        public virtual TransitClass ClassReference { get; set; } 

        /// <summary>The concession category for the ticket.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("concessionCategory")]
        public virtual string ConcessionCategory { get; set; } 

        /// <summary>A custom title to use on the pass. Currently this is only supported for MULTIDAY transit
        /// objects.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customCardTitle")]
        public virtual LocalizedString CustomCardTitle { get; set; } 

        /// <summary>A custom concession category to use when `concessionCategory` does not provide the right option.
        /// Both `concessionCategory` and `customConcessionCategory` may not be set.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customConcessionCategory")]
        public virtual LocalizedString CustomConcessionCategory { get; set; } 

        /// <summary>A custom status to use for the ticket status value when `ticketStatus` does not provide the right
        /// option. Both `ticketStatus` and `customTicketStatus` may not be set.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("customTicketStatus")]
        public virtual LocalizedString CustomTicketStatus { get; set; } 

        /// <summary>Device context associated with the object.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("deviceContext")]
        public virtual DeviceContext DeviceContext { get; set; } 

        /// <summary>Indicates if notifications should explicitly be suppressed. If this field is set to true,
        /// regardless of the `messages` field, expiration notifications to the user will be suppressed. By default,
        /// this field is set to false. Currently, this can only be set for offers.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("disableExpirationNotification")]
        public virtual System.Nullable<bool> DisableExpirationNotification { get; set; } 

        /// <summary>Information that controls how passes are grouped together.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("groupingInfo")]
        public virtual GroupingInfo GroupingInfo { get; set; } 

        /// <summary>Whether this object is currently linked to a single device. This field is set by the platform when
        /// a user saves the object, linking it to their device. Intended for use by select partners. Contact support
        /// for additional information.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hasLinkedDevice")]
        public virtual System.Nullable<bool> HasLinkedDevice { get; set; } 

        /// <summary>Indicates if the object has users. This field is set by the platform.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hasUsers")]
        public virtual System.Nullable<bool> HasUsers { get; set; } 

        /// <summary>Optional banner image displayed on the front of the card. If none is present, hero image of the
        /// class, if present, will be displayed. If hero image of the class is also not present, nothing will be
        /// displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("heroImage")]
        public virtual Image HeroImage { get; set; } 

        /// <summary>The background color for the card. If not set the dominant color of the hero image is used, and if
        /// no hero image is set, the dominant color of the logo is used. The format is #rrggbb where rrggbb is a hex
        /// RGB triplet, such as `#ffcc00`. You can also use the shorthand version of the RGB triplet which is #rgb,
        /// such as `#fc0`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hexBackgroundColor")]
        public virtual string HexBackgroundColor { get; set; } 

        /// <summary>Required. The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID.identifier where the former is issued by Google and
        /// latter is chosen by you. The unique identifier should only include alphanumeric characters, '.', '_', or
        /// '-'.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("id")]
        public virtual string Id { get; set; } 

        /// <summary>Image module data. The maximum number of these fields displayed is 1 from object level and 1 for
        /// class object level.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("imageModulesData")]
        public virtual System.Collections.Generic.IList<ImageModuleData> ImageModulesData { get; set; } 

        /// <summary>Deprecated. Use textModulesData instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("infoModuleData")]
        public virtual InfoModuleData InfoModuleData { get; set; } 

        /// <summary>linked_object_ids are a list of other objects such as event ticket, loyalty, offer, generic,
        /// giftcard, transit and boarding pass that should be automatically attached to this transit object. If a user
        /// had saved this transit card, then these linked_object_ids would be automatically pushed to the user's wallet
        /// (unless they turned off the setting to receive such linked passes). Object IDs should follow the format
        /// issuer ID.identifier where the former is issued by Google and the latter is chosen by you.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("linkedObjectIds")]
        public virtual System.Collections.Generic.IList<string> LinkedObjectIds { get; set; } 

        /// <summary>Links module data. If links module data is also defined on the class, both will be
        /// displayed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("linksModuleData")]
        public virtual LinksModuleData LinksModuleData { get; set; } 

        /// <summary>Note: This field is currently not supported to trigger geo notifications.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locations")]
        public virtual System.Collections.Generic.IList<LatLongPoint> Locations { get; set; } 

        /// <summary>An array of messages displayed in the app. All users of this object will receive its associated
        /// messages. The maximum number of these fields is 10.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("messages")]
        public virtual System.Collections.Generic.IList<Message> Messages { get; set; } 

        /// <summary>Whether or not field updates to this object should trigger notifications. When set to NOTIFY, we
        /// will attempt to trigger a field update notification to users. These notifications will only be sent to users
        /// if the field is part of an allowlist. If set to DO_NOT_NOTIFY or NOTIFICATION_SETTINGS_UNSPECIFIED, no
        /// notification will be triggered. This setting is ephemeral and needs to be set with each PATCH or UPDATE
        /// request, otherwise a notification will not be triggered.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("notifyPreference")]
        public virtual string NotifyPreference { get; set; } 

        /// <summary>The number of days a MULTIDAY transit object is valid for. Used to construct a title for MULTIDAY
        /// transit objects, eg "365 day pass". Required if the trip type is MULTIDAY. Note this field does not
        /// automatically expire the pass. `valid_time_interval` field is the source of truth which determines the
        /// expiry of the pass.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("numValidDays")]
        public virtual System.Nullable<int> NumValidDays { get; set; } 

        /// <summary>Pass constraints for the object. Includes limiting NFC and screenshot behaviors.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("passConstraints")]
        public virtual PassConstraints PassConstraints { get; set; } 

        /// <summary>The name(s) of the passengers the ticket is assigned to. The above `passengerType` field is meant
        /// to give Google context on this field.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("passengerNames")]
        public virtual string PassengerNames { get; set; } 

        /// <summary>The number of passengers.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("passengerType")]
        public virtual string PassengerType { get; set; } 

        /// <summary>Purchase details for this ticket.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("purchaseDetails")]
        public virtual PurchaseDetails PurchaseDetails { get; set; } 

        /// <summary>The rotating barcode type and value.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("rotatingBarcode")]
        public virtual RotatingBarcode RotatingBarcode { get; set; } 

        /// <summary>Restrictions on the object that needs to be verified before the user tries to save the pass. Note
        /// that this restrictions will only be applied during save time. If the restrictions changed after a user saves
        /// the pass, the new restrictions will not be applied to an already saved pass.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("saveRestrictions")]
        public virtual SaveRestrictions SaveRestrictions { get; set; } 

        /// <summary>The value that will be transmitted to a Smart Tap certified terminal over NFC for this object. The
        /// class level fields `enableSmartTap` and `redemptionIssuers` must also be set up correctly in order for the
        /// pass to support Smart Tap. Only ASCII characters are supported.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smartTapRedemptionValue")]
        public virtual string SmartTapRedemptionValue { get; set; } 

        /// <summary>Required. The state of the object. This field is used to determine how an object is displayed in
        /// the app. For example, an `inactive` object is moved to the "Expired passes" section.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("state")]
        public virtual string State { get; set; } 

        /// <summary>Text module data. If text module data is also defined on the class, both will be displayed. The
        /// maximum number of these fields displayed is 10 from the object and 10 from the class.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("textModulesData")]
        public virtual System.Collections.Generic.IList<TextModuleData> TextModulesData { get; set; } 

        /// <summary>A single ticket leg contains departure and arrival information along with boarding and seating
        /// information. If more than one leg is to be specified then use the `ticketLegs` field instead. Both
        /// `ticketLeg` and `ticketLegs` may not be set.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("ticketLeg")]
        public virtual TicketLeg TicketLeg { get; set; } 

        /// <summary>Each ticket may contain one or more legs. Each leg contains departure and arrival information along
        /// with boarding and seating information. If only one leg is to be specified then use the `ticketLeg` field
        /// instead. Both `ticketLeg` and `ticketLegs` may not be set.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("ticketLegs")]
        public virtual System.Collections.Generic.IList<TicketLeg> TicketLegs { get; set; } 

        /// <summary>The number of the ticket. This is a unique identifier for the ticket in the transit operator's
        /// system.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("ticketNumber")]
        public virtual string TicketNumber { get; set; } 

        /// <summary>Information about what kind of restrictions there are on using this ticket. For example, which days
        /// of the week it must be used, or which routes are allowed to be taken.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("ticketRestrictions")]
        public virtual TicketRestrictions TicketRestrictions { get; set; } 

        /// <summary>The status of the ticket. For states which affect display, use the `state` field instead.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("ticketStatus")]
        public virtual string TicketStatus { get; set; } 

        /// <summary>This id is used to group tickets together if the user has saved multiple tickets for the same
        /// trip.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("tripId")]
        public virtual string TripId { get; set; } 

        /// <summary>Required. The type of trip this transit object represents. Used to determine the pass title and/or
        /// which symbol to use between the origin and destination.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("tripType")]
        public virtual string TripType { get; set; } 

        /// <summary>The time period this object will be `active` and object can be used. An object's state will be
        /// changed to `expired` when this time period has passed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("validTimeInterval")]
        public virtual TimeInterval ValidTimeInterval { get; set; } 

        /// <summary>Deprecated</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("version")]
        public virtual System.Nullable<long> Version { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class TransitObjectAddMessageResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The updated TransitObject resource.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resource")]
        public virtual TransitObject Resource { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class TransitObjectListResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Pagination of the response.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("pagination")]
        public virtual Pagination Pagination { get; set; } 

        /// <summary>Resources corresponding to the list request.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resources")]
        public virtual System.Collections.Generic.IList<TransitObject> Resources { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Request to upload rotating barcode values.</summary>
    public class TransitObjectUploadRotatingBarcodeValuesRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A reference to the rotating barcode values payload that was uploaded.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("blob")]
        public virtual Media Blob { get; set; } 

        /// <summary>Extra information about the uploaded media.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mediaRequestInfo")]
        public virtual MediaRequestInfo MediaRequestInfo { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Response for uploading rotating barcode values.</summary>
    public class TransitObjectUploadRotatingBarcodeValuesResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class TranslatedString : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Identifies what kind of resource this is. Value: the fixed string
        /// `"walletobjects#translatedString"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>Represents the BCP 47 language tag. Example values are "en-US", "en-GB", "de", or "de-
        /// AT".</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("language")]
        public virtual string Language { get; set; } 

        /// <summary>The UTF-8 encoded translated string.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("value")]
        public virtual string Value { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Indicates that the issuer would like Google Wallet to send an upcoming card validity notification 1 day
    /// before card becomes valid/usable.</summary>
    public class UpcomingNotification : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Indicates if the object needs to have upcoming notification enabled.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("enableNotification")]
        public virtual System.Nullable<bool> EnableNotification { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Request for sending user private Text or URI by the Issuer.</summary>
    public class UploadPrivateDataRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The ID of the issuer sending the data.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("issuerId")]
        public virtual System.Nullable<long> IssuerId { get; set; } 

        /// <summary>Private text data of the user.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("text")]
        public virtual PrivateText Text { get; set; } 

        /// <summary>Private URIs of the user.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("uri")]
        public virtual PrivateUri Uri { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Response for uploading user private data (text or URIs)</summary>
    public class UploadPrivateDataResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A 64-bit content id for the private data that was uploaded by the Issuer.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("privateContentId")]
        public virtual System.Nullable<long> PrivateContentId { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Request to upload user's private images by Issuers to be used in passes.</summary>
    public class UploadPrivateImageRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A reference to the image payload that was uploaded by Scotty.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("blob")]
        public virtual Media Blob { get; set; } 

        /// <summary>Extra information about the uploaded media.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mediaRequestInfo")]
        public virtual MediaRequestInfo MediaRequestInfo { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Response for uploading the private image</summary>
    public class UploadPrivateImageResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A 64-bit content id for the image that was uploaded by the Issuer.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("privateContentId")]
        public virtual System.Nullable<long> PrivateContentId { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    public class Uri : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The URI's title appearing in the app as text. Recommended maximum is 20 characters to ensure full
        /// string is displayed on smaller screens. Note that in some contexts this text is not used, such as when
        /// `description` is part of an image.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("description")]
        public virtual string Description { get; set; } 

        /// <summary>The type of description to use for this link. Used to add localized descriptions at serving time
        /// when the description is unset.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("descriptionType")]
        public virtual string DescriptionType { get; set; } 

        /// <summary>The ID associated with a uri. This field is here to enable ease of management of uris.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("id")]
        public virtual string Id { get; set; } 

        /// <summary>Identifies what kind of resource this is. Value: the fixed string `"walletobjects#uri"`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kind")]
        public virtual string Kind { get; set; } 

        /// <summary>Translated strings for the description. Recommended maximum is 20 characters to ensure full string
        /// is displayed on smaller screens.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedDescription")]
        public virtual LocalizedString LocalizedDescription { get; set; } 

        /// <summary>The location of a web page, image, or other resource. URIs in the `LinksModuleData` module can have
        /// different prefixes indicating the type of URI (a link to a web page, a link to a map, a telephone number, or
        /// an email address). URIs must have a scheme.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("uri")]
        public virtual string UriValue { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>The user level information from issuer's user profile.</summary>
    public class UserLevel : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Required. The user level value which is rendered as a user Star Rank on Wallet.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("value")]
        public virtual System.Nullable<int> Value { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Details for the Vaccination Records.</summary>
    public class VaccinationDetails : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Required. Individual vaccination records. The first item in the `VaccinationRecord` is used as the
        /// default value.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("vaccinationRecord")]
        public virtual System.Collections.Generic.IList<VaccinationRecord> VaccinationRecord { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Details for the individual Vaccination Record.</summary>
    public class VaccinationRecord : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Optional. Code to identify the vaccine, such as an identifier or name of the vaccine.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("code")]
        public virtual string Code { get; set; } 

        /// <summary>Optional. A custom label to use for the code field.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("codeLabel")]
        public virtual string CodeLabel { get; set; } 

        /// <summary>Optional. Contact information for the provider where the vaccination happened, such as the address
        /// and phone for the hospital, lab, or pharmacy.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("contactInfo")]
        public virtual string ContactInfo { get; set; } 

        /// <summary>Optional. A custom label to use for the contact info field.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("contactInfoLabel")]
        public virtual string ContactInfoLabel { get; set; } 

        /// <summary>Optional. Description of the vaccine, may not be necessary if manufacturer is supplied. Must be
        /// present if `doseDateTime` is set and `manufacturer` is not set. For example: `2-Dose mRNA
        /// Vaccine`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("description")]
        public virtual string Description { get; set; } 

        /// <summary>Optional. A custom label to use for the description field.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("descriptionLabel")]
        public virtual string DescriptionLabel { get; set; } 

        /// <summary>Required. Vaccination date and time. Must be set if either `manufacturer` or `description` are set.
        /// This is an ISO 8601 extended format date and time without an offset. For example:
        /// `2027-03-25T06:30:00`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("doseDateTime")]
        public virtual string DoseDateTime { get; set; } 

        /// <summary>Required. Dose label to identify this vaccination dose, such as `1st Dose`, `2nd Dose`, `Final
        /// Dose`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("doseLabel")]
        public virtual string DoseLabel { get; set; } 

        /// <summary>Optional. Lot number or label for the vaccine.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("lotNumber")]
        public virtual string LotNumber { get; set; } 

        /// <summary>Optional. A custom label to use for the lot number field.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("lotNumberLabel")]
        public virtual string LotNumberLabel { get; set; } 

        /// <summary>Optional. Manufacturer or brand name for the vaccine, such as `BioNTech/Pfizer`, `Moderna`. Must be
        /// present if `doseDateTime` is set and `description` is not set.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("manufacturer")]
        public virtual string Manufacturer { get; set; } 

        /// <summary>Optional. Manufacturer label for the vaccine. If supplied will be visible as a label on top of the
        /// value in field manufacturer. If not the default label will be used as `Manufacturer`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("manufacturerLabel")]
        public virtual string ManufacturerLabel { get; set; } 

        /// <summary>Optional. Information for the vaccine provider; it can be name of the hospital, lab, or pharmacy
        /// name where the vaccination happened.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("provider")]
        public virtual string Provider { get; set; } 

        /// <summary>Optional. A custom label to use for the provider field.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("providerLabel")]
        public virtual string ProviderLabel { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Contains a single type of ValuablesClass.</summary>
    public class ValuablesClass : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Event Ticket class as per
        /// https://developers.google.com/pay/passes/rest/v1/eventticketclass#resource:-eventticketclass</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("eventTicketClass")]
        public virtual EventTicketClass EventTicketClass { get; set; } 

        /// <summary>Flight class as per
        /// https://developers.google.com/pay/passes/rest/v1/flightclass#resource:-flightclass</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("flightClass")]
        public virtual FlightClass FlightClass { get; set; } 

        /// <summary>Generic Class as per
        /// https://developers.google.com/pay/passes/rest/v1/genericclass#resource:-genericclass</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("genericClass")]
        public virtual GenericClass GenericClass { get; set; } 

        /// <summary>Generic Private Pass It is only added here in order to force auto-generation of
        /// api.services.walletobjects.model.GenericPrivatePass which is needed by issuerjson.JwtGenerator.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("genericPrivatePass")]
        public virtual GenericPrivatePass GenericPrivatePass { get; set; } 

        /// <summary>Gift card class as per
        /// https://developers.google.com/pay/passes/rest/v1/giftcardclass#resource:-giftcardclass</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("giftCardClass")]
        public virtual GiftCardClass GiftCardClass { get; set; } 

        /// <summary>Loyalty class as per
        /// https://developers.google.com/pay/passes/rest/v1/loyaltyclass#resource:-loyaltyclass</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("loyaltyClass")]
        public virtual LoyaltyClass LoyaltyClass { get; set; } 

        /// <summary>Offer class as per
        /// https://developers.google.com/pay/passes/rest/v1/offerclass#resource:-offerclass</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("offerClass")]
        public virtual OfferClass OfferClass { get; set; } 

        /// <summary>Transit Class as per
        /// https://developers.google.com/pay/passes/rest/v1/transitclass#resource:-transitclass</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("transitClass")]
        public virtual TransitClass TransitClass { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Contains the count of ValuablesClasses belonging to an issuer grouped by their Type.</summary>
    public class ValuablesClassesCount : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The total number of valuable classes present for the issuer_id.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("totalSize")]
        public virtual System.Nullable<long> TotalSize { get; set; } 

        /// <summary>The number of ValuablesClasses in each type for the issuer_id.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("typeCount")]
        public virtual System.Collections.Generic.IList<ValuablesClassesCountTypeCount> TypeCount { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>The type of valuable and the number of ValuablesClasses in that type.</summary>
    public class ValuablesClassesCountTypeCount : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The total number of ValuablesClasses belonging to that type.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("count")]
        public virtual System.Nullable<long> Count { get; set; } 

        /// <summary>The type of valuable.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("valuableType")]
        public virtual string ValuableType { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }    

    /// <summary>Represents a visual inspection view for a valuable and communicates key fields like type or
    /// color.</summary>
    public class VisualInspection : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Primary color of the visual inspection view. The use of this field depends on the type of view. The
        /// format is rrggbb where rrggbb is a hex RGB triplet, such as `#ffcc00`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hexPrimaryColor")]
        public virtual string HexPrimaryColor { get; set; } 

        /// <summary>Translated strings with instructions on using the view.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedUsageInstructions")]
        public virtual LocalizedString LocalizedUsageInstructions { get; set; } 

        /// <summary>The type of the visual inspection view.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("type")]
        public virtual string Type { get; set; } 

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }
}

namespace Google.Apis.Walletobjects.v1
{
    /// <summary>The Walletobjects Service.</summary>
    public class WalletobjectsService : Google.Apis.Services.BaseClientService
    {
        /// <summary>The API version.</summary>
        public const string Version = "v1";

        /// <summary>The discovery version used to generate this service.</summary>
        public static Google.Apis.Discovery.DiscoveryVersion DiscoveryVersionUsed =
            Google.Apis.Discovery.DiscoveryVersion.Version_1_0;

        /// <summary>Constructs a new service.</summary>
        public WalletobjectsService() :
            this(new Google.Apis.Services.BaseClientService.Initializer()) {}

        /// <summary>Constructs a new service.</summary>
        /// <param name="initializer">The service initializer.</param>
        public WalletobjectsService(Google.Apis.Services.BaseClientService.Initializer initializer)
            : base(initializer)
        {
            eventticketclass = new EventticketclassResource(this);
            eventticketobject = new EventticketobjectResource(this);
            flightclass = new FlightclassResource(this);
            flightobject = new FlightobjectResource(this);
            genericclass = new GenericclassResource(this);
            genericobject = new GenericobjectResource(this);
            giftcardclass = new GiftcardclassResource(this);
            giftcardobject = new GiftcardobjectResource(this);
            issuer = new IssuerResource(this);
            jwt = new JwtResource(this);
            loyaltyclass = new LoyaltyclassResource(this);
            loyaltyobject = new LoyaltyobjectResource(this);
            media = new MediaResource(this);
            offerclass = new OfferclassResource(this);
            offerobject = new OfferobjectResource(this);
            permissions = new PermissionsResource(this);
            smarttap = new SmarttapResource(this);
            transitclass = new TransitclassResource(this);
            transitobject = new TransitobjectResource(this);
            valuablesclasses = new ValuablesclassesResource(this);
            walletobjects = new WalletobjectsResource(this);
        }

        /// <summary>Gets the service supported features.</summary>
        public override System.Collections.Generic.IList<string> Features
        {
            get { return new string[0]; }
        }

        /// <summary>Gets the service name.</summary>
        public override string Name
        {
            get { return "walletobjects"; }
        }

        /// <summary>Gets the service base URI.</summary>
        public override string BaseUri
        {
            get { return "https://walletobjects.googleapis.com/"; }
        }

        /// <summary>Gets the service base path.</summary>
        public override string BasePath
        {
            get { return ""; }
        }

        /// <summary>Available OAuth 2.0 scopes for use with the Google Wallet API.</summary>
        public class Scope
        {
            /// <summary>Private Service: https://www.googleapis.com/auth/wallet_object.issuer</summary>
            public static string WalletObjectIssuer = "https://www.googleapis.com/auth/wallet_object.issuer";

        }



        private readonly EventticketclassResource eventticketclass;

        /// <summary>Gets the Eventticketclass resource.</summary>
        public virtual EventticketclassResource Eventticketclass
        {
            get { return eventticketclass; }
        }

        private readonly EventticketobjectResource eventticketobject;

        /// <summary>Gets the Eventticketobject resource.</summary>
        public virtual EventticketobjectResource Eventticketobject
        {
            get { return eventticketobject; }
        }

        private readonly FlightclassResource flightclass;

        /// <summary>Gets the Flightclass resource.</summary>
        public virtual FlightclassResource Flightclass
        {
            get { return flightclass; }
        }

        private readonly FlightobjectResource flightobject;

        /// <summary>Gets the Flightobject resource.</summary>
        public virtual FlightobjectResource Flightobject
        {
            get { return flightobject; }
        }

        private readonly GenericclassResource genericclass;

        /// <summary>Gets the Genericclass resource.</summary>
        public virtual GenericclassResource Genericclass
        {
            get { return genericclass; }
        }

        private readonly GenericobjectResource genericobject;

        /// <summary>Gets the Genericobject resource.</summary>
        public virtual GenericobjectResource Genericobject
        {
            get { return genericobject; }
        }

        private readonly GiftcardclassResource giftcardclass;

        /// <summary>Gets the Giftcardclass resource.</summary>
        public virtual GiftcardclassResource Giftcardclass
        {
            get { return giftcardclass; }
        }

        private readonly GiftcardobjectResource giftcardobject;

        /// <summary>Gets the Giftcardobject resource.</summary>
        public virtual GiftcardobjectResource Giftcardobject
        {
            get { return giftcardobject; }
        }

        private readonly IssuerResource issuer;

        /// <summary>Gets the Issuer resource.</summary>
        public virtual IssuerResource Issuer
        {
            get { return issuer; }
        }

        private readonly JwtResource jwt;

        /// <summary>Gets the Jwt resource.</summary>
        public virtual JwtResource Jwt
        {
            get { return jwt; }
        }

        private readonly LoyaltyclassResource loyaltyclass;

        /// <summary>Gets the Loyaltyclass resource.</summary>
        public virtual LoyaltyclassResource Loyaltyclass
        {
            get { return loyaltyclass; }
        }

        private readonly LoyaltyobjectResource loyaltyobject;

        /// <summary>Gets the Loyaltyobject resource.</summary>
        public virtual LoyaltyobjectResource Loyaltyobject
        {
            get { return loyaltyobject; }
        }

        private readonly MediaResource media;

        /// <summary>Gets the Media resource.</summary>
        public virtual MediaResource Media
        {
            get { return media; }
        }

        private readonly OfferclassResource offerclass;

        /// <summary>Gets the Offerclass resource.</summary>
        public virtual OfferclassResource Offerclass
        {
            get { return offerclass; }
        }

        private readonly OfferobjectResource offerobject;

        /// <summary>Gets the Offerobject resource.</summary>
        public virtual OfferobjectResource Offerobject
        {
            get { return offerobject; }
        }

        private readonly PermissionsResource permissions;

        /// <summary>Gets the Permissions resource.</summary>
        public virtual PermissionsResource Permissions
        {
            get { return permissions; }
        }

        private readonly SmarttapResource smarttap;

        /// <summary>Gets the Smarttap resource.</summary>
        public virtual SmarttapResource Smarttap
        {
            get { return smarttap; }
        }

        private readonly TransitclassResource transitclass;

        /// <summary>Gets the Transitclass resource.</summary>
        public virtual TransitclassResource Transitclass
        {
            get { return transitclass; }
        }

        private readonly TransitobjectResource transitobject;

        /// <summary>Gets the Transitobject resource.</summary>
        public virtual TransitobjectResource Transitobject
        {
            get { return transitobject; }
        }

        private readonly ValuablesclassesResource valuablesclasses;

        /// <summary>Gets the Valuablesclasses resource.</summary>
        public virtual ValuablesclassesResource Valuablesclasses
        {
            get { return valuablesclasses; }
        }

        private readonly WalletobjectsResource walletobjects;

        /// <summary>Gets the Walletobjects resource.</summary>
        public virtual WalletobjectsResource Walletobjects
        {
            get { return walletobjects; }
        }
    }

    ///<summary>A base abstract class for Walletobjects requests.</summary>
    public abstract class WalletobjectsBaseServiceRequest<TResponse> : Google.Apis.Requests.ClientServiceRequest<TResponse>
    {
        ///<summary>Constructs a new WalletobjectsBaseServiceRequest instance.</summary>
        protected WalletobjectsBaseServiceRequest(Google.Apis.Services.IClientService service)
            : base(service)
        {
        }

        /// <summary>V1 error format.</summary>
        [Google.Apis.Util.RequestParameterAttribute("$.xgafv", Google.Apis.Util.RequestParameterType.Query)]
        public virtual System.Nullable<XgafvEnum> Xgafv { get; set; }

        /// <summary>V1 error format.</summary>
        public enum XgafvEnum
        {
            /// <summary>v1 error format</summary>
            [Google.Apis.Util.StringValueAttribute("1")]
            Value1,
            /// <summary>v2 error format</summary>
            [Google.Apis.Util.StringValueAttribute("2")]
            Value2,
        }

        /// <summary>OAuth access token.</summary>
        [Google.Apis.Util.RequestParameterAttribute("access_token", Google.Apis.Util.RequestParameterType.Query)]
        public virtual string AccessToken { get; set; }

        /// <summary>Data format for response.</summary>
        /// [default: json]
        [Google.Apis.Util.RequestParameterAttribute("alt", Google.Apis.Util.RequestParameterType.Query)]
        public virtual System.Nullable<AltEnum> Alt { get; set; }

        /// <summary>Data format for response.</summary>
        public enum AltEnum
        {
            /// <summary>Responses with Content-Type of application/json</summary>
            [Google.Apis.Util.StringValueAttribute("json")]
            Json,
            /// <summary>Media download with context-dependent Content-Type</summary>
            [Google.Apis.Util.StringValueAttribute("media")]
            Media,
            /// <summary>Responses with Content-Type of application/x-protobuf</summary>
            [Google.Apis.Util.StringValueAttribute("proto")]
            Proto,
        }

        /// <summary>JSONP</summary>
        [Google.Apis.Util.RequestParameterAttribute("callback", Google.Apis.Util.RequestParameterType.Query)]
        public virtual string Callback { get; set; }

        /// <summary>Selector specifying which fields to include in a partial response.</summary>
        [Google.Apis.Util.RequestParameterAttribute("fields", Google.Apis.Util.RequestParameterType.Query)]
        public virtual string Fields { get; set; }

        /// <summary>API key. Your API key identifies your project and provides you with API access, quota, and reports.
        /// Required unless you provide an OAuth 2.0 token.</summary>
        [Google.Apis.Util.RequestParameterAttribute("key", Google.Apis.Util.RequestParameterType.Query)]
        public virtual string Key { get; set; }

        /// <summary>OAuth 2.0 token for the current user.</summary>
        [Google.Apis.Util.RequestParameterAttribute("oauth_token", Google.Apis.Util.RequestParameterType.Query)]
        public virtual string OauthToken { get; set; }

        /// <summary>Returns response with indentations and line breaks.</summary>
        /// [default: true]
        [Google.Apis.Util.RequestParameterAttribute("prettyPrint", Google.Apis.Util.RequestParameterType.Query)]
        public virtual System.Nullable<bool> PrettyPrint { get; set; }

        /// <summary>Available to use for quota purposes for server-side applications. Can be any arbitrary string
        /// assigned to a user, but should not exceed 40 characters.</summary>
        [Google.Apis.Util.RequestParameterAttribute("quotaUser", Google.Apis.Util.RequestParameterType.Query)]
        public virtual string QuotaUser { get; set; }

        /// <summary>Legacy upload protocol for media (e.g. "media", "multipart").</summary>
        [Google.Apis.Util.RequestParameterAttribute("uploadType", Google.Apis.Util.RequestParameterType.Query)]
        public virtual string UploadType { get; set; }

        /// <summary>Upload protocol for media (e.g. "raw", "multipart").</summary>
        [Google.Apis.Util.RequestParameterAttribute("upload_protocol", Google.Apis.Util.RequestParameterType.Query)]
        public virtual string UploadProtocol { get; set; }

        /// <summary>Initializes Walletobjects parameter list.</summary>
        protected override void InitParameters()
        {
            base.InitParameters();

            RequestParameters.Add(
                "$.xgafv", new Google.Apis.Discovery.Parameter
                {
                    Name = "$.xgafv",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
            RequestParameters.Add(
                "access_token", new Google.Apis.Discovery.Parameter
                {
                    Name = "access_token",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
            RequestParameters.Add(
                "alt", new Google.Apis.Discovery.Parameter
                {
                    Name = "alt",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = "json",
                    Pattern = null,
                });
            RequestParameters.Add(
                "callback", new Google.Apis.Discovery.Parameter
                {
                    Name = "callback",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
            RequestParameters.Add(
                "fields", new Google.Apis.Discovery.Parameter
                {
                    Name = "fields",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
            RequestParameters.Add(
                "key", new Google.Apis.Discovery.Parameter
                {
                    Name = "key",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
            RequestParameters.Add(
                "oauth_token", new Google.Apis.Discovery.Parameter
                {
                    Name = "oauth_token",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
            RequestParameters.Add(
                "prettyPrint", new Google.Apis.Discovery.Parameter
                {
                    Name = "prettyPrint",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = "true",
                    Pattern = null,
                });
            RequestParameters.Add(
                "quotaUser", new Google.Apis.Discovery.Parameter
                {
                    Name = "quotaUser",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
            RequestParameters.Add(
                "uploadType", new Google.Apis.Discovery.Parameter
                {
                    Name = "uploadType",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
            RequestParameters.Add(
                "upload_protocol", new Google.Apis.Discovery.Parameter
                {
                    Name = "upload_protocol",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
        }
    }

    /// <summary>The "eventticketclass" collection of methods.</summary>
    public class EventticketclassResource
    {
        private const string Resource = "eventticketclass";

        /// <summary>The service which this resource belongs to.</summary>
        private readonly Google.Apis.Services.IClientService service;

        /// <summary>Constructs a new resource.</summary>
        public EventticketclassResource(Google.Apis.Services.IClientService service)
        {
            this.service = service;

        }


        /// <summary>Adds a message to the event ticket class referenced by the given class ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual AddmessageRequest Addmessage(Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
        {
            return new AddmessageRequest(service, body, resourceId);
        }

        /// <summary>Adds a message to the event ticket class referenced by the given class ID.</summary>
        public class AddmessageRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.EventTicketClassAddMessageResponse>
        {
            /// <summary>Constructs a new Addmessage request.</summary>
            public AddmessageRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.AddMessageRequest Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "addmessage"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/eventTicketClass/{resourceId}/addMessage"; }
            }

            /// <summary>Initializes Addmessage parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Returns the event ticket class with the given class ID.</summary>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual GetRequest Get(string resourceId)
        {
            return new GetRequest(service, resourceId);
        }

        /// <summary>Returns the event ticket class with the given class ID.</summary>
        public class GetRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.EventTicketClass>
        {
            /// <summary>Constructs a new Get request.</summary>
            public GetRequest(Google.Apis.Services.IClientService service, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "get"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/eventTicketClass/{resourceId}"; }
            }

            /// <summary>Initializes Get parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Inserts an event ticket class with the given ID and properties.</summary>
        /// <param name="body">The body of the request.</param>
        public virtual InsertRequest Insert(Google.Apis.Walletobjects.v1.Data.EventTicketClass body)
        {
            return new InsertRequest(service, body);
        }

        /// <summary>Inserts an event ticket class with the given ID and properties.</summary>
        public class InsertRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.EventTicketClass>
        {
            /// <summary>Constructs a new Insert request.</summary>
            public InsertRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.EventTicketClass body)
                : base(service)
            {
                Body = body;
                InitParameters();
            }



            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.EventTicketClass Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "insert"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/eventTicketClass"; }
            }

            /// <summary>Initializes Insert parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

            }

        }

        /// <summary>Returns a list of all event ticket classes for a given issuer ID.</summary>
        public virtual ListRequest List()
        {
            return new ListRequest(service);
        }

        /// <summary>Returns a list of all event ticket classes for a given issuer ID.</summary>
        public class ListRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.EventTicketClassListResponse>
        {
            /// <summary>Constructs a new List request.</summary>
            public ListRequest(Google.Apis.Services.IClientService service)
                : base(service)
            {
                InitParameters();
            }


            /// <summary>The ID of the issuer authorized to list classes.</summary>
            [Google.Apis.Util.RequestParameterAttribute("issuerId", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<long> IssuerId { get; set; }

            /// <summary>Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
            /// classes are available in a list. For example, if you have a list of 200 classes and you call list with
            /// `maxResults` set to 20, list will return the first 20 classes and a token. Call list again with
            /// `maxResults` set to 20 and the token to get the next 20 classes.</summary>
            [Google.Apis.Util.RequestParameterAttribute("token", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string Token { get; set; }

            /// <summary>Identifies the max number of results returned by a list. All results are returned if
            /// `maxResults` isn't defined.</summary>
            [Google.Apis.Util.RequestParameterAttribute("maxResults", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<int> MaxResults { get; set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "list"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/eventTicketClass"; }
            }

            /// <summary>Initializes List parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "issuerId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "issuerId",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "token", new Google.Apis.Discovery.Parameter
                    {
                        Name = "token",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "maxResults", new Google.Apis.Discovery.Parameter
                    {
                        Name = "maxResults",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the event ticket class referenced by the given class ID. This method supports patch
        /// semantics.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual PatchRequest Patch(Google.Apis.Walletobjects.v1.Data.EventTicketClass body, string resourceId)
        {
            return new PatchRequest(service, body, resourceId);
        }

        /// <summary>Updates the event ticket class referenced by the given class ID. This method supports patch
        /// semantics.</summary>
        public class PatchRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.EventTicketClass>
        {
            /// <summary>Constructs a new Patch request.</summary>
            public PatchRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.EventTicketClass body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.EventTicketClass Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "patch"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PATCH"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/eventTicketClass/{resourceId}"; }
            }

            /// <summary>Initializes Patch parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the event ticket class referenced by the given class ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual UpdateRequest Update(Google.Apis.Walletobjects.v1.Data.EventTicketClass body, string resourceId)
        {
            return new UpdateRequest(service, body, resourceId);
        }

        /// <summary>Updates the event ticket class referenced by the given class ID.</summary>
        public class UpdateRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.EventTicketClass>
        {
            /// <summary>Constructs a new Update request.</summary>
            public UpdateRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.EventTicketClass body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.EventTicketClass Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "update"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PUT"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/eventTicketClass/{resourceId}"; }
            }

            /// <summary>Initializes Update parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }
    }

    /// <summary>The "eventticketobject" collection of methods.</summary>
    public class EventticketobjectResource
    {
        private const string Resource = "eventticketobject";

        /// <summary>The service which this resource belongs to.</summary>
        private readonly Google.Apis.Services.IClientService service;

        /// <summary>Constructs a new resource.</summary>
        public EventticketobjectResource(Google.Apis.Services.IClientService service)
        {
            this.service = service;

        }


        /// <summary>Adds a message to the event ticket object referenced by the given object ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual AddmessageRequest Addmessage(Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
        {
            return new AddmessageRequest(service, body, resourceId);
        }

        /// <summary>Adds a message to the event ticket object referenced by the given object ID.</summary>
        public class AddmessageRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.EventTicketObjectAddMessageResponse>
        {
            /// <summary>Constructs a new Addmessage request.</summary>
            public AddmessageRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.AddMessageRequest Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "addmessage"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/eventTicketObject/{resourceId}/addMessage"; }
            }

            /// <summary>Initializes Addmessage parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Returns the event ticket object with the given object ID.</summary>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual GetRequest Get(string resourceId)
        {
            return new GetRequest(service, resourceId);
        }

        /// <summary>Returns the event ticket object with the given object ID.</summary>
        public class GetRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.EventTicketObject>
        {
            /// <summary>Constructs a new Get request.</summary>
            public GetRequest(Google.Apis.Services.IClientService service, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "get"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/eventTicketObject/{resourceId}"; }
            }

            /// <summary>Initializes Get parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Inserts an event ticket object with the given ID and properties.</summary>
        /// <param name="body">The body of the request.</param>
        public virtual InsertRequest Insert(Google.Apis.Walletobjects.v1.Data.EventTicketObject body)
        {
            return new InsertRequest(service, body);
        }

        /// <summary>Inserts an event ticket object with the given ID and properties.</summary>
        public class InsertRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.EventTicketObject>
        {
            /// <summary>Constructs a new Insert request.</summary>
            public InsertRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.EventTicketObject body)
                : base(service)
            {
                Body = body;
                InitParameters();
            }



            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.EventTicketObject Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "insert"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/eventTicketObject"; }
            }

            /// <summary>Initializes Insert parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

            }

        }

        /// <summary>Returns a list of all event ticket objects for a given issuer ID.</summary>
        public virtual ListRequest List()
        {
            return new ListRequest(service);
        }

        /// <summary>Returns a list of all event ticket objects for a given issuer ID.</summary>
        public class ListRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.EventTicketObjectListResponse>
        {
            /// <summary>Constructs a new List request.</summary>
            public ListRequest(Google.Apis.Services.IClientService service)
                : base(service)
            {
                InitParameters();
            }


            /// <summary>The ID of the class whose objects will be listed.</summary>
            [Google.Apis.Util.RequestParameterAttribute("classId", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string ClassId { get; set; }

            /// <summary>Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
            /// objects are available in a list. For example, if you have a list of 200 objects and you call list with
            /// `maxResults` set to 20, list will return the first 20 objects and a token. Call list again with
            /// `maxResults` set to 20 and the token to get the next 20 objects.</summary>
            [Google.Apis.Util.RequestParameterAttribute("token", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string Token { get; set; }

            /// <summary>Identifies the max number of results returned by a list. All results are returned if
            /// `maxResults` isn't defined.</summary>
            [Google.Apis.Util.RequestParameterAttribute("maxResults", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<int> MaxResults { get; set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "list"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/eventTicketObject"; }
            }

            /// <summary>Initializes List parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "classId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "classId",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "token", new Google.Apis.Discovery.Parameter
                    {
                        Name = "token",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "maxResults", new Google.Apis.Discovery.Parameter
                    {
                        Name = "maxResults",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Modifies linked offer objects for the event ticket object with the given ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual ModifylinkedofferobjectsRequest Modifylinkedofferobjects(Google.Apis.Walletobjects.v1.Data.ModifyLinkedOfferObjectsRequest body, string resourceId)
        {
            return new ModifylinkedofferobjectsRequest(service, body, resourceId);
        }

        /// <summary>Modifies linked offer objects for the event ticket object with the given ID.</summary>
        public class ModifylinkedofferobjectsRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.EventTicketObject>
        {
            /// <summary>Constructs a new Modifylinkedofferobjects request.</summary>
            public ModifylinkedofferobjectsRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.ModifyLinkedOfferObjectsRequest body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.ModifyLinkedOfferObjectsRequest Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "modifylinkedofferobjects"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/eventTicketObject/{resourceId}/modifyLinkedOfferObjects"; }
            }

            /// <summary>Initializes Modifylinkedofferobjects parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the event ticket object referenced by the given object ID. This method supports patch
        /// semantics.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual PatchRequest Patch(Google.Apis.Walletobjects.v1.Data.EventTicketObject body, string resourceId)
        {
            return new PatchRequest(service, body, resourceId);
        }

        /// <summary>Updates the event ticket object referenced by the given object ID. This method supports patch
        /// semantics.</summary>
        public class PatchRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.EventTicketObject>
        {
            /// <summary>Constructs a new Patch request.</summary>
            public PatchRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.EventTicketObject body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.EventTicketObject Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "patch"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PATCH"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/eventTicketObject/{resourceId}"; }
            }

            /// <summary>Initializes Patch parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the event ticket object referenced by the given object ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual UpdateRequest Update(Google.Apis.Walletobjects.v1.Data.EventTicketObject body, string resourceId)
        {
            return new UpdateRequest(service, body, resourceId);
        }

        /// <summary>Updates the event ticket object referenced by the given object ID.</summary>
        public class UpdateRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.EventTicketObject>
        {
            /// <summary>Constructs a new Update request.</summary>
            public UpdateRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.EventTicketObject body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.EventTicketObject Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "update"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PUT"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/eventTicketObject/{resourceId}"; }
            }

            /// <summary>Initializes Update parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }
    }

    /// <summary>The "flightclass" collection of methods.</summary>
    public class FlightclassResource
    {
        private const string Resource = "flightclass";

        /// <summary>The service which this resource belongs to.</summary>
        private readonly Google.Apis.Services.IClientService service;

        /// <summary>Constructs a new resource.</summary>
        public FlightclassResource(Google.Apis.Services.IClientService service)
        {
            this.service = service;

        }


        /// <summary>Adds a message to the flight class referenced by the given class ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual AddmessageRequest Addmessage(Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
        {
            return new AddmessageRequest(service, body, resourceId);
        }

        /// <summary>Adds a message to the flight class referenced by the given class ID.</summary>
        public class AddmessageRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.FlightClassAddMessageResponse>
        {
            /// <summary>Constructs a new Addmessage request.</summary>
            public AddmessageRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.AddMessageRequest Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "addmessage"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/flightClass/{resourceId}/addMessage"; }
            }

            /// <summary>Initializes Addmessage parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Returns the flight class with the given class ID.</summary>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual GetRequest Get(string resourceId)
        {
            return new GetRequest(service, resourceId);
        }

        /// <summary>Returns the flight class with the given class ID.</summary>
        public class GetRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.FlightClass>
        {
            /// <summary>Constructs a new Get request.</summary>
            public GetRequest(Google.Apis.Services.IClientService service, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "get"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/flightClass/{resourceId}"; }
            }

            /// <summary>Initializes Get parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Inserts an flight class with the given ID and properties.</summary>
        /// <param name="body">The body of the request.</param>
        public virtual InsertRequest Insert(Google.Apis.Walletobjects.v1.Data.FlightClass body)
        {
            return new InsertRequest(service, body);
        }

        /// <summary>Inserts an flight class with the given ID and properties.</summary>
        public class InsertRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.FlightClass>
        {
            /// <summary>Constructs a new Insert request.</summary>
            public InsertRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.FlightClass body)
                : base(service)
            {
                Body = body;
                InitParameters();
            }



            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.FlightClass Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "insert"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/flightClass"; }
            }

            /// <summary>Initializes Insert parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

            }

        }

        /// <summary>Returns a list of all flight classes for a given issuer ID.</summary>
        public virtual ListRequest List()
        {
            return new ListRequest(service);
        }

        /// <summary>Returns a list of all flight classes for a given issuer ID.</summary>
        public class ListRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.FlightClassListResponse>
        {
            /// <summary>Constructs a new List request.</summary>
            public ListRequest(Google.Apis.Services.IClientService service)
                : base(service)
            {
                InitParameters();
            }


            /// <summary>The ID of the issuer authorized to list classes.</summary>
            [Google.Apis.Util.RequestParameterAttribute("issuerId", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<long> IssuerId { get; set; }

            /// <summary>Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
            /// classes are available in a list. For example, if you have a list of 200 classes and you call list with
            /// `maxResults` set to 20, list will return the first 20 classes and a token. Call list again with
            /// `maxResults` set to 20 and the token to get the next 20 classes.</summary>
            [Google.Apis.Util.RequestParameterAttribute("token", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string Token { get; set; }

            /// <summary>Identifies the max number of results returned by a list. All results are returned if
            /// `maxResults` isn't defined.</summary>
            [Google.Apis.Util.RequestParameterAttribute("maxResults", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<int> MaxResults { get; set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "list"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/flightClass"; }
            }

            /// <summary>Initializes List parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "issuerId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "issuerId",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "token", new Google.Apis.Discovery.Parameter
                    {
                        Name = "token",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "maxResults", new Google.Apis.Discovery.Parameter
                    {
                        Name = "maxResults",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the flight class referenced by the given class ID. This method supports patch
        /// semantics.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual PatchRequest Patch(Google.Apis.Walletobjects.v1.Data.FlightClass body, string resourceId)
        {
            return new PatchRequest(service, body, resourceId);
        }

        /// <summary>Updates the flight class referenced by the given class ID. This method supports patch
        /// semantics.</summary>
        public class PatchRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.FlightClass>
        {
            /// <summary>Constructs a new Patch request.</summary>
            public PatchRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.FlightClass body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.FlightClass Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "patch"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PATCH"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/flightClass/{resourceId}"; }
            }

            /// <summary>Initializes Patch parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the flight class referenced by the given class ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual UpdateRequest Update(Google.Apis.Walletobjects.v1.Data.FlightClass body, string resourceId)
        {
            return new UpdateRequest(service, body, resourceId);
        }

        /// <summary>Updates the flight class referenced by the given class ID.</summary>
        public class UpdateRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.FlightClass>
        {
            /// <summary>Constructs a new Update request.</summary>
            public UpdateRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.FlightClass body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.FlightClass Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "update"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PUT"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/flightClass/{resourceId}"; }
            }

            /// <summary>Initializes Update parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }
    }

    /// <summary>The "flightobject" collection of methods.</summary>
    public class FlightobjectResource
    {
        private const string Resource = "flightobject";

        /// <summary>The service which this resource belongs to.</summary>
        private readonly Google.Apis.Services.IClientService service;

        /// <summary>Constructs a new resource.</summary>
        public FlightobjectResource(Google.Apis.Services.IClientService service)
        {
            this.service = service;

        }


        /// <summary>Adds a message to the flight object referenced by the given object ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual AddmessageRequest Addmessage(Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
        {
            return new AddmessageRequest(service, body, resourceId);
        }

        /// <summary>Adds a message to the flight object referenced by the given object ID.</summary>
        public class AddmessageRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.FlightObjectAddMessageResponse>
        {
            /// <summary>Constructs a new Addmessage request.</summary>
            public AddmessageRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.AddMessageRequest Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "addmessage"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/flightObject/{resourceId}/addMessage"; }
            }

            /// <summary>Initializes Addmessage parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Returns the flight object with the given object ID.</summary>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual GetRequest Get(string resourceId)
        {
            return new GetRequest(service, resourceId);
        }

        /// <summary>Returns the flight object with the given object ID.</summary>
        public class GetRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.FlightObject>
        {
            /// <summary>Constructs a new Get request.</summary>
            public GetRequest(Google.Apis.Services.IClientService service, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "get"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/flightObject/{resourceId}"; }
            }

            /// <summary>Initializes Get parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Inserts an flight object with the given ID and properties.</summary>
        /// <param name="body">The body of the request.</param>
        public virtual InsertRequest Insert(Google.Apis.Walletobjects.v1.Data.FlightObject body)
        {
            return new InsertRequest(service, body);
        }

        /// <summary>Inserts an flight object with the given ID and properties.</summary>
        public class InsertRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.FlightObject>
        {
            /// <summary>Constructs a new Insert request.</summary>
            public InsertRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.FlightObject body)
                : base(service)
            {
                Body = body;
                InitParameters();
            }



            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.FlightObject Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "insert"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/flightObject"; }
            }

            /// <summary>Initializes Insert parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

            }

        }

        /// <summary>Returns a list of all flight objects for a given issuer ID.</summary>
        public virtual ListRequest List()
        {
            return new ListRequest(service);
        }

        /// <summary>Returns a list of all flight objects for a given issuer ID.</summary>
        public class ListRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.FlightObjectListResponse>
        {
            /// <summary>Constructs a new List request.</summary>
            public ListRequest(Google.Apis.Services.IClientService service)
                : base(service)
            {
                InitParameters();
            }


            /// <summary>The ID of the class whose objects will be listed.</summary>
            [Google.Apis.Util.RequestParameterAttribute("classId", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string ClassId { get; set; }

            /// <summary>Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
            /// objects are available in a list. For example, if you have a list of 200 objects and you call list with
            /// `maxResults` set to 20, list will return the first 20 objects and a token. Call list again with
            /// `maxResults` set to 20 and the token to get the next 20 objects.</summary>
            [Google.Apis.Util.RequestParameterAttribute("token", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string Token { get; set; }

            /// <summary>Identifies the max number of results returned by a list. All results are returned if
            /// `maxResults` isn't defined.</summary>
            [Google.Apis.Util.RequestParameterAttribute("maxResults", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<int> MaxResults { get; set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "list"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/flightObject"; }
            }

            /// <summary>Initializes List parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "classId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "classId",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "token", new Google.Apis.Discovery.Parameter
                    {
                        Name = "token",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "maxResults", new Google.Apis.Discovery.Parameter
                    {
                        Name = "maxResults",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the flight object referenced by the given object ID. This method supports patch
        /// semantics.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual PatchRequest Patch(Google.Apis.Walletobjects.v1.Data.FlightObject body, string resourceId)
        {
            return new PatchRequest(service, body, resourceId);
        }

        /// <summary>Updates the flight object referenced by the given object ID. This method supports patch
        /// semantics.</summary>
        public class PatchRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.FlightObject>
        {
            /// <summary>Constructs a new Patch request.</summary>
            public PatchRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.FlightObject body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.FlightObject Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "patch"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PATCH"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/flightObject/{resourceId}"; }
            }

            /// <summary>Initializes Patch parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the flight object referenced by the given object ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual UpdateRequest Update(Google.Apis.Walletobjects.v1.Data.FlightObject body, string resourceId)
        {
            return new UpdateRequest(service, body, resourceId);
        }

        /// <summary>Updates the flight object referenced by the given object ID.</summary>
        public class UpdateRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.FlightObject>
        {
            /// <summary>Constructs a new Update request.</summary>
            public UpdateRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.FlightObject body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.FlightObject Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "update"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PUT"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/flightObject/{resourceId}"; }
            }

            /// <summary>Initializes Update parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }
    }

    /// <summary>The "genericclass" collection of methods.</summary>
    public class GenericclassResource
    {
        private const string Resource = "genericclass";

        /// <summary>The service which this resource belongs to.</summary>
        private readonly Google.Apis.Services.IClientService service;

        /// <summary>Constructs a new resource.</summary>
        public GenericclassResource(Google.Apis.Services.IClientService service)
        {
            this.service = service;

        }


        /// <summary>Adds a message to the generic class referenced by the given class ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual AddmessageRequest Addmessage(Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
        {
            return new AddmessageRequest(service, body, resourceId);
        }

        /// <summary>Adds a message to the generic class referenced by the given class ID.</summary>
        public class AddmessageRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.GenericClassAddMessageResponse>
        {
            /// <summary>Constructs a new Addmessage request.</summary>
            public AddmessageRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.AddMessageRequest Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "addmessage"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/genericClass/{resourceId}/addMessage"; }
            }

            /// <summary>Initializes Addmessage parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Returns the generic class with the given class ID.</summary>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is issued by Google and
        /// `identifier` is chosen by you. The unique identifier can only include alphanumeric characters, `.`, `_`, or
        /// `-`.</param>
        public virtual GetRequest Get(string resourceId)
        {
            return new GetRequest(service, resourceId);
        }

        /// <summary>Returns the generic class with the given class ID.</summary>
        public class GetRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.GenericClass>
        {
            /// <summary>Constructs a new Get request.</summary>
            public GetRequest(Google.Apis.Services.IClientService service, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value needs to follow the format `issuerID.identifier` where `issuerID` is issued by Google and
            /// `identifier` is chosen by you. The unique identifier can only include alphanumeric characters, `.`, `_`,
            /// or `-`.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "get"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/genericClass/{resourceId}"; }
            }

            /// <summary>Initializes Get parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Inserts a generic class with the given ID and properties.</summary>
        /// <param name="body">The body of the request.</param>
        public virtual InsertRequest Insert(Google.Apis.Walletobjects.v1.Data.GenericClass body)
        {
            return new InsertRequest(service, body);
        }

        /// <summary>Inserts a generic class with the given ID and properties.</summary>
        public class InsertRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.GenericClass>
        {
            /// <summary>Constructs a new Insert request.</summary>
            public InsertRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.GenericClass body)
                : base(service)
            {
                Body = body;
                InitParameters();
            }



            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.GenericClass Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "insert"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/genericClass"; }
            }

            /// <summary>Initializes Insert parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

            }

        }

        /// <summary>Returns a list of all generic classes for a given issuer ID.</summary>
        public virtual ListRequest List()
        {
            return new ListRequest(service);
        }

        /// <summary>Returns a list of all generic classes for a given issuer ID.</summary>
        public class ListRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.GenericClassListResponse>
        {
            /// <summary>Constructs a new List request.</summary>
            public ListRequest(Google.Apis.Services.IClientService service)
                : base(service)
            {
                InitParameters();
            }


            /// <summary>The ID of the issuer authorized to list classes.</summary>
            [Google.Apis.Util.RequestParameterAttribute("issuerId", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<long> IssuerId { get; set; }

            /// <summary>Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
            /// classes are available in a list. For example, if you have a list of 200 classes and you call list with
            /// `maxResults` set to 20, list will return the first 20 classes and a token. Call list again with
            /// `maxResults` set to 20 and the token to get the next 20 classes.</summary>
            [Google.Apis.Util.RequestParameterAttribute("token", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string Token { get; set; }

            /// <summary>Identifies the max number of results returned by a list. All results are returned if
            /// `maxResults` isn't defined.</summary>
            [Google.Apis.Util.RequestParameterAttribute("maxResults", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<int> MaxResults { get; set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "list"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/genericClass"; }
            }

            /// <summary>Initializes List parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "issuerId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "issuerId",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "token", new Google.Apis.Discovery.Parameter
                    {
                        Name = "token",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "maxResults", new Google.Apis.Discovery.Parameter
                    {
                        Name = "maxResults",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the generic class referenced by the given class ID. This method supports patch
        /// semantics.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is issued by Google and
        /// `identifier` is chosen by you. The unique identifier can only include alphanumeric characters, `.`, `_`, or
        /// `-`.</param>
        public virtual PatchRequest Patch(Google.Apis.Walletobjects.v1.Data.GenericClass body, string resourceId)
        {
            return new PatchRequest(service, body, resourceId);
        }

        /// <summary>Updates the generic class referenced by the given class ID. This method supports patch
        /// semantics.</summary>
        public class PatchRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.GenericClass>
        {
            /// <summary>Constructs a new Patch request.</summary>
            public PatchRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.GenericClass body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value needs to follow the format `issuerID.identifier` where `issuerID` is issued by Google and
            /// `identifier` is chosen by you. The unique identifier can only include alphanumeric characters, `.`, `_`,
            /// or `-`.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.GenericClass Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "patch"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PATCH"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/genericClass/{resourceId}"; }
            }

            /// <summary>Initializes Patch parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the Generic class referenced by the given class ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is issued by Google and
        /// `identifier` is chosen by you. The unique identifier can only include alphanumeric characters, `.`, `_`, or
        /// `-`.</param>
        public virtual UpdateRequest Update(Google.Apis.Walletobjects.v1.Data.GenericClass body, string resourceId)
        {
            return new UpdateRequest(service, body, resourceId);
        }

        /// <summary>Updates the Generic class referenced by the given class ID.</summary>
        public class UpdateRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.GenericClass>
        {
            /// <summary>Constructs a new Update request.</summary>
            public UpdateRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.GenericClass body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value needs to follow the format `issuerID.identifier` where `issuerID` is issued by Google and
            /// `identifier` is chosen by you. The unique identifier can only include alphanumeric characters, `.`, `_`,
            /// or `-`.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.GenericClass Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "update"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PUT"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/genericClass/{resourceId}"; }
            }

            /// <summary>Initializes Update parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }
    }

    /// <summary>The "genericobject" collection of methods.</summary>
    public class GenericobjectResource
    {
        private const string Resource = "genericobject";

        /// <summary>The service which this resource belongs to.</summary>
        private readonly Google.Apis.Services.IClientService service;

        /// <summary>Constructs a new resource.</summary>
        public GenericobjectResource(Google.Apis.Services.IClientService service)
        {
            this.service = service;

        }


        /// <summary>Adds a message to the generic object referenced by the given object ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual AddmessageRequest Addmessage(Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
        {
            return new AddmessageRequest(service, body, resourceId);
        }

        /// <summary>Adds a message to the generic object referenced by the given object ID.</summary>
        public class AddmessageRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.GenericObjectAddMessageResponse>
        {
            /// <summary>Constructs a new Addmessage request.</summary>
            public AddmessageRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all classes from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.AddMessageRequest Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "addmessage"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/genericObject/{resourceId}/addMessage"; }
            }

            /// <summary>Initializes Addmessage parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Returns the generic object with the given object ID.</summary>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is issued by Google and
        /// `identifier` is chosen by you. The unique identifier can only include alphanumeric characters, `.`, `_`, or
        /// `-`.</param>
        public virtual GetRequest Get(string resourceId)
        {
            return new GetRequest(service, resourceId);
        }

        /// <summary>Returns the generic object with the given object ID.</summary>
        public class GetRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.GenericObject>
        {
            /// <summary>Constructs a new Get request.</summary>
            public GetRequest(Google.Apis.Services.IClientService service, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value needs to follow the format `issuerID.identifier` where `issuerID` is issued by Google and
            /// `identifier` is chosen by you. The unique identifier can only include alphanumeric characters, `.`, `_`,
            /// or `-`.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "get"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/genericObject/{resourceId}"; }
            }

            /// <summary>Initializes Get parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Inserts a generic object with the given ID and properties.</summary>
        /// <param name="body">The body of the request.</param>
        public virtual InsertRequest Insert(Google.Apis.Walletobjects.v1.Data.GenericObject body)
        {
            return new InsertRequest(service, body);
        }

        /// <summary>Inserts a generic object with the given ID and properties.</summary>
        public class InsertRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.GenericObject>
        {
            /// <summary>Constructs a new Insert request.</summary>
            public InsertRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.GenericObject body)
                : base(service)
            {
                Body = body;
                InitParameters();
            }



            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.GenericObject Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "insert"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/genericObject"; }
            }

            /// <summary>Initializes Insert parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

            }

        }

        /// <summary>Returns a list of all generic objects for a given issuer ID.</summary>
        public virtual ListRequest List()
        {
            return new ListRequest(service);
        }

        /// <summary>Returns a list of all generic objects for a given issuer ID.</summary>
        public class ListRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.GenericObjectListResponse>
        {
            /// <summary>Constructs a new List request.</summary>
            public ListRequest(Google.Apis.Services.IClientService service)
                : base(service)
            {
                InitParameters();
            }


            /// <summary>The ID of the class whose objects will be listed.</summary>
            [Google.Apis.Util.RequestParameterAttribute("classId", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string ClassId { get; set; }

            /// <summary>Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
            /// objects are available in a list. For example, if you have a list of 200 objects and you call list with
            /// `maxResults` set to 20, list will return the first 20 objects and a token. Call list again with
            /// `maxResults` set to 20 and the token to get the next 20 objects.</summary>
            [Google.Apis.Util.RequestParameterAttribute("token", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string Token { get; set; }

            /// <summary>Identifies the max number of results returned by a list. All results are returned if
            /// `maxResults` isn't defined.</summary>
            [Google.Apis.Util.RequestParameterAttribute("maxResults", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<int> MaxResults { get; set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "list"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/genericObject"; }
            }

            /// <summary>Initializes List parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "classId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "classId",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "token", new Google.Apis.Discovery.Parameter
                    {
                        Name = "token",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "maxResults", new Google.Apis.Discovery.Parameter
                    {
                        Name = "maxResults",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the generic object referenced by the given object ID. This method supports patch
        /// semantics.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is issued by Google and
        /// `identifier` is chosen by you. The unique identifier can only include alphanumeric characters, `.`, `_`, or
        /// `-`.</param>
        public virtual PatchRequest Patch(Google.Apis.Walletobjects.v1.Data.GenericObject body, string resourceId)
        {
            return new PatchRequest(service, body, resourceId);
        }

        /// <summary>Updates the generic object referenced by the given object ID. This method supports patch
        /// semantics.</summary>
        public class PatchRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.GenericObject>
        {
            /// <summary>Constructs a new Patch request.</summary>
            public PatchRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.GenericObject body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value needs to follow the format `issuerID.identifier` where `issuerID` is issued by Google and
            /// `identifier` is chosen by you. The unique identifier can only include alphanumeric characters, `.`, `_`,
            /// or `-`.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.GenericObject Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "patch"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PATCH"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/genericObject/{resourceId}"; }
            }

            /// <summary>Initializes Patch parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the generic object referenced by the given object ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value needs to follow the format `issuerID.identifier` where `issuerID` is issued by Google and
        /// `identifier` is chosen by you. The unique identifier can only include alphanumeric characters, `.`, `_`, or
        /// `-`.</param>
        public virtual UpdateRequest Update(Google.Apis.Walletobjects.v1.Data.GenericObject body, string resourceId)
        {
            return new UpdateRequest(service, body, resourceId);
        }

        /// <summary>Updates the generic object referenced by the given object ID.</summary>
        public class UpdateRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.GenericObject>
        {
            /// <summary>Constructs a new Update request.</summary>
            public UpdateRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.GenericObject body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value needs to follow the format `issuerID.identifier` where `issuerID` is issued by Google and
            /// `identifier` is chosen by you. The unique identifier can only include alphanumeric characters, `.`, `_`,
            /// or `-`.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.GenericObject Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "update"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PUT"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/genericObject/{resourceId}"; }
            }

            /// <summary>Initializes Update parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }
    }

    /// <summary>The "giftcardclass" collection of methods.</summary>
    public class GiftcardclassResource
    {
        private const string Resource = "giftcardclass";

        /// <summary>The service which this resource belongs to.</summary>
        private readonly Google.Apis.Services.IClientService service;

        /// <summary>Constructs a new resource.</summary>
        public GiftcardclassResource(Google.Apis.Services.IClientService service)
        {
            this.service = service;

        }


        /// <summary>Adds a message to the gift card class referenced by the given class ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual AddmessageRequest Addmessage(Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
        {
            return new AddmessageRequest(service, body, resourceId);
        }

        /// <summary>Adds a message to the gift card class referenced by the given class ID.</summary>
        public class AddmessageRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.GiftCardClassAddMessageResponse>
        {
            /// <summary>Constructs a new Addmessage request.</summary>
            public AddmessageRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.AddMessageRequest Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "addmessage"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/giftCardClass/{resourceId}/addMessage"; }
            }

            /// <summary>Initializes Addmessage parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Returns the gift card class with the given class ID.</summary>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual GetRequest Get(string resourceId)
        {
            return new GetRequest(service, resourceId);
        }

        /// <summary>Returns the gift card class with the given class ID.</summary>
        public class GetRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.GiftCardClass>
        {
            /// <summary>Constructs a new Get request.</summary>
            public GetRequest(Google.Apis.Services.IClientService service, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "get"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/giftCardClass/{resourceId}"; }
            }

            /// <summary>Initializes Get parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Inserts an gift card class with the given ID and properties.</summary>
        /// <param name="body">The body of the request.</param>
        public virtual InsertRequest Insert(Google.Apis.Walletobjects.v1.Data.GiftCardClass body)
        {
            return new InsertRequest(service, body);
        }

        /// <summary>Inserts an gift card class with the given ID and properties.</summary>
        public class InsertRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.GiftCardClass>
        {
            /// <summary>Constructs a new Insert request.</summary>
            public InsertRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.GiftCardClass body)
                : base(service)
            {
                Body = body;
                InitParameters();
            }



            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.GiftCardClass Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "insert"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/giftCardClass"; }
            }

            /// <summary>Initializes Insert parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

            }

        }

        /// <summary>Returns a list of all gift card classes for a given issuer ID.</summary>
        public virtual ListRequest List()
        {
            return new ListRequest(service);
        }

        /// <summary>Returns a list of all gift card classes for a given issuer ID.</summary>
        public class ListRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.GiftCardClassListResponse>
        {
            /// <summary>Constructs a new List request.</summary>
            public ListRequest(Google.Apis.Services.IClientService service)
                : base(service)
            {
                InitParameters();
            }


            /// <summary>The ID of the issuer authorized to list classes.</summary>
            [Google.Apis.Util.RequestParameterAttribute("issuerId", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<long> IssuerId { get; set; }

            /// <summary>Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
            /// classes are available in a list. For example, if you have a list of 200 classes and you call list with
            /// `maxResults` set to 20, list will return the first 20 classes and a token. Call list again with
            /// `maxResults` set to 20 and the token to get the next 20 classes.</summary>
            [Google.Apis.Util.RequestParameterAttribute("token", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string Token { get; set; }

            /// <summary>Identifies the max number of results returned by a list. All results are returned if
            /// `maxResults` isn't defined.</summary>
            [Google.Apis.Util.RequestParameterAttribute("maxResults", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<int> MaxResults { get; set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "list"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/giftCardClass"; }
            }

            /// <summary>Initializes List parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "issuerId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "issuerId",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "token", new Google.Apis.Discovery.Parameter
                    {
                        Name = "token",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "maxResults", new Google.Apis.Discovery.Parameter
                    {
                        Name = "maxResults",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the gift card class referenced by the given class ID. This method supports patch
        /// semantics.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual PatchRequest Patch(Google.Apis.Walletobjects.v1.Data.GiftCardClass body, string resourceId)
        {
            return new PatchRequest(service, body, resourceId);
        }

        /// <summary>Updates the gift card class referenced by the given class ID. This method supports patch
        /// semantics.</summary>
        public class PatchRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.GiftCardClass>
        {
            /// <summary>Constructs a new Patch request.</summary>
            public PatchRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.GiftCardClass body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.GiftCardClass Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "patch"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PATCH"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/giftCardClass/{resourceId}"; }
            }

            /// <summary>Initializes Patch parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the gift card class referenced by the given class ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual UpdateRequest Update(Google.Apis.Walletobjects.v1.Data.GiftCardClass body, string resourceId)
        {
            return new UpdateRequest(service, body, resourceId);
        }

        /// <summary>Updates the gift card class referenced by the given class ID.</summary>
        public class UpdateRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.GiftCardClass>
        {
            /// <summary>Constructs a new Update request.</summary>
            public UpdateRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.GiftCardClass body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.GiftCardClass Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "update"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PUT"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/giftCardClass/{resourceId}"; }
            }

            /// <summary>Initializes Update parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }
    }

    /// <summary>The "giftcardobject" collection of methods.</summary>
    public class GiftcardobjectResource
    {
        private const string Resource = "giftcardobject";

        /// <summary>The service which this resource belongs to.</summary>
        private readonly Google.Apis.Services.IClientService service;

        /// <summary>Constructs a new resource.</summary>
        public GiftcardobjectResource(Google.Apis.Services.IClientService service)
        {
            this.service = service;

        }


        /// <summary>Adds a message to the gift card object referenced by the given object ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual AddmessageRequest Addmessage(Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
        {
            return new AddmessageRequest(service, body, resourceId);
        }

        /// <summary>Adds a message to the gift card object referenced by the given object ID.</summary>
        public class AddmessageRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.GiftCardObjectAddMessageResponse>
        {
            /// <summary>Constructs a new Addmessage request.</summary>
            public AddmessageRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.AddMessageRequest Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "addmessage"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/giftCardObject/{resourceId}/addMessage"; }
            }

            /// <summary>Initializes Addmessage parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Returns the gift card object with the given object ID.</summary>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual GetRequest Get(string resourceId)
        {
            return new GetRequest(service, resourceId);
        }

        /// <summary>Returns the gift card object with the given object ID.</summary>
        public class GetRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.GiftCardObject>
        {
            /// <summary>Constructs a new Get request.</summary>
            public GetRequest(Google.Apis.Services.IClientService service, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "get"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/giftCardObject/{resourceId}"; }
            }

            /// <summary>Initializes Get parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Inserts an gift card object with the given ID and properties.</summary>
        /// <param name="body">The body of the request.</param>
        public virtual InsertRequest Insert(Google.Apis.Walletobjects.v1.Data.GiftCardObject body)
        {
            return new InsertRequest(service, body);
        }

        /// <summary>Inserts an gift card object with the given ID and properties.</summary>
        public class InsertRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.GiftCardObject>
        {
            /// <summary>Constructs a new Insert request.</summary>
            public InsertRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.GiftCardObject body)
                : base(service)
            {
                Body = body;
                InitParameters();
            }



            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.GiftCardObject Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "insert"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/giftCardObject"; }
            }

            /// <summary>Initializes Insert parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

            }

        }

        /// <summary>Returns a list of all gift card objects for a given issuer ID.</summary>
        public virtual ListRequest List()
        {
            return new ListRequest(service);
        }

        /// <summary>Returns a list of all gift card objects for a given issuer ID.</summary>
        public class ListRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.GiftCardObjectListResponse>
        {
            /// <summary>Constructs a new List request.</summary>
            public ListRequest(Google.Apis.Services.IClientService service)
                : base(service)
            {
                InitParameters();
            }


            /// <summary>The ID of the class whose objects will be listed.</summary>
            [Google.Apis.Util.RequestParameterAttribute("classId", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string ClassId { get; set; }

            /// <summary>Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
            /// objects are available in a list. For example, if you have a list of 200 objects and you call list with
            /// `maxResults` set to 20, list will return the first 20 objects and a token. Call list again with
            /// `maxResults` set to 20 and the token to get the next 20 objects.</summary>
            [Google.Apis.Util.RequestParameterAttribute("token", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string Token { get; set; }

            /// <summary>Identifies the max number of results returned by a list. All results are returned if
            /// `maxResults` isn't defined.</summary>
            [Google.Apis.Util.RequestParameterAttribute("maxResults", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<int> MaxResults { get; set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "list"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/giftCardObject"; }
            }

            /// <summary>Initializes List parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "classId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "classId",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "token", new Google.Apis.Discovery.Parameter
                    {
                        Name = "token",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "maxResults", new Google.Apis.Discovery.Parameter
                    {
                        Name = "maxResults",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the gift card object referenced by the given object ID. This method supports patch
        /// semantics.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual PatchRequest Patch(Google.Apis.Walletobjects.v1.Data.GiftCardObject body, string resourceId)
        {
            return new PatchRequest(service, body, resourceId);
        }

        /// <summary>Updates the gift card object referenced by the given object ID. This method supports patch
        /// semantics.</summary>
        public class PatchRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.GiftCardObject>
        {
            /// <summary>Constructs a new Patch request.</summary>
            public PatchRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.GiftCardObject body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.GiftCardObject Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "patch"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PATCH"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/giftCardObject/{resourceId}"; }
            }

            /// <summary>Initializes Patch parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the gift card object referenced by the given object ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual UpdateRequest Update(Google.Apis.Walletobjects.v1.Data.GiftCardObject body, string resourceId)
        {
            return new UpdateRequest(service, body, resourceId);
        }

        /// <summary>Updates the gift card object referenced by the given object ID.</summary>
        public class UpdateRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.GiftCardObject>
        {
            /// <summary>Constructs a new Update request.</summary>
            public UpdateRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.GiftCardObject body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.GiftCardObject Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "update"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PUT"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/giftCardObject/{resourceId}"; }
            }

            /// <summary>Initializes Update parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }
    }

    /// <summary>The "issuer" collection of methods.</summary>
    public class IssuerResource
    {
        private const string Resource = "issuer";

        /// <summary>The service which this resource belongs to.</summary>
        private readonly Google.Apis.Services.IClientService service;

        /// <summary>Constructs a new resource.</summary>
        public IssuerResource(Google.Apis.Services.IClientService service)
        {
            this.service = service;

        }


        /// <summary>Returns the issuer with the given issuer ID.</summary>
        /// <param name="resourceId">The unique identifier for an issuer.</param>
        public virtual GetRequest Get(long resourceId)
        {
            return new GetRequest(service, resourceId);
        }

        /// <summary>Returns the issuer with the given issuer ID.</summary>
        public class GetRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.Issuer>
        {
            /// <summary>Constructs a new Get request.</summary>
            public GetRequest(Google.Apis.Services.IClientService service, long resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                InitParameters();
            }


            /// <summary>The unique identifier for an issuer.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual long ResourceId { get; private set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "get"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/issuer/{resourceId}"; }
            }

            /// <summary>Initializes Get parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Inserts an issuer with the given ID and properties.</summary>
        /// <param name="body">The body of the request.</param>
        public virtual InsertRequest Insert(Google.Apis.Walletobjects.v1.Data.Issuer body)
        {
            return new InsertRequest(service, body);
        }

        /// <summary>Inserts an issuer with the given ID and properties.</summary>
        public class InsertRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.Issuer>
        {
            /// <summary>Constructs a new Insert request.</summary>
            public InsertRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.Issuer body)
                : base(service)
            {
                Body = body;
                InitParameters();
            }


            /// <summary>The source from which this request was made.</summary>
            [Google.Apis.Util.RequestParameterAttribute("callerInfo.callSource", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<CallerInfoCallSourceEnum> CallerInfoCallSource { get; set; }

            /// <summary>The source from which this request was made.</summary>
            public enum CallerInfoCallSourceEnum
            {
                /// <summary>The source of this request is unspecified.</summary>
                [Google.Apis.Util.StringValueAttribute("CALL_SOURCE_UNSPECIFIED")]
                CALLSOURCEUNSPECIFIED,
                /// <summary>Indicates this request was made from the merchant console.</summary>
                [Google.Apis.Util.StringValueAttribute("MERCHANT_CONSOLE")]
                MERCHANTCONSOLE,
            }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.Issuer Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "insert"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/issuer"; }
            }

            /// <summary>Initializes Insert parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "callerInfo.callSource", new Google.Apis.Discovery.Parameter
                    {
                        Name = "callerInfo.callSource",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Returns a list of all issuers shared to the caller.</summary>
        public virtual ListRequest List()
        {
            return new ListRequest(service);
        }

        /// <summary>Returns a list of all issuers shared to the caller.</summary>
        public class ListRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.IssuerListResponse>
        {
            /// <summary>Constructs a new List request.</summary>
            public ListRequest(Google.Apis.Services.IClientService service)
                : base(service)
            {
                InitParameters();
            }



            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "list"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/issuer"; }
            }

            /// <summary>Initializes List parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

            }

        }

        /// <summary>Updates the issuer referenced by the given issuer ID. This method supports patch
        /// semantics.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an issuer.</param>
        public virtual PatchRequest Patch(Google.Apis.Walletobjects.v1.Data.Issuer body, long resourceId)
        {
            return new PatchRequest(service, body, resourceId);
        }

        /// <summary>Updates the issuer referenced by the given issuer ID. This method supports patch
        /// semantics.</summary>
        public class PatchRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.Issuer>
        {
            /// <summary>Constructs a new Patch request.</summary>
            public PatchRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.Issuer body, long resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an issuer.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual long ResourceId { get; private set; }

            /// <summary>The source from which this request was made.</summary>
            [Google.Apis.Util.RequestParameterAttribute("callerInfo.callSource", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<CallerInfoCallSourceEnum> CallerInfoCallSource { get; set; }

            /// <summary>The source from which this request was made.</summary>
            public enum CallerInfoCallSourceEnum
            {
                /// <summary>The source of this request is unspecified.</summary>
                [Google.Apis.Util.StringValueAttribute("CALL_SOURCE_UNSPECIFIED")]
                CALLSOURCEUNSPECIFIED,
                /// <summary>Indicates this request was made from the merchant console.</summary>
                [Google.Apis.Util.StringValueAttribute("MERCHANT_CONSOLE")]
                MERCHANTCONSOLE,
            }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.Issuer Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "patch"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PATCH"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/issuer/{resourceId}"; }
            }

            /// <summary>Initializes Patch parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "callerInfo.callSource", new Google.Apis.Discovery.Parameter
                    {
                        Name = "callerInfo.callSource",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the issuer referenced by the given issuer ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an issuer.</param>
        public virtual UpdateRequest Update(Google.Apis.Walletobjects.v1.Data.Issuer body, long resourceId)
        {
            return new UpdateRequest(service, body, resourceId);
        }

        /// <summary>Updates the issuer referenced by the given issuer ID.</summary>
        public class UpdateRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.Issuer>
        {
            /// <summary>Constructs a new Update request.</summary>
            public UpdateRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.Issuer body, long resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an issuer.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual long ResourceId { get; private set; }

            /// <summary>The source from which this request was made.</summary>
            [Google.Apis.Util.RequestParameterAttribute("callerInfo.callSource", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<CallerInfoCallSourceEnum> CallerInfoCallSource { get; set; }

            /// <summary>The source from which this request was made.</summary>
            public enum CallerInfoCallSourceEnum
            {
                /// <summary>The source of this request is unspecified.</summary>
                [Google.Apis.Util.StringValueAttribute("CALL_SOURCE_UNSPECIFIED")]
                CALLSOURCEUNSPECIFIED,
                /// <summary>Indicates this request was made from the merchant console.</summary>
                [Google.Apis.Util.StringValueAttribute("MERCHANT_CONSOLE")]
                MERCHANTCONSOLE,
            }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.Issuer Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "update"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PUT"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/issuer/{resourceId}"; }
            }

            /// <summary>Initializes Update parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "callerInfo.callSource", new Google.Apis.Discovery.Parameter
                    {
                        Name = "callerInfo.callSource",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }
    }

    /// <summary>The "jwt" collection of methods.</summary>
    public class JwtResource
    {
        private const string Resource = "jwt";

        /// <summary>The service which this resource belongs to.</summary>
        private readonly Google.Apis.Services.IClientService service;

        /// <summary>Constructs a new resource.</summary>
        public JwtResource(Google.Apis.Services.IClientService service)
        {
            this.service = service;

        }


        /// <summary>Inserts the resources in the JWT.</summary>
        /// <param name="body">The body of the request.</param>
        public virtual InsertRequest Insert(Google.Apis.Walletobjects.v1.Data.JwtResource body)
        {
            return new InsertRequest(service, body);
        }

        /// <summary>Inserts the resources in the JWT.</summary>
        public class InsertRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.JwtInsertResponse>
        {
            /// <summary>Constructs a new Insert request.</summary>
            public InsertRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.JwtResource body)
                : base(service)
            {
                Body = body;
                InitParameters();
            }



            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.JwtResource Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "insert"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/jwt"; }
            }

            /// <summary>Initializes Insert parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

            }

        }
    }

    /// <summary>The "loyaltyclass" collection of methods.</summary>
    public class LoyaltyclassResource
    {
        private const string Resource = "loyaltyclass";

        /// <summary>The service which this resource belongs to.</summary>
        private readonly Google.Apis.Services.IClientService service;

        /// <summary>Constructs a new resource.</summary>
        public LoyaltyclassResource(Google.Apis.Services.IClientService service)
        {
            this.service = service;

        }


        /// <summary>Adds a message to the loyalty class referenced by the given class ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual AddmessageRequest Addmessage(Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
        {
            return new AddmessageRequest(service, body, resourceId);
        }

        /// <summary>Adds a message to the loyalty class referenced by the given class ID.</summary>
        public class AddmessageRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.LoyaltyClassAddMessageResponse>
        {
            /// <summary>Constructs a new Addmessage request.</summary>
            public AddmessageRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.AddMessageRequest Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "addmessage"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/loyaltyClass/{resourceId}/addMessage"; }
            }

            /// <summary>Initializes Addmessage parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Returns the loyalty class with the given class ID.</summary>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual GetRequest Get(string resourceId)
        {
            return new GetRequest(service, resourceId);
        }

        /// <summary>Returns the loyalty class with the given class ID.</summary>
        public class GetRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.LoyaltyClass>
        {
            /// <summary>Constructs a new Get request.</summary>
            public GetRequest(Google.Apis.Services.IClientService service, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "get"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/loyaltyClass/{resourceId}"; }
            }

            /// <summary>Initializes Get parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Inserts an loyalty class with the given ID and properties.</summary>
        /// <param name="body">The body of the request.</param>
        public virtual InsertRequest Insert(Google.Apis.Walletobjects.v1.Data.LoyaltyClass body)
        {
            return new InsertRequest(service, body);
        }

        /// <summary>Inserts an loyalty class with the given ID and properties.</summary>
        public class InsertRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.LoyaltyClass>
        {
            /// <summary>Constructs a new Insert request.</summary>
            public InsertRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.LoyaltyClass body)
                : base(service)
            {
                Body = body;
                InitParameters();
            }



            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.LoyaltyClass Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "insert"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/loyaltyClass"; }
            }

            /// <summary>Initializes Insert parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

            }

        }

        /// <summary>Returns a list of all loyalty classes for a given issuer ID.</summary>
        public virtual ListRequest List()
        {
            return new ListRequest(service);
        }

        /// <summary>Returns a list of all loyalty classes for a given issuer ID.</summary>
        public class ListRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.LoyaltyClassListResponse>
        {
            /// <summary>Constructs a new List request.</summary>
            public ListRequest(Google.Apis.Services.IClientService service)
                : base(service)
            {
                InitParameters();
            }


            /// <summary>The ID of the issuer authorized to list classes.</summary>
            [Google.Apis.Util.RequestParameterAttribute("issuerId", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<long> IssuerId { get; set; }

            /// <summary>Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
            /// classes are available in a list. For example, if you have a list of 200 classes and you call list with
            /// `maxResults` set to 20, list will return the first 20 classes and a token. Call list again with
            /// `maxResults` set to 20 and the token to get the next 20 classes.</summary>
            [Google.Apis.Util.RequestParameterAttribute("token", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string Token { get; set; }

            /// <summary>Identifies the max number of results returned by a list. All results are returned if
            /// `maxResults` isn't defined.</summary>
            [Google.Apis.Util.RequestParameterAttribute("maxResults", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<int> MaxResults { get; set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "list"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/loyaltyClass"; }
            }

            /// <summary>Initializes List parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "issuerId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "issuerId",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "token", new Google.Apis.Discovery.Parameter
                    {
                        Name = "token",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "maxResults", new Google.Apis.Discovery.Parameter
                    {
                        Name = "maxResults",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the loyalty class referenced by the given class ID. This method supports patch
        /// semantics.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual PatchRequest Patch(Google.Apis.Walletobjects.v1.Data.LoyaltyClass body, string resourceId)
        {
            return new PatchRequest(service, body, resourceId);
        }

        /// <summary>Updates the loyalty class referenced by the given class ID. This method supports patch
        /// semantics.</summary>
        public class PatchRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.LoyaltyClass>
        {
            /// <summary>Constructs a new Patch request.</summary>
            public PatchRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.LoyaltyClass body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.LoyaltyClass Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "patch"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PATCH"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/loyaltyClass/{resourceId}"; }
            }

            /// <summary>Initializes Patch parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the loyalty class referenced by the given class ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual UpdateRequest Update(Google.Apis.Walletobjects.v1.Data.LoyaltyClass body, string resourceId)
        {
            return new UpdateRequest(service, body, resourceId);
        }

        /// <summary>Updates the loyalty class referenced by the given class ID.</summary>
        public class UpdateRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.LoyaltyClass>
        {
            /// <summary>Constructs a new Update request.</summary>
            public UpdateRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.LoyaltyClass body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.LoyaltyClass Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "update"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PUT"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/loyaltyClass/{resourceId}"; }
            }

            /// <summary>Initializes Update parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }
    }

    /// <summary>The "loyaltyobject" collection of methods.</summary>
    public class LoyaltyobjectResource
    {
        private const string Resource = "loyaltyobject";

        /// <summary>The service which this resource belongs to.</summary>
        private readonly Google.Apis.Services.IClientService service;

        /// <summary>Constructs a new resource.</summary>
        public LoyaltyobjectResource(Google.Apis.Services.IClientService service)
        {
            this.service = service;

        }


        /// <summary>Adds a message to the loyalty object referenced by the given object ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual AddmessageRequest Addmessage(Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
        {
            return new AddmessageRequest(service, body, resourceId);
        }

        /// <summary>Adds a message to the loyalty object referenced by the given object ID.</summary>
        public class AddmessageRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.LoyaltyObjectAddMessageResponse>
        {
            /// <summary>Constructs a new Addmessage request.</summary>
            public AddmessageRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.AddMessageRequest Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "addmessage"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/loyaltyObject/{resourceId}/addMessage"; }
            }

            /// <summary>Initializes Addmessage parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Returns the loyalty object with the given object ID.</summary>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual GetRequest Get(string resourceId)
        {
            return new GetRequest(service, resourceId);
        }

        /// <summary>Returns the loyalty object with the given object ID.</summary>
        public class GetRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.LoyaltyObject>
        {
            /// <summary>Constructs a new Get request.</summary>
            public GetRequest(Google.Apis.Services.IClientService service, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "get"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/loyaltyObject/{resourceId}"; }
            }

            /// <summary>Initializes Get parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Inserts an loyalty object with the given ID and properties.</summary>
        /// <param name="body">The body of the request.</param>
        public virtual InsertRequest Insert(Google.Apis.Walletobjects.v1.Data.LoyaltyObject body)
        {
            return new InsertRequest(service, body);
        }

        /// <summary>Inserts an loyalty object with the given ID and properties.</summary>
        public class InsertRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.LoyaltyObject>
        {
            /// <summary>Constructs a new Insert request.</summary>
            public InsertRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.LoyaltyObject body)
                : base(service)
            {
                Body = body;
                InitParameters();
            }



            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.LoyaltyObject Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "insert"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/loyaltyObject"; }
            }

            /// <summary>Initializes Insert parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

            }

        }

        /// <summary>Returns a list of all loyalty objects for a given issuer ID.</summary>
        public virtual ListRequest List()
        {
            return new ListRequest(service);
        }

        /// <summary>Returns a list of all loyalty objects for a given issuer ID.</summary>
        public class ListRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.LoyaltyObjectListResponse>
        {
            /// <summary>Constructs a new List request.</summary>
            public ListRequest(Google.Apis.Services.IClientService service)
                : base(service)
            {
                InitParameters();
            }


            /// <summary>The ID of the class whose objects will be listed.</summary>
            [Google.Apis.Util.RequestParameterAttribute("classId", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string ClassId { get; set; }

            /// <summary>Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
            /// objects are available in a list. For example, if you have a list of 200 objects and you call list with
            /// `maxResults` set to 20, list will return the first 20 objects and a token. Call list again with
            /// `maxResults` set to 20 and the token to get the next 20 objects.</summary>
            [Google.Apis.Util.RequestParameterAttribute("token", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string Token { get; set; }

            /// <summary>Identifies the max number of results returned by a list. All results are returned if
            /// `maxResults` isn't defined.</summary>
            [Google.Apis.Util.RequestParameterAttribute("maxResults", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<int> MaxResults { get; set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "list"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/loyaltyObject"; }
            }

            /// <summary>Initializes List parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "classId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "classId",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "token", new Google.Apis.Discovery.Parameter
                    {
                        Name = "token",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "maxResults", new Google.Apis.Discovery.Parameter
                    {
                        Name = "maxResults",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Modifies linked offer objects for the loyalty object with the given ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual ModifylinkedofferobjectsRequest Modifylinkedofferobjects(Google.Apis.Walletobjects.v1.Data.ModifyLinkedOfferObjectsRequest body, string resourceId)
        {
            return new ModifylinkedofferobjectsRequest(service, body, resourceId);
        }

        /// <summary>Modifies linked offer objects for the loyalty object with the given ID.</summary>
        public class ModifylinkedofferobjectsRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.LoyaltyObject>
        {
            /// <summary>Constructs a new Modifylinkedofferobjects request.</summary>
            public ModifylinkedofferobjectsRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.ModifyLinkedOfferObjectsRequest body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.ModifyLinkedOfferObjectsRequest Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "modifylinkedofferobjects"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/loyaltyObject/{resourceId}/modifyLinkedOfferObjects"; }
            }

            /// <summary>Initializes Modifylinkedofferobjects parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the loyalty object referenced by the given object ID. This method supports patch
        /// semantics.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual PatchRequest Patch(Google.Apis.Walletobjects.v1.Data.LoyaltyObject body, string resourceId)
        {
            return new PatchRequest(service, body, resourceId);
        }

        /// <summary>Updates the loyalty object referenced by the given object ID. This method supports patch
        /// semantics.</summary>
        public class PatchRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.LoyaltyObject>
        {
            /// <summary>Constructs a new Patch request.</summary>
            public PatchRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.LoyaltyObject body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.LoyaltyObject Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "patch"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PATCH"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/loyaltyObject/{resourceId}"; }
            }

            /// <summary>Initializes Patch parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the loyalty object referenced by the given object ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual UpdateRequest Update(Google.Apis.Walletobjects.v1.Data.LoyaltyObject body, string resourceId)
        {
            return new UpdateRequest(service, body, resourceId);
        }

        /// <summary>Updates the loyalty object referenced by the given object ID.</summary>
        public class UpdateRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.LoyaltyObject>
        {
            /// <summary>Constructs a new Update request.</summary>
            public UpdateRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.LoyaltyObject body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.LoyaltyObject Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "update"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PUT"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/loyaltyObject/{resourceId}"; }
            }

            /// <summary>Initializes Update parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }
    }

    /// <summary>The "media" collection of methods.</summary>
    public class MediaResource
    {
        private const string Resource = "media";

        /// <summary>The service which this resource belongs to.</summary>
        private readonly Google.Apis.Services.IClientService service;

        /// <summary>Constructs a new resource.</summary>
        public MediaResource(Google.Apis.Services.IClientService service)
        {
            this.service = service;

        }


        /// <summary>Downloads rotating barcode values for the transit object referenced by the given object
        /// ID.</summary>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual DownloadRequest Download(string resourceId)
        {
            return new DownloadRequest(service, resourceId);
        }

        /// <summary>Downloads rotating barcode values for the transit object referenced by the given object
        /// ID.</summary>
        public class DownloadRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.Media>
        {
            /// <summary>Constructs a new Download request.</summary>
            public DownloadRequest(Google.Apis.Services.IClientService service, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                MediaDownloader = new Google.Apis.Download.MediaDownloader(service);
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "download"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/transitObject/{resourceId}/downloadRotatingBarcodeValues"; }
            }

            /// <summary>Initializes Download parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

            /// <summary>Gets the media downloader.</summary>
            public Google.Apis.Download.IMediaDownloader MediaDownloader { get; private set; }

            /// <summary>Synchronously download the media into the given stream.</summary>
            public virtual void Download(System.IO.Stream stream)
            {
                MediaDownloader.Download(this.GenerateRequestUri(), stream);
            }

            /// <summary>Asynchronously download the media into the given stream.</summary>
            public virtual System.Threading.Tasks.Task<Google.Apis.Download.IDownloadProgress> DownloadAsync(System.IO.Stream stream)
            {
                return MediaDownloader.DownloadAsync(this.GenerateRequestUri(), stream);
            }

            /// <summary>Asynchronously download the media into the given stream.</summary>
            public virtual System.Threading.Tasks.Task<Google.Apis.Download.IDownloadProgress> DownloadAsync(System.IO.Stream stream,
                System.Threading.CancellationToken cancellationToken)
            {
                return MediaDownloader.DownloadAsync(this.GenerateRequestUri(), stream, cancellationToken);
            }

        }

        /// <summary>Uploads rotating barcode values for the transit object referenced by the given object ID. Note the
        /// max upload size is specified in google3/production/config/cdd/apps-upload/customers/payments-consumer-
        /// passes/config.gcl and enforced by Scotty.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual UploadRequest Upload(Google.Apis.Walletobjects.v1.Data.TransitObjectUploadRotatingBarcodeValuesRequest body, string resourceId)
        {
            return new UploadRequest(service, body, resourceId);
        }

        /// <summary>Uploads rotating barcode values for the transit object referenced by the given object ID. Note the
        /// max upload size is specified in google3/production/config/cdd/apps-upload/customers/payments-consumer-
        /// passes/config.gcl and enforced by Scotty.</summary>
        public class UploadRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.TransitObjectUploadRotatingBarcodeValuesResponse>
        {
            /// <summary>Constructs a new Upload request.</summary>
            public UploadRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.TransitObjectUploadRotatingBarcodeValuesRequest body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.TransitObjectUploadRotatingBarcodeValuesRequest Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "upload"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/transitObject/{resourceId}/uploadRotatingBarcodeValues"; }
            }

            /// <summary>Initializes Upload parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Uploads rotating barcode values for the transit object referenced by the given object ID. Note the
        /// max upload size is specified in google3/production/config/cdd/apps-upload/customers/payments-consumer-
        /// passes/config.gcl and enforced by Scotty.</summary>/// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        /// <param name="stream">The stream to upload.</param>
        /// <param name="contentType">The content type of the stream to upload.</param>
        public virtual UploadMediaUpload Upload(Google.Apis.Walletobjects.v1.Data.TransitObjectUploadRotatingBarcodeValuesRequest body, string resourceId, System.IO.Stream stream, string contentType)
        {
            return new UploadMediaUpload(service, body, resourceId, stream, contentType);
        }

        /// <summary>Upload media upload which supports resumable upload.</summary>
        public class UploadMediaUpload : Google.Apis.Upload.ResumableUpload<Google.Apis.Walletobjects.v1.Data.TransitObjectUploadRotatingBarcodeValuesRequest, Google.Apis.Walletobjects.v1.Data.TransitObjectUploadRotatingBarcodeValuesResponse>
        {

            /// <summary>V1 error format.</summary>
            [Google.Apis.Util.RequestParameterAttribute("$.xgafv", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<XgafvEnum> Xgafv { get; set; }

            /// <summary>V1 error format.</summary>
            public enum XgafvEnum
            {
                /// <summary>v1 error format</summary>
                [Google.Apis.Util.StringValueAttribute("1")]
                Value1,
                /// <summary>v2 error format</summary>
                [Google.Apis.Util.StringValueAttribute("2")]
                Value2,
            }

            /// <summary>OAuth access token.</summary>
            [Google.Apis.Util.RequestParameterAttribute("access_token", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string AccessToken { get; set; }

            /// <summary>Data format for response.</summary>
            /// [default: json]
            [Google.Apis.Util.RequestParameterAttribute("alt", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<AltEnum> Alt { get; set; }

            /// <summary>Data format for response.</summary>
            public enum AltEnum
            {
                /// <summary>Responses with Content-Type of application/json</summary>
                [Google.Apis.Util.StringValueAttribute("json")]
                Json,
                /// <summary>Media download with context-dependent Content-Type</summary>
                [Google.Apis.Util.StringValueAttribute("media")]
                Media,
                /// <summary>Responses with Content-Type of application/x-protobuf</summary>
                [Google.Apis.Util.StringValueAttribute("proto")]
                Proto,
            }

            /// <summary>JSONP</summary>
            [Google.Apis.Util.RequestParameterAttribute("callback", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string Callback { get; set; }

            /// <summary>Selector specifying which fields to include in a partial response.</summary>
            [Google.Apis.Util.RequestParameterAttribute("fields", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string Fields { get; set; }

            /// <summary>API key. Your API key identifies your project and provides you with API access, quota, and
            /// reports. Required unless you provide an OAuth 2.0 token.</summary>
            [Google.Apis.Util.RequestParameterAttribute("key", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string Key { get; set; }

            /// <summary>OAuth 2.0 token for the current user.</summary>
            [Google.Apis.Util.RequestParameterAttribute("oauth_token", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string OauthToken { get; set; }

            /// <summary>Returns response with indentations and line breaks.</summary>
            /// [default: true]
            [Google.Apis.Util.RequestParameterAttribute("prettyPrint", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<bool> PrettyPrint { get; set; }

            /// <summary>Available to use for quota purposes for server-side applications. Can be any arbitrary string
            /// assigned to a user, but should not exceed 40 characters.</summary>
            [Google.Apis.Util.RequestParameterAttribute("quotaUser", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string QuotaUser { get; set; }

            /// <summary>Legacy upload protocol for media (e.g. "media", "multipart").</summary>
            [Google.Apis.Util.RequestParameterAttribute("uploadType", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string UploadType { get; set; }

            /// <summary>Upload protocol for media (e.g. "raw", "multipart").</summary>
            [Google.Apis.Util.RequestParameterAttribute("upload_protocol", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string UploadProtocol { get; set; }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }

            /// <summary>Constructs a new Upload media upload instance.</summary>
            public UploadMediaUpload(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.TransitObjectUploadRotatingBarcodeValuesRequest body, string
             resourceId, System.IO.Stream stream, string contentType)
                : base(service, string.Format("/{0}/{1}{2}", "upload", service.BasePath, "walletobjects/v1/transitObject/{resourceId}/uploadRotatingBarcodeValues"), "POST", stream, contentType)
            {
                ResourceId = resourceId;
                Body = body;
            }
        }
    }

    /// <summary>The "offerclass" collection of methods.</summary>
    public class OfferclassResource
    {
        private const string Resource = "offerclass";

        /// <summary>The service which this resource belongs to.</summary>
        private readonly Google.Apis.Services.IClientService service;

        /// <summary>Constructs a new resource.</summary>
        public OfferclassResource(Google.Apis.Services.IClientService service)
        {
            this.service = service;

        }


        /// <summary>Adds a message to the offer class referenced by the given class ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual AddmessageRequest Addmessage(Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
        {
            return new AddmessageRequest(service, body, resourceId);
        }

        /// <summary>Adds a message to the offer class referenced by the given class ID.</summary>
        public class AddmessageRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.OfferClassAddMessageResponse>
        {
            /// <summary>Constructs a new Addmessage request.</summary>
            public AddmessageRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.AddMessageRequest Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "addmessage"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/offerClass/{resourceId}/addMessage"; }
            }

            /// <summary>Initializes Addmessage parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Returns the offer class with the given class ID.</summary>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual GetRequest Get(string resourceId)
        {
            return new GetRequest(service, resourceId);
        }

        /// <summary>Returns the offer class with the given class ID.</summary>
        public class GetRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.OfferClass>
        {
            /// <summary>Constructs a new Get request.</summary>
            public GetRequest(Google.Apis.Services.IClientService service, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "get"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/offerClass/{resourceId}"; }
            }

            /// <summary>Initializes Get parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Inserts an offer class with the given ID and properties.</summary>
        /// <param name="body">The body of the request.</param>
        public virtual InsertRequest Insert(Google.Apis.Walletobjects.v1.Data.OfferClass body)
        {
            return new InsertRequest(service, body);
        }

        /// <summary>Inserts an offer class with the given ID and properties.</summary>
        public class InsertRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.OfferClass>
        {
            /// <summary>Constructs a new Insert request.</summary>
            public InsertRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.OfferClass body)
                : base(service)
            {
                Body = body;
                InitParameters();
            }



            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.OfferClass Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "insert"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/offerClass"; }
            }

            /// <summary>Initializes Insert parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

            }

        }

        /// <summary>Returns a list of all offer classes for a given issuer ID.</summary>
        public virtual ListRequest List()
        {
            return new ListRequest(service);
        }

        /// <summary>Returns a list of all offer classes for a given issuer ID.</summary>
        public class ListRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.OfferClassListResponse>
        {
            /// <summary>Constructs a new List request.</summary>
            public ListRequest(Google.Apis.Services.IClientService service)
                : base(service)
            {
                InitParameters();
            }


            /// <summary>The ID of the issuer authorized to list classes.</summary>
            [Google.Apis.Util.RequestParameterAttribute("issuerId", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<long> IssuerId { get; set; }

            /// <summary>Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
            /// classes are available in a list. For example, if you have a list of 200 classes and you call list with
            /// `maxResults` set to 20, list will return the first 20 classes and a token. Call list again with
            /// `maxResults` set to 20 and the token to get the next 20 classes.</summary>
            [Google.Apis.Util.RequestParameterAttribute("token", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string Token { get; set; }

            /// <summary>Identifies the max number of results returned by a list. All results are returned if
            /// `maxResults` isn't defined.</summary>
            [Google.Apis.Util.RequestParameterAttribute("maxResults", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<int> MaxResults { get; set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "list"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/offerClass"; }
            }

            /// <summary>Initializes List parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "issuerId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "issuerId",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "token", new Google.Apis.Discovery.Parameter
                    {
                        Name = "token",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "maxResults", new Google.Apis.Discovery.Parameter
                    {
                        Name = "maxResults",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the offer class referenced by the given class ID. This method supports patch
        /// semantics.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual PatchRequest Patch(Google.Apis.Walletobjects.v1.Data.OfferClass body, string resourceId)
        {
            return new PatchRequest(service, body, resourceId);
        }

        /// <summary>Updates the offer class referenced by the given class ID. This method supports patch
        /// semantics.</summary>
        public class PatchRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.OfferClass>
        {
            /// <summary>Constructs a new Patch request.</summary>
            public PatchRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.OfferClass body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.OfferClass Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "patch"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PATCH"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/offerClass/{resourceId}"; }
            }

            /// <summary>Initializes Patch parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the offer class referenced by the given class ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual UpdateRequest Update(Google.Apis.Walletobjects.v1.Data.OfferClass body, string resourceId)
        {
            return new UpdateRequest(service, body, resourceId);
        }

        /// <summary>Updates the offer class referenced by the given class ID.</summary>
        public class UpdateRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.OfferClass>
        {
            /// <summary>Constructs a new Update request.</summary>
            public UpdateRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.OfferClass body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.OfferClass Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "update"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PUT"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/offerClass/{resourceId}"; }
            }

            /// <summary>Initializes Update parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }
    }

    /// <summary>The "offerobject" collection of methods.</summary>
    public class OfferobjectResource
    {
        private const string Resource = "offerobject";

        /// <summary>The service which this resource belongs to.</summary>
        private readonly Google.Apis.Services.IClientService service;

        /// <summary>Constructs a new resource.</summary>
        public OfferobjectResource(Google.Apis.Services.IClientService service)
        {
            this.service = service;

        }


        /// <summary>Adds a message to the offer object referenced by the given object ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual AddmessageRequest Addmessage(Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
        {
            return new AddmessageRequest(service, body, resourceId);
        }

        /// <summary>Adds a message to the offer object referenced by the given object ID.</summary>
        public class AddmessageRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.OfferObjectAddMessageResponse>
        {
            /// <summary>Constructs a new Addmessage request.</summary>
            public AddmessageRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.AddMessageRequest Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "addmessage"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/offerObject/{resourceId}/addMessage"; }
            }

            /// <summary>Initializes Addmessage parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Returns the offer object with the given object ID.</summary>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual GetRequest Get(string resourceId)
        {
            return new GetRequest(service, resourceId);
        }

        /// <summary>Returns the offer object with the given object ID.</summary>
        public class GetRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.OfferObject>
        {
            /// <summary>Constructs a new Get request.</summary>
            public GetRequest(Google.Apis.Services.IClientService service, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "get"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/offerObject/{resourceId}"; }
            }

            /// <summary>Initializes Get parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Inserts an offer object with the given ID and properties.</summary>
        /// <param name="body">The body of the request.</param>
        public virtual InsertRequest Insert(Google.Apis.Walletobjects.v1.Data.OfferObject body)
        {
            return new InsertRequest(service, body);
        }

        /// <summary>Inserts an offer object with the given ID and properties.</summary>
        public class InsertRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.OfferObject>
        {
            /// <summary>Constructs a new Insert request.</summary>
            public InsertRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.OfferObject body)
                : base(service)
            {
                Body = body;
                InitParameters();
            }



            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.OfferObject Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "insert"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/offerObject"; }
            }

            /// <summary>Initializes Insert parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

            }

        }

        /// <summary>Returns a list of all offer objects for a given issuer ID.</summary>
        public virtual ListRequest List()
        {
            return new ListRequest(service);
        }

        /// <summary>Returns a list of all offer objects for a given issuer ID.</summary>
        public class ListRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.OfferObjectListResponse>
        {
            /// <summary>Constructs a new List request.</summary>
            public ListRequest(Google.Apis.Services.IClientService service)
                : base(service)
            {
                InitParameters();
            }


            /// <summary>The ID of the class whose objects will be listed.</summary>
            [Google.Apis.Util.RequestParameterAttribute("classId", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string ClassId { get; set; }

            /// <summary>Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
            /// objects are available in a list. For example, if you have a list of 200 objects and you call list with
            /// `maxResults` set to 20, list will return the first 20 objects and a token. Call list again with
            /// `maxResults` set to 20 and the token to get the next 20 objects.</summary>
            [Google.Apis.Util.RequestParameterAttribute("token", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string Token { get; set; }

            /// <summary>Identifies the max number of results returned by a list. All results are returned if
            /// `maxResults` isn't defined.</summary>
            [Google.Apis.Util.RequestParameterAttribute("maxResults", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<int> MaxResults { get; set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "list"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/offerObject"; }
            }

            /// <summary>Initializes List parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "classId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "classId",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "token", new Google.Apis.Discovery.Parameter
                    {
                        Name = "token",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "maxResults", new Google.Apis.Discovery.Parameter
                    {
                        Name = "maxResults",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the offer object referenced by the given object ID. This method supports patch
        /// semantics.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual PatchRequest Patch(Google.Apis.Walletobjects.v1.Data.OfferObject body, string resourceId)
        {
            return new PatchRequest(service, body, resourceId);
        }

        /// <summary>Updates the offer object referenced by the given object ID. This method supports patch
        /// semantics.</summary>
        public class PatchRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.OfferObject>
        {
            /// <summary>Constructs a new Patch request.</summary>
            public PatchRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.OfferObject body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.OfferObject Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "patch"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PATCH"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/offerObject/{resourceId}"; }
            }

            /// <summary>Initializes Patch parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the offer object referenced by the given object ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual UpdateRequest Update(Google.Apis.Walletobjects.v1.Data.OfferObject body, string resourceId)
        {
            return new UpdateRequest(service, body, resourceId);
        }

        /// <summary>Updates the offer object referenced by the given object ID.</summary>
        public class UpdateRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.OfferObject>
        {
            /// <summary>Constructs a new Update request.</summary>
            public UpdateRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.OfferObject body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.OfferObject Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "update"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PUT"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/offerObject/{resourceId}"; }
            }

            /// <summary>Initializes Update parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }
    }

    /// <summary>The "permissions" collection of methods.</summary>
    public class PermissionsResource
    {
        private const string Resource = "permissions";

        /// <summary>The service which this resource belongs to.</summary>
        private readonly Google.Apis.Services.IClientService service;

        /// <summary>Constructs a new resource.</summary>
        public PermissionsResource(Google.Apis.Services.IClientService service)
        {
            this.service = service;

        }


        /// <summary>Returns the permissions for the given issuer id.</summary>
        /// <param name="resourceId">The unique identifier for an issuer. This ID must be unique across all
        /// issuers.</param>
        public virtual GetRequest Get(long resourceId)
        {
            return new GetRequest(service, resourceId);
        }

        /// <summary>Returns the permissions for the given issuer id.</summary>
        public class GetRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.Permissions>
        {
            /// <summary>Constructs a new Get request.</summary>
            public GetRequest(Google.Apis.Services.IClientService service, long resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                InitParameters();
            }


            /// <summary>The unique identifier for an issuer. This ID must be unique across all issuers.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual long ResourceId { get; private set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "get"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/permissions/{resourceId}"; }
            }

            /// <summary>Initializes Get parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the permissions for the given issuer.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an issuer. This ID must be unique across all
        /// issuers.</param>
        public virtual UpdateRequest Update(Google.Apis.Walletobjects.v1.Data.Permissions body, long resourceId)
        {
            return new UpdateRequest(service, body, resourceId);
        }

        /// <summary>Updates the permissions for the given issuer.</summary>
        public class UpdateRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.Permissions>
        {
            /// <summary>Constructs a new Update request.</summary>
            public UpdateRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.Permissions body, long resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an issuer. This ID must be unique across all issuers.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual long ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.Permissions Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "update"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PUT"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/permissions/{resourceId}"; }
            }

            /// <summary>Initializes Update parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }
    }

    /// <summary>The "smarttap" collection of methods.</summary>
    public class SmarttapResource
    {
        private const string Resource = "smarttap";

        /// <summary>The service which this resource belongs to.</summary>
        private readonly Google.Apis.Services.IClientService service;

        /// <summary>Constructs a new resource.</summary>
        public SmarttapResource(Google.Apis.Services.IClientService service)
        {
            this.service = service;

        }


        /// <summary>Inserts the smart tap.</summary>
        /// <param name="body">The body of the request.</param>
        public virtual InsertRequest Insert(Google.Apis.Walletobjects.v1.Data.SmartTap body)
        {
            return new InsertRequest(service, body);
        }

        /// <summary>Inserts the smart tap.</summary>
        public class InsertRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.SmartTap>
        {
            /// <summary>Constructs a new Insert request.</summary>
            public InsertRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.SmartTap body)
                : base(service)
            {
                Body = body;
                InitParameters();
            }



            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.SmartTap Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "insert"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/smartTap"; }
            }

            /// <summary>Initializes Insert parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

            }

        }
    }

    /// <summary>The "transitclass" collection of methods.</summary>
    public class TransitclassResource
    {
        private const string Resource = "transitclass";

        /// <summary>The service which this resource belongs to.</summary>
        private readonly Google.Apis.Services.IClientService service;

        /// <summary>Constructs a new resource.</summary>
        public TransitclassResource(Google.Apis.Services.IClientService service)
        {
            this.service = service;

        }


        /// <summary>Adds a message to the transit class referenced by the given class ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual AddmessageRequest Addmessage(Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
        {
            return new AddmessageRequest(service, body, resourceId);
        }

        /// <summary>Adds a message to the transit class referenced by the given class ID.</summary>
        public class AddmessageRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.TransitClassAddMessageResponse>
        {
            /// <summary>Constructs a new Addmessage request.</summary>
            public AddmessageRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.AddMessageRequest Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "addmessage"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/transitClass/{resourceId}/addMessage"; }
            }

            /// <summary>Initializes Addmessage parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Returns the transit class with the given class ID.</summary>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual GetRequest Get(string resourceId)
        {
            return new GetRequest(service, resourceId);
        }

        /// <summary>Returns the transit class with the given class ID.</summary>
        public class GetRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.TransitClass>
        {
            /// <summary>Constructs a new Get request.</summary>
            public GetRequest(Google.Apis.Services.IClientService service, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "get"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/transitClass/{resourceId}"; }
            }

            /// <summary>Initializes Get parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Inserts a transit class with the given ID and properties.</summary>
        /// <param name="body">The body of the request.</param>
        public virtual InsertRequest Insert(Google.Apis.Walletobjects.v1.Data.TransitClass body)
        {
            return new InsertRequest(service, body);
        }

        /// <summary>Inserts a transit class with the given ID and properties.</summary>
        public class InsertRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.TransitClass>
        {
            /// <summary>Constructs a new Insert request.</summary>
            public InsertRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.TransitClass body)
                : base(service)
            {
                Body = body;
                InitParameters();
            }



            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.TransitClass Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "insert"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/transitClass"; }
            }

            /// <summary>Initializes Insert parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

            }

        }

        /// <summary>Returns a list of all transit classes for a given issuer ID.</summary>
        public virtual ListRequest List()
        {
            return new ListRequest(service);
        }

        /// <summary>Returns a list of all transit classes for a given issuer ID.</summary>
        public class ListRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.TransitClassListResponse>
        {
            /// <summary>Constructs a new List request.</summary>
            public ListRequest(Google.Apis.Services.IClientService service)
                : base(service)
            {
                InitParameters();
            }


            /// <summary>The ID of the issuer authorized to list classes.</summary>
            [Google.Apis.Util.RequestParameterAttribute("issuerId", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<long> IssuerId { get; set; }

            /// <summary>Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
            /// classes are available in a list. For example, if you have a list of 200 classes and you call list with
            /// `maxResults` set to 20, list will return the first 20 classes and a token. Call list again with
            /// `maxResults` set to 20 and the token to get the next 20 classes.</summary>
            [Google.Apis.Util.RequestParameterAttribute("token", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string Token { get; set; }

            /// <summary>Identifies the max number of results returned by a list. All results are returned if
            /// `maxResults` isn't defined.</summary>
            [Google.Apis.Util.RequestParameterAttribute("maxResults", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<int> MaxResults { get; set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "list"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/transitClass"; }
            }

            /// <summary>Initializes List parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "issuerId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "issuerId",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "token", new Google.Apis.Discovery.Parameter
                    {
                        Name = "token",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "maxResults", new Google.Apis.Discovery.Parameter
                    {
                        Name = "maxResults",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the transit class referenced by the given class ID. This method supports patch
        /// semantics.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual PatchRequest Patch(Google.Apis.Walletobjects.v1.Data.TransitClass body, string resourceId)
        {
            return new PatchRequest(service, body, resourceId);
        }

        /// <summary>Updates the transit class referenced by the given class ID. This method supports patch
        /// semantics.</summary>
        public class PatchRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.TransitClass>
        {
            /// <summary>Constructs a new Patch request.</summary>
            public PatchRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.TransitClass body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.TransitClass Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "patch"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PATCH"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/transitClass/{resourceId}"; }
            }

            /// <summary>Initializes Patch parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the transit class referenced by the given class ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for a class. This ID must be unique across all classes from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual UpdateRequest Update(Google.Apis.Walletobjects.v1.Data.TransitClass body, string resourceId)
        {
            return new UpdateRequest(service, body, resourceId);
        }

        /// <summary>Updates the transit class referenced by the given class ID.</summary>
        public class UpdateRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.TransitClass>
        {
            /// <summary>Constructs a new Update request.</summary>
            public UpdateRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.TransitClass body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for a class. This ID must be unique across all classes from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.TransitClass Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "update"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PUT"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/transitClass/{resourceId}"; }
            }

            /// <summary>Initializes Update parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }
    }

    /// <summary>The "transitobject" collection of methods.</summary>
    public class TransitobjectResource
    {
        private const string Resource = "transitobject";

        /// <summary>The service which this resource belongs to.</summary>
        private readonly Google.Apis.Services.IClientService service;

        /// <summary>Constructs a new resource.</summary>
        public TransitobjectResource(Google.Apis.Services.IClientService service)
        {
            this.service = service;

        }


        /// <summary>Adds a message to the transit object referenced by the given object ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual AddmessageRequest Addmessage(Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
        {
            return new AddmessageRequest(service, body, resourceId);
        }

        /// <summary>Adds a message to the transit object referenced by the given object ID.</summary>
        public class AddmessageRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.TransitObjectAddMessageResponse>
        {
            /// <summary>Constructs a new Addmessage request.</summary>
            public AddmessageRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.AddMessageRequest body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.AddMessageRequest Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "addmessage"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/transitObject/{resourceId}/addMessage"; }
            }

            /// <summary>Initializes Addmessage parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Returns the transit object with the given object ID.</summary>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual GetRequest Get(string resourceId)
        {
            return new GetRequest(service, resourceId);
        }

        /// <summary>Returns the transit object with the given object ID.</summary>
        public class GetRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.TransitObject>
        {
            /// <summary>Constructs a new Get request.</summary>
            public GetRequest(Google.Apis.Services.IClientService service, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "get"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/transitObject/{resourceId}"; }
            }

            /// <summary>Initializes Get parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Inserts an transit object with the given ID and properties.</summary>
        /// <param name="body">The body of the request.</param>
        public virtual InsertRequest Insert(Google.Apis.Walletobjects.v1.Data.TransitObject body)
        {
            return new InsertRequest(service, body);
        }

        /// <summary>Inserts an transit object with the given ID and properties.</summary>
        public class InsertRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.TransitObject>
        {
            /// <summary>Constructs a new Insert request.</summary>
            public InsertRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.TransitObject body)
                : base(service)
            {
                Body = body;
                InitParameters();
            }



            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.TransitObject Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "insert"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "POST"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/transitObject"; }
            }

            /// <summary>Initializes Insert parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

            }

        }

        /// <summary>Returns a list of all transit objects for a given issuer ID.</summary>
        public virtual ListRequest List()
        {
            return new ListRequest(service);
        }

        /// <summary>Returns a list of all transit objects for a given issuer ID.</summary>
        public class ListRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.TransitObjectListResponse>
        {
            /// <summary>Constructs a new List request.</summary>
            public ListRequest(Google.Apis.Services.IClientService service)
                : base(service)
            {
                InitParameters();
            }


            /// <summary>The ID of the class whose objects will be listed.</summary>
            [Google.Apis.Util.RequestParameterAttribute("classId", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string ClassId { get; set; }

            /// <summary>Used to get the next set of results if `maxResults` is specified, but more than `maxResults`
            /// objects are available in a list. For example, if you have a list of 200 objects and you call list with
            /// `maxResults` set to 20, list will return the first 20 objects and a token. Call list again with
            /// `maxResults` set to 20 and the token to get the next 20 objects.</summary>
            [Google.Apis.Util.RequestParameterAttribute("token", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string Token { get; set; }

            /// <summary>Identifies the max number of results returned by a list. All results are returned if
            /// `maxResults` isn't defined.</summary>
            [Google.Apis.Util.RequestParameterAttribute("maxResults", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<int> MaxResults { get; set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "list"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/transitObject"; }
            }

            /// <summary>Initializes List parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "classId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "classId",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "token", new Google.Apis.Discovery.Parameter
                    {
                        Name = "token",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "maxResults", new Google.Apis.Discovery.Parameter
                    {
                        Name = "maxResults",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the transit object referenced by the given object ID. This method supports patch
        /// semantics.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual PatchRequest Patch(Google.Apis.Walletobjects.v1.Data.TransitObject body, string resourceId)
        {
            return new PatchRequest(service, body, resourceId);
        }

        /// <summary>Updates the transit object referenced by the given object ID. This method supports patch
        /// semantics.</summary>
        public class PatchRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.TransitObject>
        {
            /// <summary>Constructs a new Patch request.</summary>
            public PatchRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.TransitObject body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.TransitObject Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "patch"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PATCH"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/transitObject/{resourceId}"; }
            }

            /// <summary>Initializes Patch parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }

        /// <summary>Updates the transit object referenced by the given object ID.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="resourceId">The unique identifier for an object. This ID must be unique across all objects from an
        /// issuer. This value should follow the format issuer ID. identifier where the former is issued by Google and latter is
        /// chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_', or '-'.</param>
        public virtual UpdateRequest Update(Google.Apis.Walletobjects.v1.Data.TransitObject body, string resourceId)
        {
            return new UpdateRequest(service, body, resourceId);
        }

        /// <summary>Updates the transit object referenced by the given object ID.</summary>
        public class UpdateRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.TransitObject>
        {
            /// <summary>Constructs a new Update request.</summary>
            public UpdateRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.TransitObject body, string resourceId)
                : base(service)
            {
                ResourceId = resourceId;
                Body = body;
                InitParameters();
            }


            /// <summary>The unique identifier for an object. This ID must be unique across all objects from an issuer.
            /// This value should follow the format issuer ID. identifier where the former is issued by Google and
            /// latter is chosen by you. Your unique identifier should only include alphanumeric characters, '.', '_',
            /// or '-'.</summary>
            [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string ResourceId { get; private set; }


            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.Walletobjects.v1.Data.TransitObject Body { get; set; }

            ///<summary>Returns the body of the request.</summary>
            protected override object GetBody() { return Body; }

            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "update"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "PUT"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/transitObject/{resourceId}"; }
            }

            /// <summary>Initializes Update parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "resourceId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "resourceId",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }
    }

    /// <summary>The "valuablesclasses" collection of methods.</summary>
    public class ValuablesclassesResource
    {
        private const string Resource = "valuablesclasses";

        /// <summary>The service which this resource belongs to.</summary>
        private readonly Google.Apis.Services.IClientService service;

        /// <summary>Constructs a new resource.</summary>
        public ValuablesclassesResource(Google.Apis.Services.IClientService service)
        {
            this.service = service;

        }


        /// <summary>Returns a list of all valuables classes for a given issuer ID.</summary>
        public virtual ListRequest List()
        {
            return new ListRequest(service);
        }

        /// <summary>Returns a list of all valuables classes for a given issuer ID.</summary>
        public class ListRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.ListValuablesClassesResponse>
        {
            /// <summary>Constructs a new List request.</summary>
            public ListRequest(Google.Apis.Services.IClientService service)
                : base(service)
            {
                InitParameters();
            }


            /// <summary>The ID of the issuer authorized to list classes.</summary>
            [Google.Apis.Util.RequestParameterAttribute("issuerId", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<long> IssuerId { get; set; }

            /// <summary>Specify the type(s) of ValuablesClass that needs to be listed. If none is specified, all the
            /// ValuablesClasses would be returned.</summary>
            [Google.Apis.Util.RequestParameterAttribute("requestedType", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<RequestedTypeEnum> RequestedType { get; set; }

            /// <summary>Specify the type(s) of ValuablesClass that needs to be listed. If none is specified, all the
            /// ValuablesClasses would be returned.</summary>
            public enum RequestedTypeEnum
            {
                /// <summary>Type unspecified, this is the default type.</summary>
                [Google.Apis.Util.StringValueAttribute("VALUABLE_TYPE_UNSPECIFIED")]
                VALUABLETYPEUNSPECIFIED,
                /// <summary>Valuable Type GiftCard.</summary>
                [Google.Apis.Util.StringValueAttribute("VALUABLE_TYPE_GIFT_CARD")]
                VALUABLETYPEGIFTCARD,
                /// <summary>Valuable Type Loyalty.</summary>
                [Google.Apis.Util.StringValueAttribute("VALUABLE_TYPE_LOYALTY")]
                VALUABLETYPELOYALTY,
                /// <summary>Valuable Type Offer.</summary>
                [Google.Apis.Util.StringValueAttribute("VALUABLE_TYPE_OFFER")]
                VALUABLETYPEOFFER,
                /// <summary>Valuable Type Event Ticket.</summary>
                [Google.Apis.Util.StringValueAttribute("VALUABLE_TYPE_EVENT_TICKET")]
                VALUABLETYPEEVENTTICKET,
                /// <summary>Valuable Type Flight.</summary>
                [Google.Apis.Util.StringValueAttribute("VALUABLE_TYPE_FLIGHT")]
                VALUABLETYPEFLIGHT,
                /// <summary>Valuable Type Transit.</summary>
                [Google.Apis.Util.StringValueAttribute("VALUABLE_TYPE_TRANSIT")]
                VALUABLETYPETRANSIT,
                /// <summary>Valuable Type Generic.</summary>
                [Google.Apis.Util.StringValueAttribute("VALUABLE_TYPE_GENERIC")]
                VALUABLETYPEGENERIC,
            }

            /// <summary>Used to get the next set of results if max_results is specified, but more than max_results
            /// classes are available in a list. For example, if you have a list of 200 classes and you call list with
            /// max_results set to 20, list will return the first 20 classes and a next_token. Call list again with
            /// max_results set to 20 and the token set to next_token to get the next 20 classes.</summary>
            [Google.Apis.Util.RequestParameterAttribute("token", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string Token { get; set; }

            /// <summary>Identifies the max number of results returned by a list. All results are returned if
            /// max_results isn't defined.</summary>
            [Google.Apis.Util.RequestParameterAttribute("maxResults", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<int> MaxResults { get; set; }


            ///<summary>Gets the method name.</summary>
            public override string MethodName
            {
                get { return "list"; }
            }

            ///<summary>Gets the HTTP method.</summary>
            public override string HttpMethod
            {
                get { return "GET"; }
            }

            ///<summary>Gets the REST path.</summary>
            public override string RestPath
            {
                get { return "walletobjects/v1/valuablesclasses"; }
            }

            /// <summary>Initializes List parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();

                RequestParameters.Add(
                    "issuerId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "issuerId",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "requestedType", new Google.Apis.Discovery.Parameter
                    {
                        Name = "requestedType",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "token", new Google.Apis.Discovery.Parameter
                    {
                        Name = "token",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                RequestParameters.Add(
                    "maxResults", new Google.Apis.Discovery.Parameter
                    {
                        Name = "maxResults",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
            }

        }
    }

    /// <summary>The "walletobjects" collection of methods.</summary>
    public class WalletobjectsResource
    {
        private const string Resource = "walletobjects";

        /// <summary>The service which this resource belongs to.</summary>
        private readonly Google.Apis.Services.IClientService service;

        /// <summary>Constructs a new resource.</summary>
        public WalletobjectsResource(Google.Apis.Services.IClientService service)
        {
            this.service = service;
            v1 = new V1Resource(service);

        }

        private readonly V1Resource v1;

        /// <summary>Gets the V1 resource.</summary>
        public virtual V1Resource V1
        {
            get { return v1; }
        }

        /// <summary>The "v1" collection of methods.</summary>
        public class V1Resource
        {
            private const string Resource = "v1";

            /// <summary>The service which this resource belongs to.</summary>
            private readonly Google.Apis.Services.IClientService service;

            /// <summary>Constructs a new resource.</summary>
            public V1Resource(Google.Apis.Services.IClientService service)
            {
                this.service = service;
                brand = new BrandResource(service);
                privateContent = new PrivateContentResource(service);

            }

            private readonly BrandResource brand;

            /// <summary>Gets the Brand resource.</summary>
            public virtual BrandResource Brand
            {
                get { return brand; }
            }

            /// <summary>The "brand" collection of methods.</summary>
            public class BrandResource
            {
                private const string Resource = "brand";

                /// <summary>The service which this resource belongs to.</summary>
                private readonly Google.Apis.Services.IClientService service;

                /// <summary>Constructs a new resource.</summary>
                public BrandResource(Google.Apis.Services.IClientService service)
                {
                    this.service = service;

                }


                /// <summary>Inserts brand information for the given Issuer ID and country code.</summary>
                /// <param name="body">The body of the request.</param>
                public virtual CreateRequest Create(Google.Apis.Walletobjects.v1.Data.Brand body)
                {
                    return new CreateRequest(service, body);
                }

                /// <summary>Inserts brand information for the given Issuer ID and country code.</summary>
                public class CreateRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.Brand>
                {
                    /// <summary>Constructs a new Create request.</summary>
                    public CreateRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.Brand body)
                        : base(service)
                    {
                        Body = body;
                        InitParameters();
                    }



                    /// <summary>Gets or sets the body of this request.</summary>
                    Google.Apis.Walletobjects.v1.Data.Brand Body { get; set; }

                    ///<summary>Returns the body of the request.</summary>
                    protected override object GetBody() { return Body; }

                    ///<summary>Gets the method name.</summary>
                    public override string MethodName
                    {
                        get { return "create"; }
                    }

                    ///<summary>Gets the HTTP method.</summary>
                    public override string HttpMethod
                    {
                        get { return "POST"; }
                    }

                    ///<summary>Gets the REST path.</summary>
                    public override string RestPath
                    {
                        get { return "walletobjects/v1/brand"; }
                    }

                    /// <summary>Initializes Create parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();

                    }

                }

                /// <summary>Deletes the brand referenced by the given Issuer ID and country code.</summary>
                /// <param name="resourceId">The unique identifier for an Issuer. This ID must be unique across all
                /// issuers.</param>
                /// <param name="countryCode">The country code for the brand information.</param>
                public virtual DeleteRequest Delete(long resourceId, string countryCode)
                {
                    return new DeleteRequest(service, resourceId, countryCode);
                }

                /// <summary>Deletes the brand referenced by the given Issuer ID and country code.</summary>
                public class DeleteRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.BrandDeleteResponse>
                {
                    /// <summary>Constructs a new Delete request.</summary>
                    public DeleteRequest(Google.Apis.Services.IClientService service, long resourceId, string countryCode)
                        : base(service)
                    {
                        ResourceId = resourceId;
                        CountryCode = countryCode;
                        InitParameters();
                    }


                    /// <summary>The unique identifier for an Issuer. This ID must be unique across all
                    /// issuers.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual long ResourceId { get; private set; }

                    /// <summary>The country code for the brand information.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("countryCode", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string CountryCode { get; private set; }


                    ///<summary>Gets the method name.</summary>
                    public override string MethodName
                    {
                        get { return "delete"; }
                    }

                    ///<summary>Gets the HTTP method.</summary>
                    public override string HttpMethod
                    {
                        get { return "DELETE"; }
                    }

                    ///<summary>Gets the REST path.</summary>
                    public override string RestPath
                    {
                        get { return "walletobjects/v1/brand/{resourceId}/{countryCode}"; }
                    }

                    /// <summary>Initializes Delete parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();

                        RequestParameters.Add(
                            "resourceId", new Google.Apis.Discovery.Parameter
                            {
                                Name = "resourceId",
                                IsRequired = true,
                                ParameterType = "path",
                                DefaultValue = null,
                                Pattern = null,
                            });
                        RequestParameters.Add(
                            "countryCode", new Google.Apis.Discovery.Parameter
                            {
                                Name = "countryCode",
                                IsRequired = true,
                                ParameterType = "path",
                                DefaultValue = null,
                                Pattern = null,
                            });
                    }

                }

                /// <summary>Returns the brand information for the given Issuer ID and country code.</summary>
                /// <param name="resourceId">The unique identifier for an Issuer. This ID must be unique across all
                /// issuers.</param>
                /// <param name="countryCode">The country code for the brand information.</param>
                public virtual GetRequest Get(long resourceId, string countryCode)
                {
                    return new GetRequest(service, resourceId, countryCode);
                }

                /// <summary>Returns the brand information for the given Issuer ID and country code.</summary>
                public class GetRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.Brand>
                {
                    /// <summary>Constructs a new Get request.</summary>
                    public GetRequest(Google.Apis.Services.IClientService service, long resourceId, string countryCode)
                        : base(service)
                    {
                        ResourceId = resourceId;
                        CountryCode = countryCode;
                        InitParameters();
                    }


                    /// <summary>The unique identifier for an Issuer. This ID must be unique across all
                    /// issuers.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual long ResourceId { get; private set; }

                    /// <summary>The country code for the brand information.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("countryCode", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string CountryCode { get; private set; }


                    ///<summary>Gets the method name.</summary>
                    public override string MethodName
                    {
                        get { return "get"; }
                    }

                    ///<summary>Gets the HTTP method.</summary>
                    public override string HttpMethod
                    {
                        get { return "GET"; }
                    }

                    ///<summary>Gets the REST path.</summary>
                    public override string RestPath
                    {
                        get { return "walletobjects/v1/brand/{resourceId}/{countryCode}"; }
                    }

                    /// <summary>Initializes Get parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();

                        RequestParameters.Add(
                            "resourceId", new Google.Apis.Discovery.Parameter
                            {
                                Name = "resourceId",
                                IsRequired = true,
                                ParameterType = "path",
                                DefaultValue = null,
                                Pattern = null,
                            });
                        RequestParameters.Add(
                            "countryCode", new Google.Apis.Discovery.Parameter
                            {
                                Name = "countryCode",
                                IsRequired = true,
                                ParameterType = "path",
                                DefaultValue = null,
                                Pattern = null,
                            });
                    }

                }

                /// <summary>Returns a list of all per-country brand information for the given Issuer Id.</summary>
                public virtual ListRequest List()
                {
                    return new ListRequest(service);
                }

                /// <summary>Returns a list of all per-country brand information for the given Issuer Id.</summary>
                public class ListRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.BrandListResponse>
                {
                    /// <summary>Constructs a new List request.</summary>
                    public ListRequest(Google.Apis.Services.IClientService service)
                        : base(service)
                    {
                        InitParameters();
                    }


                    /// <summary>The ID of the issuer authorized to list brands.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Query)]
                    public virtual System.Nullable<long> ResourceId { get; set; }


                    ///<summary>Gets the method name.</summary>
                    public override string MethodName
                    {
                        get { return "list"; }
                    }

                    ///<summary>Gets the HTTP method.</summary>
                    public override string HttpMethod
                    {
                        get { return "GET"; }
                    }

                    ///<summary>Gets the REST path.</summary>
                    public override string RestPath
                    {
                        get { return "walletobjects/v1/brand"; }
                    }

                    /// <summary>Initializes List parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();

                        RequestParameters.Add(
                            "resourceId", new Google.Apis.Discovery.Parameter
                            {
                                Name = "resourceId",
                                IsRequired = false,
                                ParameterType = "query",
                                DefaultValue = null,
                                Pattern = null,
                            });
                    }

                }

                /// <summary>Updates the brand referenced by the given Issuer ID and country code.</summary>
                /// <param name="body">The body of the request.</param>
                /// <param name="resourceId">The unique identifier for an issuer. This ID must be unique across all
                /// issuers.</param>
                /// <param name="countryCode">The country code for the brand information.</param>
                public virtual UpdateRequest Update(Google.Apis.Walletobjects.v1.Data.Brand body, long resourceId, string countryCode)
                {
                    return new UpdateRequest(service, body, resourceId, countryCode);
                }

                /// <summary>Updates the brand referenced by the given Issuer ID and country code.</summary>
                public class UpdateRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.Brand>
                {
                    /// <summary>Constructs a new Update request.</summary>
                    public UpdateRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.Brand body, long resourceId, string countryCode)
                        : base(service)
                    {
                        ResourceId = resourceId;
                        CountryCode = countryCode;
                        Body = body;
                        InitParameters();
                    }


                    /// <summary>The unique identifier for an issuer. This ID must be unique across all
                    /// issuers.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("resourceId", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual long ResourceId { get; private set; }

                    /// <summary>The country code for the brand information.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("countryCode", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string CountryCode { get; private set; }


                    /// <summary>Gets or sets the body of this request.</summary>
                    Google.Apis.Walletobjects.v1.Data.Brand Body { get; set; }

                    ///<summary>Returns the body of the request.</summary>
                    protected override object GetBody() { return Body; }

                    ///<summary>Gets the method name.</summary>
                    public override string MethodName
                    {
                        get { return "update"; }
                    }

                    ///<summary>Gets the HTTP method.</summary>
                    public override string HttpMethod
                    {
                        get { return "PUT"; }
                    }

                    ///<summary>Gets the REST path.</summary>
                    public override string RestPath
                    {
                        get { return "walletobjects/v1/brand/{resourceId}/{countryCode}"; }
                    }

                    /// <summary>Initializes Update parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();

                        RequestParameters.Add(
                            "resourceId", new Google.Apis.Discovery.Parameter
                            {
                                Name = "resourceId",
                                IsRequired = true,
                                ParameterType = "path",
                                DefaultValue = null,
                                Pattern = null,
                            });
                        RequestParameters.Add(
                            "countryCode", new Google.Apis.Discovery.Parameter
                            {
                                Name = "countryCode",
                                IsRequired = true,
                                ParameterType = "path",
                                DefaultValue = null,
                                Pattern = null,
                            });
                    }

                }
            }
            private readonly PrivateContentResource privateContent;

            /// <summary>Gets the PrivateContent resource.</summary>
            public virtual PrivateContentResource PrivateContent
            {
                get { return privateContent; }
            }

            /// <summary>The "privateContent" collection of methods.</summary>
            public class PrivateContentResource
            {
                private const string Resource = "privateContent";

                /// <summary>The service which this resource belongs to.</summary>
                private readonly Google.Apis.Services.IClientService service;

                /// <summary>Constructs a new resource.</summary>
                public PrivateContentResource(Google.Apis.Services.IClientService service)
                {
                    this.service = service;

                }


                /// <summary>Provide Google with information about awaiting private pass update. This will allow Google
                /// to provide the update notification to the device that currently holds this pass.</summary>
                /// <param name="body">The body of the request.</param>
                public virtual SetPassUpdateNoticeRequest SetPassUpdateNotice(Google.Apis.Walletobjects.v1.Data.SetPassUpdateNoticeRequest body)
                {
                    return new SetPassUpdateNoticeRequest(service, body);
                }

                /// <summary>Provide Google with information about awaiting private pass update. This will allow Google
                /// to provide the update notification to the device that currently holds this pass.</summary>
                public class SetPassUpdateNoticeRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.SetPassUpdateNoticeResponse>
                {
                    /// <summary>Constructs a new SetPassUpdateNotice request.</summary>
                    public SetPassUpdateNoticeRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.SetPassUpdateNoticeRequest body)
                        : base(service)
                    {
                        Body = body;
                        InitParameters();
                    }



                    /// <summary>Gets or sets the body of this request.</summary>
                    Google.Apis.Walletobjects.v1.Data.SetPassUpdateNoticeRequest Body { get; set; }

                    ///<summary>Returns the body of the request.</summary>
                    protected override object GetBody() { return Body; }

                    ///<summary>Gets the method name.</summary>
                    public override string MethodName
                    {
                        get { return "setPassUpdateNotice"; }
                    }

                    ///<summary>Gets the HTTP method.</summary>
                    public override string HttpMethod
                    {
                        get { return "POST"; }
                    }

                    ///<summary>Gets the REST path.</summary>
                    public override string RestPath
                    {
                        get { return "walletobjects/v1/privateContent/setPassUpdateNotice"; }
                    }

                    /// <summary>Initializes SetPassUpdateNotice parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();

                    }

                }

                /// <summary>Upload private data (text or URI) and returns an Id to be used in its place.</summary>
                /// <param name="body">The body of the request.</param>
                public virtual UploadPrivateDataRequest UploadPrivateData(Google.Apis.Walletobjects.v1.Data.UploadPrivateDataRequest body)
                {
                    return new UploadPrivateDataRequest(service, body);
                }

                /// <summary>Upload private data (text or URI) and returns an Id to be used in its place.</summary>
                public class UploadPrivateDataRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.UploadPrivateDataResponse>
                {
                    /// <summary>Constructs a new UploadPrivateData request.</summary>
                    public UploadPrivateDataRequest(Google.Apis.Services.IClientService service, Google.Apis.Walletobjects.v1.Data.UploadPrivateDataRequest body)
                        : base(service)
                    {
                        Body = body;
                        InitParameters();
                    }



                    /// <summary>Gets or sets the body of this request.</summary>
                    Google.Apis.Walletobjects.v1.Data.UploadPrivateDataRequest Body { get; set; }

                    ///<summary>Returns the body of the request.</summary>
                    protected override object GetBody() { return Body; }

                    ///<summary>Gets the method name.</summary>
                    public override string MethodName
                    {
                        get { return "uploadPrivateData"; }
                    }

                    ///<summary>Gets the HTTP method.</summary>
                    public override string HttpMethod
                    {
                        get { return "POST"; }
                    }

                    ///<summary>Gets the REST path.</summary>
                    public override string RestPath
                    {
                        get { return "walletobjects/v1/privateContent/uploadPrivateData"; }
                    }

                    /// <summary>Initializes UploadPrivateData parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();

                    }

                }
            }

            /// <summary>Returns a total number of valuables classes grouped by type for a given issuer ID.</summary>
            public virtual GetValuablesclassescountRequest GetValuablesclassescount()
            {
                return new GetValuablesclassescountRequest(service);
            }

            /// <summary>Returns a total number of valuables classes grouped by type for a given issuer ID.</summary>
            public class GetValuablesclassescountRequest : WalletobjectsBaseServiceRequest<Google.Apis.Walletobjects.v1.Data.ValuablesClassesCount>
            {
                /// <summary>Constructs a new GetValuablesclassescount request.</summary>
                public GetValuablesclassescountRequest(Google.Apis.Services.IClientService service)
                    : base(service)
                {
                    InitParameters();
                }


                /// <summary>The ID of the issuer authorized to list classes.</summary>
                [Google.Apis.Util.RequestParameterAttribute("issuerId", Google.Apis.Util.RequestParameterType.Query)]
                public virtual System.Nullable<long> IssuerId { get; set; }


                ///<summary>Gets the method name.</summary>
                public override string MethodName
                {
                    get { return "getValuablesclassescount"; }
                }

                ///<summary>Gets the HTTP method.</summary>
                public override string HttpMethod
                {
                    get { return "GET"; }
                }

                ///<summary>Gets the REST path.</summary>
                public override string RestPath
                {
                    get { return "walletobjects/v1/valuablesclassescount"; }
                }

                /// <summary>Initializes GetValuablesclassescount parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();

                    RequestParameters.Add(
                        "issuerId", new Google.Apis.Discovery.Parameter
                        {
                            Name = "issuerId",
                            IsRequired = false,
                            ParameterType = "query",
                            DefaultValue = null,
                            Pattern = null,
                        });
                }

            }
        }
    }
}
