# Java Echo Example

**DISCLAIMER**: This is not an officially supported Google product.

This is a sample server written in Java to handle bi-directional echo,
integrating with a [Google Standard Payments API](https://developers.google.com/standard-payments).
## Install
* [Java 11](https://openjdk.java.net/projects/jdk/11/)

## Prerequisites

* The hostname(s) that are responsible for serving your APIs have been
given to your Google contact.
* Public keys have been exchanged with your Google point of contact. 
Please note that this sample leverages the [Standard Payments PGP](https://github.com/google-pay/gsp-pgp-java) 
Java example to perform PGP encryption.
* Google has provided you with a unique Payment Integrator Account ID (PIAID).
This PIAID will be used to uniquely identify the bank when making API requests 
to the Google  API.

To view these steps in more detail, please reference the
[Implementation Steps](https://developers.google.com/standard-payments/guides/implementation-steps).

## How to use it:

1) Add the public key as 'public.gpg', add the private key as 'private.gpg',
and add the passphrase as 'passphrase.txt' to the resource's folder.
The Key Manager adds the keys on startup in 'KeyConfig.java'.

To add multiple keys, add the key to the resources folder and call
'keyManager.addPublicKeys' or 'keyManager.addSecretKeys' in 'KeyConfig.java' 
with the relative path of the key, as shown below.

Add a public key:

``` java
keyManager.addPublicKeys(resourceLoader.getResource("classpath:publickey/publicKey2.gpg").getInputStream());
```

Add a private key:
``` java
keyManager.addSecretKeys(
    resourceLoader.getResource("classpath:privatekey/privateKey2.gpg").getInputStream(),
    passPhraseBufferedReader2.readLine().toCharArray());
```

2) Update the application.properties file in the resource's folder to use the correct payment
integrator account identifier (PIAID) in the URL.

```properties
payment.integrator.account.id={PAYMENT_INTEGRATOR_ACCOUNT_ID}
```

3) Update the application.properties file in the resource's folder to use the
correct API service name for the outbound echo test to Google. This URL
can be found in the Google `echo` API reference documentation.

```properties
google.hosted.echo.url=vgw.googleapis.com/gsp/{API_SERVICE_NAME}/echo/
```

4) Run the application by executing the following shell command using Maven.

```shell
  $ ./mvn spring-boot:run
```

5) Execute the HTTP post request to test Google Standard Payments echo API by
running the command below, or navigate to
http://{HOSTNAME}/swagger-ui.html to execute the request from Swagger UI.

```shell
  $ curl -X POST -H 'Content-Type: text/plain' -d 'Hello from Partner Bank!' https://{HOSTNAME}/echo
```

6) Make a request to your Google point of contact to initiate the echo
API test from Google to the hosted echo endpoint. 