
import express from 'express';
import fetch from 'node-fetch';
import bodyParser from 'body-parser';
import ejs from 'ejs';
import cookieParser from 'cookie-parser'


import {config} from './config.cjs';

process.argv.forEach(function (val, index, array) {
  let values = val.split("=")
  if(values.length == 2 && values[0] == "client_id") {
    config.client_id = values[1]
  }
  if(values.length == 2 && values[0] == "client_secret") {
    config.client_secret = values[1]
  }
});

const client_id = config.client_id
const client_secret = config.client_secret

const app=express();
// Use the EJS template engine
app.set('view engine', 'ejs');
app.engine('ejs', ejs.__express);

// Disable browser-side caching for demo purposes.
app.disable('etag');


// Parse application/json request data.
app.use(bodyParser.json());

// Parse application/xwww-form-urlencoded request data.
app.use(bodyParser.urlencoded({extended: true}));

app.use(cookieParser());


const port=8080;


app.use(express.static('static'));


app.listen(port, () => {
  console.log(`Server is running on port ${port}`);
});



app.get('/', async (req, res) => {
  // res.cookie("doing_a_test", "true");
  // res.clearCookie("doing_a_test")

  res.render('pages/home');
});


app.get('/slideshow', async (req, res) => {
  res.render('pages/slideshow');
});

app.get('/settings', async (req, res) => {
  res.render('pages/settings');
});



app.get('/connect', async (req, res) => {

  if(req.cookies != null && req.cookies.device_info) {
    const device_info = JSON.parse(req.cookies.device_info)
    if(device_info.mediaSourcesSet) {
      res.redirect("/slideshow")
    } else {
      res.render('pages/step_3');      
    }
  } else if(req.cookies != null && req.cookies.access_data) {
    res.render('pages/step_2');
  } else {
    res.render('pages/step_1', {client_id: client_id});
  }

});


app.post('/access_data', (req, res) => {
  res.cookie("access_data", JSON.stringify(req.body))
  res.send({success: "OK"})
});

app.post('/device_info', (req, res) => {
  res.cookie("device_info", JSON.stringify(req.body))
  res.send({success: "OK"})
});



app.get('/clear_cookies', async (req, res) => {  
  res.clearCookie("access_data")
  res.clearCookie("device_info")
  res.render('pages/clear_cookies');
});


app.get('/session_expired', async (req, res) => {
  res.clearCookie("access_data")
  res.clearCookie("device_info")
  res.clearCookie("device_info")

  res.render('pages/session_expired');
});

app.get('/disconnect', async (req, res) => {
  res.clearCookie("access_data")
  res.clearCookie("device_info")
  res.render('pages/disconnect');
});






// This is a passthrough to the oauth2 token URL, but it adds the
// client_secret, which should NEVER be exposed to the end user.
// This call should be made on the limited input device, 
// and the client_secret should be hidden from the user.
app.get('/token', async (req, res) => {

  const response = fetch(`https://oauth2.googleapis.com/token`, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    body: JSON.stringify({
      client_id: client_id,
      client_secret: client_secret,
      device_code: req.query.device_code,
      grant_type: "urn:ietf:params:oauth:grant-type:device_code"
    }),
    json: true
  }).then((response) => response.json())
  .then((responseData) => {
    res.setHeader('Content-Type', 'application/json');
    res.end(JSON.stringify(responseData));
  })
  
  // Can catch oauth errors here.

});


