/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Request message for Verifications.VerifyLocation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VerifyLocationRequest extends com.google.api.client.json.GenericJson {

  /**
   * The input for ADDRESS method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AddressInput addressInput;

  /**
   * Extra context information for the verification of service businesses. Required for the
   * locations whose business type is CUSTOMER_LOCATION_ONLY. For ADDRESS verification, the address
   * will be used to send out postcard. For other methods, it should be the same as the one that is
   * passed to FetchVerificationOptions. INVALID_ARGUMENT will be thrown if it is set for other
   * types of business locations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ServiceBusinessContext context;

  /**
   * The input for EMAIL method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EmailInput emailInput;

  /**
   * The BCP 47 language code representing the language that is to be used for the verification
   * process.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String languageCode;

  /**
   * Verification method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String method;

  /**
   * The input for PHONE_CALL/SMS method
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PhoneInput phoneInput;

  /**
   * The input for ADDRESS method.
   * @return value or {@code null} for none
   */
  public AddressInput getAddressInput() {
    return addressInput;
  }

  /**
   * The input for ADDRESS method.
   * @param addressInput addressInput or {@code null} for none
   */
  public VerifyLocationRequest setAddressInput(AddressInput addressInput) {
    this.addressInput = addressInput;
    return this;
  }

  /**
   * Extra context information for the verification of service businesses. Required for the
   * locations whose business type is CUSTOMER_LOCATION_ONLY. For ADDRESS verification, the address
   * will be used to send out postcard. For other methods, it should be the same as the one that is
   * passed to FetchVerificationOptions. INVALID_ARGUMENT will be thrown if it is set for other
   * types of business locations.
   * @return value or {@code null} for none
   */
  public ServiceBusinessContext getContext() {
    return context;
  }

  /**
   * Extra context information for the verification of service businesses. Required for the
   * locations whose business type is CUSTOMER_LOCATION_ONLY. For ADDRESS verification, the address
   * will be used to send out postcard. For other methods, it should be the same as the one that is
   * passed to FetchVerificationOptions. INVALID_ARGUMENT will be thrown if it is set for other
   * types of business locations.
   * @param context context or {@code null} for none
   */
  public VerifyLocationRequest setContext(ServiceBusinessContext context) {
    this.context = context;
    return this;
  }

  /**
   * The input for EMAIL method.
   * @return value or {@code null} for none
   */
  public EmailInput getEmailInput() {
    return emailInput;
  }

  /**
   * The input for EMAIL method.
   * @param emailInput emailInput or {@code null} for none
   */
  public VerifyLocationRequest setEmailInput(EmailInput emailInput) {
    this.emailInput = emailInput;
    return this;
  }

  /**
   * The BCP 47 language code representing the language that is to be used for the verification
   * process.
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguageCode() {
    return languageCode;
  }

  /**
   * The BCP 47 language code representing the language that is to be used for the verification
   * process.
   * @param languageCode languageCode or {@code null} for none
   */
  public VerifyLocationRequest setLanguageCode(java.lang.String languageCode) {
    this.languageCode = languageCode;
    return this;
  }

  /**
   * Verification method.
   * @return value or {@code null} for none
   */
  public java.lang.String getMethod() {
    return method;
  }

  /**
   * Verification method.
   * @param method method or {@code null} for none
   */
  public VerifyLocationRequest setMethod(java.lang.String method) {
    this.method = method;
    return this;
  }

  /**
   * The input for PHONE_CALL/SMS method
   * @return value or {@code null} for none
   */
  public PhoneInput getPhoneInput() {
    return phoneInput;
  }

  /**
   * The input for PHONE_CALL/SMS method
   * @param phoneInput phoneInput or {@code null} for none
   */
  public VerifyLocationRequest setPhoneInput(PhoneInput phoneInput) {
    this.phoneInput = phoneInput;
    return this;
  }

  @Override
  public VerifyLocationRequest set(String fieldName, Object value) {
    return (VerifyLocationRequest) super.set(fieldName, value);
  }

  @Override
  public VerifyLocationRequest clone() {
    return (VerifyLocationRequest) super.clone();
  }

}
