/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Response message for Reviews.ListReviews.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListReviewsResponse extends com.google.api.client.json.GenericJson {

  /**
   * The average star rating of all reviews for this location on a scale of 1 to 5, where 5 is the
   * highest rating.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double averageRating;

  /**
   * If the number of reviews exceeded the requested page size, this field is populated with a token
   * to fetch the next page of reviews on a subsequent call to ListReviews. If there are no more
   * reviews, this field is not present in the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The reviews.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Review> reviews;

  /**
   * The total number of reviews for this location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer totalReviewCount;

  /**
   * The average star rating of all reviews for this location on a scale of 1 to 5, where 5 is the
   * highest rating.
   * @return value or {@code null} for none
   */
  public java.lang.Double getAverageRating() {
    return averageRating;
  }

  /**
   * The average star rating of all reviews for this location on a scale of 1 to 5, where 5 is the
   * highest rating.
   * @param averageRating averageRating or {@code null} for none
   */
  public ListReviewsResponse setAverageRating(java.lang.Double averageRating) {
    this.averageRating = averageRating;
    return this;
  }

  /**
   * If the number of reviews exceeded the requested page size, this field is populated with a token
   * to fetch the next page of reviews on a subsequent call to ListReviews. If there are no more
   * reviews, this field is not present in the response.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * If the number of reviews exceeded the requested page size, this field is populated with a token
   * to fetch the next page of reviews on a subsequent call to ListReviews. If there are no more
   * reviews, this field is not present in the response.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListReviewsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * The reviews.
   * @return value or {@code null} for none
   */
  public java.util.List<Review> getReviews() {
    return reviews;
  }

  /**
   * The reviews.
   * @param reviews reviews or {@code null} for none
   */
  public ListReviewsResponse setReviews(java.util.List<Review> reviews) {
    this.reviews = reviews;
    return this;
  }

  /**
   * The total number of reviews for this location.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTotalReviewCount() {
    return totalReviewCount;
  }

  /**
   * The total number of reviews for this location.
   * @param totalReviewCount totalReviewCount or {@code null} for none
   */
  public ListReviewsResponse setTotalReviewCount(java.lang.Integer totalReviewCount) {
    this.totalReviewCount = totalReviewCount;
    return this;
  }

  @Override
  public ListReviewsResponse set(String fieldName, Object value) {
    return (ListReviewsResponse) super.set(fieldName, value);
  }

  @Override
  public ListReviewsResponse clone() {
    return (ListReviewsResponse) super.clone();
  }

}
