/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Service area businesses provide their service at the customer's location (for example, a
 * locksmith or plumber).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ServiceAreaBusiness extends com.google.api.client.json.GenericJson {

  /**
   * Indicates the type of the service area business.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String businessType;

  /**
   * The area that this business serves defined through a set of places.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Places places;

  /**
   * Output only. The area that this business serves centered around a point.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PointRadius radius;

  /**
   * Indicates the type of the service area business.
   * @return value or {@code null} for none
   */
  public java.lang.String getBusinessType() {
    return businessType;
  }

  /**
   * Indicates the type of the service area business.
   * @param businessType businessType or {@code null} for none
   */
  public ServiceAreaBusiness setBusinessType(java.lang.String businessType) {
    this.businessType = businessType;
    return this;
  }

  /**
   * The area that this business serves defined through a set of places.
   * @return value or {@code null} for none
   */
  public Places getPlaces() {
    return places;
  }

  /**
   * The area that this business serves defined through a set of places.
   * @param places places or {@code null} for none
   */
  public ServiceAreaBusiness setPlaces(Places places) {
    this.places = places;
    return this;
  }

  /**
   * Output only. The area that this business serves centered around a point.
   * @return value or {@code null} for none
   */
  public PointRadius getRadius() {
    return radius;
  }

  /**
   * Output only. The area that this business serves centered around a point.
   * @param radius radius or {@code null} for none
   */
  public ServiceAreaBusiness setRadius(PointRadius radius) {
    this.radius = radius;
    return this;
  }

  @Override
  public ServiceAreaBusiness set(String fieldName, Object value) {
    return (ServiceAreaBusiness) super.set(fieldName, value);
  }

  @Override
  public ServiceAreaBusiness clone() {
    return (ServiceAreaBusiness) super.clone();
  }

}
