/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Response message for Locations.ListLocations.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListLocationsResponse extends com.google.api.client.json.GenericJson {

  /**
   * The locations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Location> locations;

  static {
    // hack to force ProGuard to consider Location used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Location.class);
  }

  /**
   * If the number of locations exceeded the requested page size, this field is populated with a
   * token to fetch the next page of locations on a subsequent call to `ListLocations`. If there are
   * no more locations, this field is not present in the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The approximate number of Locations in the list irrespective of pagination.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer totalSize;

  /**
   * The locations.
   * @return value or {@code null} for none
   */
  public java.util.List<Location> getLocations() {
    return locations;
  }

  /**
   * The locations.
   * @param locations locations or {@code null} for none
   */
  public ListLocationsResponse setLocations(java.util.List<Location> locations) {
    this.locations = locations;
    return this;
  }

  /**
   * If the number of locations exceeded the requested page size, this field is populated with a
   * token to fetch the next page of locations on a subsequent call to `ListLocations`. If there are
   * no more locations, this field is not present in the response.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * If the number of locations exceeded the requested page size, this field is populated with a
   * token to fetch the next page of locations on a subsequent call to `ListLocations`. If there are
   * no more locations, this field is not present in the response.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListLocationsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * The approximate number of Locations in the list irrespective of pagination.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTotalSize() {
    return totalSize;
  }

  /**
   * The approximate number of Locations in the list irrespective of pagination.
   * @param totalSize totalSize or {@code null} for none
   */
  public ListLocationsResponse setTotalSize(java.lang.Integer totalSize) {
    this.totalSize = totalSize;
    return this;
  }

  @Override
  public ListLocationsResponse set(String fieldName, Object value) {
    return (ListLocationsResponse) super.set(fieldName, value);
  }

  @Override
  public ListLocationsResponse clone() {
    return (ListLocationsResponse) super.clone();
  }

}
