/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * The ways in which the property provides guests with the ability to access the internet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Connectivity extends com.google.api.client.json.GenericJson {

  /**
   * Free wifi. The hotel offers guests wifi for free.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean freeWifi;

  /**
   * Free wifi exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String freeWifiException;

  /**
   * Public area wifi available. Guests have the ability to wirelessly connect to the internet in
   * the areas of the hotel accessible to anyone. Can be free or for a fee.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean publicAreaWifiAvailable;

  /**
   * Public area wifi available exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String publicAreaWifiAvailableException;

  /**
   * Public internet terminal. An area of the hotel supplied with computers and designated for the
   * purpose of providing guests with the ability to access the internet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean publicInternetTerminal;

  /**
   * Public internet terminal exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String publicInternetTerminalException;

  /**
   * Wifi available. The hotel provides the ability for guests to wirelessly connect to the
   * internet. Can be in the public areas of the hotel and/or in the guest rooms. Can be free or for
   * a fee.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean wifiAvailable;

  /**
   * Wifi available exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String wifiAvailableException;

  /**
   * Free wifi. The hotel offers guests wifi for free.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getFreeWifi() {
    return freeWifi;
  }

  /**
   * Free wifi. The hotel offers guests wifi for free.
   * @param freeWifi freeWifi or {@code null} for none
   */
  public Connectivity setFreeWifi(java.lang.Boolean freeWifi) {
    this.freeWifi = freeWifi;
    return this;
  }

  /**
   * Free wifi exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getFreeWifiException() {
    return freeWifiException;
  }

  /**
   * Free wifi exception.
   * @param freeWifiException freeWifiException or {@code null} for none
   */
  public Connectivity setFreeWifiException(java.lang.String freeWifiException) {
    this.freeWifiException = freeWifiException;
    return this;
  }

  /**
   * Public area wifi available. Guests have the ability to wirelessly connect to the internet in
   * the areas of the hotel accessible to anyone. Can be free or for a fee.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPublicAreaWifiAvailable() {
    return publicAreaWifiAvailable;
  }

  /**
   * Public area wifi available. Guests have the ability to wirelessly connect to the internet in
   * the areas of the hotel accessible to anyone. Can be free or for a fee.
   * @param publicAreaWifiAvailable publicAreaWifiAvailable or {@code null} for none
   */
  public Connectivity setPublicAreaWifiAvailable(java.lang.Boolean publicAreaWifiAvailable) {
    this.publicAreaWifiAvailable = publicAreaWifiAvailable;
    return this;
  }

  /**
   * Public area wifi available exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getPublicAreaWifiAvailableException() {
    return publicAreaWifiAvailableException;
  }

  /**
   * Public area wifi available exception.
   * @param publicAreaWifiAvailableException publicAreaWifiAvailableException or {@code null} for none
   */
  public Connectivity setPublicAreaWifiAvailableException(java.lang.String publicAreaWifiAvailableException) {
    this.publicAreaWifiAvailableException = publicAreaWifiAvailableException;
    return this;
  }

  /**
   * Public internet terminal. An area of the hotel supplied with computers and designated for the
   * purpose of providing guests with the ability to access the internet.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPublicInternetTerminal() {
    return publicInternetTerminal;
  }

  /**
   * Public internet terminal. An area of the hotel supplied with computers and designated for the
   * purpose of providing guests with the ability to access the internet.
   * @param publicInternetTerminal publicInternetTerminal or {@code null} for none
   */
  public Connectivity setPublicInternetTerminal(java.lang.Boolean publicInternetTerminal) {
    this.publicInternetTerminal = publicInternetTerminal;
    return this;
  }

  /**
   * Public internet terminal exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getPublicInternetTerminalException() {
    return publicInternetTerminalException;
  }

  /**
   * Public internet terminal exception.
   * @param publicInternetTerminalException publicInternetTerminalException or {@code null} for none
   */
  public Connectivity setPublicInternetTerminalException(java.lang.String publicInternetTerminalException) {
    this.publicInternetTerminalException = publicInternetTerminalException;
    return this;
  }

  /**
   * Wifi available. The hotel provides the ability for guests to wirelessly connect to the
   * internet. Can be in the public areas of the hotel and/or in the guest rooms. Can be free or for
   * a fee.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getWifiAvailable() {
    return wifiAvailable;
  }

  /**
   * Wifi available. The hotel provides the ability for guests to wirelessly connect to the
   * internet. Can be in the public areas of the hotel and/or in the guest rooms. Can be free or for
   * a fee.
   * @param wifiAvailable wifiAvailable or {@code null} for none
   */
  public Connectivity setWifiAvailable(java.lang.Boolean wifiAvailable) {
    this.wifiAvailable = wifiAvailable;
    return this;
  }

  /**
   * Wifi available exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getWifiAvailableException() {
    return wifiAvailableException;
  }

  /**
   * Wifi available exception.
   * @param wifiAvailableException wifiAvailableException or {@code null} for none
   */
  public Connectivity setWifiAvailableException(java.lang.String wifiAvailableException) {
    this.wifiAvailableException = wifiAvailableException;
    return this;
  }

  @Override
  public Connectivity set(String fieldName, Object value) {
    return (Connectivity) super.set(fieldName, value);
  }

  @Override
  public Connectivity clone() {
    return (Connectivity) super.clone();
  }

}
