/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * A verification represents a verification attempt on a location.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Verification extends com.google.api.client.json.GenericJson {

  /**
   * The timestamp when the verification is requested.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * The method of the verification.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String method;

  /**
   * Resource name of the verification.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The state of the verification.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * The timestamp when the verification is requested.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * The timestamp when the verification is requested.
   * @param createTime createTime or {@code null} for none
   */
  public Verification setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * The method of the verification.
   * @return value or {@code null} for none
   */
  public java.lang.String getMethod() {
    return method;
  }

  /**
   * The method of the verification.
   * @param method method or {@code null} for none
   */
  public Verification setMethod(java.lang.String method) {
    this.method = method;
    return this;
  }

  /**
   * Resource name of the verification.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Resource name of the verification.
   * @param name name or {@code null} for none
   */
  public Verification setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The state of the verification.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * The state of the verification.
   * @param state state or {@code null} for none
   */
  public Verification setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  @Override
  public Verification set(String fieldName, Object value) {
    return (Verification) super.set(fieldName, value);
  }

  @Override
  public Verification clone() {
    return (Verification) super.clone();
  }

}
