/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Represents the author of the review.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Reviewer extends com.google.api.client.json.GenericJson {

  /**
   * The name of the reviewer. Only populated with the reviewer's real name if `is_anonymous` is
   * false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Indicates whether the reviewer has opted to remain anonymous.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isAnonymous;

  /**
   * The profile photo link of the reviewer. Only populated if `is_anonymous` is false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String profilePhotoUrl;

  /**
   * The name of the reviewer. Only populated with the reviewer's real name if `is_anonymous` is
   * false.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * The name of the reviewer. Only populated with the reviewer's real name if `is_anonymous` is
   * false.
   * @param displayName displayName or {@code null} for none
   */
  public Reviewer setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Indicates whether the reviewer has opted to remain anonymous.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsAnonymous() {
    return isAnonymous;
  }

  /**
   * Indicates whether the reviewer has opted to remain anonymous.
   * @param isAnonymous isAnonymous or {@code null} for none
   */
  public Reviewer setIsAnonymous(java.lang.Boolean isAnonymous) {
    this.isAnonymous = isAnonymous;
    return this;
  }

  /**
   * The profile photo link of the reviewer. Only populated if `is_anonymous` is false.
   * @return value or {@code null} for none
   */
  public java.lang.String getProfilePhotoUrl() {
    return profilePhotoUrl;
  }

  /**
   * The profile photo link of the reviewer. Only populated if `is_anonymous` is false.
   * @param profilePhotoUrl profilePhotoUrl or {@code null} for none
   */
  public Reviewer setProfilePhotoUrl(java.lang.String profilePhotoUrl) {
    this.profilePhotoUrl = profilePhotoUrl;
    return this;
  }

  @Override
  public Reviewer set(String fieldName, Object value) {
    return (Reviewer) super.set(fieldName, value);
  }

  @Override
  public Reviewer clone() {
    return (Reviewer) super.clone();
  }

}
