/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Request message for Insights.ReportLocationInsights.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReportLocationInsightsRequest extends com.google.api.client.json.GenericJson {

  /**
   * A request to include basic metric insights in the report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BasicMetricsRequest basicRequest;

  /**
   * A request to include insights about driving-direction requests in the report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DrivingDirectionMetricsRequest drivingDirectionsRequest;

  /**
   * A collection of locations to fetch insights for, specified by their names.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> locationNames;

  /**
   * A request to include basic metric insights in the report.
   * @return value or {@code null} for none
   */
  public BasicMetricsRequest getBasicRequest() {
    return basicRequest;
  }

  /**
   * A request to include basic metric insights in the report.
   * @param basicRequest basicRequest or {@code null} for none
   */
  public ReportLocationInsightsRequest setBasicRequest(BasicMetricsRequest basicRequest) {
    this.basicRequest = basicRequest;
    return this;
  }

  /**
   * A request to include insights about driving-direction requests in the report.
   * @return value or {@code null} for none
   */
  public DrivingDirectionMetricsRequest getDrivingDirectionsRequest() {
    return drivingDirectionsRequest;
  }

  /**
   * A request to include insights about driving-direction requests in the report.
   * @param drivingDirectionsRequest drivingDirectionsRequest or {@code null} for none
   */
  public ReportLocationInsightsRequest setDrivingDirectionsRequest(DrivingDirectionMetricsRequest drivingDirectionsRequest) {
    this.drivingDirectionsRequest = drivingDirectionsRequest;
    return this;
  }

  /**
   * A collection of locations to fetch insights for, specified by their names.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getLocationNames() {
    return locationNames;
  }

  /**
   * A collection of locations to fetch insights for, specified by their names.
   * @param locationNames locationNames or {@code null} for none
   */
  public ReportLocationInsightsRequest setLocationNames(java.util.List<java.lang.String> locationNames) {
    this.locationNames = locationNames;
    return this;
  }

  @Override
  public ReportLocationInsightsRequest set(String fieldName, Object value) {
    return (ReportLocationInsightsRequest) super.set(fieldName, value);
  }

  @Override
  public ReportLocationInsightsRequest clone() {
    return (ReportLocationInsightsRequest) super.clone();
  }

}
