/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * This message denotes calories information with an upper bound and lower bound range. Lower amount
 * must be specified. Both lower and upper amounts are non-negative numbers.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CaloriesFact extends com.google.api.client.json.GenericJson {

  /**
   * Required. Lower amount of calories
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer lowerAmount;

  /**
   * Required. Unit of the given calories information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String unit;

  /**
   * Optional. Upper amount of calories
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer upperAmount;

  /**
   * Required. Lower amount of calories
   * @return value or {@code null} for none
   */
  public java.lang.Integer getLowerAmount() {
    return lowerAmount;
  }

  /**
   * Required. Lower amount of calories
   * @param lowerAmount lowerAmount or {@code null} for none
   */
  public CaloriesFact setLowerAmount(java.lang.Integer lowerAmount) {
    this.lowerAmount = lowerAmount;
    return this;
  }

  /**
   * Required. Unit of the given calories information.
   * @return value or {@code null} for none
   */
  public java.lang.String getUnit() {
    return unit;
  }

  /**
   * Required. Unit of the given calories information.
   * @param unit unit or {@code null} for none
   */
  public CaloriesFact setUnit(java.lang.String unit) {
    this.unit = unit;
    return this;
  }

  /**
   * Optional. Upper amount of calories
   * @return value or {@code null} for none
   */
  public java.lang.Integer getUpperAmount() {
    return upperAmount;
  }

  /**
   * Optional. Upper amount of calories
   * @param upperAmount upperAmount or {@code null} for none
   */
  public CaloriesFact setUpperAmount(java.lang.Integer upperAmount) {
    this.upperAmount = upperAmount;
    return this;
  }

  @Override
  public CaloriesFact set(String fieldName, Object value) {
    return (CaloriesFact) super.set(fieldName, value);
  }

  @Override
  public CaloriesFact clone() {
    return (CaloriesFact) super.clone();
  }

}
