/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * Modify at your own risk.
 */

package com.google.api.services.rcsbusinessmessaging.v1.model;

/**
 * A media file within a rich card.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the RCS Business Messaging API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Media extends com.google.api.client.json.GenericJson {

  /**
   * Information about a file, including the URL of the file and the URL of the file’s thumbnail.
   *
   * The RBM platform serves content from a cache, but an agent can force the RBM platform to fetch
   * a new version of the content and refresh the cache.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ContentInfo contentInfo;

  /**
   * The unique name of the file, returned by the RBM platform when the file was uploaded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fileName;

  /**
   * The height of the media within a rich card with a vertical layout. For a standalone card with
   * horizontal layout, height is not customizable, and this field is ignored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String height;

  /**
   * Information about a file, including the URL of the file and the URL of the file’s thumbnail.
   *
   * The RBM platform serves content from a cache, but an agent can force the RBM platform to fetch
   * a new version of the content and refresh the cache.
   * @return value or {@code null} for none
   */
  public ContentInfo getContentInfo() {
    return contentInfo;
  }

  /**
   * Information about a file, including the URL of the file and the URL of the file’s thumbnail.
   *
   * The RBM platform serves content from a cache, but an agent can force the RBM platform to fetch
   * a new version of the content and refresh the cache.
   * @param contentInfo contentInfo or {@code null} for none
   */
  public Media setContentInfo(ContentInfo contentInfo) {
    this.contentInfo = contentInfo;
    return this;
  }

  /**
   * The unique name of the file, returned by the RBM platform when the file was uploaded.
   * @return value or {@code null} for none
   */
  public java.lang.String getFileName() {
    return fileName;
  }

  /**
   * The unique name of the file, returned by the RBM platform when the file was uploaded.
   * @param fileName fileName or {@code null} for none
   */
  public Media setFileName(java.lang.String fileName) {
    this.fileName = fileName;
    return this;
  }

  /**
   * The height of the media within a rich card with a vertical layout. For a standalone card with
   * horizontal layout, height is not customizable, and this field is ignored.
   * @return value or {@code null} for none
   */
  public java.lang.String getHeight() {
    return height;
  }

  /**
   * The height of the media within a rich card with a vertical layout. For a standalone card with
   * horizontal layout, height is not customizable, and this field is ignored.
   * @param height height or {@code null} for none
   */
  public Media setHeight(java.lang.String height) {
    this.height = height;
    return this;
  }

  @Override
  public Media set(String fieldName, Object value) {
    return (Media) super.set(fieldName, value);
  }

  @Override
  public Media clone() {
    return (Media) super.clone();
  }

}
