/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * Modify at your own risk.
 */

package com.google.api.services.rcsbusinessmessaging.v1.model;

/**
 * Parameters specific to media downloads.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the RCS Business Messaging API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GdataDownloadParameters extends com.google.api.client.json.GenericJson {

  /**
   * A boolean to be returned in the response to Scotty. Allows/disallows gzip encoding of the
   * payload content when the server thinks it's advantageous (hence, does not guarantee
   * compression) which allows Scotty to GZip the response to the client.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean allowGzipCompression;

  /**
   * Determining whether or not Apiary should skip the inclusion of any Content-Range header on its
   * response to Scotty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean ignoreRange;

  /**
   * A boolean to be returned in the response to Scotty. Allows/disallows gzip encoding of the
   * payload content when the server thinks it's advantageous (hence, does not guarantee
   * compression) which allows Scotty to GZip the response to the client.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAllowGzipCompression() {
    return allowGzipCompression;
  }

  /**
   * A boolean to be returned in the response to Scotty. Allows/disallows gzip encoding of the
   * payload content when the server thinks it's advantageous (hence, does not guarantee
   * compression) which allows Scotty to GZip the response to the client.
   * @param allowGzipCompression allowGzipCompression or {@code null} for none
   */
  public GdataDownloadParameters setAllowGzipCompression(java.lang.Boolean allowGzipCompression) {
    this.allowGzipCompression = allowGzipCompression;
    return this;
  }

  /**
   * Determining whether or not Apiary should skip the inclusion of any Content-Range header on its
   * response to Scotty.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIgnoreRange() {
    return ignoreRange;
  }

  /**
   * Determining whether or not Apiary should skip the inclusion of any Content-Range header on its
   * response to Scotty.
   * @param ignoreRange ignoreRange or {@code null} for none
   */
  public GdataDownloadParameters setIgnoreRange(java.lang.Boolean ignoreRange) {
    this.ignoreRange = ignoreRange;
    return this;
  }

  @Override
  public GdataDownloadParameters set(String fieldName, Object value) {
    return (GdataDownloadParameters) super.set(fieldName, value);
  }

  @Override
  public GdataDownloadParameters clone() {
    return (GdataDownloadParameters) super.clone();
  }

}
