/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * Modify at your own risk.
 */

package com.google.api.services.rcsbusinessmessaging.v1.model;

/**
 * Backend response for a Diff upload request. For details on the Scotty Diff protocol, visit
 * http://go/scotty-diff-protocol.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the RCS Business Messaging API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GdataDiffUploadResponse extends com.google.api.client.json.GenericJson {

  /**
   * The object version of the object at the server. Must be included in the end notification
   * response. The version in the end notification response must correspond to the new version of
   * the object that is now stored at the server, after the upload.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectVersion;

  /**
   * The location of the original file for a diff upload request. Must be filled in if responding to
   * an upload start notification.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GdataCompositeMedia originalObject;

  /**
   * The object version of the object at the server. Must be included in the end notification
   * response. The version in the end notification response must correspond to the new version of
   * the object that is now stored at the server, after the upload.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectVersion() {
    return objectVersion;
  }

  /**
   * The object version of the object at the server. Must be included in the end notification
   * response. The version in the end notification response must correspond to the new version of
   * the object that is now stored at the server, after the upload.
   * @param objectVersion objectVersion or {@code null} for none
   */
  public GdataDiffUploadResponse setObjectVersion(java.lang.String objectVersion) {
    this.objectVersion = objectVersion;
    return this;
  }

  /**
   * The location of the original file for a diff upload request. Must be filled in if responding to
   * an upload start notification.
   * @return value or {@code null} for none
   */
  public GdataCompositeMedia getOriginalObject() {
    return originalObject;
  }

  /**
   * The location of the original file for a diff upload request. Must be filled in if responding to
   * an upload start notification.
   * @param originalObject originalObject or {@code null} for none
   */
  public GdataDiffUploadResponse setOriginalObject(GdataCompositeMedia originalObject) {
    this.originalObject = originalObject;
    return this;
  }

  @Override
  public GdataDiffUploadResponse set(String fieldName, Object value) {
    return (GdataDiffUploadResponse) super.set(fieldName, value);
  }

  @Override
  public GdataDiffUploadResponse clone() {
    return (GdataDiffUploadResponse) super.clone();
  }

}
