/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * Modify at your own risk.
 */

package com.google.api.services.rcsbusinessmessaging.v1.model;

/**
 * An event from the agent to the user.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the RCS Business Messaging API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AgentEvent extends com.google.api.client.json.GenericJson {

  /**
   * The type of the agent event.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String eventType;

  /**
   * The ID of the user message that the agent event pertains to. This field is only applicable for
   * agent events of type READ.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String messageId;

  /**
   * This field is set by the RBM platform. Do not include it when creating an agent event. The
   * field resolves "phones/{E.164}/agentEvents/{eventId}", where {E.164} is the user's phone number
   * in E.164 format and {eventId} is the agent-assigned ID of the agent event.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * This field is set by the RBM platform. Do not include it when creating an agent message. The
   * field resolves the time when the event is sent to the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String sendTime;

  /**
   * The type of the agent event.
   * @return value or {@code null} for none
   */
  public java.lang.String getEventType() {
    return eventType;
  }

  /**
   * The type of the agent event.
   * @param eventType eventType or {@code null} for none
   */
  public AgentEvent setEventType(java.lang.String eventType) {
    this.eventType = eventType;
    return this;
  }

  /**
   * The ID of the user message that the agent event pertains to. This field is only applicable for
   * agent events of type READ.
   * @return value or {@code null} for none
   */
  public java.lang.String getMessageId() {
    return messageId;
  }

  /**
   * The ID of the user message that the agent event pertains to. This field is only applicable for
   * agent events of type READ.
   * @param messageId messageId or {@code null} for none
   */
  public AgentEvent setMessageId(java.lang.String messageId) {
    this.messageId = messageId;
    return this;
  }

  /**
   * This field is set by the RBM platform. Do not include it when creating an agent event. The
   * field resolves "phones/{E.164}/agentEvents/{eventId}", where {E.164} is the user's phone number
   * in E.164 format and {eventId} is the agent-assigned ID of the agent event.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * This field is set by the RBM platform. Do not include it when creating an agent event. The
   * field resolves "phones/{E.164}/agentEvents/{eventId}", where {E.164} is the user's phone number
   * in E.164 format and {eventId} is the agent-assigned ID of the agent event.
   * @param name name or {@code null} for none
   */
  public AgentEvent setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * This field is set by the RBM platform. Do not include it when creating an agent message. The
   * field resolves the time when the event is sent to the user.
   * @return value or {@code null} for none
   */
  public String getSendTime() {
    return sendTime;
  }

  /**
   * This field is set by the RBM platform. Do not include it when creating an agent message. The
   * field resolves the time when the event is sent to the user.
   * @param sendTime sendTime or {@code null} for none
   */
  public AgentEvent setSendTime(String sendTime) {
    this.sendTime = sendTime;
    return this;
  }

  @Override
  public AgentEvent set(String fieldName, Object value) {
    return (AgentEvent) super.set(fieldName, value);
  }

  @Override
  public AgentEvent clone() {
    return (AgentEvent) super.clone();
  }

}
