/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * Modify at your own risk.
 */

package com.google.api.services.rcsbusinessmessaging.v1.model;

/**
 * A line item in a payment request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the RCS Business Messaging API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LineItem extends com.google.api.client.json.GenericJson {

  /**
   * The amount of the line item. SECONDARY line items may have a negative amount.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Money amount;

  /**
   * The text for a line item. For example, "Total due".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String label;

  /**
   * (Optional) Text that is displayed in a smaller font below the line item label.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subText;

  /**
   * The line item type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The amount of the line item. SECONDARY line items may have a negative amount.
   * @return value or {@code null} for none
   */
  public Money getAmount() {
    return amount;
  }

  /**
   * The amount of the line item. SECONDARY line items may have a negative amount.
   * @param amount amount or {@code null} for none
   */
  public LineItem setAmount(Money amount) {
    this.amount = amount;
    return this;
  }

  /**
   * The text for a line item. For example, "Total due".
   * @return value or {@code null} for none
   */
  public java.lang.String getLabel() {
    return label;
  }

  /**
   * The text for a line item. For example, "Total due".
   * @param label label or {@code null} for none
   */
  public LineItem setLabel(java.lang.String label) {
    this.label = label;
    return this;
  }

  /**
   * (Optional) Text that is displayed in a smaller font below the line item label.
   * @return value or {@code null} for none
   */
  public java.lang.String getSubText() {
    return subText;
  }

  /**
   * (Optional) Text that is displayed in a smaller font below the line item label.
   * @param subText subText or {@code null} for none
   */
  public LineItem setSubText(java.lang.String subText) {
    this.subText = subText;
    return this;
  }

  /**
   * The line item type.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The line item type.
   * @param type type or {@code null} for none
   */
  public LineItem setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public LineItem set(String fieldName, Object value) {
    return (LineItem) super.set(fieldName, value);
  }

  @Override
  public LineItem clone() {
    return (LineItem) super.clone();
  }

}
