/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * Modify at your own risk.
 */

package com.google.api.services.rcsbusinessmessaging.v1.model;

/**
 * Extra information added to operations that support Scotty media requests.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the RCS Business Messaging API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MediaRequestInfo extends com.google.api.client.json.GenericJson {

  /**
   * The number of current bytes uploaded or downloaded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long currentBytes;

  /**
   * Data to be copied to backend requests. Custom data is returned to Scotty in the agent_state
   * field, which Scotty will then provide in subsequent upload notifications.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customData;

  /**
   * Set if the http request info is diff encoded. The value of this field is the version number of
   * the base revision. This is corresponding to Apiary's mediaDiffObjectVersion
   * (//depot/google3/java/com/google/api/server/media/variable/DiffObjectVersionVariable.java). See
   * go/esf-scotty-diff-upload for more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String diffObjectVersion;

  /**
   * The type of notification received from Scotty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String notificationType;

  /**
   * The Scotty request ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String requestId;

  /**
   * The total size of the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long totalBytes;

  /**
   * Whether the total bytes field contains an estimated data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean totalBytesIsEstimated;

  /**
   * The number of current bytes uploaded or downloaded.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCurrentBytes() {
    return currentBytes;
  }

  /**
   * The number of current bytes uploaded or downloaded.
   * @param currentBytes currentBytes or {@code null} for none
   */
  public MediaRequestInfo setCurrentBytes(java.lang.Long currentBytes) {
    this.currentBytes = currentBytes;
    return this;
  }

  /**
   * Data to be copied to backend requests. Custom data is returned to Scotty in the agent_state
   * field, which Scotty will then provide in subsequent upload notifications.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomData() {
    return customData;
  }

  /**
   * Data to be copied to backend requests. Custom data is returned to Scotty in the agent_state
   * field, which Scotty will then provide in subsequent upload notifications.
   * @param customData customData or {@code null} for none
   */
  public MediaRequestInfo setCustomData(java.lang.String customData) {
    this.customData = customData;
    return this;
  }

  /**
   * Set if the http request info is diff encoded. The value of this field is the version number of
   * the base revision. This is corresponding to Apiary's mediaDiffObjectVersion
   * (//depot/google3/java/com/google/api/server/media/variable/DiffObjectVersionVariable.java). See
   * go/esf-scotty-diff-upload for more information.
   * @return value or {@code null} for none
   */
  public java.lang.String getDiffObjectVersion() {
    return diffObjectVersion;
  }

  /**
   * Set if the http request info is diff encoded. The value of this field is the version number of
   * the base revision. This is corresponding to Apiary's mediaDiffObjectVersion
   * (//depot/google3/java/com/google/api/server/media/variable/DiffObjectVersionVariable.java). See
   * go/esf-scotty-diff-upload for more information.
   * @param diffObjectVersion diffObjectVersion or {@code null} for none
   */
  public MediaRequestInfo setDiffObjectVersion(java.lang.String diffObjectVersion) {
    this.diffObjectVersion = diffObjectVersion;
    return this;
  }

  /**
   * The type of notification received from Scotty.
   * @return value or {@code null} for none
   */
  public java.lang.String getNotificationType() {
    return notificationType;
  }

  /**
   * The type of notification received from Scotty.
   * @param notificationType notificationType or {@code null} for none
   */
  public MediaRequestInfo setNotificationType(java.lang.String notificationType) {
    this.notificationType = notificationType;
    return this;
  }

  /**
   * The Scotty request ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getRequestId() {
    return requestId;
  }

  /**
   * The Scotty request ID.
   * @param requestId requestId or {@code null} for none
   */
  public MediaRequestInfo setRequestId(java.lang.String requestId) {
    this.requestId = requestId;
    return this;
  }

  /**
   * The total size of the file.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTotalBytes() {
    return totalBytes;
  }

  /**
   * The total size of the file.
   * @param totalBytes totalBytes or {@code null} for none
   */
  public MediaRequestInfo setTotalBytes(java.lang.Long totalBytes) {
    this.totalBytes = totalBytes;
    return this;
  }

  /**
   * Whether the total bytes field contains an estimated data.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getTotalBytesIsEstimated() {
    return totalBytesIsEstimated;
  }

  /**
   * Whether the total bytes field contains an estimated data.
   * @param totalBytesIsEstimated totalBytesIsEstimated or {@code null} for none
   */
  public MediaRequestInfo setTotalBytesIsEstimated(java.lang.Boolean totalBytesIsEstimated) {
    this.totalBytesIsEstimated = totalBytesIsEstimated;
    return this;
  }

  @Override
  public MediaRequestInfo set(String fieldName, Object value) {
    return (MediaRequestInfo) super.set(fieldName, value);
  }

  @Override
  public MediaRequestInfo clone() {
    return (MediaRequestInfo) super.clone();
  }

}
