/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * Modify at your own risk.
 */

package com.google.api.services.rcsbusinessmessaging.v1.model;

/**
 * A reference to data stored on the filesystem, on GFS or in blobstore.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the RCS Business Messaging API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GdataMedia extends com.google.api.client.json.GenericJson {

  /**
   * Deprecated, use one of explicit hash type fields instead. Algorithm used for calculating the
   * hash. As of 2011/01/21, "MD5" is the only possible value for this field. New values may be
   * added at any time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String algorithm;

  /**
   * Use object_id instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bigstoreObjectRef;

  /**
   * Blobstore v1 reference, set if reference_type is BLOBSTORE_REF This should be the byte
   * representation of a blobstore.BlobRef. Since Blobstore is deprecating v1, use blobstore2_info
   * instead. For now, any v2 blob will also be represented in this field as v1 BlobRef.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String blobRef;

  /**
   * Blobstore v2 info, set if reference_type is BLOBSTORE_REF and it refers to a v2 blob.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GdataBlobstore2Info blobstore2Info;

  /**
   * A composite media composed of one or more media objects, set if reference_type is
   * COMPOSITE_MEDIA. The media length field must be set to the sum of the lengths of all composite
   * media objects.
   *
   * Note: All composite media must have length specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GdataCompositeMedia> compositeMedia;

  /**
   * MIME type of the data
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String contentType;

  /**
   * Extended content type information provided for Scotty uploads.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GdataContentTypeInfo contentTypeInfo;

  /**
   * A binary data reference for a media download. Serves as a technology-agnostic binary reference
   * in some Google infrastructure. This value is a serialized storage_cosmo.BinaryReference proto.
   * Storing it as bytes is a hack to get around the fact that the cosmo proto (as well as others it
   * includes) doesn't support JavaScript. This prevents us from including the actual type of this
   * field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cosmoBinaryReference;

  /**
   * For Scotty Uploads: Scotty-provided hashes for uploads
   *
   * For Scotty Downloads: (WARNING: DO NOT USE WITHOUT PERMISSION FROM THE SCOTTY TEAM.) A Hash
   * provided by the agent to be used to verify the data being downloaded. Currently only supported
   * for inline payloads. Further, only crc32c_hash is currently supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long crc32cHash;

  /**
   * Set if reference_type is DIFF_CHECKSUMS_RESPONSE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GdataDiffChecksumsResponse diffChecksumsResponse;

  /**
   * Set if reference_type is DIFF_DOWNLOAD_RESPONSE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GdataDiffDownloadResponse diffDownloadResponse;

  /**
   * Set if reference_type is DIFF_UPLOAD_REQUEST.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GdataDiffUploadRequest diffUploadRequest;

  /**
   * Set if reference_type is DIFF_UPLOAD_RESPONSE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GdataDiffUploadResponse diffUploadResponse;

  /**
   * Set if reference_type is DIFF_VERSION_RESPONSE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GdataDiffVersionResponse diffVersionResponse;

  /**
   * Parameters for a media download.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GdataDownloadParameters downloadParameters;

  /**
   * Original file name
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String filename;

  /**
   * Deprecated, use one of explicit hash type fields instead. These two hash related fields will
   * only be populated on Scotty based media uploads and will contain the content of the hash group
   * in the NotificationRequest:
   * https://cs/#google3/uploader/service/proto/upload_listener.proto=class:Hash Hex encoded hash
   * value of the uploaded media.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hash;

  /**
   * For Scotty uploads only. If a user sends a hash code and the backend has requested that Scotty
   * verify the upload against the client hash, Scotty will perform the check on behalf of the
   * backend and will reject it if the hashes don't match. This is set to true if Scotty performed
   * this verification.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hashVerified;

  /**
   * Media data, set if reference_type is INLINE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String inline;

  /**
   * |is_potential_retry| is set false only when Scotty is certain that it has not sent the request
   * before. When a client resumes an upload, this field must be set true in agent calls, because
   * Scotty cannot be certain that it has never sent the request before due to potential failure in
   * the session state persistence.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isPotentialRetry;

  /**
   * Size of the data, in bytes
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long length;

  /**
   * Scotty-provided MD5 hash for an upload.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String md5Hash;

  /**
   * Media id to forward to the operation GetMedia. Can be set if reference_type is GET_MEDIA.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mediaId;

  /**
   * Reference to a TI Blob, set if reference_type is BIGSTORE_REF.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GdataObjectId objectId;

  /**
   * Path to the data, set if reference_type is PATH
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String path;

  /**
   * Describes what the field reference contains.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String referenceType;

  /**
   * Scotty-provided SHA1 hash for an upload.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sha1Hash;

  /**
   * Scotty-provided SHA256 hash for an upload.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sha256Hash;

  /**
   * Time at which the media data was last updated, in milliseconds since UNIX epoch
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger timestamp;

  /**
   * A unique fingerprint/version id for the media data
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String token;

  /**
   * Deprecated, use one of explicit hash type fields instead. Algorithm used for calculating the
   * hash. As of 2011/01/21, "MD5" is the only possible value for this field. New values may be
   * added at any time.
   * @return value or {@code null} for none
   */
  public java.lang.String getAlgorithm() {
    return algorithm;
  }

  /**
   * Deprecated, use one of explicit hash type fields instead. Algorithm used for calculating the
   * hash. As of 2011/01/21, "MD5" is the only possible value for this field. New values may be
   * added at any time.
   * @param algorithm algorithm or {@code null} for none
   */
  public GdataMedia setAlgorithm(java.lang.String algorithm) {
    this.algorithm = algorithm;
    return this;
  }

  /**
   * Use object_id instead.
   * @see #decodeBigstoreObjectRef()
   * @return value or {@code null} for none
   */
  public java.lang.String getBigstoreObjectRef() {
    return bigstoreObjectRef;
  }

  /**
   * Use object_id instead.
   * @see #getBigstoreObjectRef()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeBigstoreObjectRef() {
    return com.google.api.client.util.Base64.decodeBase64(bigstoreObjectRef);
  }

  /**
   * Use object_id instead.
   * @see #encodeBigstoreObjectRef()
   * @param bigstoreObjectRef bigstoreObjectRef or {@code null} for none
   */
  public GdataMedia setBigstoreObjectRef(java.lang.String bigstoreObjectRef) {
    this.bigstoreObjectRef = bigstoreObjectRef;
    return this;
  }

  /**
   * Use object_id instead.
   * @see #setBigstoreObjectRef()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public GdataMedia encodeBigstoreObjectRef(byte[] bigstoreObjectRef) {
    this.bigstoreObjectRef = com.google.api.client.util.Base64.encodeBase64URLSafeString(bigstoreObjectRef);
    return this;
  }

  /**
   * Blobstore v1 reference, set if reference_type is BLOBSTORE_REF This should be the byte
   * representation of a blobstore.BlobRef. Since Blobstore is deprecating v1, use blobstore2_info
   * instead. For now, any v2 blob will also be represented in this field as v1 BlobRef.
   * @see #decodeBlobRef()
   * @return value or {@code null} for none
   */
  public java.lang.String getBlobRef() {
    return blobRef;
  }

  /**
   * Blobstore v1 reference, set if reference_type is BLOBSTORE_REF This should be the byte
   * representation of a blobstore.BlobRef. Since Blobstore is deprecating v1, use blobstore2_info
   * instead. For now, any v2 blob will also be represented in this field as v1 BlobRef.
   * @see #getBlobRef()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeBlobRef() {
    return com.google.api.client.util.Base64.decodeBase64(blobRef);
  }

  /**
   * Blobstore v1 reference, set if reference_type is BLOBSTORE_REF This should be the byte
   * representation of a blobstore.BlobRef. Since Blobstore is deprecating v1, use blobstore2_info
   * instead. For now, any v2 blob will also be represented in this field as v1 BlobRef.
   * @see #encodeBlobRef()
   * @param blobRef blobRef or {@code null} for none
   */
  public GdataMedia setBlobRef(java.lang.String blobRef) {
    this.blobRef = blobRef;
    return this;
  }

  /**
   * Blobstore v1 reference, set if reference_type is BLOBSTORE_REF This should be the byte
   * representation of a blobstore.BlobRef. Since Blobstore is deprecating v1, use blobstore2_info
   * instead. For now, any v2 blob will also be represented in this field as v1 BlobRef.
   * @see #setBlobRef()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public GdataMedia encodeBlobRef(byte[] blobRef) {
    this.blobRef = com.google.api.client.util.Base64.encodeBase64URLSafeString(blobRef);
    return this;
  }

  /**
   * Blobstore v2 info, set if reference_type is BLOBSTORE_REF and it refers to a v2 blob.
   * @return value or {@code null} for none
   */
  public GdataBlobstore2Info getBlobstore2Info() {
    return blobstore2Info;
  }

  /**
   * Blobstore v2 info, set if reference_type is BLOBSTORE_REF and it refers to a v2 blob.
   * @param blobstore2Info blobstore2Info or {@code null} for none
   */
  public GdataMedia setBlobstore2Info(GdataBlobstore2Info blobstore2Info) {
    this.blobstore2Info = blobstore2Info;
    return this;
  }

  /**
   * A composite media composed of one or more media objects, set if reference_type is
   * COMPOSITE_MEDIA. The media length field must be set to the sum of the lengths of all composite
   * media objects.
   *
   * Note: All composite media must have length specified.
   * @return value or {@code null} for none
   */
  public java.util.List<GdataCompositeMedia> getCompositeMedia() {
    return compositeMedia;
  }

  /**
   * A composite media composed of one or more media objects, set if reference_type is
   * COMPOSITE_MEDIA. The media length field must be set to the sum of the lengths of all composite
   * media objects.
   *
   * Note: All composite media must have length specified.
   * @param compositeMedia compositeMedia or {@code null} for none
   */
  public GdataMedia setCompositeMedia(java.util.List<GdataCompositeMedia> compositeMedia) {
    this.compositeMedia = compositeMedia;
    return this;
  }

  /**
   * MIME type of the data
   * @return value or {@code null} for none
   */
  public java.lang.String getContentType() {
    return contentType;
  }

  /**
   * MIME type of the data
   * @param contentType contentType or {@code null} for none
   */
  public GdataMedia setContentType(java.lang.String contentType) {
    this.contentType = contentType;
    return this;
  }

  /**
   * Extended content type information provided for Scotty uploads.
   * @return value or {@code null} for none
   */
  public GdataContentTypeInfo getContentTypeInfo() {
    return contentTypeInfo;
  }

  /**
   * Extended content type information provided for Scotty uploads.
   * @param contentTypeInfo contentTypeInfo or {@code null} for none
   */
  public GdataMedia setContentTypeInfo(GdataContentTypeInfo contentTypeInfo) {
    this.contentTypeInfo = contentTypeInfo;
    return this;
  }

  /**
   * A binary data reference for a media download. Serves as a technology-agnostic binary reference
   * in some Google infrastructure. This value is a serialized storage_cosmo.BinaryReference proto.
   * Storing it as bytes is a hack to get around the fact that the cosmo proto (as well as others it
   * includes) doesn't support JavaScript. This prevents us from including the actual type of this
   * field.
   * @see #decodeCosmoBinaryReference()
   * @return value or {@code null} for none
   */
  public java.lang.String getCosmoBinaryReference() {
    return cosmoBinaryReference;
  }

  /**
   * A binary data reference for a media download. Serves as a technology-agnostic binary reference
   * in some Google infrastructure. This value is a serialized storage_cosmo.BinaryReference proto.
   * Storing it as bytes is a hack to get around the fact that the cosmo proto (as well as others it
   * includes) doesn't support JavaScript. This prevents us from including the actual type of this
   * field.
   * @see #getCosmoBinaryReference()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeCosmoBinaryReference() {
    return com.google.api.client.util.Base64.decodeBase64(cosmoBinaryReference);
  }

  /**
   * A binary data reference for a media download. Serves as a technology-agnostic binary reference
   * in some Google infrastructure. This value is a serialized storage_cosmo.BinaryReference proto.
   * Storing it as bytes is a hack to get around the fact that the cosmo proto (as well as others it
   * includes) doesn't support JavaScript. This prevents us from including the actual type of this
   * field.
   * @see #encodeCosmoBinaryReference()
   * @param cosmoBinaryReference cosmoBinaryReference or {@code null} for none
   */
  public GdataMedia setCosmoBinaryReference(java.lang.String cosmoBinaryReference) {
    this.cosmoBinaryReference = cosmoBinaryReference;
    return this;
  }

  /**
   * A binary data reference for a media download. Serves as a technology-agnostic binary reference
   * in some Google infrastructure. This value is a serialized storage_cosmo.BinaryReference proto.
   * Storing it as bytes is a hack to get around the fact that the cosmo proto (as well as others it
   * includes) doesn't support JavaScript. This prevents us from including the actual type of this
   * field.
   * @see #setCosmoBinaryReference()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public GdataMedia encodeCosmoBinaryReference(byte[] cosmoBinaryReference) {
    this.cosmoBinaryReference = com.google.api.client.util.Base64.encodeBase64URLSafeString(cosmoBinaryReference);
    return this;
  }

  /**
   * For Scotty Uploads: Scotty-provided hashes for uploads
   *
   * For Scotty Downloads: (WARNING: DO NOT USE WITHOUT PERMISSION FROM THE SCOTTY TEAM.) A Hash
   * provided by the agent to be used to verify the data being downloaded. Currently only supported
   * for inline payloads. Further, only crc32c_hash is currently supported.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCrc32cHash() {
    return crc32cHash;
  }

  /**
   * For Scotty Uploads: Scotty-provided hashes for uploads
   *
   * For Scotty Downloads: (WARNING: DO NOT USE WITHOUT PERMISSION FROM THE SCOTTY TEAM.) A Hash
   * provided by the agent to be used to verify the data being downloaded. Currently only supported
   * for inline payloads. Further, only crc32c_hash is currently supported.
   * @param crc32cHash crc32cHash or {@code null} for none
   */
  public GdataMedia setCrc32cHash(java.lang.Long crc32cHash) {
    this.crc32cHash = crc32cHash;
    return this;
  }

  /**
   * Set if reference_type is DIFF_CHECKSUMS_RESPONSE.
   * @return value or {@code null} for none
   */
  public GdataDiffChecksumsResponse getDiffChecksumsResponse() {
    return diffChecksumsResponse;
  }

  /**
   * Set if reference_type is DIFF_CHECKSUMS_RESPONSE.
   * @param diffChecksumsResponse diffChecksumsResponse or {@code null} for none
   */
  public GdataMedia setDiffChecksumsResponse(GdataDiffChecksumsResponse diffChecksumsResponse) {
    this.diffChecksumsResponse = diffChecksumsResponse;
    return this;
  }

  /**
   * Set if reference_type is DIFF_DOWNLOAD_RESPONSE.
   * @return value or {@code null} for none
   */
  public GdataDiffDownloadResponse getDiffDownloadResponse() {
    return diffDownloadResponse;
  }

  /**
   * Set if reference_type is DIFF_DOWNLOAD_RESPONSE.
   * @param diffDownloadResponse diffDownloadResponse or {@code null} for none
   */
  public GdataMedia setDiffDownloadResponse(GdataDiffDownloadResponse diffDownloadResponse) {
    this.diffDownloadResponse = diffDownloadResponse;
    return this;
  }

  /**
   * Set if reference_type is DIFF_UPLOAD_REQUEST.
   * @return value or {@code null} for none
   */
  public GdataDiffUploadRequest getDiffUploadRequest() {
    return diffUploadRequest;
  }

  /**
   * Set if reference_type is DIFF_UPLOAD_REQUEST.
   * @param diffUploadRequest diffUploadRequest or {@code null} for none
   */
  public GdataMedia setDiffUploadRequest(GdataDiffUploadRequest diffUploadRequest) {
    this.diffUploadRequest = diffUploadRequest;
    return this;
  }

  /**
   * Set if reference_type is DIFF_UPLOAD_RESPONSE.
   * @return value or {@code null} for none
   */
  public GdataDiffUploadResponse getDiffUploadResponse() {
    return diffUploadResponse;
  }

  /**
   * Set if reference_type is DIFF_UPLOAD_RESPONSE.
   * @param diffUploadResponse diffUploadResponse or {@code null} for none
   */
  public GdataMedia setDiffUploadResponse(GdataDiffUploadResponse diffUploadResponse) {
    this.diffUploadResponse = diffUploadResponse;
    return this;
  }

  /**
   * Set if reference_type is DIFF_VERSION_RESPONSE.
   * @return value or {@code null} for none
   */
  public GdataDiffVersionResponse getDiffVersionResponse() {
    return diffVersionResponse;
  }

  /**
   * Set if reference_type is DIFF_VERSION_RESPONSE.
   * @param diffVersionResponse diffVersionResponse or {@code null} for none
   */
  public GdataMedia setDiffVersionResponse(GdataDiffVersionResponse diffVersionResponse) {
    this.diffVersionResponse = diffVersionResponse;
    return this;
  }

  /**
   * Parameters for a media download.
   * @return value or {@code null} for none
   */
  public GdataDownloadParameters getDownloadParameters() {
    return downloadParameters;
  }

  /**
   * Parameters for a media download.
   * @param downloadParameters downloadParameters or {@code null} for none
   */
  public GdataMedia setDownloadParameters(GdataDownloadParameters downloadParameters) {
    this.downloadParameters = downloadParameters;
    return this;
  }

  /**
   * Original file name
   * @return value or {@code null} for none
   */
  public java.lang.String getFilename() {
    return filename;
  }

  /**
   * Original file name
   * @param filename filename or {@code null} for none
   */
  public GdataMedia setFilename(java.lang.String filename) {
    this.filename = filename;
    return this;
  }

  /**
   * Deprecated, use one of explicit hash type fields instead. These two hash related fields will
   * only be populated on Scotty based media uploads and will contain the content of the hash group
   * in the NotificationRequest:
   * https://cs/#google3/uploader/service/proto/upload_listener.proto=class:Hash Hex encoded hash
   * value of the uploaded media.
   * @return value or {@code null} for none
   */
  public java.lang.String getHash() {
    return hash;
  }

  /**
   * Deprecated, use one of explicit hash type fields instead. These two hash related fields will
   * only be populated on Scotty based media uploads and will contain the content of the hash group
   * in the NotificationRequest:
   * https://cs/#google3/uploader/service/proto/upload_listener.proto=class:Hash Hex encoded hash
   * value of the uploaded media.
   * @param hash hash or {@code null} for none
   */
  public GdataMedia setHash(java.lang.String hash) {
    this.hash = hash;
    return this;
  }

  /**
   * For Scotty uploads only. If a user sends a hash code and the backend has requested that Scotty
   * verify the upload against the client hash, Scotty will perform the check on behalf of the
   * backend and will reject it if the hashes don't match. This is set to true if Scotty performed
   * this verification.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHashVerified() {
    return hashVerified;
  }

  /**
   * For Scotty uploads only. If a user sends a hash code and the backend has requested that Scotty
   * verify the upload against the client hash, Scotty will perform the check on behalf of the
   * backend and will reject it if the hashes don't match. This is set to true if Scotty performed
   * this verification.
   * @param hashVerified hashVerified or {@code null} for none
   */
  public GdataMedia setHashVerified(java.lang.Boolean hashVerified) {
    this.hashVerified = hashVerified;
    return this;
  }

  /**
   * Media data, set if reference_type is INLINE
   * @see #decodeInline()
   * @return value or {@code null} for none
   */
  public java.lang.String getInline() {
    return inline;
  }

  /**
   * Media data, set if reference_type is INLINE
   * @see #getInline()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeInline() {
    return com.google.api.client.util.Base64.decodeBase64(inline);
  }

  /**
   * Media data, set if reference_type is INLINE
   * @see #encodeInline()
   * @param inline inline or {@code null} for none
   */
  public GdataMedia setInline(java.lang.String inline) {
    this.inline = inline;
    return this;
  }

  /**
   * Media data, set if reference_type is INLINE
   * @see #setInline()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public GdataMedia encodeInline(byte[] inline) {
    this.inline = com.google.api.client.util.Base64.encodeBase64URLSafeString(inline);
    return this;
  }

  /**
   * |is_potential_retry| is set false only when Scotty is certain that it has not sent the request
   * before. When a client resumes an upload, this field must be set true in agent calls, because
   * Scotty cannot be certain that it has never sent the request before due to potential failure in
   * the session state persistence.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsPotentialRetry() {
    return isPotentialRetry;
  }

  /**
   * |is_potential_retry| is set false only when Scotty is certain that it has not sent the request
   * before. When a client resumes an upload, this field must be set true in agent calls, because
   * Scotty cannot be certain that it has never sent the request before due to potential failure in
   * the session state persistence.
   * @param isPotentialRetry isPotentialRetry or {@code null} for none
   */
  public GdataMedia setIsPotentialRetry(java.lang.Boolean isPotentialRetry) {
    this.isPotentialRetry = isPotentialRetry;
    return this;
  }

  /**
   * Size of the data, in bytes
   * @return value or {@code null} for none
   */
  public java.lang.Long getLength() {
    return length;
  }

  /**
   * Size of the data, in bytes
   * @param length length or {@code null} for none
   */
  public GdataMedia setLength(java.lang.Long length) {
    this.length = length;
    return this;
  }

  /**
   * Scotty-provided MD5 hash for an upload.
   * @see #decodeMd5Hash()
   * @return value or {@code null} for none
   */
  public java.lang.String getMd5Hash() {
    return md5Hash;
  }

  /**
   * Scotty-provided MD5 hash for an upload.
   * @see #getMd5Hash()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeMd5Hash() {
    return com.google.api.client.util.Base64.decodeBase64(md5Hash);
  }

  /**
   * Scotty-provided MD5 hash for an upload.
   * @see #encodeMd5Hash()
   * @param md5Hash md5Hash or {@code null} for none
   */
  public GdataMedia setMd5Hash(java.lang.String md5Hash) {
    this.md5Hash = md5Hash;
    return this;
  }

  /**
   * Scotty-provided MD5 hash for an upload.
   * @see #setMd5Hash()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public GdataMedia encodeMd5Hash(byte[] md5Hash) {
    this.md5Hash = com.google.api.client.util.Base64.encodeBase64URLSafeString(md5Hash);
    return this;
  }

  /**
   * Media id to forward to the operation GetMedia. Can be set if reference_type is GET_MEDIA.
   * @see #decodeMediaId()
   * @return value or {@code null} for none
   */
  public java.lang.String getMediaId() {
    return mediaId;
  }

  /**
   * Media id to forward to the operation GetMedia. Can be set if reference_type is GET_MEDIA.
   * @see #getMediaId()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeMediaId() {
    return com.google.api.client.util.Base64.decodeBase64(mediaId);
  }

  /**
   * Media id to forward to the operation GetMedia. Can be set if reference_type is GET_MEDIA.
   * @see #encodeMediaId()
   * @param mediaId mediaId or {@code null} for none
   */
  public GdataMedia setMediaId(java.lang.String mediaId) {
    this.mediaId = mediaId;
    return this;
  }

  /**
   * Media id to forward to the operation GetMedia. Can be set if reference_type is GET_MEDIA.
   * @see #setMediaId()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public GdataMedia encodeMediaId(byte[] mediaId) {
    this.mediaId = com.google.api.client.util.Base64.encodeBase64URLSafeString(mediaId);
    return this;
  }

  /**
   * Reference to a TI Blob, set if reference_type is BIGSTORE_REF.
   * @return value or {@code null} for none
   */
  public GdataObjectId getObjectId() {
    return objectId;
  }

  /**
   * Reference to a TI Blob, set if reference_type is BIGSTORE_REF.
   * @param objectId objectId or {@code null} for none
   */
  public GdataMedia setObjectId(GdataObjectId objectId) {
    this.objectId = objectId;
    return this;
  }

  /**
   * Path to the data, set if reference_type is PATH
   * @return value or {@code null} for none
   */
  public java.lang.String getPath() {
    return path;
  }

  /**
   * Path to the data, set if reference_type is PATH
   * @param path path or {@code null} for none
   */
  public GdataMedia setPath(java.lang.String path) {
    this.path = path;
    return this;
  }

  /**
   * Describes what the field reference contains.
   * @return value or {@code null} for none
   */
  public java.lang.String getReferenceType() {
    return referenceType;
  }

  /**
   * Describes what the field reference contains.
   * @param referenceType referenceType or {@code null} for none
   */
  public GdataMedia setReferenceType(java.lang.String referenceType) {
    this.referenceType = referenceType;
    return this;
  }

  /**
   * Scotty-provided SHA1 hash for an upload.
   * @see #decodeSha1Hash()
   * @return value or {@code null} for none
   */
  public java.lang.String getSha1Hash() {
    return sha1Hash;
  }

  /**
   * Scotty-provided SHA1 hash for an upload.
   * @see #getSha1Hash()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeSha1Hash() {
    return com.google.api.client.util.Base64.decodeBase64(sha1Hash);
  }

  /**
   * Scotty-provided SHA1 hash for an upload.
   * @see #encodeSha1Hash()
   * @param sha1Hash sha1Hash or {@code null} for none
   */
  public GdataMedia setSha1Hash(java.lang.String sha1Hash) {
    this.sha1Hash = sha1Hash;
    return this;
  }

  /**
   * Scotty-provided SHA1 hash for an upload.
   * @see #setSha1Hash()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public GdataMedia encodeSha1Hash(byte[] sha1Hash) {
    this.sha1Hash = com.google.api.client.util.Base64.encodeBase64URLSafeString(sha1Hash);
    return this;
  }

  /**
   * Scotty-provided SHA256 hash for an upload.
   * @see #decodeSha256Hash()
   * @return value or {@code null} for none
   */
  public java.lang.String getSha256Hash() {
    return sha256Hash;
  }

  /**
   * Scotty-provided SHA256 hash for an upload.
   * @see #getSha256Hash()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeSha256Hash() {
    return com.google.api.client.util.Base64.decodeBase64(sha256Hash);
  }

  /**
   * Scotty-provided SHA256 hash for an upload.
   * @see #encodeSha256Hash()
   * @param sha256Hash sha256Hash or {@code null} for none
   */
  public GdataMedia setSha256Hash(java.lang.String sha256Hash) {
    this.sha256Hash = sha256Hash;
    return this;
  }

  /**
   * Scotty-provided SHA256 hash for an upload.
   * @see #setSha256Hash()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public GdataMedia encodeSha256Hash(byte[] sha256Hash) {
    this.sha256Hash = com.google.api.client.util.Base64.encodeBase64URLSafeString(sha256Hash);
    return this;
  }

  /**
   * Time at which the media data was last updated, in milliseconds since UNIX epoch
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getTimestamp() {
    return timestamp;
  }

  /**
   * Time at which the media data was last updated, in milliseconds since UNIX epoch
   * @param timestamp timestamp or {@code null} for none
   */
  public GdataMedia setTimestamp(java.math.BigInteger timestamp) {
    this.timestamp = timestamp;
    return this;
  }

  /**
   * A unique fingerprint/version id for the media data
   * @return value or {@code null} for none
   */
  public java.lang.String getToken() {
    return token;
  }

  /**
   * A unique fingerprint/version id for the media data
   * @param token token or {@code null} for none
   */
  public GdataMedia setToken(java.lang.String token) {
    this.token = token;
    return this;
  }

  @Override
  public GdataMedia set(String fieldName, Object value) {
    return (GdataMedia) super.set(fieldName, value);
  }

  @Override
  public GdataMedia clone() {
    return (GdataMedia) super.clone();
  }

}
