﻿# RCS Business Messaging: Your First Agent

This sample RBM agent demonstrates how to use the RBM C# SDK to
send and receive messages to an RCS-enabled device.


## Prerequisites

You must have the following software installed on your development machine:

* .NET Framework v4.7.2


## Setup

Prepare credentials:

1. Open the [RBM Developer Console](https://business-communications.cloud.google.com/console/partner-console/])
with your RBM Platform Google account and create a new RBM agent.

2. When the agent is available, click the agent's card.

3. In the left navigation, click **Service account**.

4. Click **Create key**, then click **Create**. Your browser downloads a service account key for
your agent. Note the location of the service account key file. You need this key to make RBM API
calls as your agent.


Find your project ID:

Your agent's project ID is embedded in the Pub/Sub subscription name following `project/`.

1. Open the [RBM Developer Console](https://business-communications.cloud.google.com/console/partner-console/]), sign in with
your RBM Platform Google account, and click your agent.

2. In the left navigation, click **Integrations**.

3. Click **View subscriptions**.

4. Find your agent's **Subscription name**.

5. Identify the text segment between `project/` and the following `/`. This is
your agent's project ID.

For example, if the subscription name is
`projects/rbm-growing-tree-bank-nbdjkl6t/subscriptions/rbm-agent-subscription`,
your agent's project ID is `rbm-growing-tree-bank-nbdjkl6t`.


## Set up your test device

1. In a terminal, navigate to this sample's root directory.

2. Run the following commands:

```
   dotnet build
   dotnet run PATH_TO_SERVICE_ACCOUNT_KEY PROJECT_ID PHONE_NUMBER invite
```

Replace the `PATH_TO_SERVICE_ACCOUNT_KEY` with the location of the service account key
file you downloaded and replace `PROJECT_ID` with the project ID you extracted from your
agent's Pub/Sub subscription name.

The "invite" text at the end of this command sends `PHONE_NUMBER` an invite to
become a tester for your agent.


## Run the sample

1. In a terminal, navigate to this sample's root directory.

2. Run the following commands:

```
   dotnet build
   donet run PATH_TO_SERVICE_ACCOUNT_KEY PROJECT_ID PHONE_NUMBER chat
```

## Updates

### April 11 2023

- updated for Visual Studio 2019
- updated library dependencies to latest versions
- now targetting for .Net Framework v4.7.2