/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * Modify at your own risk.
 */

package com.google.api.services.rcsbusinessmessaging.v1.model;

/**
 * Tokenization information for the payment request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the RCS Business Messaging API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TokenizationData extends com.google.api.client.json.GenericJson {

  /**
   * Tokenization parameters, such as the public key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> parameters;

  /**
   * The tokenization type for the payment processing provider.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tokenizationType;

  /**
   * Tokenization parameters, such as the public key.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getParameters() {
    return parameters;
  }

  /**
   * Tokenization parameters, such as the public key.
   * @param parameters parameters or {@code null} for none
   */
  public TokenizationData setParameters(java.util.Map<String, java.lang.String> parameters) {
    this.parameters = parameters;
    return this;
  }

  /**
   * The tokenization type for the payment processing provider.
   * @return value or {@code null} for none
   */
  public java.lang.String getTokenizationType() {
    return tokenizationType;
  }

  /**
   * The tokenization type for the payment processing provider.
   * @param tokenizationType tokenizationType or {@code null} for none
   */
  public TokenizationData setTokenizationType(java.lang.String tokenizationType) {
    this.tokenizationType = tokenizationType;
    return this;
  }

  @Override
  public TokenizationData set(String fieldName, Object value) {
    return (TokenizationData) super.set(fieldName, value);
  }

  @Override
  public TokenizationData clone() {
    return (TokenizationData) super.clone();
  }

}
