/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * Modify at your own risk.
 */

package com.google.api.services.rcsbusinessmessaging.v1.model;

/**
 * When tapped, sends the text reply back to the agent.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the RCS Business Messaging API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SuggestedReply extends com.google.api.client.json.GenericJson {

  /**
   * The base64-encoded payload that the agent receives in a user event when the user taps the
   * suggested reply.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String postbackData;

  /**
   * Text that is shown in the suggested reply and sent back to the agent when the user taps it.
   * Maximum 25 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String text;

  /**
   * The base64-encoded payload that the agent receives in a user event when the user taps the
   * suggested reply.
   * @return value or {@code null} for none
   */
  public java.lang.String getPostbackData() {
    return postbackData;
  }

  /**
   * The base64-encoded payload that the agent receives in a user event when the user taps the
   * suggested reply.
   * @param postbackData postbackData or {@code null} for none
   */
  public SuggestedReply setPostbackData(java.lang.String postbackData) {
    this.postbackData = postbackData;
    return this;
  }

  /**
   * Text that is shown in the suggested reply and sent back to the agent when the user taps it.
   * Maximum 25 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getText() {
    return text;
  }

  /**
   * Text that is shown in the suggested reply and sent back to the agent when the user taps it.
   * Maximum 25 characters.
   * @param text text or {@code null} for none
   */
  public SuggestedReply setText(java.lang.String text) {
    this.text = text;
    return this;
  }

  @Override
  public SuggestedReply set(String fieldName, Object value) {
    return (SuggestedReply) super.set(fieldName, value);
  }

  @Override
  public SuggestedReply clone() {
    return (SuggestedReply) super.clone();
  }

}
