/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * Modify at your own risk.
 */

package com.google.api.services.rcsbusinessmessaging.v1.model;

/**
 * This is a copy of the tech.blob.ObjectId proto, which could not be used directly here due to
 * transitive closure issues with JavaScript support; see http://b/8801763.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the RCS Business Messaging API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GdataObjectId extends com.google.api.client.json.GenericJson {

  /**
   * The name of the bucket to which this object belongs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bucketName;

  /**
   * Generation of the object. Generations are monotonically increasing across writes, allowing them
   * to be be compared to determine which generation is newer. If this is omitted in a request, then
   * you are requesting the live object. See http://go/bigstore-versions
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long generation;

  /**
   * The name of the object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectName;

  /**
   * The name of the bucket to which this object belongs.
   * @return value or {@code null} for none
   */
  public java.lang.String getBucketName() {
    return bucketName;
  }

  /**
   * The name of the bucket to which this object belongs.
   * @param bucketName bucketName or {@code null} for none
   */
  public GdataObjectId setBucketName(java.lang.String bucketName) {
    this.bucketName = bucketName;
    return this;
  }

  /**
   * Generation of the object. Generations are monotonically increasing across writes, allowing them
   * to be be compared to determine which generation is newer. If this is omitted in a request, then
   * you are requesting the live object. See http://go/bigstore-versions
   * @return value or {@code null} for none
   */
  public java.lang.Long getGeneration() {
    return generation;
  }

  /**
   * Generation of the object. Generations are monotonically increasing across writes, allowing them
   * to be be compared to determine which generation is newer. If this is omitted in a request, then
   * you are requesting the live object. See http://go/bigstore-versions
   * @param generation generation or {@code null} for none
   */
  public GdataObjectId setGeneration(java.lang.Long generation) {
    this.generation = generation;
    return this;
  }

  /**
   * The name of the object.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectName() {
    return objectName;
  }

  /**
   * The name of the object.
   * @param objectName objectName or {@code null} for none
   */
  public GdataObjectId setObjectName(java.lang.String objectName) {
    this.objectName = objectName;
    return this;
  }

  @Override
  public GdataObjectId set(String fieldName, Object value) {
    return (GdataObjectId) super.set(fieldName, value);
  }

  @Override
  public GdataObjectId clone() {
    return (GdataObjectId) super.clone();
  }

}
