# RCS Business Messaging: Bonjour Rail Demo

This sample RBM agent demonstrates how to use the RBM Java SDK to
send and receive messages to an RCS enabled device.

This sample demonstrates is setup to run on the Google App Engine.

See the Google App Engine (https://cloud.google.com/appengine/docs/java/) standard environment
documentation for more detailed instructions.

## Prerequisites

You must have the following software installed on your development machine:

* [Apache Maven](http://maven.apache.org) 3.3.9 or greater
* [Google Cloud SDK](https://cloud.google.com/sdk/) (aka gcloud)
* [Java 8](http://www.oracle.com/technetwork/java/javase/downloads/index.html)
* [Google App Engine SDK for Java](https://cloud.google.com/appengine/docs/standard/java/download)


## Setup

Set up the RBM agent:

1. Open the RBM Developer Console (https://business-communications.cloud.google.com/console/partner-console/)
with your RBM Platform Google account and create a new RBM agent.

2. When the agent is available, click the agent's card.

3. In the left navigation, click **Service account**.

4. Click **Create key**, then click **Create**. Your browser downloads a service account key for
your agent. You need this key to make RBM API calls as your agent.

5. Rename the service account key `rbm-agent-service-account-credentials.json` and move it
into the `src/main/resources` directory.

## GCP setup

You will need to enable the Cloud Build api for your project:

https://console.cloud.google.com/apis/library/cloudbuild.googleapis.com

You should select your target GCP project:

```
gcloud config set project <gcp project name>
```

Before you can deploy to GCP you will need to create an appengine application:

```
gcloud app create
```

## Deploy the sample

1. In a terminal, navigate to this sample's root directory.

2. Run the following commands:

```
    mvn appengine:deploy
```

3. The output of this command will tell you the URL of the service which you can open.


## Setup the agent webhook

1. Return to the RBM Developer Console, in the left navigation, click **Integrations**.

2. Click Edit subscription and configure a push subscription with a
URL of https://YOUR-GCP-PROJECT-ID.appspot.com/callback