/*
Copyright 2018 Google Inc. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package com.google.rbm.samples.servlets;

// [START servlet for retrieving messages for a device from chat]

import com.google.appengine.api.datastore.Entity;
import com.google.rbm.samples.BankingAgentBot;

import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

/**
 * Servlet for customer support chat interface for retrieving current chat history.
 */
@WebServlet(name = "CustomerSupportMessages", value = "/retrieveMessages")
public class CustomerSupportMessages extends HttpServlet {
    private static final Logger logger = Logger.getLogger(CustomerSupportMessages.class.getName());

    public CustomerSupportMessages() {
        super();
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        // set the response type to JSON
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");

        // check the session for the phone number associated with this chat
        if(request.getSession().getAttribute("phone_number") != null) {
            String phoneNumber = request.getSession().getAttribute("phone_number").toString();

            try {
                BankingAgentBot bankingAgentBot = new BankingAgentBot(phoneNumber);

                // get the list of messages
                List<Entity> posts = bankingAgentBot.getMessages();

                String messages = "";
                boolean first = true;

                // convert messages into JSON for UI
                for (Entity result : posts) {
                    // Build up string with values from the Datastore entity
                    String recordOutput = "{\"sender\": \"" + result.getProperty("sender")
                            + "\", \"body\": \"" + result.getProperty("body") + "\"}";

                    logger.info(recordOutput);

                    if (!first) {
                        messages += ", ";
                    }

                    first = false;

                    messages += recordOutput;
                }

                messages = "[" + messages + "]";

                response.getWriter().println("{\"response\": \"ok\", \"messages\": " + messages + "}");
                response.getWriter().flush();
            } catch (Exception e) {
                logger.info(e.getMessage());

                response.getWriter().println("{\"response\": \"fail\"}");
                response.getWriter().flush();
            }
        }
    }
}
// [END servlet for retrieving messages for a device from chat]