/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * Modify at your own risk.
 */

package com.google.api.services.rcsbusinessmessaging.v1;

/**
 * Service definition for RCSBusinessMessaging (v1).
 *
 * <p>
 * 
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/rcs-business-messaging/rest" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link RCSBusinessMessagingRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class RCSBusinessMessaging extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.25.0-SNAPSHOT of the RCS Business Messaging API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://rcsbusinessmessaging.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public RCSBusinessMessaging(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  RCSBusinessMessaging(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Files collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code RCSBusinessMessaging rcsbusinessmessaging = new RCSBusinessMessaging(...);}
   *   {@code RCSBusinessMessaging.Files.List request = rcsbusinessmessaging.files().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Files files() {
    return new Files();
  }

  /**
   * The "files" collection of methods.
   */
  public class Files {

    /**
     * Uploads a file for use in media or rich card messages. The agent provides the URL or binary of
     * the file and (optionally) the URL of the corresponding thumbnail file. The RBM platform caches
     * the file for 60 days and returns a unique name that you can use to identify the file when sending
     * agent messages. To upload a file binary, make an HTTP POST request to the Upload URI, omit the
     * `fileUrl` field from the JSON request body, and specify the binary as the POST request body. For
     * example, use the `--upload-file` cURL flag with the fully qualified file path of the binary file.
     *
     * Create a request for the method "files.create".
     *
     * This request holds the parameters needed by the rcsbusinessmessaging server.  After setting any
     * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.rcsbusinessmessaging.v1.model.CreateFileRequest}
     * @return the request
     */
    public Create create(com.google.api.services.rcsbusinessmessaging.v1.model.CreateFileRequest content) throws java.io.IOException {
      Create result = new Create(content);
      initialize(result);
      return result;
    }

    /**
     * Uploads a file for use in media or rich card messages. The agent provides the URL or binary of
     * the file and (optionally) the URL of the corresponding thumbnail file. The RBM platform caches
     * the file for 60 days and returns a unique name that you can use to identify the file when sending
     * agent messages. To upload a file binary, make an HTTP POST request to the Upload URI, omit the
     * `fileUrl` field from the JSON request body, and specify the binary as the POST request body. For
     * example, use the `--upload-file` cURL flag with the fully qualified file path of the binary file.
     *
     * Create a request for the method "files.create".
     *
     * This request holds the parameters needed by the the rcsbusinessmessaging server.  After setting
     * any optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     *
     * @param content the {@link com.google.api.services.rcsbusinessmessaging.v1.model.CreateFileRequest} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Create create(com.google.api.services.rcsbusinessmessaging.v1.model.CreateFileRequest content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Create result = new Create(content, mediaContent);
      initialize(result);
      return result;
    }

    public class Create extends RCSBusinessMessagingRequest<com.google.api.services.rcsbusinessmessaging.v1.model.File> {

      private static final String REST_PATH = "v1/files";

      /**
       * Uploads a file for use in media or rich card messages. The agent provides the URL or binary of
       * the file and (optionally) the URL of the corresponding thumbnail file. The RBM platform caches
       * the file for 60 days and returns a unique name that you can use to identify the file when
       * sending agent messages. To upload a file binary, make an HTTP POST request to the Upload URI,
       * omit the `fileUrl` field from the JSON request body, and specify the binary as the POST request
       * body. For example, use the `--upload-file` cURL flag with the fully qualified file path of the
       * binary file.
       *
       * Create a request for the method "files.create".
       *
       * This request holds the parameters needed by the the rcsbusinessmessaging server.  After setting
       * any optional parameters, call the {@link Create#execute()} method to invoke the remote
       * operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.rcsbusinessmessaging.v1.model.CreateFileRequest}
       * @since 1.13
       */
      protected Create(com.google.api.services.rcsbusinessmessaging.v1.model.CreateFileRequest content) {
        super(RCSBusinessMessaging.this, "POST", REST_PATH, content, com.google.api.services.rcsbusinessmessaging.v1.model.File.class);
      }

      /**
       * Uploads a file for use in media or rich card messages. The agent provides the URL or binary of
       * the file and (optionally) the URL of the corresponding thumbnail file. The RBM platform caches
       * the file for 60 days and returns a unique name that you can use to identify the file when
       * sending agent messages. To upload a file binary, make an HTTP POST request to the Upload URI,
       * omit the `fileUrl` field from the JSON request body, and specify the binary as the POST request
       * body. For example, use the `--upload-file` cURL flag with the fully qualified file path of the
       * binary file.
       *
       * Create a request for the method "files.create".
       *
       * This request holds the parameters needed by the the rcsbusinessmessaging server.  After setting
       * any optional parameters, call the {@link Create#execute()} method to invoke the remote
       * operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       *
       * @param content the {@link com.google.api.services.rcsbusinessmessaging.v1.model.CreateFileRequest} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Create(com.google.api.services.rcsbusinessmessaging.v1.model.CreateFileRequest content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(RCSBusinessMessaging.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.rcsbusinessmessaging.v1.model.File.class);
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Create set$Xgafv(java.lang.String $Xgafv) {
        return (Create) super.set$Xgafv($Xgafv);
      }

      @Override
      public Create setAccessToken(java.lang.String accessToken) {
        return (Create) super.setAccessToken(accessToken);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setCallback(java.lang.String callback) {
        return (Create) super.setCallback(callback);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUploadType(java.lang.String uploadType) {
        return (Create) super.setUploadType(uploadType);
      }

      @Override
      public Create setUploadProtocol(java.lang.String uploadProtocol) {
        return (Create) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Phones collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code RCSBusinessMessaging rcsbusinessmessaging = new RCSBusinessMessaging(...);}
   *   {@code RCSBusinessMessaging.Phones.List request = rcsbusinessmessaging.phones().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Phones phones() {
    return new Phones();
  }

  /**
   * The "phones" collection of methods.
   */
  public class Phones {

    /**
     * Get the RBM-related capabilities of a user. The returned payload specifies whether a user can be
     * reached with RBM and, if so, which RBM features the user supports. If the user can't be reached
     * with RBM, the RBM platform returns `404 NOT_FOUND`. An agent that isn't launched can only request
     * capabilities for users who are testers of that agent. If an unlaunched agent requests the
     * capabilities of a non-tester, the RBM platform returns `403 PERMISSION_DENIED`.
     *
     * Create a request for the method "phones.getCapabilities".
     *
     * This request holds the parameters needed by the rcsbusinessmessaging server.  After setting any
     * optional parameters, call the {@link GetCapabilities#execute()} method to invoke the remote
     * operation.
     *
     * @param name This field resolves to "phones/{E.164}/capabilities", where {E.164} is the user's phone number in
     *        E.164 format. For example, for a user with the US phone number +1-222-333-4444, the
     *        resulting endpoint is
     *        https://rcsbusinessmessaging.googleapis.com/v1/phones/+12223334444/capabilities.
     * @return the request
     */
    public GetCapabilities getCapabilities(java.lang.String name) throws java.io.IOException {
      GetCapabilities result = new GetCapabilities(name);
      initialize(result);
      return result;
    }

    public class GetCapabilities extends RCSBusinessMessagingRequest<com.google.api.services.rcsbusinessmessaging.v1.model.Capabilities> {

      private static final String REST_PATH = "v1/{+name}/capabilities";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^phones/[^/]+$");

      /**
       * Get the RBM-related capabilities of a user. The returned payload specifies whether a user can
       * be reached with RBM and, if so, which RBM features the user supports. If the user can't be
       * reached with RBM, the RBM platform returns `404 NOT_FOUND`. An agent that isn't launched can
       * only request capabilities for users who are testers of that agent. If an unlaunched agent
       * requests the capabilities of a non-tester, the RBM platform returns `403 PERMISSION_DENIED`.
       *
       * Create a request for the method "phones.getCapabilities".
       *
       * This request holds the parameters needed by the the rcsbusinessmessaging server.  After setting
       * any optional parameters, call the {@link GetCapabilities#execute()} method to invoke the remote
       * operation. <p> {@link GetCapabilities#initialize(com.google.api.client.googleapis.services.Abst
       * ractGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param name This field resolves to "phones/{E.164}/capabilities", where {E.164} is the user's phone number in
     *        E.164 format. For example, for a user with the US phone number +1-222-333-4444, the
     *        resulting endpoint is
     *        https://rcsbusinessmessaging.googleapis.com/v1/phones/+12223334444/capabilities.
       * @since 1.13
       */
      protected GetCapabilities(java.lang.String name) {
        super(RCSBusinessMessaging.this, "GET", REST_PATH, null, com.google.api.services.rcsbusinessmessaging.v1.model.Capabilities.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^phones/[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetCapabilities set$Xgafv(java.lang.String $Xgafv) {
        return (GetCapabilities) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetCapabilities setAccessToken(java.lang.String accessToken) {
        return (GetCapabilities) super.setAccessToken(accessToken);
      }

      @Override
      public GetCapabilities setAlt(java.lang.String alt) {
        return (GetCapabilities) super.setAlt(alt);
      }

      @Override
      public GetCapabilities setCallback(java.lang.String callback) {
        return (GetCapabilities) super.setCallback(callback);
      }

      @Override
      public GetCapabilities setFields(java.lang.String fields) {
        return (GetCapabilities) super.setFields(fields);
      }

      @Override
      public GetCapabilities setKey(java.lang.String key) {
        return (GetCapabilities) super.setKey(key);
      }

      @Override
      public GetCapabilities setOauthToken(java.lang.String oauthToken) {
        return (GetCapabilities) super.setOauthToken(oauthToken);
      }

      @Override
      public GetCapabilities setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetCapabilities) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetCapabilities setQuotaUser(java.lang.String quotaUser) {
        return (GetCapabilities) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetCapabilities setUploadType(java.lang.String uploadType) {
        return (GetCapabilities) super.setUploadType(uploadType);
      }

      @Override
      public GetCapabilities setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetCapabilities) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * This field resolves to "phones/{E.164}/capabilities", where {E.164} is the user's phone
       * number in E.164 format. For example, for a user with the US phone number +1-222-333-4444,
       * the resulting endpoint is
       * https://rcsbusinessmessaging.googleapis.com/v1/phones/+12223334444/capabilities.
       */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** This field resolves to "phones/{E.164}/capabilities", where {E.164} is the user's phone number in
     E.164 format. For example, for a user with the US phone number +1-222-333-4444, the resulting
     endpoint is https://rcsbusinessmessaging.googleapis.com/v1/phones/+12223334444/capabilities.
       */
      public java.lang.String getName() {
        return name;
      }

      /**
       * This field resolves to "phones/{E.164}/capabilities", where {E.164} is the user's phone
       * number in E.164 format. For example, for a user with the US phone number +1-222-333-4444,
       * the resulting endpoint is
       * https://rcsbusinessmessaging.googleapis.com/v1/phones/+12223334444/capabilities.
       */
      public GetCapabilities setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^phones/[^/]+$");
        }
        this.name = name;
        return this;
      }

      /**
       * The unique ID of the request, assigned by the agent. This must be a UUID, as defined in
       * https://tools.ietf.org/html/rfc4122. If the request ID matches an ID that the agent used
       * for a previous request, the RBM platform ignores the new request.
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** The unique ID of the request, assigned by the agent. This must be a UUID, as defined in
     https://tools.ietf.org/html/rfc4122. If the request ID matches an ID that the agent used for a
     previous request, the RBM platform ignores the new request.
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * The unique ID of the request, assigned by the agent. This must be a UUID, as defined in
       * https://tools.ietf.org/html/rfc4122. If the request ID matches an ID that the agent used
       * for a previous request, the RBM platform ignores the new request.
       */
      public GetCapabilities setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public GetCapabilities set(String parameterName, Object value) {
        return (GetCapabilities) super.set(parameterName, value);
      }
    }

    /**
     * An accessor for creating requests from the AgentEvents collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code RCSBusinessMessaging rcsbusinessmessaging = new RCSBusinessMessaging(...);}
     *   {@code RCSBusinessMessaging.AgentEvents.List request = rcsbusinessmessaging.agentEvents().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public AgentEvents agentEvents() {
      return new AgentEvents();
    }

    /**
     * The "agentEvents" collection of methods.
     */
    public class AgentEvents {

      /**
       * Sends an event from the agent to a user. Agent events can be used to indicate that the agent has
       * read a message from the user or that the agent is in the process of typing (which adds a human
       * element to the RBM experience). Unlike agent messages, agent events cannot be revoked after
       * sending.
       *
       * Create a request for the method "agentEvents.create".
       *
       * This request holds the parameters needed by the rcsbusinessmessaging server.  After setting any
       * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param parent "phones/{E.164}", where {E.164} is the user's phone number in E.164 format. For example, for a user
       *        with the US phone number +1-222-333-4444, the value would be phones/+12223334444, and the
       *        resulting endpoint would be
       *        https://rcsbusinessmessaging.googleapis.com/v1/phones/+12223334444/agentEvents.
       * @param content the {@link com.google.api.services.rcsbusinessmessaging.v1.model.AgentEvent}
       * @return the request
       */
      public Create create(java.lang.String parent, com.google.api.services.rcsbusinessmessaging.v1.model.AgentEvent content) throws java.io.IOException {
        Create result = new Create(parent, content);
        initialize(result);
        return result;
      }

      public class Create extends RCSBusinessMessagingRequest<com.google.api.services.rcsbusinessmessaging.v1.model.AgentEvent> {

        private static final String REST_PATH = "v1/{+parent}/agentEvents";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^phones/[^/]+$");

        /**
         * Sends an event from the agent to a user. Agent events can be used to indicate that the agent
         * has read a message from the user or that the agent is in the process of typing (which adds a
         * human element to the RBM experience). Unlike agent messages, agent events cannot be revoked
         * after sending.
         *
         * Create a request for the method "agentEvents.create".
         *
         * This request holds the parameters needed by the the rcsbusinessmessaging server.  After setting
         * any optional parameters, call the {@link Create#execute()} method to invoke the remote
         * operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent "phones/{E.164}", where {E.164} is the user's phone number in E.164 format. For example, for a user
       *        with the US phone number +1-222-333-4444, the value would be phones/+12223334444, and the
       *        resulting endpoint would be
       *        https://rcsbusinessmessaging.googleapis.com/v1/phones/+12223334444/agentEvents.
         * @param content the {@link com.google.api.services.rcsbusinessmessaging.v1.model.AgentEvent}
         * @since 1.13
         */
        protected Create(java.lang.String parent, com.google.api.services.rcsbusinessmessaging.v1.model.AgentEvent content) {
          super(RCSBusinessMessaging.this, "POST", REST_PATH, content, com.google.api.services.rcsbusinessmessaging.v1.model.AgentEvent.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^phones/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * "phones/{E.164}", where {E.164} is the user's phone number in E.164 format. For example,
         * for a user with the US phone number +1-222-333-4444, the value would be
         * phones/+12223334444, and the resulting endpoint would be
         * https://rcsbusinessmessaging.googleapis.com/v1/phones/+12223334444/agentEvents.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /**" phones/{E.164}", where {E.164} is the user's phone number in E.164 format. For example, for a user
      " with the US phone number +1-222-333-4444, the value would be phones/+12223334444, and the
      " resulting endpoint would be
      " https://rcsbusinessmessaging.googleapis.com/v1/phones/+12223334444/agentEvents.
      "

         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * "phones/{E.164}", where {E.164} is the user's phone number in E.164 format. For example,
         * for a user with the US phone number +1-222-333-4444, the value would be
         * phones/+12223334444, and the resulting endpoint would be
         * https://rcsbusinessmessaging.googleapis.com/v1/phones/+12223334444/agentEvents.
         */
        public Create setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^phones/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /**
         * The ID of the event, assigned by the agent. This must be a UUID, as defined in
         * https://tools.ietf.org/html/rfc4122. The RBM platform ignores any agent message sent with
         * an ID that was used by an earlier message or event sent from the same agent.
         */
        @com.google.api.client.util.Key
        private java.lang.String eventId;

        /** The ID of the event, assigned by the agent. This must be a UUID, as defined in
       https://tools.ietf.org/html/rfc4122. The RBM platform ignores any agent message sent with an ID
       that was used by an earlier message or event sent from the same agent.
         */
        public java.lang.String getEventId() {
          return eventId;
        }

        /**
         * The ID of the event, assigned by the agent. This must be a UUID, as defined in
         * https://tools.ietf.org/html/rfc4122. The RBM platform ignores any agent message sent with
         * an ID that was used by an earlier message or event sent from the same agent.
         */
        public Create setEventId(java.lang.String eventId) {
          this.eventId = eventId;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the AgentMessages collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code RCSBusinessMessaging rcsbusinessmessaging = new RCSBusinessMessaging(...);}
     *   {@code RCSBusinessMessaging.AgentMessages.List request = rcsbusinessmessaging.agentMessages().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public AgentMessages agentMessages() {
      return new AgentMessages();
    }

    /**
     * The "agentMessages" collection of methods.
     */
    public class AgentMessages {

      /**
       * Sends a message from the agent to a user. The user must be RCS enabled and reachable by the RBM
       * platform in order for the agent to successfully send a message. When the message has been
       * successfully sent, the call returns with no error. Otherwise, the agent receives an error code.
       * If the user is online, the RBM platform delivers the message right away. Otherwise, the RBM
       * platform queues the message and delivered it when the user is next online. The RBM platform
       * ignores any agent message sent with an ID that was used by an earlier message or event sent from
       * the same agent. Agent messages can be revoked between the time that they are sent and the time
       * that they are delivered.
       *
       * Create a request for the method "agentMessages.create".
       *
       * This request holds the parameters needed by the rcsbusinessmessaging server.  After setting any
       * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param parent "phones/{E.164}", where {E.164} is the user's phone number in E.164 format. For example, with the US
       *        phone number +1-222-333-4444, the value would be phones/+12223334444, and the resulting
       *        endpoint would be
       *        https://rcsbusinessmessaging.googleapis.com/v1/phones/+12223334444/agentMessages.
       * @param content the {@link com.google.api.services.rcsbusinessmessaging.v1.model.AgentMessage}
       * @return the request
       */
      public Create create(java.lang.String parent, com.google.api.services.rcsbusinessmessaging.v1.model.AgentMessage content) throws java.io.IOException {
        Create result = new Create(parent, content);
        initialize(result);
        return result;
      }

      public class Create extends RCSBusinessMessagingRequest<com.google.api.services.rcsbusinessmessaging.v1.model.AgentMessage> {

        private static final String REST_PATH = "v1/{+parent}/agentMessages";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^phones/[^/]+$");

        /**
         * Sends a message from the agent to a user. The user must be RCS enabled and reachable by the RBM
         * platform in order for the agent to successfully send a message. When the message has been
         * successfully sent, the call returns with no error. Otherwise, the agent receives an error code.
         * If the user is online, the RBM platform delivers the message right away. Otherwise, the RBM
         * platform queues the message and delivered it when the user is next online. The RBM platform
         * ignores any agent message sent with an ID that was used by an earlier message or event sent
         * from the same agent. Agent messages can be revoked between the time that they are sent and the
         * time that they are delivered.
         *
         * Create a request for the method "agentMessages.create".
         *
         * This request holds the parameters needed by the the rcsbusinessmessaging server.  After setting
         * any optional parameters, call the {@link Create#execute()} method to invoke the remote
         * operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent "phones/{E.164}", where {E.164} is the user's phone number in E.164 format. For example, with the US
       *        phone number +1-222-333-4444, the value would be phones/+12223334444, and the resulting
       *        endpoint would be
       *        https://rcsbusinessmessaging.googleapis.com/v1/phones/+12223334444/agentMessages.
         * @param content the {@link com.google.api.services.rcsbusinessmessaging.v1.model.AgentMessage}
         * @since 1.13
         */
        protected Create(java.lang.String parent, com.google.api.services.rcsbusinessmessaging.v1.model.AgentMessage content) {
          super(RCSBusinessMessaging.this, "POST", REST_PATH, content, com.google.api.services.rcsbusinessmessaging.v1.model.AgentMessage.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^phones/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * "phones/{E.164}", where {E.164} is the user's phone number in E.164 format. For example,
         * with the US phone number +1-222-333-4444, the value would be phones/+12223334444, and the
         * resulting endpoint would be
         * https://rcsbusinessmessaging.googleapis.com/v1/phones/+12223334444/agentMessages.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /**" phones/{E.164}", where {E.164} is the user's phone number in E.164 format. For example, with the
      " US phone number +1-222-333-4444, the value would be phones/+12223334444, and the resulting
      " endpoint would be
      " https://rcsbusinessmessaging.googleapis.com/v1/phones/+12223334444/agentMessages.
      "

         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * "phones/{E.164}", where {E.164} is the user's phone number in E.164 format. For example,
         * with the US phone number +1-222-333-4444, the value would be phones/+12223334444, and the
         * resulting endpoint would be
         * https://rcsbusinessmessaging.googleapis.com/v1/phones/+12223334444/agentMessages.
         */
        public Create setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^phones/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /**
         * The unique ID of the message, assigned by the agent. This must be a UUID, as defined in
         * https://tools.ietf.org/html/rfc4122. The RBM platform ignores any agent message sent with
         * an ID that was used by an earlier message or event sent from the same agent.
         */
        @com.google.api.client.util.Key
        private java.lang.String messageId;

        /** The unique ID of the message, assigned by the agent. This must be a UUID, as defined in
       https://tools.ietf.org/html/rfc4122. The RBM platform ignores any agent message sent with an ID
       that was used by an earlier message or event sent from the same agent.
         */
        public java.lang.String getMessageId() {
          return messageId;
        }

        /**
         * The unique ID of the message, assigned by the agent. This must be a UUID, as defined in
         * https://tools.ietf.org/html/rfc4122. The RBM platform ignores any agent message sent with
         * an ID that was used by an earlier message or event sent from the same agent.
         */
        public Create setMessageId(java.lang.String messageId) {
          this.messageId = messageId;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Revokes an agent message that has been sent but not yet delivered. If the RBM platform
       * successfully revokes a message, then the message is deleted from the user’s message queue and is
       * never delivered. This method immediately returns 200 OK, whether or not the message was
       * successfully revoked. There is a small chance that the agent may initiate a revocation while the
       * RBM platform is in the process of delivering the message. In these rare cases, the agent receives
       * a DELIVERED user event for the message shortly after initiating the revocation request.
       *
       * Create a request for the method "agentMessages.delete".
       *
       * This request holds the parameters needed by the rcsbusinessmessaging server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param name "phones/{E.164}/agentMessages/{messageId}", where {E.164} is the user's phone number in E.164 format
       *        and {messageId} is the agent-assigned ID of the agent message that should be revoked. For
       *        example, with the US phone number +1-222-333-4444 and an agent message with the ID
       *        "12345xyz", the resulting endpoint would be
       *        https://rcsbusinessmessaging.googleapis.com/v1/phones/+12223334444/agentMessages/12345xyz.
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends RCSBusinessMessagingRequest<com.google.api.services.rcsbusinessmessaging.v1.model.Empty> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^phones/[^/]+/agentMessages/[^/]+$");

        /**
         * Revokes an agent message that has been sent but not yet delivered. If the RBM platform
         * successfully revokes a message, then the message is deleted from the user’s message queue and
         * is never delivered. This method immediately returns 200 OK, whether or not the message was
         * successfully revoked. There is a small chance that the agent may initiate a revocation while
         * the RBM platform is in the process of delivering the message. In these rare cases, the agent
         * receives a DELIVERED user event for the message shortly after initiating the revocation
         * request.
         *
         * Create a request for the method "agentMessages.delete".
         *
         * This request holds the parameters needed by the the rcsbusinessmessaging server.  After setting
         * any optional parameters, call the {@link Delete#execute()} method to invoke the remote
         * operation. <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name "phones/{E.164}/agentMessages/{messageId}", where {E.164} is the user's phone number in E.164 format
       *        and {messageId} is the agent-assigned ID of the agent message that should be revoked. For
       *        example, with the US phone number +1-222-333-4444 and an agent message with the ID
       *        "12345xyz", the resulting endpoint would be
       *        https://rcsbusinessmessaging.googleapis.com/v1/phones/+12223334444/agentMessages/12345xyz.
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(RCSBusinessMessaging.this, "DELETE", REST_PATH, null, com.google.api.services.rcsbusinessmessaging.v1.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^phones/[^/]+/agentMessages/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * "phones/{E.164}/agentMessages/{messageId}", where {E.164} is the user's phone number in
         * E.164 format and {messageId} is the agent-assigned ID of the agent message that should be
         * revoked. For example, with the US phone number +1-222-333-4444 and an agent message with
         * the ID "12345xyz", the resulting endpoint would be https://rcsbusinessmessaging.googleapi
         * s.com/v1/phones/+12223334444/agentMessages/12345xyz.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /**" phones/{E.164}/agentMessages/{messageId}", where {E.164} is the user's phone number in E.164
      " format and {messageId} is the agent-assigned ID of the agent message that should be revoked. For
      " example, with the US phone number +1-222-333-4444 and an agent message with the ID "12345xyz", the
      " resulting endpoint would be
      " https://rcsbusinessmessaging.googleapis.com/v1/phones/+12223334444/agentMessages/12345xyz.
      "

         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * "phones/{E.164}/agentMessages/{messageId}", where {E.164} is the user's phone number in
         * E.164 format and {messageId} is the agent-assigned ID of the agent message that should be
         * revoked. For example, with the US phone number +1-222-333-4444 and an agent message with
         * the ID "12345xyz", the resulting endpoint would be https://rcsbusinessmessaging.googleapi
         * s.com/v1/phones/+12223334444/agentMessages/12345xyz.
         */
        public Delete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^phones/[^/]+/agentMessages/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Capability collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code RCSBusinessMessaging rcsbusinessmessaging = new RCSBusinessMessaging(...);}
     *   {@code RCSBusinessMessaging.Capability.List request = rcsbusinessmessaging.capability().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Capability capability() {
      return new Capability();
    }

    /**
     * The "capability" collection of methods.
     */
    public class Capability {

      /**
       * Requests a callback containing the capabilities of a user. Following this request, the agent
       * receives an asynchronous callback with the user's capabilities.
       *
       * Create a request for the method "capability.requestCapabilityCallback".
       *
       * This request holds the parameters needed by the rcsbusinessmessaging server.  After setting any
       * optional parameters, call the {@link RequestCapabilityCallback#execute()} method to invoke the
       * remote operation.
       *
       * @param name "phones/{E.164}/capability", where {E.164} is the user's phone number in E.164 format. For example,
       *        with the US phone number +1-222-333-4444, the resulting endpoint would be https://rcsbusin
       *        essmessaging.googleapis.com/v1/phones/+12223334444/capability:requestCapabilityCallback
       * @param content the {@link com.google.api.services.rcsbusinessmessaging.v1.model.RequestCapabilityCallbackRequest}
       * @return the request
       */
      public RequestCapabilityCallback requestCapabilityCallback(java.lang.String name, com.google.api.services.rcsbusinessmessaging.v1.model.RequestCapabilityCallbackRequest content) throws java.io.IOException {
        RequestCapabilityCallback result = new RequestCapabilityCallback(name, content);
        initialize(result);
        return result;
      }

      public class RequestCapabilityCallback extends RCSBusinessMessagingRequest<com.google.api.services.rcsbusinessmessaging.v1.model.Empty> {

        private static final String REST_PATH = "v1/{+name}/capability:requestCapabilityCallback";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^phones/[^/]+$");

        /**
         * Requests a callback containing the capabilities of a user. Following this request, the agent
         * receives an asynchronous callback with the user's capabilities.
         *
         * Create a request for the method "capability.requestCapabilityCallback".
         *
         * This request holds the parameters needed by the the rcsbusinessmessaging server.  After setting
         * any optional parameters, call the {@link RequestCapabilityCallback#execute()} method to invoke
         * the remote operation. <p> {@link RequestCapabilityCallback#initialize(com.google.api.client.goo
         * gleapis.services.AbstractGoogleClientRequest)} must be called to initialize this instance
         * immediately after invoking the constructor. </p>
         *
         * @param name "phones/{E.164}/capability", where {E.164} is the user's phone number in E.164 format. For example,
       *        with the US phone number +1-222-333-4444, the resulting endpoint would be https://rcsbusin
       *        essmessaging.googleapis.com/v1/phones/+12223334444/capability:requestCapabilityCallback
         * @param content the {@link com.google.api.services.rcsbusinessmessaging.v1.model.RequestCapabilityCallbackRequest}
         * @since 1.13
         */
        protected RequestCapabilityCallback(java.lang.String name, com.google.api.services.rcsbusinessmessaging.v1.model.RequestCapabilityCallbackRequest content) {
          super(RCSBusinessMessaging.this, "POST", REST_PATH, content, com.google.api.services.rcsbusinessmessaging.v1.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^phones/[^/]+$");
          }
        }

        @Override
        public RequestCapabilityCallback set$Xgafv(java.lang.String $Xgafv) {
          return (RequestCapabilityCallback) super.set$Xgafv($Xgafv);
        }

        @Override
        public RequestCapabilityCallback setAccessToken(java.lang.String accessToken) {
          return (RequestCapabilityCallback) super.setAccessToken(accessToken);
        }

        @Override
        public RequestCapabilityCallback setAlt(java.lang.String alt) {
          return (RequestCapabilityCallback) super.setAlt(alt);
        }

        @Override
        public RequestCapabilityCallback setCallback(java.lang.String callback) {
          return (RequestCapabilityCallback) super.setCallback(callback);
        }

        @Override
        public RequestCapabilityCallback setFields(java.lang.String fields) {
          return (RequestCapabilityCallback) super.setFields(fields);
        }

        @Override
        public RequestCapabilityCallback setKey(java.lang.String key) {
          return (RequestCapabilityCallback) super.setKey(key);
        }

        @Override
        public RequestCapabilityCallback setOauthToken(java.lang.String oauthToken) {
          return (RequestCapabilityCallback) super.setOauthToken(oauthToken);
        }

        @Override
        public RequestCapabilityCallback setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (RequestCapabilityCallback) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public RequestCapabilityCallback setQuotaUser(java.lang.String quotaUser) {
          return (RequestCapabilityCallback) super.setQuotaUser(quotaUser);
        }

        @Override
        public RequestCapabilityCallback setUploadType(java.lang.String uploadType) {
          return (RequestCapabilityCallback) super.setUploadType(uploadType);
        }

        @Override
        public RequestCapabilityCallback setUploadProtocol(java.lang.String uploadProtocol) {
          return (RequestCapabilityCallback) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * "phones/{E.164}/capability", where {E.164} is the user's phone number in E.164 format.
         * For example, with the US phone number +1-222-333-4444, the resulting endpoint would be ht
         * tps://rcsbusinessmessaging.googleapis.com/v1/phones/+12223334444/capability:requestCapabi
         * lityCallback
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /**" phones/{E.164}/capability", where {E.164} is the user's phone number in E.164 format. For example,
      " with the US phone number +1-222-333-4444, the resulting endpoint would be https://rcsbusinessmessa
      " ging.googleapis.com/v1/phones/+12223334444/capability:requestCapabilityCallback
      "

         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * "phones/{E.164}/capability", where {E.164} is the user's phone number in E.164 format.
         * For example, with the US phone number +1-222-333-4444, the resulting endpoint would be ht
         * tps://rcsbusinessmessaging.googleapis.com/v1/phones/+12223334444/capability:requestCapabi
         * lityCallback
         */
        public RequestCapabilityCallback setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^phones/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public RequestCapabilityCallback set(String parameterName, Object value) {
          return (RequestCapabilityCallback) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the DialogflowMessages collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code RCSBusinessMessaging rcsbusinessmessaging = new RCSBusinessMessaging(...);}
     *   {@code RCSBusinessMessaging.DialogflowMessages.List request = rcsbusinessmessaging.dialogflowMessages().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public DialogflowMessages dialogflowMessages() {
      return new DialogflowMessages();
    }

    /**
     * The "dialogflowMessages" collection of methods.
     */
    public class DialogflowMessages {

      /**
       * Prompts a Dialogflow agent to send messages through an RBM agent. If Dialogflow integration isn't
       * enabled for an RBM agent, this method returns `403 PERMISSION_DENIED`. When an RBM agent is
       * integrated with a Dialogflow agent, this method triggers an event in the Dialogflow agent. The
       * RBM Platform routes responses from Dialogflow to the user's device and routes messages from the
       * user back to the Dialogflow agent. If a Dialogflow intent defines multiple responses, the RBM
       * Platform sends users one message per defined response. If you contact a webhook with Dialogflow
       * fulfillment, the fulfillment request includes the following information in the payload: Field
       * Description rbm_user_phone_number The user's phone number. rbm_share_location_response The user's
       * location, if they tapped the share location suggested action.
       *
       * Create a request for the method "dialogflowMessages.create".
       *
       * This request holds the parameters needed by the rcsbusinessmessaging server.  After setting any
       * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param parent "phones/{E.164}", where {E.164} is the user's phone number
       * @param content the {@link com.google.api.services.rcsbusinessmessaging.v1.model.DialogflowEvent}
       * @return the request
       */
      public Create create(java.lang.String parent, com.google.api.services.rcsbusinessmessaging.v1.model.DialogflowEvent content) throws java.io.IOException {
        Create result = new Create(parent, content);
        initialize(result);
        return result;
      }

      public class Create extends RCSBusinessMessagingRequest<com.google.api.services.rcsbusinessmessaging.v1.model.DialogflowEvent> {

        private static final String REST_PATH = "v1/{+parent}/dialogflowMessages";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^phones/[^/]+$");

        /**
         * Prompts a Dialogflow agent to send messages through an RBM agent. If Dialogflow integration
         * isn't enabled for an RBM agent, this method returns `403 PERMISSION_DENIED`. When an RBM agent
         * is integrated with a Dialogflow agent, this method triggers an event in the Dialogflow agent.
         * The RBM Platform routes responses from Dialogflow to the user's device and routes messages from
         * the user back to the Dialogflow agent. If a Dialogflow intent defines multiple responses, the
         * RBM Platform sends users one message per defined response. If you contact a webhook with
         * Dialogflow fulfillment, the fulfillment request includes the following information in the
         * payload: Field Description rbm_user_phone_number The user's phone number.
         * rbm_share_location_response The user's location, if they tapped the share location suggested
         * action.
         *
         * Create a request for the method "dialogflowMessages.create".
         *
         * This request holds the parameters needed by the the rcsbusinessmessaging server.  After setting
         * any optional parameters, call the {@link Create#execute()} method to invoke the remote
         * operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent "phones/{E.164}", where {E.164} is the user's phone number
         * @param content the {@link com.google.api.services.rcsbusinessmessaging.v1.model.DialogflowEvent}
         * @since 1.13
         */
        protected Create(java.lang.String parent, com.google.api.services.rcsbusinessmessaging.v1.model.DialogflowEvent content) {
          super(RCSBusinessMessaging.this, "POST", REST_PATH, content, com.google.api.services.rcsbusinessmessaging.v1.model.DialogflowEvent.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^phones/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /** "phones/{E.164}", where {E.164} is the user's phone number */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /**" phones/{E.164}", where {E.164} is the user's phone number
      "

         */
        public java.lang.String getParent() {
          return parent;
        }

        /** "phones/{E.164}", where {E.164} is the user's phone number */
        public Create setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^phones/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /**
         * A unique prefix of RBM message IDs that result from the Dialogflow event. Dialogflow
         * supports multiple responses for a given event. If an event triggers multiple responses,
         * RBM forwards each response as a separate message. Each message ID shares the same prefix.
         */
        @com.google.api.client.util.Key
        private java.lang.String messageIdPrefix;

        /** A unique prefix of RBM message IDs that result from the Dialogflow event. Dialogflow supports
       multiple responses for a given event. If an event triggers multiple responses, RBM forwards each
       response as a separate message. Each message ID shares the same prefix.
         */
        public java.lang.String getMessageIdPrefix() {
          return messageIdPrefix;
        }

        /**
         * A unique prefix of RBM message IDs that result from the Dialogflow event. Dialogflow
         * supports multiple responses for a given event. If an event triggers multiple responses,
         * RBM forwards each response as a separate message. Each message ID shares the same prefix.
         */
        public Create setMessageIdPrefix(java.lang.String messageIdPrefix) {
          this.messageIdPrefix = messageIdPrefix;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Testers collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code RCSBusinessMessaging rcsbusinessmessaging = new RCSBusinessMessaging(...);}
     *   {@code RCSBusinessMessaging.Testers.List request = rcsbusinessmessaging.testers().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Testers testers() {
      return new Testers();
    }

    /**
     * The "testers" collection of methods.
     */
    public class Testers {

      /**
       * Invites a user to test an agent. The invited user must be RCS-enabled and reachable by the RBM
       * platform. When an agent invites a user to become a tester, an RBM platform management agent sends
       * a message to the user asking for confirmation that she wants to be a tester of the agent. Once
       * the user confirms, she becomes a tester. An agent that has not yet launched can only interact
       * with users who are testers of that agent. If an unlaunched agent attempts to send a message,
       * event, or capability callback to a non-tester, the RBM platform returns a `403 PERMISSION_DENIED`
       * error. An agent can send 20 tester requests each day with a total maximum of 200 tester requests.
       * If you send tester requests above those limits, the RBM platform returns a `429
       * RESOURCE_EXHAUSTED` response.
       *
       * Create a request for the method "testers.create".
       *
       * This request holds the parameters needed by the rcsbusinessmessaging server.  After setting any
       * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param parent "phones/{E.164}", where {E.164} is the user's phone number in E.164 format. For example, with the US
       *        phone number +1-222-333-4444, the resulting endpoint would be
       *        https://rcsbusinessmessaging.googleapis.com/v1/phones/+12223334444/testers/.
       * @param content the {@link com.google.api.services.rcsbusinessmessaging.v1.model.Tester}
       * @return the request
       */
      public Create create(java.lang.String parent, com.google.api.services.rcsbusinessmessaging.v1.model.Tester content) throws java.io.IOException {
        Create result = new Create(parent, content);
        initialize(result);
        return result;
      }

      public class Create extends RCSBusinessMessagingRequest<com.google.api.services.rcsbusinessmessaging.v1.model.Tester> {

        private static final String REST_PATH = "v1/{+parent}/testers";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^phones/[^/]+$");

        /**
         * Invites a user to test an agent. The invited user must be RCS-enabled and reachable by the RBM
         * platform. When an agent invites a user to become a tester, an RBM platform management agent
         * sends a message to the user asking for confirmation that she wants to be a tester of the agent.
         * Once the user confirms, she becomes a tester. An agent that has not yet launched can only
         * interact with users who are testers of that agent. If an unlaunched agent attempts to send a
         * message, event, or capability callback to a non-tester, the RBM platform returns a `403
         * PERMISSION_DENIED` error. An agent can send 20 tester requests each day with a total maximum of
         * 200 tester requests. If you send tester requests above those limits, the RBM platform returns a
         * `429 RESOURCE_EXHAUSTED` response.
         *
         * Create a request for the method "testers.create".
         *
         * This request holds the parameters needed by the the rcsbusinessmessaging server.  After setting
         * any optional parameters, call the {@link Create#execute()} method to invoke the remote
         * operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent "phones/{E.164}", where {E.164} is the user's phone number in E.164 format. For example, with the US
       *        phone number +1-222-333-4444, the resulting endpoint would be
       *        https://rcsbusinessmessaging.googleapis.com/v1/phones/+12223334444/testers/.
         * @param content the {@link com.google.api.services.rcsbusinessmessaging.v1.model.Tester}
         * @since 1.13
         */
        protected Create(java.lang.String parent, com.google.api.services.rcsbusinessmessaging.v1.model.Tester content) {
          super(RCSBusinessMessaging.this, "POST", REST_PATH, content, com.google.api.services.rcsbusinessmessaging.v1.model.Tester.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^phones/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * "phones/{E.164}", where {E.164} is the user's phone number in E.164 format. For example,
         * with the US phone number +1-222-333-4444, the resulting endpoint would be
         * https://rcsbusinessmessaging.googleapis.com/v1/phones/+12223334444/testers/.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /**" phones/{E.164}", where {E.164} is the user's phone number in E.164 format. For example, with the
      " US phone number +1-222-333-4444, the resulting endpoint would be
      " https://rcsbusinessmessaging.googleapis.com/v1/phones/+12223334444/testers/.
      "

         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * "phones/{E.164}", where {E.164} is the user's phone number in E.164 format. For example,
         * with the US phone number +1-222-333-4444, the resulting endpoint would be
         * https://rcsbusinessmessaging.googleapis.com/v1/phones/+12223334444/testers/.
         */
        public Create setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^phones/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * An accessor for creating requests from the Users collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code RCSBusinessMessaging rcsbusinessmessaging = new RCSBusinessMessaging(...);}
   *   {@code RCSBusinessMessaging.Users.List request = rcsbusinessmessaging.users().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Users users() {
    return new Users();
  }

  /**
   * The "users" collection of methods.
   */
  public class Users {

    /**
     * Gets the RCS-enabled phone numbers for a list of users. The returned payload contains a list of
     * RCS-enabled phone numbers reachable by the RBM platform for the specified users. Only phone
     * numbers that are RCS-enabled for a carrier the agent is launched on will be returned. The
     * returned payload also contains values that can be used to estimate the potential reach of a list
     * of phone numbers regardless of the launch status of the agent.
     *
     * Create a request for the method "users.batchGet".
     *
     * This request holds the parameters needed by the rcsbusinessmessaging server.  After setting any
     * optional parameters, call the {@link BatchGet#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.rcsbusinessmessaging.v1.model.BatchGetUsersRequest}
     * @return the request
     */
    public BatchGet batchGet(com.google.api.services.rcsbusinessmessaging.v1.model.BatchGetUsersRequest content) throws java.io.IOException {
      BatchGet result = new BatchGet(content);
      initialize(result);
      return result;
    }

    public class BatchGet extends RCSBusinessMessagingRequest<com.google.api.services.rcsbusinessmessaging.v1.model.BatchGetUsersResponse> {

      private static final String REST_PATH = "v1/users:batchGet";

      /**
       * Gets the RCS-enabled phone numbers for a list of users. The returned payload contains a list of
       * RCS-enabled phone numbers reachable by the RBM platform for the specified users. Only phone
       * numbers that are RCS-enabled for a carrier the agent is launched on will be returned. The
       * returned payload also contains values that can be used to estimate the potential reach of a
       * list of phone numbers regardless of the launch status of the agent.
       *
       * Create a request for the method "users.batchGet".
       *
       * This request holds the parameters needed by the the rcsbusinessmessaging server.  After setting
       * any optional parameters, call the {@link BatchGet#execute()} method to invoke the remote
       * operation. <p> {@link
       * BatchGet#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.rcsbusinessmessaging.v1.model.BatchGetUsersRequest}
       * @since 1.13
       */
      protected BatchGet(com.google.api.services.rcsbusinessmessaging.v1.model.BatchGetUsersRequest content) {
        super(RCSBusinessMessaging.this, "POST", REST_PATH, content, com.google.api.services.rcsbusinessmessaging.v1.model.BatchGetUsersResponse.class);
      }

      @Override
      public BatchGet set$Xgafv(java.lang.String $Xgafv) {
        return (BatchGet) super.set$Xgafv($Xgafv);
      }

      @Override
      public BatchGet setAccessToken(java.lang.String accessToken) {
        return (BatchGet) super.setAccessToken(accessToken);
      }

      @Override
      public BatchGet setAlt(java.lang.String alt) {
        return (BatchGet) super.setAlt(alt);
      }

      @Override
      public BatchGet setCallback(java.lang.String callback) {
        return (BatchGet) super.setCallback(callback);
      }

      @Override
      public BatchGet setFields(java.lang.String fields) {
        return (BatchGet) super.setFields(fields);
      }

      @Override
      public BatchGet setKey(java.lang.String key) {
        return (BatchGet) super.setKey(key);
      }

      @Override
      public BatchGet setOauthToken(java.lang.String oauthToken) {
        return (BatchGet) super.setOauthToken(oauthToken);
      }

      @Override
      public BatchGet setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (BatchGet) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public BatchGet setQuotaUser(java.lang.String quotaUser) {
        return (BatchGet) super.setQuotaUser(quotaUser);
      }

      @Override
      public BatchGet setUploadType(java.lang.String uploadType) {
        return (BatchGet) super.setUploadType(uploadType);
      }

      @Override
      public BatchGet setUploadProtocol(java.lang.String uploadProtocol) {
        return (BatchGet) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public BatchGet set(String parameterName, Object value) {
        return (BatchGet) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link RCSBusinessMessaging}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link RCSBusinessMessaging}. */
    @Override
    public RCSBusinessMessaging build() {
      return new RCSBusinessMessaging(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link RCSBusinessMessagingRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setRCSBusinessMessagingRequestInitializer(
        RCSBusinessMessagingRequestInitializer rcsbusinessmessagingRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(rcsbusinessmessagingRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
