/*
Copyright 2018 Google Inc. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package com.google.rbm.samples.servlets;

// [START servlet for resetting chat messages for a device]
import com.google.appengine.api.datastore.*;
import com.google.rbm.samples.BankingAgentBot;

import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.logging.Logger;

/**
 * Servlet for customer support chat interface to reset chat.
 */
@WebServlet(name = "CustomerSupportReset", value = "/chatReset")
public class CustomerSupportReset extends HttpServlet {
    private static final Logger logger = Logger.getLogger(CustomerSupportReset.class.getName());

    public CustomerSupportReset() {
        super();
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response)
            throws IOException {

        // get the test device number
        String phoneNumber = request.getParameter("phone_number");

        try {
            BankingAgentBot bankingAgentBot = new BankingAgentBot(phoneNumber);

            // removes chat history for the phone number
            bankingAgentBot.resetChat();
        } catch (Exception e) {
            e.printStackTrace();
        }

        response.sendRedirect("index.jsp");
    }
}
// [END servlet for resetting chat messages for a device]