/*
 * Copyright (C) 2018 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.rbm.samples.servlets;

// [START conversation start servlet]

// [START import_libraries]

import com.google.rbm.samples.BankingAgentBot;
import com.google.rbm.samples.lib.RbmApiHelper;

import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.logging.Logger;
// [END import_libraries]

/**
 * Servlet for starting the conversation with the Banking Agent bot.
 */
@WebServlet(name = "BankingAgentConversationStart", value = "/startConversation")
public class BankingAgentConversationStart extends HttpServlet {
    private static final Logger logger = Logger.getLogger(BankingAgentConversationStart.class.getName());

    public BankingAgentConversationStart() {
        super();
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        // set the response type to JSON
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");

        // get the test device number
        String phoneNumber = request.getParameter("phone_number");

        request.getSession().setAttribute("phone_number", phoneNumber);

        // start the conversation
        try {
            BankingAgentBot bankingAgentBot = new BankingAgentBot(phoneNumber);
            bankingAgentBot.sendGreeting();

            response.getWriter().println("{\"response\": \"ok\"}");
            response.getWriter().flush();
        } catch(Exception e) {
            e.printStackTrace();
            logger.info(e.getMessage());

            response.getWriter().println("{\"response\": \"fail\"}");
            response.getWriter().flush();
        }
    }
}
// [END conversation start servlet]
