/*
Copyright 2018 Google Inc. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package com.google.rbm.samples.servlets;

// [START servlet for initializing a direct chat with a device]
import com.google.rbm.samples.BankingAgentBot;

import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.logging.Logger;

/**
 * Servlet for customer support chat initialization.
 */
@WebServlet(name = "CustomerSupportInitChat", value = "/initChat")
public class CustomerSupportInitChat extends HttpServlet {
    private static final Logger logger = Logger.getLogger(CustomerSupportInitChat.class.getName());

    public CustomerSupportInitChat() {
        super();
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        // set the response type to JSON
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");

        // get the test device number
        String phoneNumber = request.getParameter("phone_number");

        // write phone number to the session
        request.getSession().setAttribute("phone_number", phoneNumber);

        response.getWriter().println("{\"response\": \"ok\"}");
        response.getWriter().flush();
    }
}
// [END servlet for initializing a direct chat with a device]