/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * Modify at your own risk.
 */

package com.google.api.services.rcsbusinessmessaging.v1.model;

/**
 * Dialogflow event triggered by the RBM Platform. With events, an agent can match an intent without
 * using language as an input. Parameters enable personalized responses. For example, with the input
 * `{ "eventName": "welcome_event", "parameters": { "name": "Sam" } }`, a Dialogflow agent can
 * create the response `"Hello Sam! What can I do for you today?"`.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the RCS Business Messaging API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DialogflowEvent extends com.google.api.client.json.GenericJson {

  /**
   * The unique identifier of the event. For example, `RBM_WELCOME_EVENT`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String eventName;

  /**
   * The language of this query. For a list of language codes, see Language Support. Before a
   * Dialogflow agent can use a language, the language must be enabled in the Dialogflow console.
   * Queries in the same session can specify different languages. If a language isn't specified,
   * Dialogflow uses the agent's default language. do not necessarily need to specify the same
   * language.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String languageCode;

  /**
   * This field is set by the RBM platform. Don't include it when creating an agent message. The
   * field resolves "phones/{E.164}/dialogflowMessages/{messageId}", where {E.164} is the user's
   * phone number in E.164 format and {messageId} is the agent-assigned ID of the RBM agent message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * (Optional) Parameters associated with the event.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.Object> parameters;

  /**
   * The unique identifier of the event. For example, `RBM_WELCOME_EVENT`.
   * @return value or {@code null} for none
   */
  public java.lang.String getEventName() {
    return eventName;
  }

  /**
   * The unique identifier of the event. For example, `RBM_WELCOME_EVENT`.
   * @param eventName eventName or {@code null} for none
   */
  public DialogflowEvent setEventName(java.lang.String eventName) {
    this.eventName = eventName;
    return this;
  }

  /**
   * The language of this query. For a list of language codes, see Language Support. Before a
   * Dialogflow agent can use a language, the language must be enabled in the Dialogflow console.
   * Queries in the same session can specify different languages. If a language isn't specified,
   * Dialogflow uses the agent's default language. do not necessarily need to specify the same
   * language.
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguageCode() {
    return languageCode;
  }

  /**
   * The language of this query. For a list of language codes, see Language Support. Before a
   * Dialogflow agent can use a language, the language must be enabled in the Dialogflow console.
   * Queries in the same session can specify different languages. If a language isn't specified,
   * Dialogflow uses the agent's default language. do not necessarily need to specify the same
   * language.
   * @param languageCode languageCode or {@code null} for none
   */
  public DialogflowEvent setLanguageCode(java.lang.String languageCode) {
    this.languageCode = languageCode;
    return this;
  }

  /**
   * This field is set by the RBM platform. Don't include it when creating an agent message. The
   * field resolves "phones/{E.164}/dialogflowMessages/{messageId}", where {E.164} is the user's
   * phone number in E.164 format and {messageId} is the agent-assigned ID of the RBM agent message.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * This field is set by the RBM platform. Don't include it when creating an agent message. The
   * field resolves "phones/{E.164}/dialogflowMessages/{messageId}", where {E.164} is the user's
   * phone number in E.164 format and {messageId} is the agent-assigned ID of the RBM agent message.
   * @param name name or {@code null} for none
   */
  public DialogflowEvent setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * (Optional) Parameters associated with the event.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.Object> getParameters() {
    return parameters;
  }

  /**
   * (Optional) Parameters associated with the event.
   * @param parameters parameters or {@code null} for none
   */
  public DialogflowEvent setParameters(java.util.Map<String, java.lang.Object> parameters) {
    this.parameters = parameters;
    return this;
  }

  @Override
  public DialogflowEvent set(String fieldName, Object value) {
    return (DialogflowEvent) super.set(fieldName, value);
  }

  @Override
  public DialogflowEvent clone() {
    return (DialogflowEvent) super.clone();
  }

}
