/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * Modify at your own risk.
 */

package com.google.api.services.rcsbusinessmessaging.v1.model;

/**
 * Request for creating file.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the RCS Business Messaging API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CreateFileRequest extends com.google.api.client.json.GenericJson {

  /**
   * Blob file reference. This will be propagated by scotty agent automatically.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GdataMedia blob;

  /**
   * Optional. Text description of the file's content. Screen readers use this description to help
   * users with disabilities understand what the file contains.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String contentDescription;

  /**
   * Optional. Publicly available URL of the file. The RBM platform determines the MIME type of the
   * file from the content-type field in the HTTP headers when fetching the file. Supported image
   * content types: image/jpeg, image/jpg, image/gif, image/png. Supported video content types:
   * video/h263, video/m4v, video/mp4, video/mpeg, video/mpeg4, video/webm.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fileUrl;

  /**
   * Media request info populated by Scotty server. This will be propagated by scotty agent
   * automatically.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MediaRequestInfo mediaRequestInfo;

  /**
   * Optional. Publicly available URL of the thumbnail corresponding to the file. If this field is
   * not set, then the RBM platform automatically generates a thumbnail from the file. The RBM
   * platform determines the MIME type of the file from the content-type field in the HTTP headers
   * when fetching the file. Supported image content types: image/jpeg, image/jpg, image/gif,
   * image/png.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String thumbnailUrl;

  /**
   * Blob file reference. This will be propagated by scotty agent automatically.
   * @return value or {@code null} for none
   */
  public GdataMedia getBlob() {
    return blob;
  }

  /**
   * Blob file reference. This will be propagated by scotty agent automatically.
   * @param blob blob or {@code null} for none
   */
  public CreateFileRequest setBlob(GdataMedia blob) {
    this.blob = blob;
    return this;
  }

  /**
   * Optional. Text description of the file's content. Screen readers use this description to help
   * users with disabilities understand what the file contains.
   * @return value or {@code null} for none
   */
  public java.lang.String getContentDescription() {
    return contentDescription;
  }

  /**
   * Optional. Text description of the file's content. Screen readers use this description to help
   * users with disabilities understand what the file contains.
   * @param contentDescription contentDescription or {@code null} for none
   */
  public CreateFileRequest setContentDescription(java.lang.String contentDescription) {
    this.contentDescription = contentDescription;
    return this;
  }

  /**
   * Optional. Publicly available URL of the file. The RBM platform determines the MIME type of the
   * file from the content-type field in the HTTP headers when fetching the file. Supported image
   * content types: image/jpeg, image/jpg, image/gif, image/png. Supported video content types:
   * video/h263, video/m4v, video/mp4, video/mpeg, video/mpeg4, video/webm.
   * @return value or {@code null} for none
   */
  public java.lang.String getFileUrl() {
    return fileUrl;
  }

  /**
   * Optional. Publicly available URL of the file. The RBM platform determines the MIME type of the
   * file from the content-type field in the HTTP headers when fetching the file. Supported image
   * content types: image/jpeg, image/jpg, image/gif, image/png. Supported video content types:
   * video/h263, video/m4v, video/mp4, video/mpeg, video/mpeg4, video/webm.
   * @param fileUrl fileUrl or {@code null} for none
   */
  public CreateFileRequest setFileUrl(java.lang.String fileUrl) {
    this.fileUrl = fileUrl;
    return this;
  }

  /**
   * Media request info populated by Scotty server. This will be propagated by scotty agent
   * automatically.
   * @return value or {@code null} for none
   */
  public MediaRequestInfo getMediaRequestInfo() {
    return mediaRequestInfo;
  }

  /**
   * Media request info populated by Scotty server. This will be propagated by scotty agent
   * automatically.
   * @param mediaRequestInfo mediaRequestInfo or {@code null} for none
   */
  public CreateFileRequest setMediaRequestInfo(MediaRequestInfo mediaRequestInfo) {
    this.mediaRequestInfo = mediaRequestInfo;
    return this;
  }

  /**
   * Optional. Publicly available URL of the thumbnail corresponding to the file. If this field is
   * not set, then the RBM platform automatically generates a thumbnail from the file. The RBM
   * platform determines the MIME type of the file from the content-type field in the HTTP headers
   * when fetching the file. Supported image content types: image/jpeg, image/jpg, image/gif,
   * image/png.
   * @return value or {@code null} for none
   */
  public java.lang.String getThumbnailUrl() {
    return thumbnailUrl;
  }

  /**
   * Optional. Publicly available URL of the thumbnail corresponding to the file. If this field is
   * not set, then the RBM platform automatically generates a thumbnail from the file. The RBM
   * platform determines the MIME type of the file from the content-type field in the HTTP headers
   * when fetching the file. Supported image content types: image/jpeg, image/jpg, image/gif,
   * image/png.
   * @param thumbnailUrl thumbnailUrl or {@code null} for none
   */
  public CreateFileRequest setThumbnailUrl(java.lang.String thumbnailUrl) {
    this.thumbnailUrl = thumbnailUrl;
    return this;
  }

  @Override
  public CreateFileRequest set(String fieldName, Object value) {
    return (CreateFileRequest) super.set(fieldName, value);
  }

  @Override
  public CreateFileRequest clone() {
    return (CreateFileRequest) super.clone();
  }

}
