/*
Copyright 2018 Google Inc. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package com.google.rbm.samples.dialogflow;

// [START import_libraries]
import com.google.protobuf.Value;

import java.util.Map;
// [END import_libraries]

/**
 * Helper class to wrap the needed parameters needed from DialogFlow.
 */
public class DialogFlowResponse {
    // The intent name
    private String displayName;

    // The response recommended from DiaglogFlow
    private String responseText;

    // A flag indicating the data for the intent is complete
    private boolean isComplete;

    // The key/value pairs returned as part of the intent in DialogFlow
    private Map<String, Value> fields;

    public DialogFlowResponse(String displayName, String responseText,
                              boolean isComplete, Map<String, Value> fields) {
        this.displayName = displayName;
        this.responseText = responseText;
        this.isComplete = isComplete;
        this.fields = fields;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getResponseText() {
        return responseText;
    }

    public void setResponseText(String responseText) {
        this.responseText = responseText;
    }

    public boolean isComplete() {
        return isComplete;
    }

    public void setComplete(boolean complete) {
        isComplete = complete;
    }

    public Map<String, Value> getFields() {
        return fields;
    }
}
