/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * Modify at your own risk.
 */

package com.google.api.services.rcsbusinessmessaging.v1.model;

/**
 * Information to read/write to blobstore2.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the RCS Business Messaging API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GdataBlobstore2Info extends com.google.api.client.json.GenericJson {

  /**
   * The blob generation id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long blobGeneration;

  /**
   * The blob id, e.g., /blobstore/prod/playground/scotty
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String blobId;

  /**
   * Read handle passed from Bigstore -> Scotty for a GCS download. This is a signed, serialized
   * blobstore2.ReadHandle proto which must never be set outside of Bigstore, and is not applicable
   * to non-GCS media downloads.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String downloadReadHandle;

  /**
   * The blob read token. Needed to read blobs that have not been replicated. Might not be available
   * until the final call.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String readToken;

  /**
   * Metadata passed from Blobstore -> Scotty for a new GCS upload. This is a signed, serialized
   * blobstore2.BlobMetadataContainer proto which must never be consumed outside of Bigstore, and is
   * not applicable to non-GCS media uploads.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String uploadMetadataContainer;

  /**
   * The blob generation id.
   * @return value or {@code null} for none
   */
  public java.lang.Long getBlobGeneration() {
    return blobGeneration;
  }

  /**
   * The blob generation id.
   * @param blobGeneration blobGeneration or {@code null} for none
   */
  public GdataBlobstore2Info setBlobGeneration(java.lang.Long blobGeneration) {
    this.blobGeneration = blobGeneration;
    return this;
  }

  /**
   * The blob id, e.g., /blobstore/prod/playground/scotty
   * @return value or {@code null} for none
   */
  public java.lang.String getBlobId() {
    return blobId;
  }

  /**
   * The blob id, e.g., /blobstore/prod/playground/scotty
   * @param blobId blobId or {@code null} for none
   */
  public GdataBlobstore2Info setBlobId(java.lang.String blobId) {
    this.blobId = blobId;
    return this;
  }

  /**
   * Read handle passed from Bigstore -> Scotty for a GCS download. This is a signed, serialized
   * blobstore2.ReadHandle proto which must never be set outside of Bigstore, and is not applicable
   * to non-GCS media downloads.
   * @see #decodeDownloadReadHandle()
   * @return value or {@code null} for none
   */
  public java.lang.String getDownloadReadHandle() {
    return downloadReadHandle;
  }

  /**
   * Read handle passed from Bigstore -> Scotty for a GCS download. This is a signed, serialized
   * blobstore2.ReadHandle proto which must never be set outside of Bigstore, and is not applicable
   * to non-GCS media downloads.
   * @see #getDownloadReadHandle()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeDownloadReadHandle() {
    return com.google.api.client.util.Base64.decodeBase64(downloadReadHandle);
  }

  /**
   * Read handle passed from Bigstore -> Scotty for a GCS download. This is a signed, serialized
   * blobstore2.ReadHandle proto which must never be set outside of Bigstore, and is not applicable
   * to non-GCS media downloads.
   * @see #encodeDownloadReadHandle()
   * @param downloadReadHandle downloadReadHandle or {@code null} for none
   */
  public GdataBlobstore2Info setDownloadReadHandle(java.lang.String downloadReadHandle) {
    this.downloadReadHandle = downloadReadHandle;
    return this;
  }

  /**
   * Read handle passed from Bigstore -> Scotty for a GCS download. This is a signed, serialized
   * blobstore2.ReadHandle proto which must never be set outside of Bigstore, and is not applicable
   * to non-GCS media downloads.
   * @see #setDownloadReadHandle()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public GdataBlobstore2Info encodeDownloadReadHandle(byte[] downloadReadHandle) {
    this.downloadReadHandle = com.google.api.client.util.Base64.encodeBase64URLSafeString(downloadReadHandle);
    return this;
  }

  /**
   * The blob read token. Needed to read blobs that have not been replicated. Might not be available
   * until the final call.
   * @return value or {@code null} for none
   */
  public java.lang.String getReadToken() {
    return readToken;
  }

  /**
   * The blob read token. Needed to read blobs that have not been replicated. Might not be available
   * until the final call.
   * @param readToken readToken or {@code null} for none
   */
  public GdataBlobstore2Info setReadToken(java.lang.String readToken) {
    this.readToken = readToken;
    return this;
  }

  /**
   * Metadata passed from Blobstore -> Scotty for a new GCS upload. This is a signed, serialized
   * blobstore2.BlobMetadataContainer proto which must never be consumed outside of Bigstore, and is
   * not applicable to non-GCS media uploads.
   * @see #decodeUploadMetadataContainer()
   * @return value or {@code null} for none
   */
  public java.lang.String getUploadMetadataContainer() {
    return uploadMetadataContainer;
  }

  /**
   * Metadata passed from Blobstore -> Scotty for a new GCS upload. This is a signed, serialized
   * blobstore2.BlobMetadataContainer proto which must never be consumed outside of Bigstore, and is
   * not applicable to non-GCS media uploads.
   * @see #getUploadMetadataContainer()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeUploadMetadataContainer() {
    return com.google.api.client.util.Base64.decodeBase64(uploadMetadataContainer);
  }

  /**
   * Metadata passed from Blobstore -> Scotty for a new GCS upload. This is a signed, serialized
   * blobstore2.BlobMetadataContainer proto which must never be consumed outside of Bigstore, and is
   * not applicable to non-GCS media uploads.
   * @see #encodeUploadMetadataContainer()
   * @param uploadMetadataContainer uploadMetadataContainer or {@code null} for none
   */
  public GdataBlobstore2Info setUploadMetadataContainer(java.lang.String uploadMetadataContainer) {
    this.uploadMetadataContainer = uploadMetadataContainer;
    return this;
  }

  /**
   * Metadata passed from Blobstore -> Scotty for a new GCS upload. This is a signed, serialized
   * blobstore2.BlobMetadataContainer proto which must never be consumed outside of Bigstore, and is
   * not applicable to non-GCS media uploads.
   * @see #setUploadMetadataContainer()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public GdataBlobstore2Info encodeUploadMetadataContainer(byte[] uploadMetadataContainer) {
    this.uploadMetadataContainer = com.google.api.client.util.Base64.encodeBase64URLSafeString(uploadMetadataContainer);
    return this;
  }

  @Override
  public GdataBlobstore2Info set(String fieldName, Object value) {
    return (GdataBlobstore2Info) super.set(fieldName, value);
  }

  @Override
  public GdataBlobstore2Info clone() {
    return (GdataBlobstore2Info) super.clone();
  }

}
