/*
Copyright 2018 Google Inc. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package com.google.rbm.samples.servlets;

// [START servlet for sending messages from chat to user's device]
import com.google.rbm.samples.BankingAgentBot;

import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.logging.Logger;

/**
 * Servlet for customer support chat message sending.
 */
@WebServlet(name = "CustomerSupportChat", value = "/sendMessage")
public class CustomerSupportChat extends HttpServlet {
    private static final Logger logger = Logger.getLogger(CustomerSupportChat.class.getName());

    public CustomerSupportChat() {
        super();
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        // set the response type to JSON
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");

        // get the message text
        String message = request.getParameter("message");

        logger.info(message);

        // check the session for the phone number
        if(request.getSession().getAttribute("phone_number") != null) {
            String phoneNumber = request.getSession().getAttribute("phone_number").toString();

            try {
                BankingAgentBot bankingAgentBot = new BankingAgentBot(phoneNumber);

                // send the client the message
                bankingAgentBot.sendCustomerSupportMessage(message);

                response.getWriter().println("{\"response\": \"ok\"}");
                response.getWriter().flush();
            } catch (Exception e) {
                logger.info(e.getMessage());

                response.getWriter().println("{\"response\": \"fail\"}");
                response.getWriter().flush();
            }
        }
        else {
            response.getWriter().println("{\"response\": \"fail\", \"message\": \"No phone number found.\"}");
            response.getWriter().flush();
        }
    }
}
// [END servlet for sending messages from chat to user's device]