/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * Modify at your own risk.
 */

package com.google.api.services.rcsbusinessmessaging.v1.model;

/**
 * Payment request action.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the RCS Business Messaging API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PaymentRequestAction extends com.google.api.client.json.GenericJson {

  /**
   * Text that replaces the payment request text when the transaction is complete.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String completedMessage;

  /**
   * (Optional) A timestamp of when the payment request expires. If a payment request expires, the
   * request becomes invalid. If you specify a timestamp, the RCS-enabled messaging app doesn't
   * verify an expiration time with the RBM agent. If you don't specify a timestamp, the payment
   * request only expires if the agent flags the request as expired via the experation check
   * webhook.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String expireTime;

  /**
   * Text that replaces the payment request text when the request is expired.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String expiredMessage;

  /**
   * Payment request line items, including regular items, taxes, sub-total, and shipping.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LineItem> items;

  /**
   * Supported payment methods.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Method> paymentMethods;

  /**
   * The agent-assigned ID of the payment request. This may be a UUID, as defined in
   * https://tools.ietf.org/html/rfc4122.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String requestId;

  /**
   * This field is set by the RBM platform. Do not include it when creating a payment request. The
   * field resolves to a checksum the RBM platform uses to validate the payment request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String signature;

  /**
   * The total amount of the payment request. The value must be positive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LineItem total;

  /**
   * Text that replaces the payment request text when the transaction is complete.
   * @return value or {@code null} for none
   */
  public java.lang.String getCompletedMessage() {
    return completedMessage;
  }

  /**
   * Text that replaces the payment request text when the transaction is complete.
   * @param completedMessage completedMessage or {@code null} for none
   */
  public PaymentRequestAction setCompletedMessage(java.lang.String completedMessage) {
    this.completedMessage = completedMessage;
    return this;
  }

  /**
   * (Optional) A timestamp of when the payment request expires. If a payment request expires, the
   * request becomes invalid. If you specify a timestamp, the RCS-enabled messaging app doesn't
   * verify an expiration time with the RBM agent. If you don't specify a timestamp, the payment
   * request only expires if the agent flags the request as expired via the experation check
   * webhook.
   * @return value or {@code null} for none
   */
  public String getExpireTime() {
    return expireTime;
  }

  /**
   * (Optional) A timestamp of when the payment request expires. If a payment request expires, the
   * request becomes invalid. If you specify a timestamp, the RCS-enabled messaging app doesn't
   * verify an expiration time with the RBM agent. If you don't specify a timestamp, the payment
   * request only expires if the agent flags the request as expired via the experation check
   * webhook.
   * @param expireTime expireTime or {@code null} for none
   */
  public PaymentRequestAction setExpireTime(String expireTime) {
    this.expireTime = expireTime;
    return this;
  }

  /**
   * Text that replaces the payment request text when the request is expired.
   * @return value or {@code null} for none
   */
  public java.lang.String getExpiredMessage() {
    return expiredMessage;
  }

  /**
   * Text that replaces the payment request text when the request is expired.
   * @param expiredMessage expiredMessage or {@code null} for none
   */
  public PaymentRequestAction setExpiredMessage(java.lang.String expiredMessage) {
    this.expiredMessage = expiredMessage;
    return this;
  }

  /**
   * Payment request line items, including regular items, taxes, sub-total, and shipping.
   * @return value or {@code null} for none
   */
  public java.util.List<LineItem> getItems() {
    return items;
  }

  /**
   * Payment request line items, including regular items, taxes, sub-total, and shipping.
   * @param items items or {@code null} for none
   */
  public PaymentRequestAction setItems(java.util.List<LineItem> items) {
    this.items = items;
    return this;
  }

  /**
   * Supported payment methods.
   * @return value or {@code null} for none
   */
  public java.util.List<Method> getPaymentMethods() {
    return paymentMethods;
  }

  /**
   * Supported payment methods.
   * @param paymentMethods paymentMethods or {@code null} for none
   */
  public PaymentRequestAction setPaymentMethods(java.util.List<Method> paymentMethods) {
    this.paymentMethods = paymentMethods;
    return this;
  }

  /**
   * The agent-assigned ID of the payment request. This may be a UUID, as defined in
   * https://tools.ietf.org/html/rfc4122.
   * @return value or {@code null} for none
   */
  public java.lang.String getRequestId() {
    return requestId;
  }

  /**
   * The agent-assigned ID of the payment request. This may be a UUID, as defined in
   * https://tools.ietf.org/html/rfc4122.
   * @param requestId requestId or {@code null} for none
   */
  public PaymentRequestAction setRequestId(java.lang.String requestId) {
    this.requestId = requestId;
    return this;
  }

  /**
   * This field is set by the RBM platform. Do not include it when creating a payment request. The
   * field resolves to a checksum the RBM platform uses to validate the payment request.
   * @return value or {@code null} for none
   */
  public java.lang.String getSignature() {
    return signature;
  }

  /**
   * This field is set by the RBM platform. Do not include it when creating a payment request. The
   * field resolves to a checksum the RBM platform uses to validate the payment request.
   * @param signature signature or {@code null} for none
   */
  public PaymentRequestAction setSignature(java.lang.String signature) {
    this.signature = signature;
    return this;
  }

  /**
   * The total amount of the payment request. The value must be positive.
   * @return value or {@code null} for none
   */
  public LineItem getTotal() {
    return total;
  }

  /**
   * The total amount of the payment request. The value must be positive.
   * @param total total or {@code null} for none
   */
  public PaymentRequestAction setTotal(LineItem total) {
    this.total = total;
    return this;
  }

  @Override
  public PaymentRequestAction set(String fieldName, Object value) {
    return (PaymentRequestAction) super.set(fieldName, value);
  }

  @Override
  public PaymentRequestAction clone() {
    return (PaymentRequestAction) super.clone();
  }

}
