/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * Modify at your own risk.
 */

package com.google.api.services.rcsbusinessmessaging.v1.model;

/**
 * Supported payment methods.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the RCS Business Messaging API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Method extends com.google.api.client.json.GenericJson {

  /**
   * The countries that the payment request is valid in, as ISO-2 country codes. For example,
   * `["US", "MX"]`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> allowedCountryCodes;

  /**
   * The billing address format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String billingAddressFormat;

  /**
   * Whether or not the user must provide a billing address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean billingAddressRequired;

  /**
   * The merchant ID for the supported payment method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String merchantId;

  /**
   * The merchant name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String merchantName;

  /**
   * The payment method name. You must set this field to `"https://paywith.google.com/pay"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String paymentMethod;

  /**
   * The supported card networks. For example, `["MASTERCARD", "VISA", "DISCOVER"]`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> supportedCardNetworks;

  /**
   * The supported card types. For example, `["CARD", "TOKENIZED_CARD"]`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> supportedCardTypes;

  /**
   * Tokenization information for the payment request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TokenizationData tokenizationData;

  /**
   * The countries that the payment request is valid in, as ISO-2 country codes. For example,
   * `["US", "MX"]`.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAllowedCountryCodes() {
    return allowedCountryCodes;
  }

  /**
   * The countries that the payment request is valid in, as ISO-2 country codes. For example,
   * `["US", "MX"]`.
   * @param allowedCountryCodes allowedCountryCodes or {@code null} for none
   */
  public Method setAllowedCountryCodes(java.util.List<java.lang.String> allowedCountryCodes) {
    this.allowedCountryCodes = allowedCountryCodes;
    return this;
  }

  /**
   * The billing address format.
   * @return value or {@code null} for none
   */
  public java.lang.String getBillingAddressFormat() {
    return billingAddressFormat;
  }

  /**
   * The billing address format.
   * @param billingAddressFormat billingAddressFormat or {@code null} for none
   */
  public Method setBillingAddressFormat(java.lang.String billingAddressFormat) {
    this.billingAddressFormat = billingAddressFormat;
    return this;
  }

  /**
   * Whether or not the user must provide a billing address.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getBillingAddressRequired() {
    return billingAddressRequired;
  }

  /**
   * Whether or not the user must provide a billing address.
   * @param billingAddressRequired billingAddressRequired or {@code null} for none
   */
  public Method setBillingAddressRequired(java.lang.Boolean billingAddressRequired) {
    this.billingAddressRequired = billingAddressRequired;
    return this;
  }

  /**
   * The merchant ID for the supported payment method.
   * @return value or {@code null} for none
   */
  public java.lang.String getMerchantId() {
    return merchantId;
  }

  /**
   * The merchant ID for the supported payment method.
   * @param merchantId merchantId or {@code null} for none
   */
  public Method setMerchantId(java.lang.String merchantId) {
    this.merchantId = merchantId;
    return this;
  }

  /**
   * The merchant name.
   * @return value or {@code null} for none
   */
  public java.lang.String getMerchantName() {
    return merchantName;
  }

  /**
   * The merchant name.
   * @param merchantName merchantName or {@code null} for none
   */
  public Method setMerchantName(java.lang.String merchantName) {
    this.merchantName = merchantName;
    return this;
  }

  /**
   * The payment method name. You must set this field to `"https://paywith.google.com/pay"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getPaymentMethod() {
    return paymentMethod;
  }

  /**
   * The payment method name. You must set this field to `"https://paywith.google.com/pay"`.
   * @param paymentMethod paymentMethod or {@code null} for none
   */
  public Method setPaymentMethod(java.lang.String paymentMethod) {
    this.paymentMethod = paymentMethod;
    return this;
  }

  /**
   * The supported card networks. For example, `["MASTERCARD", "VISA", "DISCOVER"]`.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSupportedCardNetworks() {
    return supportedCardNetworks;
  }

  /**
   * The supported card networks. For example, `["MASTERCARD", "VISA", "DISCOVER"]`.
   * @param supportedCardNetworks supportedCardNetworks or {@code null} for none
   */
  public Method setSupportedCardNetworks(java.util.List<java.lang.String> supportedCardNetworks) {
    this.supportedCardNetworks = supportedCardNetworks;
    return this;
  }

  /**
   * The supported card types. For example, `["CARD", "TOKENIZED_CARD"]`.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSupportedCardTypes() {
    return supportedCardTypes;
  }

  /**
   * The supported card types. For example, `["CARD", "TOKENIZED_CARD"]`.
   * @param supportedCardTypes supportedCardTypes or {@code null} for none
   */
  public Method setSupportedCardTypes(java.util.List<java.lang.String> supportedCardTypes) {
    this.supportedCardTypes = supportedCardTypes;
    return this;
  }

  /**
   * Tokenization information for the payment request.
   * @return value or {@code null} for none
   */
  public TokenizationData getTokenizationData() {
    return tokenizationData;
  }

  /**
   * Tokenization information for the payment request.
   * @param tokenizationData tokenizationData or {@code null} for none
   */
  public Method setTokenizationData(TokenizationData tokenizationData) {
    this.tokenizationData = tokenizationData;
    return this;
  }

  @Override
  public Method set(String fieldName, Object value) {
    return (Method) super.set(fieldName, value);
  }

  @Override
  public Method clone() {
    return (Method) super.clone();
  }

}
