'use strict';

var partner = Object.freeze({SLICE: 0, DELIVERY: 1});
var testParams = require('./test_params.json');
let pretty = require('js-object-pretty-print').pretty;

process.env.TEST = true;

var testUtils = require('./test_utils');

// var Assistant = require('../actions-on-google').FoodOrderingActions;
var Debug = require('debug');
var chai = require('chai');
var chaiHttp = require('chai-http');
var should = chai.should();
var supertest = require('supertest');
chai.use(chaiHttp);

var debug = Debug('food-ordering-agent-test:debug');
var error = Debug('food-ordering-agent-test:error');
debug.log = console.log.bind(console);
error.log = console.error.bind(console);

describe('CheckoutAction', function() {
  it('Empty cart', function(done) {
    var request = testUtils.buildInitialCheckoutRequest();
    var cart = testUtils.buildCartWithNoItems();
    request.inputs[0].arguments[0].extension = cart;
    var api = supertest(testParams.apiEndpoint);
    api.post('/')
        .set('google-actions-api-version', '2')
        .send(request)
        .end(function(err, res) {
          testUtils.testInitialStructuredResponse(request, res);
          testUtils.testCartCheckoutResponse(request, res);
          done();
        });
  });

  it('Single item, with no extensions, in cart', function(done) {
    var request = testUtils.buildInitialCheckoutRequest();
    var cart = testUtils.buildCartWithNoItems();
    cart.lineItems[0] = testParams.lineItemWithNoExtensions;
    request.inputs[0].arguments[0].extension = cart;
    var api = supertest(testParams.apiEndpoint);
    api.post('/')
        .set('google-actions-api-version', '2')
        .send(request)
        .end(function(err, res) {
          testUtils.testInitialStructuredResponse(request, res);
          testUtils.testCartCheckoutResponse(request, res);
          testUtils.testTotalPriceCheckoutResponse(request, res);
          testUtils.testFoodOrderExtensionCheckoutResponse(request, res);
          testUtils.testProposedOrderOtherItemsCheckoutResponse(request, res);
          testUtils.testPaymentOptionsCheckoutResponse(request, res);
          done();
        });
  });

  it('Single item, with extensions, in cart', function(done) {
    var request = testUtils.buildInitialCheckoutRequest();
    var cart = testUtils.buildCartWithNoItems();
    cart.lineItems[0] = testParams.lineItemWithExtensions;
    request.inputs[0].arguments[0].extension = cart;
    var api = supertest(testParams.apiEndpoint);
    api.post('/')
        .set('google-actions-api-version', '2')
        .send(request)
        .end(function(err, res) {
          testUtils.testInitialStructuredResponse(request, res);
          testUtils.testCartCheckoutResponse(request, res);
          testUtils.testTotalPriceCheckoutResponse(request, res);
          testUtils.testFoodOrderExtensionCheckoutResponse(request, res);
          testUtils.testProposedOrderOtherItemsCheckoutResponse(request, res);
          testUtils.testPaymentOptionsCheckoutResponse(request, res);
          done();
        });
  });
});

describe('SubmitOrderAction', function() {
  it('Order with empty cart', function(done) {
    var request = testUtils.buildInitialSubmitOrderRequest();
    var cart = testUtils.buildCartWithNoItems();
    delete cart['@type'];
    request.inputs[0]
        .arguments[0]
        .transactionDecisionValue.order.finalOrder.cart = cart;
    var api = supertest(testParams.apiEndpoint);
    api.post('/')
        .set('google-actions-api-version', '2')
        .send(request)
        .end(function(err, res) {
          testUtils.testInitialStructuredResponse(request, res);
          testUtils.testActionOrderIdSubmitOrderResponse(request, res);
          done();
        });
  });
});

// TODO(aditigoyal): Add asyncupdate action and unhappy paths for all three
// calls.

